<?php
/**
 * This class assists with the rendering of print templates
 * This class is used to handle print requests from URL.
 * The $print_methods array contains a list of methods that can be called from URL
 * to render a print template
 *
 * @package WooCommerce_PickingPal
 */

class WCPP_Print_Handler_Standard extends WCPP_Print_Handler {

	public function __construct() {
		$this->print_methods[] = 'pickingpal_print_pick_list';
	}


	/**
	 * Prints the pick list template
	 *
	 * @return void Content wil be output to print
	 * @throws Exception
	 */
	public function pickingpal_print_pick_list() {
		$legacy_template_name  = 'template_pick_list';
		$legacy_theme_template = WCPP()->find_theme_template( $legacy_template_name );
		if ( $legacy_theme_template ) {
			// Support old custom implementation
			$this->print_pick_list();
		} else {
			// Render new implementation
			$orders   = WCPP_Print_Handler::get_orders();
			$template = new WCPP_Print_Template( 'template_print_pick_list', $orders );
			$template->render_template();
		}
		exit;
	}

	/**
	 * @return void
	 * @throws Exception
	 * @deprecated
	 * @use pickingpal_print_pick_list
	 */
	private function print_pick_list() {
		$v_control = WCPP_Visibility_Controller::init();

		$warehouse_locations = array_filter(
			WCPP()->settings_handler->get_warehouse_locations( 'only_enabled' ),
			function ( $data, $key ) use ( $v_control ) {
				return $v_control->is_visible( $key, $v_control::PICK_LIST_VIEW );
			},
			ARRAY_FILTER_USE_BOTH
		);

		$additional_skus = array_filter(
			WCPP()->settings_handler->get_skus( 'only_enabled' ),
			function ( $data, $key ) use ( $v_control ) {
				return $v_control->is_visible( $key, $v_control::PICK_LIST_VIEW );
			},
			ARRAY_FILTER_USE_BOTH
		);

		$total_units_to_pick  = 0;
		$item_data            = array();
		$order_ids            = (array) $_GET['ids'];
		$combined_order_items = array();
		$bin_number           = 0;

		foreach ( $order_ids as $index => $order_id ) {
			++$bin_number;
			$picker_helper = new WCPP_Picker_Data( $order_id );
			$picker_data   = $picker_helper->get_data();

			/*
			 * Combine items by product id
			 */
			foreach ( $picker_data['products'] as $item_id => $item_data ) {
				$product_id = $item_data['product_id'];

				// Support old templates
				$item_data['warehouse_location'] = $item_data['warehouse'];
				$item_data['variation']          = $item_data['meta_data'];

				if ( ! isset( $combined_order_items[ $product_id ] ) ) {
					$combined_order_items[ $product_id ] = $item_data;
				} else {
					$combined_order_items[ $product_id ]['qty']            += $item_data['qty'];
					$combined_order_items[ $product_id ]['qty_required']   += $item_data['qty_required'];
					$combined_order_items[ $product_id ]['qty_picked']     += $item_data['qty_picked'];
					$combined_order_items[ $product_id ]['qty_overpicked'] += $item_data['qty_overpicked'];
					$combined_order_items[ $product_id ]['bundle_qty']     += $item_data['bundle_qty'];
				}

				// Add bin splits
				$combined_order_items[ $product_id ]['bins'][ $bin_number ] = array(
					'id'           => $order_id,
					'qty'          => $combined_order_items[ $product_id ]['qty'],
					'qty_required' => $combined_order_items[ $product_id ]['qty_required'],
				);

				$total_units_to_pick += $item_data['qty_required'];
			}
		}

		if ( ( count( $order_ids ) > 1 ) && WCPP()->settings_handler->get_option( 'sort_by_warehouse_location' ) ) {
			$combined_order_items = WCPP()->helper->sort_array_empty_last( $combined_order_items, 'warehouse' );
		}

		$template_name = 'template_pick_list';
		$this->print_legacy_template(
			$template_name,
			array(
				'items'                    => $combined_order_items,
				'total'                    => $total_units_to_pick,
				'total_orders'             => count( $order_ids ),
				'url_list_css'             => WCPP_Print_Handler::get_url_list_css( $template_name ),
				'with_warehouse_locations' => count( $warehouse_locations ) > 0,
				'with_additional_skus'     => count( $additional_skus ) > 0,
			)
		);
		exit();
	}
}
