<?php

class WCPP_Settings_Tab extends WCPP_Tab {

	/**
	 * @var string Path to class views
	 */
	public $tab_name = 'settings';


	public function thematic_enqueue_scripts() {
		parent::thematic_enqueue_scripts();

		wp_enqueue_media();
		wp_enqueue_script( 'uploader-hook', WCPP()->plugin_js_url() . '/settings/uploader-hook.js', array( 'jquery' ), WCPP_VERSION );

		wp_enqueue_style( 'settings-woocommerce-pickingpal', WCPP()->plugin_css_url() . '/settings.css', array(), WCPP_VERSION );
	}

	protected function process_request( $request ) {
		if ( ! empty( $request['delete_logo'] ) ) {
			WCPP()->settings_handler->clear_option( 'url_file' );
		}

		if ( $_POST ) {
			WCPP()->settings_handler->save_options( $request );
		}
	}

	protected function process_request_old( $request ) {

		if ( ! empty( $request['delete_logo'] ) ) {
				delete_option( 'pickingpal-logo' );
		}

		if ( $_POST ) {
			// WCPP()->metakey_warehouse_locations
			if ( isset( $request['location'] ) ) {
					$locations = array();
				foreach ( $request['location'] as $key => $value ) {
						$locations[ $key ]['label']   = $value['label'];
						$locations[ $key ]['enabled'] = $value['enabled'];
				}
					// update_option( WCPP()->metakey_warehouse_locations, $locations );
			} else {
				// update_option( WCPP()->metakey_warehouse_locations, array() );
			}

			// WCPP()->metakey_skus
			if ( isset( $request['sku'] ) ) {
					$skus = array();
				foreach ( $request['sku'] as $key => $value ) {
						$skus[ $key ]['label']   = $value['label'];
						$skus[ $key ]['enabled'] = $value['enabled'];
				}
					// update_option( WCPP()->metakey_skus, $skus );
			} else {
				// update_option( WCPP()->metakey_skus, array() );
			}

			// if ( ! empty( $request['pickingpal-switch_order_status_from'] ) ) {
			// update_option( 'pickingpal-switch_order_status_from', $request['pickingpal-switch_order_status_from'] );
			// } else {
			// delete_option( 'pickingpal-switch_order_status_from' );
			// }

			// if ( ! empty( $request['pickingpal-switch_order_status_to'] ) ) {
			// update_option( 'pickingpal-switch_order_status_to', $request['pickingpal-switch_order_status_to'] );
			// } else {
			// delete_option( 'pickingpal-switch_order_status_to' );
			// }

			// if ( ! empty( $request['active_fields'] ) ) {
			// update_option( 'wc-picking-pal-active-fields', $request['active_fields'] );
			// } else {
			// delete_option( 'wc-picking-pal-active-fields' );
			// }

			// if ( ! empty( $request['fields'] ) ) {
			// update_option( 'wc-picking-pal-fields', $request['fields'] );
			// } else {
			// delete_option( 'wc-picking-pal-fields' );
			// }

			// if ( ! empty( $request['pickingpal-pick_to_bin_max_order'] ) ) {
			// update_option( 'pickingpal-pick_to_bin_max_order', $request['pickingpal-pick_to_bin_max_order'] );
			// } else {
			// if ( ! get_option('pickingpal-pick_to_bin_max_order') ) {
			// update_option( 'pickingpal-pick_to_bin_max_order', 10 );
			// }
			// }

			// if ( ! empty( $request['pickingpal-pick_to_bin_columns'] ) ) {
			// if ( $request['pickingpal-pick_to_bin_columns'] > 5 ) {
			// update_option( 'pickingpal-pick_to_bin_columns', 5 );
			// } else {
			// update_option( 'pickingpal-pick_to_bin_columns', $request['pickingpal-pick_to_bin_columns'] );
			// }
			// } else {
			// if ( ! get_option('pickingpal-pick_to_bin_columns') ) {
			// update_option( 'pickingpal-pick_to_bin_columns', 4 );
			// }
			// }

			$settings = array(
			// 'contact'                                      => 'pickingpal-contact',
			// 'url_file'                                     => 'pickingpal-logo',
			// 'pickingpal-show_taxes'                        => 'pickingpal-show_taxes',
			// 'pickingpal-sort_by_warehouse_location'        => 'pickingpal-sort_by_warehouse_location',
			// 'pickingpal-show_warehouse_location'           => 'pickingpal-show_warehouse_location',
			// 'pickingpal-show_product_image_on_pick_ticket' => 'pickingpal-show_product_image_on_pick_ticket',
			// 'pickingpal-autopick_digital_products'         => 'pickingpal-autopick_digital_products',
			// 'pickingpal-pick_to_bin'                       => 'pickingpal-pick_to_bin',
			);

			foreach ( $settings as $setting => $option ) {
				if ( isset( $request[ $setting ] ) ) {
					update_option( $option, $request[ $setting ] );
				}
			}
		}
	}

	public function get_fields() {
		global $wpdb;

		$fields = array(
			'sku'   => '',
			'name'  => '',
			'price' => '',
		);

		$attributes = $wpdb->get_results( "SELECT `{$wpdb->prefix}woocommerce_attribute_taxonomies`.attribute_name  FROM `{$wpdb->prefix}woocommerce_attribute_taxonomies`" );
		foreach ( $attributes as $key => $attribute ) {
			$fields[ $attribute->attribute_name ] = '';
		}
		$custom_fields = apply_filters( 'wc_pickingpal_custom_fields', array() );
		if ( $custom_fields ) {
			$fields = array_merge( $fields, $custom_fields );
		}
		// $s_fields = get_option('wc-picking-pal-fields');
		$s_fields = WCPP()->settings_handler->get_option( 'fields' );
		if ( $s_fields ) {
			$this->update_existing( $s_fields, $fields );
			// update_option('wc-picking-pal-fields', $fields);
			WCPP()->settings_handler->save_option( 'fields', $fields );
		}
		return $fields;
	}

	public function update_existing( &$array_source, &$array_destination ) {

		foreach ( $array_source as $index => $value ) {

			if ( isset( $array_destination[ $index ] ) and empty( $array_destination[ $index ] ) ) {
				$array_destination[ $index ] = $value;
			}
		}
	}
}
