<?php


class WCPP_Helper {

	public function get_product_warehouse_locations( $product_id ) {
		$warehouse_locations = WCPP()->settings_handler->get_warehouse_locations( 'available' );

		$result = array();
		if ( count( $warehouse_locations ) ) {
			foreach ( $warehouse_locations as $key => $location ) :
				$_value = get_post_meta( $product_id, $key );
				if ( isset( $_value[0] ) && ! empty( $_value[0] ) ) {
					$result[] = $location['label'] . ': ' . $_value[0];
				}
			endforeach;
		}

		return $result;
	}

	public function get_product_warehouse_location( $product_id, $key ) {
		$result = false;
		$_value = get_post_meta( $product_id, $key );
		if ( isset( $_value[0] ) && ! empty( $_value[0] ) ) {
			$result = $_value[0];
		}

		return $result;
	}

	/**
	 * Returns an array of additional SKUs assigned to the given product ID
	 *
	 * @param int  $product_id
	 * @param bool $key_is_label If true the label for the SKU field is used as key and value is string,
	 *                           otherwise the meta/attribute key is used as key and value is array
	 * @return array
	 */
	public function get_product_additional_skus( $product_id, $key_is_label = true ) {
		$skus = WCPP()->settings_handler->get_skus( 'available' );

		$result = array();
		foreach ( $skus as $key => $value ) {
			$_value = get_post_meta( $product_id, $key );
			if ( ! empty( $_value[0] ) ) {
				if ( $key_is_label ) {
					$result[ $value['label'] ] = $_value[0];
				} else {
					$result[ $key ] = array(
						'label' => $value['label'],
						'value' => $_value[0],
					);
				}
			}
		}
		return $result;
	}

	public function get_product_additional_sku( $product_id, $key ) {
		$result = false;
		$_value = get_post_meta( $product_id, $key );
		if ( ! empty( $_value[0] ) ) {
			$result = $_value[0];
		}

		return $result;
	}

	/**
	 * Returns metadata for an order item where
	 * key is the attribute name and value is the attribute value
	 *
	 * @param WC_Order_Item $order_item
	 *
	 * @return array Array of meta data
	 */
	public function get_order_item_meta_data_array( $order_item ) {
		$meta_data = array();
		foreach ( $order_item->get_formatted_meta_data() as $var ) {
			$var               = (array) $var;
			$key               = str_replace( 'attribute_', '', $var['display_key'] );
			$val               = str_replace( 'attribute_', '', $var['value'] );
			$meta_data[ $key ] = $val;
		}

		return $meta_data;
	}

	/**
	 * Sorts an array by a key value, maintaining numeric indexes, and placing empty values last.
	 *
	 * @param array  $array Array to sort
	 * @param string $key   Key to sort value by
	 * @param string $order 'asc' to sort ascending, 'desc' to sort descending
	 *
	 * @return array Sorted array
	 */
	public function sort_array_empty_last( $array, $key, $order = 'asc' ) {
		$sort_func = function ( $a, $b ) use ( $key, $order ) {
			if ( ! isset( $a[ $key ] ) || ! isset( $b[ $key ] ) ) {
				return 0;
			}

			if ( $a[ $key ] === $b[ $key ] ) {
				return 0;
			}

			if ( empty( $a[ $key ] ) ) {
				return 1;
			}

			if ( empty( $b[ $key ] ) ) {
				return - 1;
			}

			$ascValue  = ( $a[ $key ] < $b[ $key ] ) ? - 1 : 1;
			$descValue = ( $a[ $key ] < $b[ $key ] ) ? 1 : - 1;

			return strcasecmp( $order, 'asc' ) === 0 ? $ascValue : $descValue;
		};

		uasort( $array, $sort_func );

		return $array;
	}
}
