<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$standard_view = plugin_dir_path( WCPP_PLUGIN_FILE ) . '/extensions/standard/view/license.php';
if ( file_exists( $standard_view ) ) {
	include $standard_view;
	return;
}
?>
<div class="pickingpal-liteupgrade">
	<h2><?php _e( 'Upgrade to PickingPal or PickingPal Pro' ); ?></h2>
	<div class="wrap">
		<h3><?php _e( 'Get access to additional features such as', 'woocommerce-pickingpal' ); ?>:</h3>
		<ul>
			<li class="list-item"><span class="tick">✔</span> Customize/personalize picking documents</li>
			<li class="list-item"><span class="tick">✔</span> Print Pick Tickets for each order</li>
			<li class="list-item"><span class="tick">✔</span> Custom SKU/UPC/GTIN fields</li>
			<li class="list-item"><span class="tick">✔</span> Identify Warehouse locations</li>
			<li class="list-item"><span class="tick">✔</span> Additional picking-related documents</li>
			<li class="list-item"><span class="tick">✔</span> Detailed scanning logs</li>
			<li class="list-item"><span class="tick">✔</span> Picking large quantity orders</li>
			<li class="list-item"><span class="tick">✔</span> & much more….</li>
		</ul>
		<small><i>Visit <a href="https://pickingpal.com/?ref=pplite" target="_blank">pickingpal.com</a> to learn more.</i></small>
	</div>
	<a class="button button-primary" href="https://pickingpal.com/shop/?ref=pplite" target="_blank">
		<?php _e( 'Buy the Upgrade', 'woocommerce-pickingpal' ); ?>
	</a>
</div>

<style>
	.wrap {
		margin-bottom: 20px;
	}
	.pickingpal-liteupgrade h2 {
		margin-bottom: 15px;
		font-size: 20px;
		line-height: 1.4;
	}
	.wrap h3 {
		margin-top: 0;
	}
	.list-item {
		margin-bottom: 10px;
	}
	.tick {
		color: green;
	}
</style>

