<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
add_thickbox();
$sound_url     = WCPP()->plugin_sounds_url();
$enable_picker = WCPP()->is_picker_enabled();
?>
<div class="tabs-content__wrap" style="padding-right:20px;">
	<audio id="audio_order_load" src="<?php echo $sound_url; ?>/01-load-order-sound.mp3" preload="auto"  ></audio>
	<audio id="audio_item_success" src="<?php echo $sound_url; ?>/02-pick-item-success-sound.mp3" preload="auto"  ></audio>
	<audio id="audio_item_error" src="<?php echo $sound_url; ?>/03-pick-item-error-sound.mp3" preload="auto"  ></audio>
	<audio id="audio_order_complete" src="<?php echo $sound_url; ?>/04-pick-order-complete-sound.mp3" preload="auto"  ></audio>
	<audio id="change_order_status" src="<?php echo $sound_url; ?>/05-change-order-status-sound.mp3" preload="auto"  ></audio>

	<div class="p_input__wrap">
		<div class="p_input">
			<label class="label_input_pp" for="pickingpal-input--order-number"><?php echo __( 'Order Number', 'woocommerce-pickingpal' ); ?></label>
			<input type="text" id="pickingpal-input--order-number" value="" <?php echo $enable_picker ? '' : 'disabled'; ?>>
			<input type="button" class="button button-primary" id="pickingpal-btn--load-order" value="<?php _e( 'Load', 'woocommerce-pickingpal' ); ?>">
		</div>
		<div class="p_input">
			<label class="label_input_pp" for="pickingpal-input--product-sku"><?php echo __( 'Product SKU', 'woocommerce-pickingpal' ); ?></label>
			<input type="text" id="pickingpal-input--product-sku" value="">
			<input type="button" class="button button-primary" id="pickingpal-btn--pick" value="<?php _e( 'Pick', 'woocommerce-pickingpal' ); ?>">
		</div>
	</div>

	<div id="pickingpal-progressbar">
		<div class="progress-label"></div>
	</div>

	<div id="pickingpal-status-x__wrap">
		<span id="pickingpal-status-x"></span>
		<span id="pickingpal-status-x-delimiter" style="display: none">|</span>
		<span id="pickingpal-order-status"></span>
	</div>

	<div class="pickingpal-items-row">
		<div class="pickingpal-itemslist">
			<div class="pickingpal-itemslist__header"><?php _e( 'Unpicked items', 'woocommerce-pickingpal' ); ?></div>
			<div id="pickingpal-itemslist--unpicked" class="pickingpal-itemslist__items"></div>
		</div>
		<div class="pickingpal-itemslist">
			<div class="pickingpal-itemslist__header"><?php _e( 'Picked items', 'woocommerce-pickingpal' ); ?></div>
			<div id="pickingpal-itemslist--picked" class="pickingpal-itemslist__items"></div>
		</div>
	</div>
	<div class="clearfix"></div>

	<div class="pickingpal-items-row">
		<div class="pickingpal-itemslist">
			<div class="pickingpal-itemslist__header"><?php _e( 'Unpicked items (backordered)', 'woocommerce-pickingpal' ); ?></div>
			<div id="pickingpal-itemslist--back-unpicked" class="pickingpal-itemslist__items"></div>
		</div>
		<div class="pickingpal-itemslist">
			<div class="pickingpal-itemslist__header"><?php _e( 'Picked items (backordered)', 'woocommerce-pickingpal' ); ?></div>
			<div id="pickingpal-itemslist--back-picked" class="pickingpal-itemslist__items"></div>
		</div>
	</div>
	<div class="clearfix"></div>

	<?php do_action( 'wcpp_after_view_items' ); ?>


	<div class="p_order_controls__wrap">
		<div class="left">
			<div id="pickingpal-order-buttons-left">
				<?php do_action( 'wcpp_picker_buttons_left' ); ?>
			</div>
		</div>

		<div class="right">
			<div id="pickingpal-order-buttons">
				<?php do_action( 'wcpp_picker_buttons_right' ); ?>
			</div>
		</div>
	</div>
	<br class="clear">
</div>

<!--PP-OVRD-ITM-QTY-->
<div class="modal" id="pickingpal-modal--override-item">
	<div class="modal-content">
		<div class="form-group">
			<label for="pickingpal-input--sku-over"><?php echo _e( 'Product SKU', 'woocommerce-pickingpal' ); ?>:&nbsp;</label>
			<input type="text" id="pickingpal-input--sku-over">
		</div>
		<div class="form-group">
			<input type="button" class="button button-primary" id="pickingpal-btn--load-product-over" value="<?php _e( 'Load', 'woocommerce-pickingpal' ); ?>">
		</div>
		<div class="form-group">
			<input type="number" min="1" max="" id="pickingpal-input--qty-over" placeholder="<?php echo _e( 'Qty', 'woocommerce-pickingpal' ); ?>">
		</div>
		<div class="form-group">
			<input type="button" class="button button-primary" id="pickingpal-btn--pick-over" value="<?php _e( 'Pick', 'woocommerce-pickingpal' ); ?>" >
		</div>
		<div class="form-group full-width">
			<span id="product_title_over"></span>
			<span id="product_qty_label_over"></span>
		</div>
	</div>
</div>