<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$help_image_url = isset( $help_image_url ) ? $help_image_url : null;
$fields         = array();
$active_fields  = isset( $active_fields ) ? $active_fields : array();
if ( isset( $active_tab_class ) ) {
	$fields = $active_tab_class->get_fields();
}
?>

<tr>
	<td class="table-td-align-top">
		<span class="header-2"><?php _e( 'Export Setup', 'woocommerce-pickingpal' ); ?></span>
	</td>
	<td>
		<div class="table-export">

			<div class="tb-row ">
				<div class="tb-col ">
					<h3><?php _e( 'Select Export Fields', 'woocommerce-pickingpal' ); ?>
						<img class="help_tip" style="margin: 0 0 0 2px;float: none" data-tip="sss"
							src="<?php echo $help_image_url; ?>"
							title="
							<?php
								_e(
									'Select items for export. See Docs for instructions.',
									'woocommerce-pickingpal'
								)
								?>
								" height="16" width="16">
					</h3>
				</div>
				<div class="tb-col ">
					<h3>
					<?php
					_e(
						'Export Field Order (Drag to reorder)',
						'woocommerce-pickingpal'
					)
					?>
							</h3>
				</div>
			</div>
			<div class="tb-row">
				<div class="tb-col ">

					<div class="woocommerce-pickingpal-table padding-5">
						<?php
						foreach ( $fields as $field => $value ) {
							?>
							<div class="row clearfix2" data-field="<?php echo $field; ?>">

								<div class="col1"><?php echo $field; ?></div>
								<div class="col2"><input class="wc-field" type="checkbox" value="1"
														name="fields[<?php echo $field; ?>]" <?php echo ! empty( $value ) ? 'checked' : ''; ?>>

								</div>
							</div>
							<?php
						}
						?>
						<div style="padding: 15px 5px">
							<a id="add_new_attribute" class="button button-primary"
								href="edit.php?post_type=product&page=product_attributes">
								<?php
								_e(
									'Add New Attribute',
									'woocommerce-pickingpal'
								)
								?>
									</a>
						</div>

					</div>
				</div>
				<div class="tb-col ">

					<div class="woocommerce-pickingpal-table active-fields padding-5">

						<?php
						if ( ! empty( $active_fields ) ) {
							foreach ( $active_fields as $field => $value ) {
								?>
								<div class="row clearfix2" data-field="<?php echo $field; ?>">
									<input type="hidden" name="active_fields[<?php echo $field; ?>]" value="1">
									<div class="col1"><?php echo $field; ?></div>
								</div>
								<?php
							}
						}
						?>

					</div>
				</div>
			</div>
		</div>
	</td>
</tr>
