<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WP_List_Table' ) ) {
	require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}
// require_once(ABSPATH . 'wp-admin/includes/template.php' );
if ( ! class_exists( 'WP_Screen' ) ) {
	require_once ABSPATH . 'wp-admin/includes/screen.php';
}

class WCPP_List_Log extends WP_List_Table {

	public function __construct() {

		parent::__construct(
			array(
				'singular' => __( 'Item', 'woocommerce-pickingpal' ),
				'plural'   => __( 'Items', 'woocommerce-pickingpal' ),
				'ajax'     => true,
			)
		);
	}

	/**
	 * Output the report
	 */
	public function output_report() {
		$this->prepare_items();

		echo '<form method="post" id="pickingpal">';

		$this->search_box( __( 'Search', 'woocommerce-pickingpal' ), 'search' );
		$this->display();

		echo '</form>';
	}

	/**
	 * Extra controls to be displayed between bulk actions and pagination.
	 *
	 * @since 3.1.0
	 *
	 * @param string $which
	 */
	protected function extra_tablenav( $which ) {
		if ( 'top' === $which ) {
			return;
		}
		do_action( 'wcpp_extra_tablenav_log', $which );
	}

	/**
	 * get_columns function.
	 */
	public function get_columns() {
		$columns = array(
			'tracking_order_number' => __( 'Order', 'woocommerce-pickingpal' ),
			'action_date_gmt'       => __( 'Last Scan', 'woocommerce-pickingpal' ),
			'display_name'          => __( 'Scanned by', 'woocommerce-pickingpal' ),
			'picking_status'        => __( 'Picking Status', 'woocommerce-pickingpal' ),
		);
		if ( WCPP()->get_standard_extension() ) {
			$columns['activity_log'] = __( 'Activity Log', 'woocommerce-pickingpal' );
		}
		return $columns;
	}

	public function prepare_items() {
		global $wpdb;

		$columns             = $this->get_columns();
		$hidden              = array( '' );
		$sortable            = $this->get_sortable_columns();
		$order_meta_table    = WCPP()->is_hpos_enabled() ? $wpdb->prefix . 'wc_orders_meta' : $wpdb->postmeta;
		$order_meta_id_field = WCPP()->is_hpos_enabled() ? 'order_id' : 'post_id';

		$this->_column_headers = array( $columns, $hidden, $sortable );

		$log_table_name            = WCPP_Order_Actions_Log_Store::get_table_name();
		$postmeta_key_order_number = WCPP_Order_Extend::ORDER_META_ORDER_NUMBER;
		$per_page                  = 10;

		$select    = "SELECT DISTINCT {$log_table_name}.*,pp_postmeta_1.meta_value as tracking_order_number, pp_users_1.display_name";
		$from      = "FROM {$log_table_name}, {$order_meta_table} as pp_postmeta_1, {$wpdb->users} as pp_users_1";
		$from_aggr = "(SELECT MAX(id) as id, order_id, MAX(action_date_gmt) as action_date_gmt
      from {$log_table_name}
      GROUP BY order_id
      ORDER BY action_date_gmt DESC) as {$log_table_name}_aggr";
		$from     .= ", {$from_aggr}";

		$where_tracking_order_number = $wpdb->prepare( "(pp_postmeta_1.{$order_meta_id_field} = {$log_table_name}.order_id AND pp_postmeta_1.meta_key = %s ) ", $postmeta_key_order_number );
		$where_display_name          = "(pp_users_1.ID = {$log_table_name}.user_id) ";
		$where_aggr                  = "({$log_table_name}.id = {$log_table_name}_aggr.id) ";
		$where                       = "{$where_tracking_order_number} AND {$where_display_name} AND $where_aggr";
		if ( ! empty( $_REQUEST['s'] ) ) {
			$s      = '%' . esc_sql( $_REQUEST['s'] ) . '%';
			$where .= $wpdb->prepare(
				" AND
					(pp_postmeta_1.meta_value LIKE '%s'
					OR
					{$log_table_name}.user_id IN (SELECT ID FROM {$wpdb->users} WHERE {$wpdb->users}.display_name LIKE '%s')
					OR
					{$log_table_name}.action_date_gmt LIKE '%s') 
				",
				$s,
				$s,
				$s
			);
		}

		$column    = isset( $_REQUEST['orderby'] ) ? $_REQUEST['orderby'] : 'action_date_gmt';
		$direction = isset( $_REQUEST['order'] ) ? $_REQUEST['order'] : 'desc';

		if ( $direction == 'asc' ) {
			$order_by = sprintf( 'ORDER BY %s ASC', sanitize_key( $column ) );
		} else {
			$order_by = sprintf( 'ORDER BY %s DESC', sanitize_key( $column ) );
		}

		if ( isset( $_REQUEST['paged'] ) ) {
			$paged        = $_REQUEST['paged'] > 0 ? $_REQUEST['paged'] : 1;
			$start_offset = ( $paged - 1 ) * $per_page;
		} else {
			$start_offset = 0;
		}

		$limit = $wpdb->prepare( 'LIMIT %d,%d', $start_offset, $per_page );

		if ( $where ) {
			$where = " WHERE $where";
		}
		$sql = "{$select} {$from} {$where} {$order_by} {$limit}";
		$r   = $wpdb->get_results( $sql, ARRAY_A );

		$data                   = array();
		$picked_order_action_id = WCPP_Order_Actions_Log_Store::ACTION_PICK_ORDER;
		foreach ( $r as $row ) {
			$order_id = $row['order_id'];

			// @todo replace : Too heavy for list loop, loads order and checks if all items picked!!
			$picking_status_id = $this->get_picking_status_id( $order_id );

			//
			// Pick complete should be determined from current order status and presence of pick complete log
			// Issue: WCPP_Order_Extend->pick_status is not reliable!
			//
			// $has_pick_complete_log = $this->order_has_action_log( $order_id, $picked_order_action_id );
			// if($has_pick_complete_log){
			// $pick_complete = true;
			// $order = WC_Order_Compat::get_order_compat( $order_id );
			// if($order && $order->get_id() == $order_id){
			// $order = new WCPP_Order_Extend($order);
			// $pick_complete = $order->is_pick_status_finished();
			// }
			// }

			$item                          = array();
			$item['order_post_id']         = $order_id;// id as number!
			$item['tracking_order_number'] = $row['tracking_order_number'];
			$item['action_date_gmt']       = $row['action_date_gmt'];
			$item['pick_complete']         = $picking_status_id == WCPP_Order_Extend::PICK_STATUS_FINISHED;

			$user                 = new WP_User( $row['user_id'] );
			$item['display_name'] = $user->display_name;

			$activity_url           = admin_url( 'admin.php?page=' . WCPP_admin::MENU_SLUG . '&tab=log&activity_log=1&order_log=' . $order_id );
			$item['activity_log']   = sprintf( "<a href='%s'>%s</a>", $activity_url, __( 'View', 'woocommerce-pickingpal' ) );
			$item['picking_status'] = $this->get_picking_status_name( $picking_status_id );
			$data[]                 = $item;
		}

		$this->items = $data;
		$amount_rows = $wpdb->get_var( "SELECT COUNT(DISTINCT {$log_table_name}.id) {$from} {$where}" );
		/**
		 * Pagination
		 */
		$this->set_pagination_args(
			array(
				'total_items' => count( $r ),
				'per_page'    => $per_page,
				'total_pages' => ceil( $amount_rows / $per_page ),
			)
		);
	}

	/**
	 * @param int|string $order_id
	 *
	 * @return int Picking status ID
	 */
	protected function get_picking_status_id( $order_id ) {
		$picker_data = new WCPP_Picker_Data( $order_id );
		$order_items = $picker_data->get_data();
		if ( $order_items['picked'] ) {
			return WCPP_Order_Extend::PICK_STATUS_FINISHED;
		}
		if ( $order_items['processing'] ) {
			return WCPP_Order_Extend::PICK_STATUS_PROCESSING;
		}
		return WCPP_Order_Extend::PICK_STATUS_NOT_SCANNED;
	}

	/**
	 * @param int $status_id
	 *
	 * @return string Picking status Name
	 */
	protected function get_picking_status_name( $status_id ) {
		if ( $status_id == WCPP_Order_Extend::PICK_STATUS_FINISHED ) {
			return __( 'Complete', 'woocommerce-pickingpal' );
		}
		if ( $status_id == WCPP_Order_Extend::PICK_STATUS_PROCESSING ) {
			return __( 'Processing', 'woocommerce-pickingpal' );
		}
		return __( 'Not Picked', 'woocommerce-pickingpal' );
	}

	/**
	 * @param $action_id int As defined in WCPP_Order_Actions_Log_Store action CONSTANTS
	 */
	protected function order_has_action_log( $order_id, $action_id ) {
		$args = array(
			'order_id'  => array( $order_id ),
			'action_id' => array( $action_id ),
		);
		$log  = WCPP_Order_Actions_Log_Store::get( $order_id, $action_id );
		if ( count( $log ) ) {
			return true;
		}
		return false;
	}

	function column_default( $item, $column_name ) {
		return isset( $item[ $column_name ] ) ? $item[ $column_name ] : '';
	}

	function column_picking_status( $item ) {
		$r = "<a class=\"modal_open thickbox\" href=\"#TB_inline?width=0&height=0&inlineId=modal&order_id={$item[ 'tracking_order_number' ]}\" data-id=\"{$item[ 'tracking_order_number' ]}\">" . $item['picking_status'] . '</a>';

		if ( $item['pick_complete'] ) {
			$r .= '<span class="dashicons dashicons-yes"></span>';
		}

		return $r;
	}

	public function get_sortable_columns() {
		return array(
			'tracking_order_number' => array( 'tracking_order_number', false ),
			'action_date_gmt'       => array( 'action_date_gmt', false ),
			'order_quantity'        => array( 'order_quantity', false ),
			'display_name'          => array( 'display_name', false ),
		);
	}
}
