<?php
/**
 * WCPP_Tab
 *
 * @class       WCPP_Tab
 * @category    Class
 */
abstract class WCPP_Tab {

	public $tab_name;

	public function __construct() {
		add_action( 'admin_enqueue_scripts', array( $this, 'thematic_enqueue_scripts' ) );
	}


	public function post_handler() {
		if ( $_REQUEST ) {
			$this->process_request( $_REQUEST );
		}
	}


	protected function process_request( $request ) {
		// do nothing
	}

	public function return_path_to_view() {
		$tab_name = $this->tab_name;
		return WCPP_admin::admin_views_path() . '/' . $tab_name . '.php';
	}

	/**
	 * Register js files
	 */
	public function register() {
	}

	public function thematic_enqueue_scripts() {
		wp_enqueue_script( 'jquery-ui-core' );
		wp_enqueue_script( 'jquery-ui-dialog' );
		wp_enqueue_script( 'jquery-ui-tabs' );
		wp_enqueue_style( 'wp-jquery-ui-dialog' );

		// from Woocommerce
		wp_enqueue_script( 'jquery-tooltip', WCPP()->plugin_url() . '/../woocommerce/assets/js/jquery-tiptip/jquery.tipTip.js', array(), WCPP_VERSION );
		wp_enqueue_style( 'admin-wc-req', WCPP()->plugin_url() . '/../woocommerce/assets/css/admin.css', array(), WCPP_VERSION );

		wp_enqueue_style( 'bootsrtap-table', WCPP()->plugin_css_url() . '/bootstrap-table.css', array(), WCPP_VERSION );
		wp_enqueue_style( 'jquery-woocommerce-pickingpal', WCPP()->plugin_css_url() . '/jquery-ui.css', array(), WCPP_VERSION );

		wp_enqueue_style( 'main-woocommerce-pickingpal', WCPP()->plugin_css_url() . '/main.css', array(), WCPP_VERSION );
		wp_enqueue_script( 'main-woocommerce-pickingpal', WCPP()->plugin_js_url() . '/main.js', array(), WCPP_VERSION );

		// for current TAB
		$tab_name = $this->tab_name;

		$script_name      = 'ajax_script_' . $tab_name;
		$script_path      = WCPP()->plugin_js_url() . '/' . $tab_name . '.js';
		$ajax_object_name = 'ajax_object_' . $tab_name;

		wp_enqueue_script(
			$script_name,
			$script_path,
			array( 'jquery' ),
			WCPP_VERSION
		);

		$nonce = wp_create_nonce( 'admin_nonce_' . $tab_name );

		wp_localize_script(
			$script_name,
			$ajax_object_name,
			array(
				'script_name' => $script_name,
				'ajax_url'    => WCPP()->ajax_url(),
				'nonce'       => $nonce,
			)
		);
	}
}
