<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * WCPP_Frontend
 *
 * PickingPal modifies WooCommerce UI
 *
 * @class       WCPP_Frontend
 * @category    Class
 */
class WCPP_Frontend {
	/**
	 * @var WCPP_Visibility_Controller
	 */
	protected $visibility_controller;

	public function __construct() {
		add_filter( 'woocommerce_available_variation', array( $this, 'add_sku_on_product_page_variable' ) );
		add_action( 'init', array( $this, 'init' ), 0 );

		$this->visibility_controller = WCPP_Visibility_Controller::init();
	}

	public function init() {
		// add new tab in products
		add_filter( 'woocommerce_product_tabs', array( $this, 'custom_tab_information' ) );

		// $skus = get_option(WCPP()->metakey_skus,array());
		$skus = WCPP()->settings_handler->get_option( 'metakey_skus' );
		if ( ! empty( $skus ) ) {
			if ( version_compare( WC_VERSION, '2.7', '<' ) ) {
				add_filter( 'woocommerce_get_sku', array( $this, 'add_sku_on_product_page_simple' ), 10, 2 );
			} else {
				add_filter( 'woocommerce_product_get_sku', array( $this, 'add_sku_on_product_page_simple' ), 10, 2 );
			}
		}
	}

	function add_sku_on_product_page_variable( $arr ) {
		$v_control = $this->visibility_controller;

		$sku_labels = array();
		foreach ( WCPP()->settings_handler->get_skus( 'only_enabled' ) as $key => $sku_data ) {
			if ( $v_control->is_visible( $key, $v_control::PRODUCT_PAGE_VIEW ) ) {
				$product_sku = get_post_meta( $arr['variation_id'], $key );
				if ( ! empty( $product_sku[0] ) ) {
					$sku_labels[] = $sku_data['label'] . ': ' . $product_sku[0];
				}
			}
		}

		if ( count( $sku_labels ) === 0 ) {
			return $arr;
		}

		$arr['sku'] .= ', ' . implode( ', ', $sku_labels );

		return $arr;
	}


	function add_sku_on_product_page_simple( $sku, $product ) {
		if ( is_admin() || ! $product ) {
			return $sku;
		}

		if ( self::get_product_type( $product ) == 'variable' ) {
			return $sku;
		}

		$v_control  = $this->visibility_controller;
		$product_id = method_exists( $product, 'get_id' ) ? $product->get_id() : $product->id;// for WC 2.6

		$sku_labels = array();
		foreach ( WCPP()->settings_handler->get_skus( 'only_enabled' ) as $key => $sku_data ) {
			if ( $v_control->is_visible( $key, $v_control::PRODUCT_PAGE_VIEW ) ) {
				$product_sku = get_post_meta( $product_id, $key );
				if ( ! empty( $product_sku[0] ) ) {
					$sku_labels[] = $sku_data['label'] . ': ' . $product_sku[0];
				}
			}
		}

		if ( count( $sku_labels ) === 0 ) {
			return $sku;
		}

		$sku .= ', ' . implode( ', ', $sku_labels );

		return $sku;
	}

	static function get_product_type( $product ) {
		if ( version_compare( WC_VERSION, '2.7', '<' ) ) {
			$type = $product->product_type;
		} else {
			$type = $product->get_type();
		}
		return $type;
	}

	// show TAB, INACTIVE!

	function custom_tab_information( $tabs ) {
		return $tabs;
		// $skus = get_option(WCPP()->metakey_skus,array());
		$skus    = WCPP()->settings_handler->get_option( 'metakey_skus' );
		$prod_id = get_the_ID();
		if ( ! $skus ) {
			return $tabs;
		}
		$show = false;

		$product = wc_get_product( $prod_id );
		if ( self::get_product_type( $product ) != 'variable' ) {
			foreach ( $skus as $key => $value ) {
				$sku = get_post_meta( $prod_id, $key );
				if ( ( $value['product_page'] == 'on' ) && ( $value['enabled'] == 'on' ) && ( ! empty( $sku[0] ) ) ) {
					$show = true;
					break;
				}
			}
		} else {
			foreach ( $product->get_available_variations() as $v ) {
				if ( $v['variation_is_visible'] && $v['variation_is_active'] ) {
					foreach ( $skus as $key => $value ) {
						$sku = get_post_meta( $v['variation_id'], $key );
						if ( ( $value['product_page'] == 'on' ) && ( $value['enabled'] == 'on' ) && ( ! empty( $sku[0] ) ) ) {
							$show = true;
							break;
						}
					}
				}
			}
		}

		if ( ! $show ) {
			return $tabs;
		}

		$tabs['desc_tab'] = array(
			'title'    => __( 'Additional SKU', 'woocommerce-pickingpal' ),
			'priority' => 50,
			'callback' => array( $this, 'custom_tab_information_content' ),
		);
		return $tabs;
	}

	function custom_tab_information_content() {
		$prod_id = get_the_ID();
		// $skus = get_option(WCPP()->metakey_skus,array());
		$skus    = WCPP()->settings_handler->get_option( 'metakey_skus' );
		$product = wc_get_product( $prod_id );
		// echo '<h2>'.__('Additional SKU', 'woocommerce-pickingpal').':</h2>';
		if ( $product->is_type( 'variable' ) ) {
			$this->render(
				'product_tab_variable',
				array(
					'product' => $product,
					'skus'    => $skus,
				)
			);
		} else {
			$this->render(
				'product_tab_other',
				array(
					'prod_id' => $prod_id,
					'skus'    => $skus,
				)
			);
		}
	}
}

new WCPP_Frontend();
