jQuery( document ).ready( function( $ ) {

    // Tooltips
    var tiptip_args = {
        'fadeIn': 50,
        'fadeOut': 50,
        'delay': 200
    };


    $( function() {
        $( ".help_tip" ).tipTip( tiptip_args );
    } );


    $( '.btn-export' ).click( function() {
        var product_sum_count = $( '.wp-table2' ).find( 'input[type=checkbox]:checked' ).length;
        if ( 0 == product_sum_count ) {
            // alert( '<?php _e( 'Please select one or more items.', 'woocommerce-pickingpal' ) ?>' )
            alert('Please select one or more items.', 'woocommerce-pickingpal'); //TODO translate
            return false;
        }

    })

});

jQuery( document ).ready( function( $ ) {

    var loader = $( '#loader' ).html(); // loading png


    function wp_table( target ) {
        var that = this;
        this.columns = { };

        this.update = function( data ) {

            var method = 'export_table';

            $( target ).html( loader );

            var query_data = {
                action:         ajax_object_export.script_name,
                _ajax_nonce:    ajax_object_export.nonce,
                method:         method,
                tab: active_tab,
                page: menu_slug,
            };

            if (typeof data !== 'undefined') {
                query_data = $.extend(query_data, data);
            }

            var request = $.ajax({
                url: ajax_object_export.ajax_url,
                method: "GET",
                data: query_data,
                dataType: "html"
            });

            request.done( function( response ) {
                jQuery( '.wp-table2' ).html( response );
                index_reindexing();
                set_functions_for_new_items();
            })
        };

        function index_reindexing() {
            var cols = $( target ).find( 'table thead th' );
            $.each(
                cols,
                function( i, col ) {
                    var name = $( col ).attr( 'id' );
                    that.columns[name] = {
                        index: i - 1
                    };
                }
            )
        }

        this.get_rows = function() {
            return $( target ).find( 'table tbody tr' );
        }

    }


    var table = new wp_table( '.wp-table2' );
    table.update(  );

  // function set_callback_functions() {
  //           $( '#product_name' ).keypress(
  //               function( e ) {
  //                   if ( e.keyCode == 13 ) { // pressed ENTER
  //                       filter_products()
  //                   }
  //               }
  //           );
  //          }

    function set_functions_for_new_items() {


        // sorting by name
        jQuery( '.wp-table2 th' ).find( 'a' ).click( function(e) {
            e.preventDefault();
            var data = $( this ).attr( 'href' ).split( '&' );
            direction = data[data.length - 1].split('=');
            order_by = data[data.length - 2].split('=');

            data = {};
            data[direction[0]] = direction[1];
            data[order_by[0]] = order_by[1];

            table.update( data );
            return false;

        } );



        jQuery('#search-submit').click(function () {
            data = {
                product_name: $( '#product_name' ).val(),
                product_cat_parent: $( '#product_cat_parent' ).val(),
            };
            table.update( data );

            return false;
        });

        // index of qty column
        var n_qty = 0, n_qty_i = 0;
        $.each(table.columns, function (name) {
            if (name == 'qty') n_qty = n_qty_i;
            n_qty_i++;
        })

        var rows = table.get_rows();
        var input = $( '<input>' );

        // transform qty text to qty input
        $.each( rows, function( i, row ) {
            var qty = $( row ).find( 'td:eq(' + n_qty + ')' ); // get cell row,qty

            var v = $( qty ).html();

            $( qty ).empty();

            var input_templ = input.clone().appendTo( qty );
            var img = $( '<img src="' + preloader_image_url + '" class="preloader">' );
            input_templ.val( v );
            input_templ.addClass( 'input_template' );
            img.appendTo( input_templ.parent( 'td' ) );
            var post_id = parseInt( $( qty ).closest( 'tr' ).find( '.id' ).text() );

            input_templ.keyup( function( h ) { // change product postmeta qty
                var timeoutID = 0;
                clearTimeout( timeoutID );
                var th = this;
                img.show();
                timeoutID = setTimeout( function() {

                    data = {
                        action:         ajax_object_export.script_name,
                        _ajax_nonce:    ajax_object_export.nonce,
                        method: 'save_qty',
                        value: $( th ).val(),
                        post_id: post_id,
                        tab: active_tab,
                        page: menu_slug,
                    };

                    $.post(
                        ajax_object_export.ajax_url,
                        data,
                        function( response ) {
                            img.hide()
                        },
                        'json'
                    )

                    // var request = $.ajax({
                    //     url: ajax_object.ajax_url,
                    //     method: "GET",
                    //     data: data,
                    //     dataType: "json"
                    // });
                    //
                    // request.done( function( response ) {
                    //     img.hide();
                    // })

                }, 1000 )
            } )

        } )
    }


} )