
jQuery( document ).ready( function( $ ) {

    var ajax_object = window['ajax_object_' + 'log']; // TODO insert filename
    var activity = typeof window['ajax_object_' + 'log' + '_activity_log'] !== "undefined" ? window['ajax_object_' + 'log' + '_activity_log'] : {};
    var loader = $( '#loader' ).html();
    var target = '.wp-table';

    load();


    function load( data ) {
        $( target ).html( loader );

        var query_data = {};

        if (typeof activity.activity !== 'undefined') {
            query_data = {
                action: ajax_object.script_name,
                _ajax_nonce: ajax_object.nonce,
                method: 'print_activity_log',
                order_id: activity.order_id,
                tab: active_tab,
                page: menu_slug,
            };
        } else {
            query_data = {
                action: ajax_object.script_name,
                _ajax_nonce: ajax_object.nonce,
                method: 'print_log',
                tab: active_tab,
                page: menu_slug,
            };
        }

        if (typeof data !== 'undefined') {
            query_data = $.extend(query_data, data);
        }

        var request = $.ajax({
            url: ajax_object.ajax_url,
            method: "GET",
            data: query_data,
            dataType: "html",
        });

        request.done( function( response ) {
            $( target ).html( response );
            add_event();
        });
    }

    function find() {
        data = {
            s: $( '#search-search-input' ).val(),
        };

        load(data);
    }

    function add_event() {

        $( '.wp-list-table' ).find( 'th > a' ).click( function() {

            var query = $( this ).attr( 'href' ).split( '?' )[1];

            var request = $.ajax({
                url: ajax_object.ajax_url,
                method: "GET",
                data: query,
                dataType: "html",
            });

            request.done( function( response ) {
                $( target ).html( response );
                add_event();
            });
            return false;
        } );

        $( '#pickingpal' ).find( 'input' ).keypress( function( ev ) {
	        var charCode = ( ev.which ) ? ev.which : ev.keyCode;
            if ( charCode === 13 ) {
                find();
                return false;
            }
        } );

        $( '#search-submit' ).click( function() {
            find();
            return false;
        } );

        $( ".modal_open" ).click( function( e ) {

            var method = 'load_order_log';

            $( '#modal_body' ).html( loader );

            data = {
                action:         ajax_object.script_name,
                _ajax_nonce:    ajax_object.nonce,
                method:         method,
                tab: active_tab,
                page: menu_slug,
                order_id: $( this ).data( 'id' ),
            };

            var request = $.ajax({
                url: ajax_object.ajax_url,
                method: "GET",
                data: data,
                dataType: "html",
            });

            request.done( function( response ) {
                $( '#modal_body' ).html( response );
                resizeTB( 600 )
            });
        } );

        $( '.pagination-links a:not(.disabled)' ).click( function( e ) {
            var url = $( this ).attr( 'href' );
            $.get( url, '', function( data ) {
                $( '.wp-table' ).html( data )
                add_event();
            }, 'html' )
            return false;
        } )

        $( '.pagination-links a.disabled' ).click( function( e ) {
            return false;
        } )
    }

} )