<?php

class WCPP_Extension_Standard {

	private $initialised = false;
	private $path_to_views;
	private $plugin_assets_url;


	public function init() {
		if ( ! $this->initialised ) {
			if ( ! class_exists( 'WCPP_API_Manager' ) ) {
				require_once $this->get_extension_path() . '/includes/class-wcpp-api-manager.php';
			}
			$this->path_to_views = $this->get_extension_path() . '/view';
			$this->init_api_manager();

			add_action( 'wcpp_extra_tablenav_log', array( $this, 'output_extra_tablenav_log' ) );
			add_action( 'wcpp_picker_buttons_right', array( $this, 'output_picker_buttons_right' ) );
			add_action( 'wcpp_picker_buttons_left', array( $this, 'output_picker_buttons_left' ) );
			add_action( 'admin_init', array( $this, 'print_gate_standard' ) );

			$this->extend_woocommerce_ui();
		}
		$this->initialised = true;
	}


	public function get_tab( $name ) {
		if ( $name == 'settings' ) {
			include_once $this->get_extension_path() . '/includes/admin/tabs/class-wcpp-settings-tab.php';
			return new WCPP_Settings_Tab();
		}
		if ( $name == 'export' ) {
			include_once $this->get_extension_path() . '/includes/admin/tabs/class-wcpp-export-tab.php';
			return new WCPP_Export_Tab();
		}
		return null;
	}

	private function init_api_manager() {
		$api_manager = WCPP_API_Manager::get();
	}

	private function get_extension_path() {
		return WCPP()->plugin_path() . '/extensions/standard';
	}
	private function get_path_to_view( $view_name ) {
		return $this->path_to_views . '/settings/' . $view_name . '.php';
	}

	/**
	 * Actions that change the UI, similar to actions in class-wcpp-admin-tweak-ui.php
	 */
	private function extend_woocommerce_ui() {
		include_once $this->get_extension_path() . '/includes/admin/class-wcpp-admin-tweak-ui-standard.php';
		$extendUi = new WCPP_Admin_Tweak_UI_Standard();
	}

	public function output_extra_tablenav_log( $which ) {
		$activity_url = admin_url( 'admin.php?page=' . WCPP_admin::MENU_SLUG . '&tab=log&activity_log=1' );
		?>
		<div style="float:left; padding-top: 5px">
			<span>
				<a href="<?php echo $activity_url; ?>"><?php echo _e( 'View Picking Activity Detail Log', 'woocommerce-pickingpal' ); ?></a>
			</span>
		</div>
		<?php
	}

	public function output_picker_buttons_right() {
		$order_edit_uri = add_query_arg(
			array(
				'post'   => '{{order_id}}',
				'action' => 'edit',
			),
			admin_url( 'post.php' )
		);
		if ( WCPP()->is_hpos_enabled() ) {
			$order_edit_uri = add_query_arg(
				array(
					'id'     => '{{order_id}}',
					'page'   => 'wc-orders',
					'action' => 'edit',
				),
				admin_url( 'admin.php' )
			);
		}
		?>
			<button data-url="<?php echo $order_edit_uri; ?>"
					class="button button-primary"
					id="pickingpal-btn--view-order">
				<?php _e( 'View order', 'woocommerce-pickingpal' ); ?>
			</button>

			<button  data-url="<?php echo wp_nonce_url( admin_url( '?method=pickingpal_print_packing_slip&ids[0]=order_id' ) ); ?>"
					class="button button-primary"
					id="pickingpal-btn--print-slip">
				<?php _e( 'Print Packing Slip', 'woocommerce-pickingpal' ); ?>
			</button>
		<?php
	}

	public function output_picker_buttons_left() {
		$loading_image_url = WCPP()->plugin_imgs_url() . '/loading.gif';
		?>
			<button class="button loading-button warning" id="pickingpal-btn--reset-picking-status" style="display: none;"
					title="<?php _e( 'Reset Picking Status', 'woocommerce-pickingpal' ); ?>">
				<img style="margin-left: -15px; width: 22px; vertical-align: text-bottom" src="<?php echo $loading_image_url; ?>">
				<?php _e( 'Reset picked items', 'woocommerce-pickingpal' ); ?>
			</button>
		<?php
	}

	public function filter_admin_tab_names( $tab_names ) {
		$tab_names             = is_array( $tab_names ) ? $tab_names : array();
		$tab_names['settings'] = __( 'Settings', 'woocommerce-pickingpal' );
		$tab_names['export']   = __( 'Export', 'woocommerce-pickingpal' );
		return $tab_names;
	}

	public function print_gate_standard() {
		include_once $this->get_extension_path() . '/includes/admin/class-wcpp-print-handler-standard.php';
		$print_handler = new WCPP_Print_Handler_Standard();
		$method        = isset( $_REQUEST['method'] ) ? $_REQUEST['method'] : null;
		if ( $method ) {
			$print_handler->handle( $method );
		}
	}
}
