<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}


/**
 * WCPP_Admin_Tweak_UI_Standard
 *
 * PickingPal modifies WooCommerce UI
 */
class WCPP_Admin_Tweak_UI_Standard {

	protected $settings;
	private $plugin_assets_url;

	public function __construct( $settings = array() ) {
		$this->settings          = $settings;
		$this->plugin_assets_url = WCPP()->plugin_url() . '/extensions/pro/assets';

		// hpos compatible
		add_filter( 'bulk_actions-woocommerce_page_wc-orders', array( $this, 'register_bulk_actions' ) );
		// legacy (not hpos compatible)
		add_filter( 'bulk_actions-edit-shop_order', array( $this, 'register_bulk_actions' ) );

		add_action( 'load-edit.php', array( $this, 'woocommerce_custom_bulk_action' ) );
	}


	public function register_bulk_actions( $bulk_actions ) {
		$bulk_actions                    = is_array( $bulk_actions ) ? $bulk_actions : array();
		$bulk_actions['print_pick_list'] = __( 'Print Pick List', 'woocommerce-pickingpal' );
		return $bulk_actions;
	}

	public function woocommerce_custom_bulk_action() {
		$wp_list_table = _get_list_table( 'WP_Posts_List_Table' );
		$action        = $wp_list_table->current_action();

		if ( isset( $_REQUEST['post'] ) ) {
			$ids = $_REQUEST['post'];
		} else {
			return;
		}
		switch ( $action ) {
			case 'print_pick_list':
				$sendback = wp_nonce_url( admin_url() );
				$sendback = add_query_arg(
					array(
						'method' => 'pickingpal_print_pick_list',
						'ids'    => $ids,
					),
					$sendback
				);
				break;

			default:
				return;
		}
		wp_redirect( $sendback );

		exit();
	}
}
