<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$license_class  = WCPP_Api_Manager::get();
$license_active = $license_class->is_activated_license( true );
$product_id     = WCPP_Api_Manager::get_product_id();
?>
<h1><?php echo WCPP()->get_app_name(); ?></h1>
<h2> <?php echo _e( 'Licence Status', 'woocommerce-pickingpal' ); ?>:
	<small>
<?php echo $license_active ? _e( 'Active', 'woocommerce-pickingpal' ) : _e( 'Not Active', 'woocommerce-pickingpal' ); ?>
	</small>
</h2>

<p>
<?php $license_class->wc_am_activation_info(); ?>
</p>
<a class="button button-primary" href="<?php echo esc_url( admin_url( 'options-general.php?page=wc_am_client_' . $product_id . '_dashboard' ) ); ?>">
	<?php echo $license_active ? _e( 'Manage License', 'woocommerce-pickingpal' ) : _e( 'Activate Licence', 'woocommerce-pickingpal' ); ?>
</a>

<?php if ( ! WCPP()->is_pro() ) : ?>
	<div class="pickingpal-liteupgrade">
		<h2><?php _e( 'Upgrade to PickingPal Pro', 'woocommerce-pickingpal' ); ?></h2>
		<div class="wrap">
			<h3><?php _e( 'Get access to additional features such as', 'woocommerce-pickingpal' ); ?>:</h3>
			<ul>
				<li class="list-item"><span class="tick">✔</span> Use on 2 sites – Ability for purchaser to use PickingPal on 2 sites simultaneously. License is valid to purchaser-owned sites only</li>
				<li class="list-item"><span class="tick">✔</span> Pick reset override barcode – Quickly reset the picking status of an order by scanning a barcode</li>
				<li class="list-item"><span class="tick">✔</span> Advanced visibility settings – More options to show/hide certain information in different areas of PickingPal or the site</li>
				<li class="list-item"><span class="tick">✔</span> Auto pick digital goods – For shops that offer a combination of physical and digital goods on an order, when enabled, this feature will automatically pick items that are flagged as Virtual or Downloadable</li>
				<li class="list-item"><span class="tick">✔</span> Pick to Bin – Enhanced Pick List that groups the pick list into order “bins”, allowing the picker to gain production efficiencies in order fulfillment</li>
				<li class="list-item"><span class="tick">✔</span> Order status change on pick complete – Ability to automatically up to two (2) order status change rules when an order reaches 100% pick-complete</li>
				<li class="list-item"><span class="tick">✔</span> Order status change via barcode scanning – Ability to update/change the order status via scanning special pre-defined barcodes</li>
				<li class="list-item"><span class="tick">✔</span> Picking order statuses – Ability to set valid order statuses for picking to prevent picking cancelled or unpaid orders</li>
			</ul>
			<small><i>Visit <a href="https://pickingpal.com/?ref=ppstandard" target="_blank">pickingpal.com</a> to learn more.</i></small>
		</div>
		<a class="button button-primary" href="https://pickingpal.com?ref=ppstandard" target="_blank">
			<?php _e( 'Buy the Upgrade', 'woocommerce-pickingpal' ); ?>
		</a>
	</div>

	<style>
		.wrap {
			margin-bottom: 20px;
		}
		.pickingpal-liteupgrade h2 {
			margin-bottom: 15px;
			font-size: 20px;
			line-height: 1.4;
		}
		.wrap h3 {
			margin-top: 0;
		}
		.list-item {
			margin-bottom: 10px;
		}
		.tick {
			color: green;
		}
	</style>


<?php endif; ?>
