<?php
/**
 * Created by PhpStorm.
 * User: q
 * Date: 25.12.17
 * Time: 14:09
 */

class WCPP_Admin_Helper {

	public static function is_digital( $product ) {
		if ( class_exists( 'WC_Product_Bundle' ) && $product instanceof WC_Product_Bundle ) {
			$digital = $product->is_downloadable();
		} else {
			$digital = $product->is_virtual() || $product->is_downloadable();
		}

		return apply_filters( 'wc_pickingpal_is_digital', $digital, $product );
	}

	public static function get_product_variation_id( $product ) {
		if ( version_compare( WC_VERSION, '3.0', '<' ) ) {
			$type = $product->variation_id;
		} else {
			$type = $product->get_id();
		}
		return $type;
	}


	public static function get_product_variations( $_product ) {
		$variation = array();

		if ( self::is_variation( $_product ) ) {
			$variation_data = $_product->get_variation_attributes();
			if ( ! empty( $variation_data ) ) {

				foreach ( $variation_data as $label => $value ) {
					$attribute_key = str_replace( 'attribute_', '', $label );
					$label         = wc_attribute_label( $attribute_key, $_product );
					if ( taxonomy_exists( $attribute_key ) ) {
						$term = get_term_by( 'slug', $value, $attribute_key );
						if ( ! is_wp_error( $term ) && is_object( $term ) && $term->name ) {
							$value = $term->name;
						}
					}
					$variation[] = compact( 'label', 'value' );
				}
			}
		}

		return $variation;
	}

	public static function wcpp_render_template( $template_name, $params = array(), $template_path = null ) {
		$default_path  = ( null == $template_path );
		$e_template    = WCPP()->return_url_and_path_existing_template( $template_name, $default_path );
		$template_path = ! empty( $e_template['path'] ) ? $e_template['path'] : $template_path;

		extract( $params );

		$template_dir = $template_path . '/' . $template_name . '.php';

		include $template_dir;
	}

	public static function is_variation( $product ) {
		if ( version_compare( WC_VERSION, '2.7', '<' ) ) {
			$type = $product->product_type;
		} else {
			$type = $product->get_type();
		}
		return in_array( $type, array( 'product_variation', 'variation' ) );
	}

	private static function fix_name_attributes_bug( $text ) {
		$text = preg_replace( '#,,+#', ',', $text );
		$text = preg_replace( '#(?<=&ndash;\s),#', '', $text );
		return $text;
	}

	private static function get_additional_skus( $product_id ) {
		// $skus = get_option(WCPP()->metakey_skus,array());
		$skus    = WCPP()->settings_handler->get_option( 'metakey_skus' );
		$add_sku = array();
		if ( ! $skus ) {
			return $add_sku;
		}
		foreach ( $skus as $key => $value ) {
			if ( ( $value['enabled'] == 'off' ) ) {
				continue;
			}
			$value = get_post_meta( $product_id, $key );
			if ( isset( $value[0] ) ) {
				$add_sku[] = $value[0];
			}
		}

		return $add_sku;
	}

	/**
	 * @param WC_Product $product
	 */
	public static function get_product_formatted_name( $product ) {
		if ( $product->get_sku() ) {
			$identifier = $product->get_sku();
		} else {
			$identifier = '#' . $product->get_id();
		}

		$edit_post_id   = ( $product instanceof WC_Product_Variation ) ? $product->get_parent_id() : $product->get_id();
		$edit_post_link = admin_url( 'post.php?post=' . $edit_post_id . '&action=edit' );
		$formatted_name = sprintf( '%2$s (<a href="%3$s" target="_blank">%1$s</a>)', $identifier, $product->get_name(), $edit_post_link );

		if ( $product instanceof WC_Product_Variation ) {
			$formatted_variation_list = wc_get_formatted_variation( $product, true, true, true );
			$formatted_name          .= '<span class="description">' . $formatted_variation_list . '</span>';
		}

		return $formatted_name;
	}
}
