<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

class WCPP_Order_Extend {
	const ORDER_META_PICK_STATUS  = '_pp_order_pick_status';
	const ORDER_META_ORDER_NUMBER = '_pp_order_number';

	/**
	 * @var WC_Order
	 */
	protected $order;

	/**
	 * @var int
	 */
	protected $pick_status;
	const PICK_STATUS_NOT_SCANNED = 1;
	const PICK_STATUS_PROCESSING  = 2;
	const PICK_STATUS_FINISHED    = 3;

	/**
	 * @var string
	 */
	protected $order_number;

	/**
	 * @param WC_Order $order
	 *
	 * @throws Exception
	 */
	public function __construct( $order ) {
		if ( ! ( $order instanceof WC_Order ) ) {
			throw new Exception( 'Wrong type!' );
		}

		if ( $order->get_id() === 0 ) {
			throw new Exception( 'The order should exist!' );
		}

		$this->order = $order;
		$this->set_pick_status( (int) ( $this->order->get_meta( self::ORDER_META_PICK_STATUS ) ) );
		$this->set_order_number( $this->order->get_meta( self::ORDER_META_ORDER_NUMBER ) );
	}

	/**
	 * @return int
	 */
	public function save() {
		$this->order->update_meta_data( self::ORDER_META_PICK_STATUS, $this->pick_status );
		$this->order->update_meta_data( self::ORDER_META_ORDER_NUMBER, $this->order_number );
		return $this->order->save();
	}

	/**
	 * @param int $status
	 */
	public function set_pick_status( $status ) {
		if ( ! is_int( $status ) ) {
			return;
		}

		$allowed_statuses = array(
			self::PICK_STATUS_NOT_SCANNED,
			self::PICK_STATUS_PROCESSING,
			self::PICK_STATUS_FINISHED,
		);

		if ( in_array( $status, $allowed_statuses, true ) ) {
			$this->pick_status = $status;
		} else {
			$this->pick_status = self::PICK_STATUS_NOT_SCANNED;
		}
	}

	public function get_pick_status() {
		return $this->pick_status;
	}

	public function is_pick_status_finished() {
		return $this->pick_status === self::PICK_STATUS_FINISHED;
	}

	/**
	 * @return bool
	 */
	public function is_processing() {
		return $this->pick_status === self::PICK_STATUS_PROCESSING;
	}

	/**
	 * @return bool
	 */
	public function is_scanned() {
		return $this->pick_status !== self::PICK_STATUS_NOT_SCANNED;
	}

	public function set_order_number( $number ) {
		if ( $number = (string) $number ) {
			$this->order_number = $number;
		}
	}

	/**
	 * @return string
	 */
	public function get_order_number() {
		return $this->order_number;
	}
}
