<?php

class WCPP_Print_Template_Data {
	private $template_vars = array();

	/**
	 * WCPP_Print_Template_Data constructor.
	 *
	 * @param array $template_vars Array of template variables
	 *
	 * @throws Exception If not array
	 */
	public function __construct( $template_vars ) {
		if ( ! is_array( $template_vars ) ) {
			throw new Exception( 'Template vars must be an array' );
		}
		$this->template_vars = $template_vars;
	}

	/**
	 * This will print the variable in a format suitable for display.
	 * If a formatted version of the variable is not available
	 * an HTML escaped value of the variable will be printed.
	 *
	 * This method will not attempt to print any variables that
	 * cannot be returned as a string.
	 *
	 * @param $key
	 *
	 * @return void
	 */
	public function print_var( $key = null ) {
		$formatted_value = $this->get_var( $key . '_formatted' );
		if ( $formatted_value ) {
			echo $formatted_value;
			return;
		}
		$this->print_if_printable( $this->get_var( $key ) );
	}

	/**
	 * Get a template variable by key, if key is not set, return null
	 *
	 * @param $key
	 *
	 * @return mixed|null
	 */
	public function get_var( $key = null ) {
		if ( isset( $this->template_vars[ $key ] ) ) {
			return $this->template_vars[ $key ];
		}
		return null;
	}

	/**
	 * Returns an array of all the data keys available
	 *
	 * @return array Array of data keys
	 */
	public function list_properties() {
		return array_keys( $this->template_vars );
	}

	public function toArray() {
		$template_vars = $this->template_vars;
		foreach ( $this->template_vars as $key => $value ) {
			if ( is_a( $value, 'WCPP_Print_Template_Data' ) ) {
				$template_vars[ $key ] = $value->toArray();
			}
			if ( is_array( $value ) ) {
				foreach ( $value as $sub_key => $sub_value ) {
					if ( is_a( $sub_value, 'WCPP_Print_Template_Data' ) ) {
						$template_vars[ $key ][ $sub_key ] = $sub_value->toArray();
					}
				}
			}
		}
		return $template_vars;
	}

	private function print_if_printable( $value ) {
		if ( ! is_array( $value ) && ! is_object( $value ) ) {
			$value = (string) $value;
			echo esc_html( $value );
		}
	}
}
