<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$help_image_url = isset( $help_image_url ) ? $help_image_url : null;
$logo           = isset( $logo ) ? $logo : null;
$menu_slug      = isset( $menu_slug ) ? $menu_slug : null;
?>

<tr>
	<td class="table-td-align-top">
		<span class="header-2"><?php _e( 'Company Logo URL', 'woocommerce-pickingpal' ); ?>:</span>
		<img class="help_tip" data-tip="ddd" src="<?php echo $help_image_url; ?>"
			title="
			<?php
				echo _e(
					'Choose a logo to display in the header of your print documents. Use Select image button to select an image from the Media Library, or to upload a new one.',
					'woocommerce-pickingpal'
				)
				?>
				" height="16" width="16">
	</td>
	<td>
		<input type="text" name="url_file" id="url_file" value="<?php echo $logo; ?>">
		<input type="button" class="button button-primary" id="upload_logo_button"
				value="<?php _e( 'Select image', 'woocommerce-pickingpal' ); ?>">
	</td>
</tr>
<tr>
	<td>

	</td>
	<td>
		<div>
			<?php
			if ( $logo ) {
				?>
				<div class="delete-logo">
					<img src="<?php echo $logo; ?>">
					<a href="<?php echo admin_url( 'admin.php?page=' . $menu_slug . '&tab=settings&delete_logo=1' ); ?>">
										<?php
										_e(
											'Remove logo',
											'woocommerce-pickingpal'
										)
										?>
							</a>
				</div>

				<?php
			}
			?>

		</div>
	</td>
</tr>
