<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$v_control      = WCPP_Visibility_Controller::init();
$help_image_url = isset( $help_image_url ) ? $help_image_url : null;
?>

<style>
	#pp-visibility-table td {
		width: 100px;
		height: 50px;
	}

	#pp-visibility-table {
		border-spacing: 0;
		border-collapse: collapse;
	}
	#pp-visibility-table tr,
	#pp-visibility-table td,
	#pp-visibility-table th {
		border: solid 1px grey;
		text-align: center;
	}

	#pp-visibility-table .switchbtn {
		display: inline-block;
	}

	#pp-visibility-table .help_tip {
		float: none;
		margin: 0;
	}

</style>

<tr class="table-td-align-top">
	<td>
		<span>
			<?php echo __( 'Visibility Settings', 'woocommerce-pickingpal' ); ?>
			<img class="help_tip" data-tip="" src="<?php echo $help_image_url; ?>"
				title="<?php _e( 'Set option to ON to show the value, or OFF to hide column value. Columns indicate where the value will be shown or hidden.', 'woocommerce-pickingpal' ); ?>"
				height="16"
				width="16">
			</span>
	</td>
	<td>
		<table id="pp-visibility-table">
			<thead>
				<th><?php echo __( 'Show/Hide', 'woocommerce-pickingpal' ); ?></th>
				<?php foreach ( $v_control->get_all_views() as $key ) { ?>
					<th><?php echo $v_control->get_view_label( $key ); ?></th>
				<?php } ?>
			</thead>
			<tbody>
			<?php foreach ( $v_control->get_all_features() as $feat_key ) { ?>
				<?php $inaccessible_counter = 0; ?>
				<tr>
					<td><?php echo $v_control->get_feature_label( $feat_key ); ?></td>
					<?php foreach ( $v_control->get_all_views() as $view_key ) { ?>
						<?php if ( $inaccessible_counter > 0 && $v_control->get_status( $feat_key, $view_key ) !== $v_control::INACCESSIBLE_STATUS ) : ?>
							<td colspan="<?php echo $inaccessible_counter; ?>">
								<div style="height: 25px;text-align: center; margin: 1em 0;">
							<span style="font-weight: bold; vertical-align: bottom;">
									<?php echo wc_strtoupper( __( 'Upgrade', 'woocommerce-pickingpal' ) ); ?>
								</span>
									<img class="help_tip" data-tip="" src="<?php echo $help_image_url; ?>"
										style="padding: 0 !important;"
										title="<?php _e( 'This feature is available in PickingPal Pro', 'woocommerce-pickingpal' ); ?>"
										height="16"
										width="16">
								</div>
							</td>
							<?php
							$inaccessible_counter = 0;
						endif;
						?>

						<?php if ( $v_control->get_status( $feat_key, $view_key ) === $v_control::NO_SENSE_STATUS ) : ?>
							<td class="inactive"></td>
						<?php elseif ( $v_control->get_status( $feat_key, $view_key ) === $v_control::INACCESSIBLE_STATUS ) : ?>
							<?php ++$inaccessible_counter; ?>
						<?php else : ?>
							<td>
								<span>
									<div class="switchbtn"></div>
									<input type="hidden" id="pickingpal-visibility-<?php echo $feat_key; ?>-<?php echo $view_key; ?>"
										value="<?php echo $v_control->is_visible( $feat_key, $view_key ) ? 'true' : 'false'; ?>"
										name="visibility[<?php echo $feat_key; ?>][<?php echo $view_key; ?>]" class="switchbtn_value">
								</span>
							</td>
						<?php endif; ?>
					<?php } ?>

					<?php if ( $inaccessible_counter > 0 ) : ?>
						<td colspan="<?php echo $inaccessible_counter; ?>">
							<div style="height: 25px;text-align: center; margin: 1em 0;">
							<span style="font-weight: bold; vertical-align: bottom;">
									<?php echo wc_strtoupper( __( 'Upgrade', 'woocommerce-pickingpal' ) ); ?>
								</span>
								<img class="help_tip" data-tip="" src="<?php echo $help_image_url; ?>"
									style="padding: 0 !important;"
									title="<?php _e( 'This feature is available in PickingPal Pro', 'woocommerce-pickingpal' ); ?>"
									height="16"
									width="16">
							</div>
						</td>
						<?php
							$inaccessible_counter = 0;
							endif;
					?>
				</tr>
			<?php } ?>
			</tbody>
		</table>
	</td>
</tr>
