<?php
/**
 * Metabox config file.
 *
 * @link       https://shapedplugin.com
 * @since      3.0.0
 *
 * @package    WP_Carousel_Pro
 * @subpackage WP_Carousel_Pro/admin/views
 */

use ShapedPlugin\WPCarouselPro\Admin\views\sp_framework\classes\SP_WPCP_Framework;

if ( ! defined( 'ABSPATH' ) ) {
	die;
} // Cannot access pages directly.
//
// Style settings section begin.
//
SP_WPCP_Framework::createSection(
	$wpcp_carousel_shortcode_settings,
	array(
		'title'  => __( 'Display Settings', 'wp-carousel-pro' ),
		'icon'   => 'wpcp-icon-display',
		'fields' => array(
			array(
				'type'  => 'tabbed',
				'class' => 'wp-carousel-style-tabs',
				'tabs'  => array(
					// Item Style.
					array(
						'title'  => __( 'Item Styles', 'wp-carousel-pro' ),
						'icon'   => 'wpcp-icon-tab_style-settings',
						'fields' => array(
							array(
								'id'         => 'section_title',
								'type'       => 'switcher',
								'title'      => __( 'Section Title', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide the section title.', 'wp-carousel-pro' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'wpcp_section_background',
								'type'       => 'color',
								'title'      => __( 'Section Background Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a background color for the Section.', 'wp-carousel-pro' ),
								'default'    => 'rgb(159, 160, 81)',
								'dependency' => array( 'wpcp_slider_style|wpcp_layout', '==|==', 'fashion|slider', true ),
							),
							array(
								'id'              => 'wpcp_content_carousel_height',
								'type'            => 'dimensions_advanced',
								'title'           => __( 'Slide Height', 'wp-carousel-pro' ),
								'subtitle'        => __( 'Set height for the slides in pixel.', 'wp-carousel-pro' ),
								'top_icon'        => '<i class="fa fa-arrows-v"></i>',
								'top_placeholder' => 'height',
								'right'           => false,
								'bottom'          => false,
								'left'            => false,
								'color'           => false,
								'styles'          => array(
									'min-height',
									'height',
								),
								'default'         => array(
									'top'   => 300,
									'style' => 'min-height',
									'unit'  => 'px',
								),
								'dependency'      => array( 'wpcp_carousel_type', '==', 'content-carousel', true ),
							),
							array(
								'id'         => 'wpcp_content_style',
								'class'      => 'wpcp_content_style',
								'type'       => 'image_select',
								'title'      => __( 'Items Style', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Select an item style for the title, description, meta etc.', 'wp-carousel-pro' ),
								'options'    => array(
									'default'          => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/default/default.svg',
										'text'  => __( 'Classic', 'wp-carousel-pro' ),
									),
									'with_overlay'     => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/overlay/overlay.svg',
										'text'  => __( 'Overlay', 'wp-carousel-pro' ),
									),
									'caption_full'     => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/caption-full/caption_full.svg',
										'text'  => __( 'Caption Full', 'wp-carousel-pro' ),
									),
									'caption_partial'  => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/caption-partial/caption_partial.svg',
										'text'  => __( 'Caption Part', 'wp-carousel-pro' ),
									),
									'content_diagonal' => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/diagonal/diagonal.svg',
										'text'  => __( 'Diagonal', 'wp-carousel-pro' ),
									),
									'content_box'      => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/content-box/content-box.svg',
										'text'  => __( 'Content Box', 'wp-carousel-pro' ),
									),
									'moving'           => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/caption-partial/content-moving.svg',
										'text'  => __( 'Moving', 'wp-carousel-pro' ),
									),
								),
								'default'    => 'default',
								'dependency' => array( 'wpcp_carousel_type', 'any|==', 'image-carousel,post-carousel,product-carousel,external-carousel', true ),
							),
							array(
								'id'         => 'wpcp_post_detail_position',
								'class'      => 'wpcp_content_position default_content',
								'type'       => 'image_select',
								'title'      => __( 'Content Position', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a position for the content.', 'wp-carousel-pro' ),
								'options'    => array(
									'bottom'   => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/default/default-bottom.svg',
										'text'  => __( 'Bottom', 'wp-carousel-pro' ),
									),
									'top'      => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/default/default-top.svg',
										'text'  => __( 'Top', 'wp-carousel-pro' ),
									),
									'on_right' => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/default/default-right.svg',
										'text'  => __( 'Right', 'wp-carousel-pro' ),
									),
									'on_left'  => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/default/default-left.svg',
										'text'  => __( 'Left', 'wp-carousel-pro' ),
									),
								),
								'default'    => 'bottom',
								'dependency' => array( 'wpcp_carousel_type|wpcp_content_style', 'any|==|==', 'image-carousel,post-carousel,product-carousel,external-carousel|default', true ),
							),
							array(
								'id'         => 'wpcp_overlay_position',
								'class'      => 'overlay_style',
								'type'       => 'image_select',
								'title'      => __( 'Content Position', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a position for content', 'wp-carousel-pro' ),
								'inline'     => true,
								'options'    => array(
									'full_covered' => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/overlay/overlay-full.svg',
										'text'  => __( 'Full', 'wp-carousel-pro' ),
									),
									'left'         => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/overlay/overlay-left.svg',
										'text'  => __( 'Left', 'wp-carousel-pro' ),
									),
									'right'        => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/overlay/overlay-right.svg',
										'text'  => __( 'Right', 'wp-carousel-pro' ),
									),
								),
								'default'    => 'full_covered',
								'dependency' => array( 'wpcp_carousel_type|wpcp_content_style', 'any|==', 'image-carousel,post-carousel,product-carousel,external-carousel|with_overlay', true ),
							),
							array(
								'id'         => 'wpcp_caption_full',
								'class'      => 'caption_full',
								'type'       => 'image_select',
								'title'      => __( 'Content Position', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a position for content', 'wp-carousel-pro' ),
								'inline'     => true,
								'options'    => array(
									'bottom' => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/caption-full/content-style-bottom.svg',
										'text'  => __( 'Bottom', 'wp-carousel-pro' ),
									),
									'center' => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/caption-full/content-style-center.svg',
										'text'  => __( 'Center', 'wp-carousel-pro' ),
									),
									'top'    => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/caption-full/content-style-top.svg',
										'text'  => __( 'Top', 'wp-carousel-pro' ),
									),
								),
								'default'    => 'bottom',
								'dependency' => array( 'wpcp_carousel_type|wpcp_content_style', 'any|==', 'image-carousel,post-carousel,product-carousel,external-carousel|caption_full', true ),
							),
							array(
								'id'         => 'wpcp_caption_partial',
								'class'      => 'caption_partial',
								'type'       => 'image_select',
								'title'      => __( 'Content Position', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a position for content', 'wp-carousel-pro' ),
								'inline'     => true,
								'options'    => array(
									'bottom_left'  => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/caption-partial/content-style-bottom-left.svg',
										'text'  => __( 'Bottom Left', 'wp-carousel-pro' ),
									),
									'top_left'     => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/caption-partial/content-style-top-left.svg',
										'text'  => __( 'Top Left', 'wp-carousel-pro' ),
									),
									'bottom_right' => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/caption-partial/content-style-bottom-right.svg',
										'text'  => __( 'Bottom right', 'wp-carousel-pro' ),
									),
									'top_right'    => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/caption-partial/content-style-top-right.svg',
										'text'  => __( 'Top Right', 'wp-carousel-pro' ),
									),
								),
								'default'    => 'bottom_left',
								'dependency' => array( 'wpcp_carousel_type|wpcp_content_style', 'any|==', 'image-carousel,post-carousel,product-carousel,external-carousel|caption_partial', true ),
							),
							array(
								'id'         => 'wpcp_caption_diagonal',
								'class'      => 'caption_diagonal',
								'type'       => 'image_select',
								'title'      => __( 'Content Position', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a position for content', 'wp-carousel-pro' ),
								'inline'     => true,
								'options'    => array(
									'bottom_left'  => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/diagonal/content-style-bottom-left.svg',
										'text'  => __( 'Bottom Left', 'wp-carousel-pro' ),
									),
									'top_left'     => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/diagonal/content-style-top-left.svg',
										'text'  => __( 'Top Left', 'wp-carousel-pro' ),
									),
									'bottom_right' => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/diagonal/content-style-bottom-right.svg',
										'text'  => __( 'Bottom Right', 'wp-carousel-pro' ),
									),
									'top_right'    => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/diagonal/content-style-top-right.svg',
										'text'  => __( 'Top Right', 'wp-carousel-pro' ),
									),
								),
								'default'    => 'bottom_left',
								'dependency' => array( 'wpcp_carousel_type|wpcp_content_style', 'any|==', 'image-carousel,post-carousel,product-carousel,external-carousel|content_diagonal', true ),
							),
							array(
								'id'         => 'wpcp_content_box',
								'class'      => 'content_box',
								'type'       => 'image_select',
								'title'      => __( 'Content Position', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a position for the content', 'wp-carousel-pro' ),
								'inline'     => true,
								'options'    => array(
									'bottom' => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/content-box/content-box-bottom.svg',
										'text'  => __( 'Bottom', 'wp-carousel-pro' ),
									),
									'top'    => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/content-box/content-box-top.svg',
										'text'  => __( 'Top', 'wp-carousel-pro' ),
									),
									'left'   => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/content-box/content-box-left.svg',
										'text'  => __( 'Left', 'wp-carousel-pro' ),
									),
									'right'  => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/content-box/content-box-right.svg',
										'text'  => __( 'Right', 'wp-carousel-pro' ),
									),
									'center' => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/content-box/content-box-center.svg',
										'text'  => __( 'Center', 'wp-carousel-pro' ),
									),
								),
								'default'    => 'bottom',
								'dependency' => array( 'wpcp_carousel_type|wpcp_content_style', 'any|==', 'image-carousel,post-carousel,product-carousel,external-carousel|content_box', true ),
							),
							array(
								'id'         => 'item_same_height',
								'class'      => 'item_same_height',
								'type'       => 'switcher',
								'title'      => __( 'Enable Equal Height', 'wp-carousel-pro' ),
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'subtitle'   => __( 'Enable to make all items or slides equal to the tallest one.', 'wp-carousel-pro' ),
								'title_help' => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/equal-height.svg" alt="Equal Height"></div><div class="sp_wpcp-info-label">' . __( 'Equal Height', 'wp-carousel-pro' ) . '</div><a class="sp_wpcp-open-docs" href="https://docs.shapedplugin.com/docs/wordpress-carousel-pro/configurations/how-to-enable-equal-height/" target="_blank">Open Docs</a>',
								'default'    => false,
								'dependency' => array( 'wpcp_layout|wpcp_content_style', 'not-any|==', 'thumbnails-slider,justified,masonry,tiles|default', true ),
							),
							array(
								'id'          => 'wpcp_content_box_border',
								'type'        => 'border',
								'title'       => __( 'Content Box Border', 'wp-carousel-pro' ),
								'subtitle'    => __( 'Set content box border for the items.', 'wp-carousel-pro' ),
								'all'         => true,
								'hover-color' => false,
								'radius'      => true,
								'default'     => array(
									'all'    => '0',
									'style'  => 'solid',
									'color'  => '#dddddd',
									'radius' => '2',
								),
								'dependency'  => array( 'wpcp_carousel_type|wpcp_content_style', 'any|any', 'image-carousel,post-carousel,product-carousel|content_box,moving', true ),
							),
							// Box Shadow.
							array(
								'id'         => 'wpcp_show_content_box_shadow',
								'type'       => 'checkbox',
								'class'      => 'wpcp_show_content_box_shadow',
								'title'      => __( 'Content Box-Shadow', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Check to enable content box-shadow for the item.', 'wp-carousel-pro' ),
								'dependency' => array( 'wpcp_carousel_type|wpcp_content_style', 'any|any', 'image-carousel,post-carousel,product-carousel|content_box,moving', true ),
							),
							array(
								'id'          => 'wpcp_content_box_shadow',
								'type'        => 'box_shadow',
								'class'       => 'wpcp_content_box_shadow',
								'title'       => __( 'Content Box-Shadow Values', 'wp-carousel-pro' ),
								'subtitle'    => __( 'Set content box-shadow property values for the item.', 'wp-carousel-pro' ),
								'style'       => true,
								'hover_color' => true,
								'default'     => array(
									'vertical'    => '0',
									'horizontal'  => '0',
									'blur'        => '10',
									'spread'      => '0',
									'style'       => 'outset',
									'color'       => '#dddddd',
									'hover_color' => '#dddddd',
								),
								'dependency'  => array( 'wpcp_carousel_type|wpcp_content_style|wpcp_show_content_box_shadow', 'any|any|==', 'image-carousel,post-carousel,product-carousel|content_box,moving|true', true ),
							),
							array(
								'id'         => 'wpcp_content_vertical_alignment',
								'type'       => 'button_set',
								'class'      => 'wpcp_content_vertical_alignment',
								'title'      => __( 'Content Vertical Alignment', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Select a vertical alignment for the content.', 'wp-carousel-pro' ),
								'title_help' => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/content-vertical-alignment.svg" alt="Content Vertical Alignment"></div><div class="sp_wpcp-info-label">' . __( 'Content Vertical Alignment', 'wp-carousel-pro' ) . '</div>',
								'options'    => array(
									'flex-start' => __( 'Top', 'wp-carousel-pro' ),
									'center'     => __( 'Middle', 'wp-carousel-pro' ),
									'flex-end'   => __( 'Bottom', 'wp-carousel-pro' ),
								),
								'default'    => 'center',
								'dependency' => array( 'wpcp_layout|wpcp_content_style', 'not-any|any', 'thumbnails-slider,justified,masonry|with_overlay', true ),
							),

							array(
								'id'         => 'wpcp_content_box_size',
								'type'       => 'slider',
								'title'      => __( 'Content Box Size', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set content box size.', 'wp-carousel-pro' ),
								'title_help' => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/content-box-size.svg" alt="Content Box Size"></div><div class="sp_wpcp-info-label">' . __( 'Content Box Size', 'wp-carousel-pro' ) . '</div><a class="sp_wpcp-open-live-demo" href="https://wpcarousel.io/content-box-size/" target="_blank">Live Demo</a>',
								'default'    => 50,
								'min'        => 5,
								'max'        => 100,
								'unit'       => '%',
								'dependency' => array( 'wpcp_layout|wpcp_content_style|wpcp_overlay_position', 'not-any|==|!=', 'thumbnails-slider,justified,masonry|with_overlay|full_covered', true ),
							),
							array(
								'id'         => 'wpcp_overlay_visibility',
								'type'       => 'button_set',
								'class'      => 'wpcp_overlay_visibility',
								'title'      => __( 'Overlay Content Visibility', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set visibility for the overlay content.', 'wp-carousel-pro' ),
								'title_help' => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/overlay-content-visibility.svg" alt="Overlay Content Visibility"></div><div class="sp_wpcp-info-label">' . __( 'Overlay Content Visibility', 'wp-carousel-pro' ) . '</div>',
								'options'    => array(
									'always'   => __( 'Always', 'wp-carousel-pro' ),
									'on_hover' => __( 'On Hover', 'wp-carousel-pro' ),
								),
								'radio'      => true,
								'default'    => 'always',
								'dependency' => array( 'wpcp_carousel_type|wpcp_content_style', 'any|not-any', 'image-carousel,post-carousel,product-carousel|default,content_box,moving', true ),
							),
							array(
								'id'         => 'wpcp_overlay_animation',
								'type'       => 'select',
								'class'      => 'wpcp_overlay_animation',
								'title'      => __( 'Animation Type', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Select an animation type for the overlay content on hover.', 'wp-carousel-pro' ),
								'options'    => array(
									'none'         => __( 'None', 'wp-carousel-pro' ),
									'fadeIn'       => __( 'fadeIn', 'wp-carousel-pro' ),
									'fadeInDown'   => __( 'fadeInDown', 'wp-carousel-pro' ),
									'fadeInRight'  => __( 'fadeInRight', 'wp-carousel-pro' ),
									'fadeInLeft'   => __( 'fadeInLeft', 'wp-carousel-pro' ),
									'fadeInUp'     => __( 'fadeInUp', 'wp-carousel-pro' ),
									'flipInX'      => __( 'flipInX', 'wp-carousel-pro' ),
									'flipInY'      => __( 'flipInY', 'wp-carousel-pro' ),
									'slideInUp'    => __( 'slideInUp', 'wp-carousel-pro' ),
									'slideInDown'  => __( 'slideInDown', 'wp-carousel-pro' ),
									'zoomIn'       => __( 'zoomIn', 'wp-carousel-pro' ),
									'zoomInDown'   => __( 'zoomInDown', 'wp-carousel-pro' ),
									'jackInTheBox' => __( 'jackInTheBox', 'wp-carousel-pro' ),
									'rollIn'       => __( 'rollIn', 'wp-carousel-pro' ),
								),
								'default'    => 'none',
								'dependency' => array( 'wpcp_carousel_type|wpcp_content_style|wpcp_overlay_visibility', 'any|not-any|==', 'image-carousel,post-carousel,product-carousel|default,content_box,moving|on_hover', true ),
							),
							array(
								'id'         => 'wpcp_overlay_color_type',
								'type'       => 'button_set',
								'title'      => __( 'Overlay Background Color Type', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Select overlay background color type.', 'wp-carousel-pro' ),
								'options'    => array(
									'solid'    => __( 'Solid', 'wp-carousel-pro' ),
									'gradient' => __( 'Gradient', 'wp-carousel-pro' ),
								),
								'default'    => 'solid',
								'dependency' => array( 'wpcp_layout|wpcp_content_style', 'not-any|not-any', 'thumbnails-slider,justified,masonry|default,content_box,moving', true ),
							),
							array(
								'id'         => 'wpcp_overlay_bg',
								'type'       => 'color',
								'class'      => 'wpcp_overlay_bg',
								'title'      => __( 'Solid Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a color for the overlay background.', 'wp-carousel-pro' ),
								'default'    => 'rgba(0,0,0,0.55)',
								'rgba'       => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_content_style|wpcp_overlay_color_type', 'any|not-any|==', 'image-carousel,post-carousel,product-carousel|default,content_box,moving|solid', true ),
							),
							array(
								'id'                    => 'wpcp_bg_gradient_color',
								'type'                  => 'background',
								'class'                 => 'wpcp_bg_gradient_color',
								'title'                 => __( 'Gradient Color', 'wp-carousel-pro' ),
								'subtitle'              => __( 'Set gradient color for the tab title background.', 'wp-carousel-pro' ),
								'background_gradient'   => true,
								'background_color'      => true,
								'background_image'      => false,
								'background_position'   => false,
								'background_repeat'     => false,
								'background_attachment' => false,
								'background_size'       => false,
								'default'               => array(
									'background-color' => '#004054bd',
									'background-gradient-color' => '#23b7edb5',
									'background-gradient-direction' => '135deg',
								),
								'dependency'            => array( 'wpcp_carousel_type|wpcp_content_style|wpcp_overlay_color_type', 'any|not-any|==', 'image-carousel,post-carousel,product-carousel|default,content_box,moving|gradient', true ),
							),
							array(
								'id'         => 'wpcp_content_box_color_type',
								'type'       => 'button_set',
								'title'      => __( 'Content Box Background Color Type', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Select content box background color type.', 'wp-carousel-pro' ),
								'options'    => array(
									'solid'    => __( 'Solid', 'wp-carousel-pro' ),
									'gradient' => __( 'Gradient', 'wp-carousel-pro' ),
								),
								'default'    => 'solid',
								'dependency' => array( 'wpcp_layout|wpcp_content_style', 'not-any|any', 'thumbnails-slider,justified,masonry|content_box,moving', true ),
							),
							array(
								'id'         => 'wpcp_content_overlay_bg',
								'type'       => 'color',
								'class'      => 'wpcp_content_overlay_bg',
								'title'      => __( 'Content Solid Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a color for the overlay content background.', 'wp-carousel-pro' ),
								'default'    => 'rgba(0,0,0,0.55)',
								'rgba'       => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_content_style|wpcp_content_box_color_type', 'any|any|==', 'image-carousel,post-carousel,product-carousel|content_box,moving|solid', true ),
							),
							array(
								'id'                    => 'wpcp_content_bg_gradient_color',
								'type'                  => 'background',
								'class'                 => 'wpcp_content_bg_gradient_color',
								'title'                 => __( 'Content Gradient Color', 'wp-carousel-pro' ),
								'subtitle'              => __( 'Set gradient color for the tab content background.', 'wp-carousel-pro' ),
								'background_gradient'   => true,
								'background_color'      => true,
								'background_image'      => false,
								'background_position'   => false,
								'background_repeat'     => false,
								'background_attachment' => false,
								'background_size'       => false,
								'default'               => array(
									'background-color' => '#004054bd',
									'background-gradient-color' => '#23b7edb5',
									'background-gradient-direction' => '135deg',
								),
								'dependency'            => array( 'wpcp_carousel_type|wpcp_content_style|wpcp_content_box_color_type', 'any|any|==', 'image-carousel,post-carousel,product-carousel|content_box,moving|gradient', true ),
							),
							array(
								'id'         => 'wpcp_image_vertical_alignment',
								'type'       => 'button_set',
								'class'      => 'wpcp_image_vertical_alignment',
								'title'      => __( 'Items Vertical Alignment', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Select a vertical alignment for the items.', 'wp-carousel-pro' ),
								'title_help' => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/slider-vertical-alignment.svg" alt="Slider Vertical Alignment"></div><div class="sp_wpcp-info-label">' . __( 'Slider Vertical Alignment', 'wp-carousel-pro' ) . '</div>',
								'options'    => array(
									'flex-start' => __( 'Top', 'wp-carousel-pro' ),
									'center'     => __( 'Middle', 'wp-carousel-pro' ),
									'flex-end'   => __( 'Bottom', 'wp-carousel-pro' ),
								),
								'default'    => 'center',
								'dependency' => array( 'wpcp_layout|item_same_height', 'not-any|==', 'thumbnails-slider,justified,masonry|false', true ),
							),
							array(
								'id'          => 'wpcp_slide_border',
								'type'        => 'border',
								'title'       => __( 'Items Border', 'wp-carousel-pro' ),
								'subtitle'    => __( 'Set border for the items.', 'wp-carousel-pro' ),
								'title_help'  => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/slider-border.svg" alt="Items Border"></div><div class="sp_wpcp-info-label">' . __( 'Items Border', 'wp-carousel-pro' ) . '</div>',
								'all'         => true,
								'hover-color' => false,
								'radius'      => true,
								'default'     => array(
									'all'    => '1',
									'style'  => 'solid',
									'color'  => '#dddddd',
									'radius' => '0',
								),
							),
							array(
								'id'         => 'wpcp_slide_inner_padding',
								'type'       => 'spacing',
								'title'      => __( 'Items Inner Padding', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set an inner padding for the items.', 'wp-carousel-pro' ),
								'title_help' => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/slider-inner-padding.svg" alt="Items Inner Padding"></div><div class="sp_wpcp-info-label">' . __( 'Items Inner Padding', 'wp-carousel-pro' ) . '</div>',
								'style'      => false,
								'color'      => false,
								'all'        => false,
								'units'      => array( 'px' ),
								'default'    => array(
									'top'    => '0',
									'right'  => '0',
									'bottom' => '0',
									'left'   => '0',
								),
								'attributes' => array(
									'min' => 0,
								),
							),
							array(
								'id'         => 'wpcp_content_inner_padding',
								'type'       => 'spacing',
								'class'      => 'wpcp_content_inner_padding',
								'title'      => __( 'Content Padding', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set content inner padding of the item.', 'wp-carousel-pro' ),
								'title_help' => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/content-padding.svg" alt="Content Padding"></div><div class="sp_wpcp-info-label">' . __( 'Content Padding', 'wp-carousel-pro' ) . '</div>',
								'style'      => false,
								'color'      => false,
								'all'        => false,
								'units'      => array( 'px' ),
								'default'    => array(
									'top'    => '0',
									'right'  => '0',
									'bottom' => '0',
									'left'   => '0',
								),
								'attributes' => array(
									'min' => 0,
								),
								'dependency' => array( 'wpcp_carousel_type|wpcp_content_style', 'any|any', 'image-carousel,post-carousel,product-carousel|default,with_overlay,caption_full,caption_partial,content_diagonal', true ),
							),
							array(
								'id'         => 'wpcp_content_box_padding',
								'type'       => 'spacing',
								'class'      => 'wpcp_content_box_padding',
								'title'      => __( 'Content Box Padding', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set content inner padding of the slide. Default value is 0.', 'wp-carousel-pro' ),
								'title_help' => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/content-box-padding.svg" alt="Content Box Padding"></div><div class="sp_wpcp-info-label">' . __( 'Content Box Padding', 'wp-carousel-pro' ) . '</div>',
								'style'      => false,
								'color'      => false,
								'all'        => false,
								'units'      => array( 'px' ),
								'default'    => array(
									'top'    => '0',
									'right'  => '0',
									'bottom' => '0',
									'left'   => '0',
								),
								'attributes' => array(
									'min' => 0,
								),
								'dependency' => array( 'wpcp_carousel_type|wpcp_content_style', 'any|any', 'image-carousel,post-carousel,product-carousel|with_overlay,content_box,caption_partial', true ),
							),
							array(
								'id'         => 'wpcp_slide_background',
								'type'       => 'color',
								'title'      => __( 'Items Background Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a background color for the items.', 'wp-carousel-pro' ),
								'default'    => '#ffffff',
								'dependency' => array( 'wpcp_carousel_type', 'any', 'image-carousel,post-carousel,product-carousel,video-carousel', true ),
							),
							// Box Shadow.
							// array(
							// 'id'       => 'wpcp_show_box_shadow',
							// 'type'     => 'checkbox',
							// 'title'    => __( 'Items Box-Shadow', 'wp-carousel-pro' ),
							// 'subtitle' => __( 'Check to enable box-shadow for the items.', 'wp-carousel-pro' ),
							// ),
							array(
								'id'       => 'wpcp_box_shadow_style',
								'type'     => 'button_set',
								'title'    => __( 'Items Box-Shadow', 'wp-carousel-pro' ),
								'subtitle' => __( 'Set Box-Shadow for the items.', 'wp-carousel-pro' ),
								'options'  => array(
									'outset' => __( 'Outset', 'wp-carousel-pro' ),
									'inset'  => __( 'Inset', 'wp-carousel-pro' ),
									'none'   => __( 'None', 'wp-carousel-pro' ),
								),
								'default'  => 'none',
							),
							array(
								'id'          => 'wpcp_box_shadow',
								'type'        => 'box_shadow',
								'title'       => __( 'Box-Shadow Values', 'wp-carousel-pro' ),
								'subtitle'    => __( 'Set box-shadow property values for the item.', 'wp-carousel-pro' ),
								'style'       => false,
								'hover_color' => true,
								'default'     => array(
									'vertical'    => '0',
									'horizontal'  => '0',
									'blur'        => '10',
									'spread'      => '0',
									// 'style'       => 'outset',
									'color'       => '#dddddd',
									'hover_color' => '#dddddd',
								),
								'dependency'  => array( 'wpcp_box_shadow_style', '!=', 'none', true ),
							),
							array(
								'type'       => 'subheading',
								'content'    => __( 'Video', 'wp-carousel-pro' ),
								'dependency' => array( 'wpcp_carousel_type', 'any', 'video-carousel,mix-content', true ),
							),
							array(
								'id'         => 'video_play_mode',
								'class'      => 'video_play_mode',
								'type'       => 'button_set',
								'title'      => __( 'Video Play Mode', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a video play mode.', 'wp-carousel-pro' ),
								'options'    => array(
									'lightbox' => __( 'Lightbox', 'wp-carousel-pro' ),
									'inline'   => __( 'Inline', 'wp-carousel-pro' ),
								),
								'radio'      => true,
								'default'    => 'lightbox',
								'dependency' => array( 'wpcp_carousel_type', 'any', 'video-carousel,mix-content', true ),
							),
							array(
								'id'         => 'wpcp_video_icon_size',
								'type'       => 'spinner',
								'title'      => __( 'Video Icon Size', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set size for video icon.', 'wp-carousel-pro' ),
								'default'    => 40,
								'unit'       => 'px',
								'dependency' => array( 'wpcp_carousel_type', 'any', 'video-carousel,mix-content', true ),
							),
							array(
								'id'         => 'wpcp_video_icon_color',
								'type'       => 'color',
								'title'      => __( 'Video Icon Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Used as video icon color.', 'wp-carousel-pro' ),
								'default'    => '#fff',
								'dependency' => array( 'wpcp_carousel_type', 'any', 'video-carousel,mix-content', true ),
							),
						),
					),
					// Image.
					array(
						'title'  => __( 'Image Styles', 'wp-carousel-pro' ),
						'icon'   => 'wpcp-icon-tab_image-settings',
						'fields' => array(
							array(
								'id'         => 'show_image',
								'type'       => 'switcher',
								'title'      => __( 'Image', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide slide image.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type', 'any', 'post-carousel,product-carousel', true ),
							),
							array(
								'id'         => 'wpcp_image_sizes',
								'type'       => 'image_sizes',
								'chosen'     => true,
								'title'      => __( 'Dimensions', 'wp-carousel-pro' ),
								'default'    => 'full',
								'subtitle'   => __( 'Set dimensions for the image.', 'wp-carousel-pro' ),
								'dependency' => array( 'wpcp_carousel_type|show_image', 'any|==', 'image-carousel,post-carousel,product-carousel,video-carousel|true', true ),
							),
							array(
								'id'                => 'wpcp_image_crop_size',
								'type'              => 'dimensions_advanced',
								'class'             => 'standard_width_of_spacing_field',
								'title'             => __( 'Custom Size', 'wp-carousel-pro' ),
								'subtitle'          => __( 'Set width and height of the image.', 'wp-carousel-pro' ),
								'chosen'            => true,
								'bottom'            => false,
								'left'              => false,
								'color'             => false,
								'top_text'          => __( 'Width', 'wp-carousel-pro' ),
								'right_text'        => __( 'Height', 'wp-carousel-pro' ),
								'style_text'        => __( 'Crop', 'wp-carousel-pro' ),
								'top_icon'          => '<i class="fa fa-arrows-h"></i>',
								'right_icon'        => '<i class="fa fa-arrows-v"></i>',
								'top_placeholder'   => 'width',
								'right_placeholder' => 'height',
								'styles'            => array(
									'Soft-crop',
									'Hard-crop',
								),
								'default'           => array(
									'top'   => '600',
									'right' => '400',
									'style' => 'Soft-crop',
									'unit'  => 'px',
								),
								'attributes'        => array(
									'min' => 0,
								),
								'dependency'        => array( 'wpcp_carousel_type|show_image|wpcp_image_sizes', 'any|==|==', 'image-carousel,post-carousel,product-carousel,video-carousel|true|custom', true ),
							),
							array(
								'id'         => 'load_2x_image',
								'type'       => 'switcher',
								'title'      => __( 'Load 2x Resolution Image in Retina Display', 'wp-carousel-pro' ),
								'subtitle'   => __( 'You should upload 2x sized images to show in retina display.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type|show_image|wpcp_image_sizes', 'any|==|==', 'image-carousel,post-carousel,product-carousel|true|custom', true ),
							),
							array(
								'id'                 => 'wpcp_image_height_css',
								'type'               => 'dimensions_advanced',
								'class'              => 'dimensions_advanced_field',
								'title'              => __( 'Height', 'wp-carousel-pro' ),
								'subtitle'           => __( 'Set image height on different devices.', 'wp-carousel-pro' ),
								'title_help'         => __( '<div class="sp_wpcp-info-label">Height</div><div class="sp_wpcp-short-content">Set image height on various devices for ideal responsiveness. Ensure your content looks great on every screen size with customized image heights.</div><a class="sp_wpcp-open-docs" href="https://docs.shapedplugin.com/docs/wordpress-carousel-pro/configurations/how-to-configure-the-image-height-css/" target="_blank">Open Docs</a><a class="sp_wpcp-open-live-demo" href="https://wpcarousel.io/carousel-orientations/" target="_blank">Live Demo</a>', 'wp-carousel-pro' ),
								'top_icon'           => '<i class="fa fa-desktop"></i>',
								'right_icon'         => '<i class="fa fa-laptop"></i>',
								'bottom_icon'        => '<i class="fa fa-tablet"></i>',
								'left_icon'          => '<i class="fa fa-mobile"></i>',
								'top_placeholder'    => 'height',
								'right_placeholder'  => 'height',
								'bottom_placeholder' => 'height',
								'left_placeholder'   => 'height',
								'lg_desktop'         => true,
								'color'              => false,
								'styles'             => array(
									'max-height',
									'height',
								),
								'default'            => array(
									'lg_desktop' => 700,
									'top'        => 600,
									'right'      => 500,
									'bottom'     => 400,
									'left'       => 300,
									'style'      => 'max-height',
									'unit'       => 'px',
								),
								'dependency'         => array( 'wpcp_carousel_type|show_image', 'any|==', 'image-carousel,post-carousel,product-carousel,video-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_img_width_auto',
								'type'       => 'checkbox',
								'title'      => __( 'Image Width Auto', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Check to make image width auto.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array( 'wpcp_layout|show_image', '==|==', 'thumbnails-slider|true', true ),
							),
							array(
								'id'         => 'wpcp_product_image_border',
								'type'       => 'border',
								'title'      => __( 'Border', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set border for the image.', 'wp-carousel-pro' ),
								'title_help' => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/image-border.svg" alt="Border"></div><div class="sp_wpcp-info-label">' . __( 'Border', 'wp-carousel-pro' ) . '</div>',
								'all'        => true,
								'default'    => array(
									'all'         => '0',
									'style'       => 'solid',
									'color'       => '#dddddd',
									'hover-color' => '#dddddd',
								),
								'dependency' => array( 'wpcp_carousel_type|show_image', 'any|==', 'image-carousel,post-carousel,product-carousel|true', true ),
							),

							array(
								'id'         => '_variable_width',
								'type'       => 'switcher',
								'title'      => __( 'Variable Width', 'wp-carousel-pro' ),
								'subtitle'   => __( ' The number of columns depends on the image width.', 'wp-carousel-pro' ),
								'title_help' => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/variable-width.svg" alt="Variable Width"></div><div class="sp_wpcp-info-label">' . __( 'Variable Width', 'wp-carousel-pro' ) . '</div><a class="sp_wpcp-open-docs" href="https://docs.shapedplugin.com/docs/wordpress-carousel-pro/configurations/how-to-enable-the-variable-width/" target="_blank">Open Docs</a><a class="sp_wpcp-open-live-demo" href="https://wpcarousel.io/variable-width/" target="_blank">Live Demo</a>',
								'default'    => false,
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'dependency' => array( 'wpcp_carousel_type|wpcp_carousel_orientation|wpcp_layout', 'not-any|!=|==', 'content-carousel,audio-carousel|vertical|carousel', true ),
							),
							array(
								'id'         => 'wpcp_hide_product_without_img',
								'type'       => 'checkbox',
								'title'      => __( 'Hide Product without Thumbnail', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Hide products if featured image is not existed.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type|show_image', '==|==', 'product-carousel|true', true ),
							),
							array(
								'id'         => '_image_light_box',
								'type'       => 'switcher',
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'title'      => __( 'Lightbox', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable/Disable lightbox for the image.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type|show_image', '==|==', 'product-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_lb_overlay_color',
								'type'       => 'color',
								'title'      => __( 'Lightbox Overlay Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set lightbox overlay color.', 'wp-carousel-pro' ),
								'default'    => '#0b0b0b',
								'dependency' => array( 'wpcp_carousel_type|show_image|_image_light_box', '==|==|==', 'product-carousel|true|true', true ),
							),
							array(
								'id'         => 'wpcp_image_lazy_load',
								'type'       => 'switcher',
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'title'      => __( 'Lazy Load', 'wp-carousel-pro' ),
								'subtitle'   => __( 'When enabled, it improves page load times & performance.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_mode|wpcp_carousel_type|show_image', '!=|any|==', 'ticker|image-carousel,post-carousel,product-carousel,video-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_image_zoom',
								'type'       => 'select',
								'title'      => __( 'Zoom Effect', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a zoom effect on hover the image.', 'wp-carousel-pro' ),
								'title_help' => __( '<div class="sp_wpcp-info-label">Zoom</div><div class="sp_wpcp-short-content">This feature lets you choose a specific zoom effect when hovering over an image for an engaging experience.</div><a class="sp_wpcp-open-live-demo" href="https://wpcarousel.io/post-carousel-zoom-image-modes/" target="_blank">Live Demo</a>', 'wp-carousel-pro' ),
								'options'    => array(
									''         => __( 'None', 'wp-carousel-pro' ),
									'zoom_in'  => __( 'Zoom In', 'wp-carousel-pro' ),
									'zoom_out' => __( 'Zoom Out', 'wp-carousel-pro' ),
								),
								'default'    => '',
								'class'      => 'chosen wpcp_image_zoom',
								'dependency' => array( 'wpcp_carousel_type|show_image', 'any|==', 'image-carousel,post-carousel,product-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_image_gray_scale',
								'type'       => 'select',
								'title'      => __( 'Image Mode', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a mode for images.', 'wp-carousel-pro' ),
								'desc'       => __( 'Custom colors only apply to PNG files.', 'wp-carousel-pro' ),
								'options'    => array(
									''              => __( 'Original', 'wp-carousel-pro' ),
									'gray_and_normal_on_hover' => __( 'Grayscale and original on hover', 'wp-carousel-pro' ),
									'gray_on_hover' => __( 'Grayscale on hover', 'wp-carousel-pro' ),
									'always_gray'   => __( 'Always grayscale', 'wp-carousel-pro' ),
									'custom_color'  => __( 'Custom color', 'wp-carousel-pro' ),
								),
								'default'    => '',
								'class'      => 'chosen wpcp_image_mode',
								'dependency' => array( 'wpcp_carousel_type|show_image', 'any|==', 'image-carousel,post-carousel,product-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_image_custom_color',
								'type'       => 'image_color',
								'title'      => __( 'Image Custom Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a custom color for images.', 'wp-carousel-pro' ),
								'options'    => array(
									'color'       => __( 'Color', 'wp-carousel-pro' ),
									'color_hover' => __( 'Hover', 'wp-carousel-pro' ),
								),
								'default'    => array(
									'color'       => '#aaaaaa',
									'color_hover' => '#999999',
								),
								'dependency' => array( 'wpcp_image_gray_scale', '==', 'custom_color', true ),
							),
							array(
								'id'         => 'wpcp_watermark',
								'class'      => 'wpcp_watermark',
								'type'       => 'switcher',
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'title'      => __( 'Watermark', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable to add watermark to the image.', 'wp-carousel-pro' ),
								'title_help' => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/watermark.svg" alt="Watermark"></div><div class="sp_wpcp-info-label">' . __( 'Watermark', 'wp-carousel-pro' ) . '</div><a class="sp_wpcp-open-docs" href="https://docs.shapedplugin.com/docs/wordpress-carousel-pro/configurations/how-to-configure-the-watermark/" target="_blank">Open Docs</a><a class="sp_wpcp-open-live-demo" href="https://wpcarousel.io/watermark-protection/" target="_blank">Live Demo</a>',
								'desc'       => __( '<a href="' . esc_url( $single_page_link ) . '" target="_blank">Set watermark image→</a>', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type', '==', 'image-carousel', true ),
							),
							array(
								'id'         => 'wpcp_img_protection',
								'type'       => 'switcher',
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'title'      => __( 'Image Protection', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable to protect image downloading from right-click.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type', '==', 'image-carousel', true ),
							),
							array(
								'id'         => '_image_title_attr',
								'type'       => 'switcher',
								'title'      => __( 'Image Title Attribute', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide image title attribute.', 'wp-carousel-pro' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'dependency' => array( 'wpcp_carousel_type|show_image', 'any|==', 'image-carousel,post-carousel,product-carousel|true', true ),
							),

						),
					),
					// Post Content.
					array(
						'title'  => __( 'Post Content', 'wp-carousel-pro' ),
						'icon'   => 'wpcp-icon-tab_post-meta',
						'fields' => array(
							array(
								'id'         => 'wpcp_feed_title',
								'type'       => 'switcher',
								'title'      => __( 'Post Title', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide post title.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type', '==|==', 'external-carousel', true ),
							),
							array(
								'id'         => 'wpcp_feed_content_show',
								'type'       => 'switcher',
								'title'      => __( 'Feed Content', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide feed content.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type', '==|==', 'external-carousel', true ),
							),
							array(
								'id'         => 'wpcp_feed_content_chars_limit',
								'type'       => 'spinner',
								'title'      => __( 'Length', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Leave empty to show full feed content.', 'wp-carousel-pro' ),
								'default'    => 100,
								'min'        => 0,
								'unit'       => 'Letters',
								'dependency' => array( 'wpcp_carousel_type|wpcp_feed_content_show', '==|==|==', 'external-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_feed_readmore_button_show',
								'type'       => 'switcher',
								'title'      => __( 'Read More Button', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide content read more button.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type', '==', 'external-carousel', true ),
							),
							array(
								'id'         => 'wpcp_feed_readmore_text',
								'type'       => 'text',
								'title'      => __( 'Read More Button Label', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Change the read more button label text.', 'wp-carousel-pro' ),
								'default'    => 'Read More',
								'dependency' => array( 'wpcp_carousel_type|wpcp_feed_readmore_button_show', '==|==', 'external-carousel|true', true ),
							),
							array(
								'id'          => 'wpcp_feed_readmore_border',
								'type'        => 'border',
								'title'       => __( 'Border', 'wp-carousel-pro' ),
								'subtitle'    => __( 'Set border for the readmore button.', 'wp-carousel-pro' ),
								'all'         => true,
								'hover-color' => true,
								'radius'      => true,
								'default'     => array(
									'all'         => '1',
									'style'       => 'solid',
									'color'       => '#257F87',
									'hover-color' => '#1f5c5d',
									'radius'      => '0',
								),
								'dependency'  => array( 'wpcp_carousel_type|wpcp_feed_readmore_button_show', '==|==', 'external-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_feed_readmore_color_set',
								'type'       => 'color_group',
								'title'      => __( 'Read More Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set color for the read more button.', 'wp-carousel-pro' ),
								'options'    => array(
									'color1' => __( 'Color', 'wp-carousel-pro' ),
									'color2' => __( 'Hover Color', 'wp-carousel-pro' ),
									'color3' => __( 'Background', 'wp-carousel-pro' ),
									'color4' => __( 'Hover Background', 'wp-carousel-pro' ),
								),
								'default'    => array(
									'color1' => '#fff',
									'color2' => '#fff',
									'color3' => '#257F87',
									'color4' => '#1f5c5d',
								),
								'dependency' => array( 'wpcp_carousel_type|wpcp_feed_readmore_button_show', '==|==', 'external-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_post_title',
								'type'       => 'switcher',
								'title'      => __( 'Post Title', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide post title.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type', '==', 'post-carousel', true ),
							),
							array(
								'id'         => 'wpcp_post_title_chars_limit',
								'type'       => 'spinner',
								'title'      => __( 'Length', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Leave empty to show full post title.', 'wp-carousel-pro' ),
								'default'    => '',
								'min'        => 0,
								'unit'       => 'Letters',
								'dependency' => array( 'wpcp_carousel_type|wpcp_post_title', '==|==', 'post-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_post_content_show',
								'type'       => 'switcher',
								'title'      => __( 'Post Content', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide post content.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type', '==', 'post-carousel', true ),
							),
							array(
								'id'         => 'wpcp_post_content_type',
								'type'       => 'select',
								'title'      => __( 'Content Display Type', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Select a content display type.', 'wp-carousel-pro' ),
								'options'    => array(
									'excerpt'            => __( 'Excerpt', 'wp-carousel-pro' ),
									'content'            => __( 'Full Content', 'wp-carousel-pro' ),
									'content_with_limit' => __( 'Content with Limit', 'wp-carousel-pro' ),
								),
								'default'    => 'content_with_limit',
								'dependency' => array( 'wpcp_carousel_type|wpcp_post_content_show', '==|==', 'post-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_post_content_words_limit',
								'type'       => 'spinner',
								'title'      => __( 'Words Limit', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set post content words limit. Default value is 30 words.', 'wp-carousel-pro' ),
								'default'    => 30,
								'min'        => 0,
								'dependency' => array( 'wpcp_carousel_type|wpcp_post_content_show|wpcp_post_content_type', '==|==|==', 'post-carousel|true|content_with_limit', true ),
							),
							array(
								'id'         => 'wpcp_post_readmore_button_show',
								'class'      => 'wpcp_post_readmore_button_show',
								'type'       => 'switcher',
								'title'      => __( 'Read More Button', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide content read more button.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_post_content_type|wpcp_carousel_type', '!=|==', 'content|post-carousel', true ),
							),
							array(
								'id'         => 'wpcp_post_readmore_text',
								'type'       => 'text',
								'title'      => __( 'Read More Button Label', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Change the read more button label text.', 'wp-carousel-pro' ),
								'default'    => 'Read More',
								'dependency' => array( 'wpcp_carousel_type|wpcp_post_content_type|wpcp_post_readmore_button_show', '==|any|==', 'post-carousel|content_with_limit,excerpt|true', true ),
							),
							array(
								'id'          => 'wpcp_readmore_border',
								'type'        => 'border',
								'title'       => __( 'Border', 'wp-carousel-pro' ),
								'subtitle'    => __( 'Set border for the readmore button.', 'wp-carousel-pro' ),
								'all'         => true,
								'hover-color' => true,
								'radius'      => true,
								'default'     => array(
									'all'         => '1',
									'style'       => 'solid',
									'color'       => '#257F87',
									'hover-color' => '#1f5c5d',
									'radius'      => '0',
								),
								'dependency'  => array( 'wpcp_carousel_type|wpcp_post_content_type|wpcp_post_readmore_button_show', '==|any|==', 'post-carousel|content_with_limit,excerpt|true', true ),
							),
							array(
								'id'         => 'wpcp_readmore_color_set',
								'type'       => 'color_group',
								'title'      => __( 'Read More Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set color for the read more button.', 'wp-carousel-pro' ),
								'options'    => array(
									'color1' => __( 'Label Color', 'wp-carousel-pro' ),
									'color2' => __( 'Hover Color', 'wp-carousel-pro' ),
									'color3' => __( 'Background', 'wp-carousel-pro' ),
									'color4' => __( 'Hover Background', 'wp-carousel-pro' ),
								),
								'default'    => array(
									'color1' => '#fff',
									'color2' => '#fff',
									'color3' => '#257F87',
									'color4' => '#1f5c5d',
								),
								'dependency' => array( 'wpcp_carousel_type|wpcp_post_content_type|wpcp_post_readmore_button_show', '==|any|==', 'post-carousel|content_with_limit,excerpt|true', true ),
							),
							array(
								'type'       => 'subheading',
								'content'    => __( 'Meta Data', 'wp-carousel-pro' ),
								'dependency' => array( 'wpcp_carousel_type', '==', 'post-carousel', true ),
							),
							array(
								'id'         => 'wpcp_post_category_show',
								'type'       => 'switcher',
								'title'      => __( 'Category', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide post category name.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type', '==', 'post-carousel', true ),
							),
							array(
								'id'         => 'wpcp_post_author_show',
								'type'       => 'switcher',
								'title'      => __( 'Author', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide post author name.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type', '==', 'post-carousel', true ),
							),
							array(
								'id'         => 'wpcp_post_date_show',
								'type'       => 'switcher',
								'title'      => __( 'Date', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide post date.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type', '==', 'post-carousel', true ),
							),
							array(
								'id'         => 'wpcp_post_comment_show',
								'type'       => 'switcher',
								'title'      => __( 'Comment', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide post comment number.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type', '==', 'post-carousel', true ),
							),
							array(
								'id'         => 'wpcp_post_tags_show',
								'type'       => 'switcher',
								'title'      => __( 'Tag', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide post tags.', 'wp-carousel-pro' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'dependency' => array( 'wpcp_carousel_type', '==', 'post-carousel', true ),
							),
							array(
								'type'       => 'subheading',
								'content'    => __( 'Social Share', 'wp-carousel-pro' ),
								'dependency' => array( 'wpcp_carousel_type', '==', 'post-carousel', true ),
							),
							array(
								'id'         => 'wpcp_post_social_show',
								'type'       => 'switcher',
								'title'      => __( 'Social Share', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide post social share.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type', '==', 'post-carousel', true ),
							),
							array(
								'id'         => 'wpcp_icon_color_type',
								'type'       => 'button_set',
								'title'      => __( 'Icon Color Type', 'wp-carousel-pro' ),
								'options'    => array(
									'original' => __( 'Native', 'wp-carousel-pro' ),
									'custom'   => __( 'Custom', 'wp-carousel-pro' ),
								),
								'default'    => 'original',
								'dependency' => array( 'wpcp_carousel_type|wpcp_post_social_show', '==|==', 'post-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_post_social_color',
								'type'       => 'color_group',
								'title'      => __( 'Social Button Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set color for the social button.', 'wp-carousel-pro' ),
								'options'    => array(
									'color1' => __( 'Icon Color', 'wp-carousel-pro' ),
									'color2' => __( 'Icon Hover Color', 'wp-carousel-pro' ),
									'color3' => __( 'Background', 'wp-carousel-pro' ),
									'color4' => __( 'Hover Background', 'wp-carousel-pro' ),
								),
								'default'    => array(
									'color1' => '#257F87',
									'color2' => '#fff',
									'color3' => '#fff',
									'color4' => '#1f5c5d',
								),
								'dependency' => array( 'wpcp_carousel_type|wpcp_post_social_show|wpcp_icon_color_type', '==|==|==', 'post-carousel|true|custom', true ),
							),
							array(
								'id'          => 'wpcp_post_social_border',
								'type'        => 'border',
								'title'       => __( 'Border', 'wp-carousel-pro' ),
								'subtitle'    => __( 'Set border for the social button.', 'wp-carousel-pro' ),
								'all'         => true,
								'hover-color' => true,
								'radius'      => true,
								'default'     => array(
									'all'         => '1',
									'style'       => 'solid',
									'color'       => '#257F87',
									'hover-color' => '#1f5c5d',
									'radius'      => '0',
								),
								'dependency'  => array( 'wpcp_carousel_type|wpcp_post_social_show', '==|==', 'post-carousel|true', true ),
							),
							array(
								'id'          => 'wpcp_post_social_margin',
								'type'        => 'spacing',
								'title'       => __( 'Margin', 'wp-carousel-pro' ),
								'subtitle'    => __( 'Set margin for social button.', 'wp-carousel-pro' ),
								'output_mode' => 'margin',
								'units'       => array( 'px' ),
								'min'         => '-200',
								'default'     => array(
									'top'    => '0',
									'right'  => '5',
									'bottom' => '0',
									'left'   => '0',
								),
								'dependency'  => array( 'wpcp_carousel_type|wpcp_post_social_show', '==|==', 'post-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_post_social_alignment',
								'type'       => 'button_set',
								'title'      => __( 'Alignment', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Choose social icon alignment.', 'wp-carousel-pro' ),
								'options'    => array(
									'left'   => '<i class="fa fa-align-left" title="Left"></i>',
									'center' => '<i class="fa fa-align-center" title="Center"></i>',
									'right'  => '<i class="fa fa-align-right" title="Right"></i>',
								),
								'default'    => 'center',
								'dependency' => array( 'wpcp_carousel_type|wpcp_post_social_show', '==|==', 'post-carousel|true', true ),
							),
						),
					),
					// Product Information.
					array(
						'title'  => __( 'Product Info', 'wp-carousel-pro' ),
						'icon'   => 'wpcp-icon-tab_product-info',
						'fields' => array(
							array(
								'id'         => 'wpcp_product_name',
								'type'       => 'switcher',
								'title'      => __( 'Product Name', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide product name.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type', '==', 'product-carousel', true ),
							),
							array(
								'id'         => 'wpcp_product_name_chars_limit',
								'type'       => 'spinner',
								'title'      => __( 'Length', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Leave empty to show full product name.', 'wp-carousel-pro' ),
								'default'    => '',
								'min'        => 0,
								'unit'       => 'Letters',
								'dependency' => array( 'wpcp_carousel_type|wpcp_product_name', '==|==', 'product-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_product_price',
								'type'       => 'switcher',
								'title'      => __( 'Product Price', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide product price.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type', '==', 'product-carousel', true ),
							),
							array(
								'id'         => 'wpcp_product_desc',
								'type'       => 'button_set',
								'title'      => __( 'Product Description', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Choose the description display type.', 'wp-carousel-pro' ),
								'options'    => array(
									'full'  => __( 'Full', 'wp-carousel-pro' ),
									'short' => __( 'Short', 'wp-carousel-pro' ),
									'hide'  => __( 'Hide', 'wp-carousel-pro' ),
								),
								'default'    => 'full',
								'dependency' => array( 'wpcp_carousel_type', '==', 'product-carousel', true ),
							),
							array(
								'id'         => 'wpcp_product_desc_limit_number',
								'type'       => 'spinner',
								'title'      => __( 'Limit', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Leave empty to show full product description.', 'wp-carousel-pro' ),
								'default'    => '15',
								'min'        => 0,
								'unit'       => 'Words',
								'dependency' => array( 'wpcp_carousel_type|wpcp_product_desc', '==|!=', 'product-carousel|hide', true ),
							),
							array(
								'id'         => 'wpcp_product_readmore_show',
								'type'       => 'switcher',
								'title'      => __( 'Read More', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide product content read more button.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_product_desc', '==|!=', 'product-carousel|hide', true ),
							),
							array(
								'id'         => 'wpcp_product_readmore_text',
								'type'       => 'text',
								'title'      => __( 'Read More Label', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Change the read more button label text.', 'wp-carousel-pro' ),
								'default'    => 'Read More',
								'dependency' => array( 'wpcp_carousel_type|wpcp_product_desc|wpcp_product_readmore_show', '==|!=|==', 'product-carousel|hide|true', true ),
							),
							array(
								'id'         => 'wpcp_product_rating',
								'type'       => 'switcher',
								'title'      => __( 'Product Rating', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide product rating.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type', '==', 'product-carousel', true ),
							),
							array(
								'id'         => 'wpcp_product_rating_star_color_set',
								'type'       => 'color_group',
								'title'      => __( 'Rating Star Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set color for the rating stars.', 'wp-carousel-pro' ),
								'color1'     => true,
								'color2'     => true,
								'options'    => array(
									'color1' => __( 'Color', 'wp-carousel-pro' ),
									'color2' => __( 'Empty Color', 'wp-carousel-pro' ),
								),
								'default'    => array(
									'color1' => '#ffb900',
									'color2' => '#cccccc',
								),
								'dependency' => array( 'wpcp_carousel_type|wpcp_product_rating', '==|==', 'product-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_product_rating_alignment',
								'type'       => 'button_set',
								'title'      => __( 'Rating Alignment', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set alignment for the product rating star.', 'wp-carousel-pro' ),
								'class'      => 'wpcp_rating_alignment',
								'options'    => array(
									'left'   => '<i class="fa fa-align-left" title="Left"></i>',
									'center' => '<i class="fa fa-align-center" title="Center"></i>',
									'right'  => '<i class="fa fa-align-right" title="Right"></i>',
								),
								'radio'      => true,
								'default'    => 'center',
								'dependency' => array( 'wpcp_carousel_type|wpcp_product_rating', '==|==', 'product-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_product_cart',
								'type'       => 'switcher',
								'title'      => __( 'Add to Cart Button', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide add to cart button.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type', '==', 'product-carousel', true ),
							),
							array(
								'id'          => 'wpcp_add_to_cart_border',
								'type'        => 'border',
								'title'       => __( 'Add to Cart Border', 'wp-carousel-pro' ),
								'subtitle'    => __( 'Set border for the add to cart button.', 'wp-carousel-pro' ),
								'all'         => true,
								'hover-color' => true,
								'radius'      => true,
								'default'     => array(
									'all'         => '1',
									'style'       => 'solid',
									'color'       => '#d1d1d1',
									'hover-color' => '#d1d1d1',
									'radius'      => '0',
								),
								'dependency'  => array( 'wpcp_carousel_type|wpcp_product_cart', '==|==', 'product-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_add_to_cart_color_set',
								'type'       => 'color_group',
								'title'      => __( 'Add to Cart Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set color for the add to cart button.', 'wp-carousel-pro' ),
								'options'    => array(
									'color1' => __( 'Color', 'wp-carousel-pro' ),
									'color2' => __( 'Hover Color', 'wp-carousel-pro' ),
									'color3' => __( 'Background', 'wp-carousel-pro' ),
									'color4' => __( 'Hover Background', 'wp-carousel-pro' ),
								),
								'default'    => array(
									'color1' => '#545454',
									'color2' => '#fff',
									'color3' => '#ebebeb',
									'color4' => '#3f3f3f',
								),
								'dependency' => array( 'wpcp_carousel_type|wpcp_product_cart', '==|==', 'product-carousel|true', true ),
							),

						),
					),
					// Image Content.
					array(
						'title'  => __( 'Title & Description', 'wp-carousel-pro' ),
						'icon'   => 'wpcp-icon-title_description',
						'fields' => array(
							array(
								'id'         => 'wpcp_image_caption',
								'type'       => 'switcher',
								'title'      => __( 'Title', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide title for the image.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type', '==', 'image-carousel', true ),
							),
							array(
								'id'         => 'wpcp_image_title_source',
								'type'       => 'select',
								'title'      => __( 'Title Source', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Choose a title source.', 'wp-carousel-pro' ),
								'options'    => array(
									'title'   => __( 'Title', 'wp-carousel-pro' ),
									'caption' => __( 'Caption', 'wp-carousel-pro' ),
									'alt'     => __( 'Alt Text', 'wp-carousel-pro' ),
								),
								'default'    => 'caption',
								'dependency' => array( 'wpcp_carousel_type|wpcp_image_caption', '==|==', 'image-carousel|true', true ),
							),
							array(
								'id'         => 'wpcp_image_desc',
								'type'       => 'switcher',
								'title'      => __( 'Description', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide description for image.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type', 'any', 'image-carousel,video-carousel,audio-carousel', true ),
							),
							array(
								'id'         => 'img_desc_display_type',
								'type'       => 'button_set',
								'title'      => __( 'Display Type', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Choose the description display type.', 'wp-carousel-pro' ),
								'options'    => array(
									'full'  => __( 'Full', 'wp-carousel-pro' ),
									'limit' => __( 'Limit', 'wp-carousel-pro' ),
								),
								'default'    => 'full',
								'dependency' => array( 'wpcp_carousel_type|wpcp_image_desc', '==|==', 'image-carousel|true', true ),
							),
							array(
								'id'         => 'img_desc_word_limit',
								'type'       => 'spinner',
								'title'      => __( 'Words Limit', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set description words limit.', 'wp-carousel-pro' ),
								'default'    => '30',
								'min'        => 0,
								'dependency' => array( 'wpcp_carousel_type|wpcp_image_desc|img_desc_display_type', '==|==|==', 'image-carousel|true|limit', true ),
							),
							array(
								'id'         => 'img_desc_read_more',
								'type'       => 'switcher',
								'title'      => __( 'Read More Button', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide description read more button.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_image_desc|img_desc_display_type', '==|==|==', 'image-carousel|true|limit', true ),
							),
							array(
								'id'         => 'img_readmore_label',
								'type'       => 'text',
								'title'      => __( 'Read More Button Label', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Change the read more button label text.', 'wp-carousel-pro' ),
								'default'    => 'Read More',
								'dependency' => array( 'wpcp_carousel_type|wpcp_image_desc|img_desc_display_type|img_desc_read_more', '==|==|==|==', 'image-carousel|true|limit|true', true ),
							),
							array(
								'id'          => 'img_readmore_border',
								'type'        => 'border',
								'title'       => __( 'Border', 'wp-carousel-pro' ),
								'subtitle'    => __( 'Set border for read more button.', 'wp-carousel-pro' ),
								'all'         => true,
								'hover-color' => true,
								'radius'      => true,
								'default'     => array(
									'all'         => '1',
									'style'       => 'solid',
									'color'       => '#257F87',
									'hover-color' => '#1f5c5d',
									'radius'      => '0',
								),
								'dependency'  => array( 'wpcp_carousel_type|wpcp_image_desc|img_desc_display_type|img_desc_read_more', '==|==|==|==', 'image-carousel|true|limit|true', true ),
							),
							array(
								'id'         => 'img_readmore_color_set',
								'type'       => 'color_group',
								'title'      => __( 'Read More Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set color for the read more button.', 'wp-carousel-pro' ),
								'options'    => array(
									'color1' => __( 'Label Color', 'wp-carousel-pro' ),
									'color2' => __( 'Hover Color', 'wp-carousel-pro' ),
									'color3' => __( 'Background', 'wp-carousel-pro' ),
									'color4' => __( 'Hover Background', 'wp-carousel-pro' ),
								),
								'default'    => array(
									'color1' => '#fff',
									'color2' => '#fff',
									'color3' => '#257F87',
									'color4' => '#1f5c5d',
								),
								'dependency' => array( 'wpcp_carousel_type|wpcp_image_desc|img_desc_display_type|img_desc_read_more', '==|==|==|==', 'image-carousel|true|limit|true', true ),
							),

						),
					),
					// Typographpy.
					array(
						'title'  => __( 'Typographpy', 'wp-carousel-pro' ),
						'icon'   => 'wpcp-icon-tab_typography',
						'fields' => array(
							array(
								'type'    => 'notice',
								'class'   => 'wpcp-typography-notice',
								/* translators: 1: start link tag, 2: close tag. */
								'content' => sprintf( __( 'The %1$sGlobal Google Fonts%2$s option must be enabled for the font-weight and family to work properly.', 'wp-carousel-pro' ), '<a href="' . esc_url( admin_url( 'edit.php?post_type=sp_wp_carousel&page=wpcp_settings#tab=advanced-controls' ) ) . '" target="_blank"><b>', '</b></a>' ),
							),
							array(
								'id'       => 'section_title_font_load',
								'type'     => 'switcher',
								'title'    => __( 'Load Section Title Font', 'wp-carousel-pro' ),
								'subtitle' => __( 'On/Off google font for the section title.', 'wp-carousel-pro' ),
								'default'  => false,
							),
							array(
								'id'           => 'wpcp_section_title_typography',
								'type'         => 'typography',
								'title'        => __( 'Section Title Font', 'wp-carousel-pro' ),
								'subtitle'     => __( 'Set section title font properties.', 'wp-carousel-pro' ),
								'margin'       => true,
								'default'      => array(
									'color'          => '#444444',
									'font-family'    => '',
									'font-weight'    => '',
									'font-size'      => '24',
									'line-height'    => '28',
									'letter-spacing' => '0',
									'text-align'     => 'center',
									'text-transform' => 'none',
									'margin-top'     => '0',
									'margin-bottom'  => '30',
									'unit'           => 'px',
									'type'           => 'google',
								// 'unit'           => 'px',
								),
								'preview'      => 'always',
								'preview_text' => 'Section Title',
							),
							array(
								'id'         => 'wpcp_image_caption_font_load',
								'class'      => 'wpcp_image_caption_font_load',
								'type'       => 'switcher',
								'title'      => __( 'Load Title Font', 'wp-carousel-pro' ),
								'subtitle'   => __( 'On/Off google font for the image title.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type', 'any', 'image-carousel,external-carousel', true ),
							),
							array(
								'id'           => 'wpcp_image_caption_typography',
								'class'        => 'wpcp_image_caption_typography',
								'type'         => 'typography',
								'title'        => __( 'Title Font', 'wp-carousel-pro' ),
								'subtitle'     => __( 'Set title font properties.', 'wp-carousel-pro' ),
								'margin'       => true,
								'default'      => array(
									'color'          => '#333',
									'font-family'    => '',
									'font-weight'    => '',
									'font-size'      => '15',
									'line-height'    => '23',
									'letter-spacing' => '0',
									'margin-top'     => '0',
									'margin-bottom'  => '0',
									'text-align'     => 'center',
									'text-transform' => 'capitalize',
									'type'           => 'google',
								),
								'preview_text' => 'The image caption',
								'preview'      => 'always',
								'dependency'   => array( 'wpcp_carousel_type', 'any', 'image-carousel,external-carousel', true ),
							),
							array(
								'id'         => 'wpcp_image_desc_font_load',
								'type'       => 'switcher',
								'title'      => __( 'Load Description Font', 'wp-carousel-pro' ),
								'subtitle'   => __( 'On/Off google font for the image description.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type', '==', 'image-carousel', true ),
							),
							array(
								'id'         => 'wpcp_image_desc_typography',
								'type'       => 'typography',
								'title'      => __( 'Description Font', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set description font properties.', 'wp-carousel-pro' ),
								'margin'     => true,
								'default'    => array(
									'color'          => '#333',
									'font-family'    => '',
									'font-weight'    => '',
									'font-style'     => 'normal',
									'font-size'      => '14',
									'line-height'    => '21',
									'letter-spacing' => '0',
									'margin-top'     => '0',
									'margin-bottom'  => '0',
									'text-align'     => 'center',
									'type'           => 'google',
								),
								'preview'    => 'always',
								'dependency' => array( 'wpcp_carousel_type', '==', 'image-carousel', true ),
							),
							// Post Typography.
							array(
								'id'         => 'wpcp_title_font_load',
								'class'      => 'wpcp_title_font_load',
								'type'       => 'switcher',
								'title'      => __( 'Load Title Font', 'wp-carousel-pro' ),
								'subtitle'   => __( 'On/Off google font for the slide title.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type', 'any', 'post-carousel,external-carousel', true ),
							),

							array(
								'id'           => 'wpcp_title_typography',
								'class'        => 'wpcp_title_typography',
								'type'         => 'typography',
								'title'        => __( 'Post Title Font', 'wp-carousel-pro' ),
								'subtitle'     => __( 'Set title font properties.', 'wp-carousel-pro' ),
								'default'      => array(
									'color'          => '#444',
									'hover_color'    => '#1f5c5d',
									'font-family'    => '',
									'font-style'     => '',
									'font-size'      => '18',
									'line-height'    => '26',
									'letter-spacing' => '0',
									'text-align'     => 'center',
									'text-transform' => 'capitalize',
									'type'           => 'google',
								),
								'hover_color'  => true,
								'preview_text' => 'The Post Title',
								'preview'      => 'always',
								'dependency'   => array( 'wpcp_carousel_type', 'any', 'post-carousel,external-carousel', true ),
							),

							array(
								'id'         => 'wpcp_post_content_font_load',
								'class'      => 'wpcp_post_content_font_load',
								'type'       => 'switcher',
								'title'      => __( 'Post Content Font Load', 'wp-carousel-pro' ),
								'subtitle'   => __( 'On/Off google font for post the content.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type', 'any', 'post-carousel,external-carousel', true ),
							),
							array(
								'id'         => 'wpcp_post_content_typography',
								'class'      => 'wpcp_post_content_typography',
								'type'       => 'typography',
								'title'      => __( 'Post Content Font', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set post content font properties.', 'wp-carousel-pro' ),
								'default'    => array(
									'color'          => '#444',
									'font-family'    => '',
									'font-style'     => '',
									'font-size'      => '14',
									'line-height'    => '24',
									'letter-spacing' => '0',
									'text-align'     => 'center',
									'type'           => 'google',
								),
								'preview'    => 'always',
								'dependency' => array( 'wpcp_carousel_type', 'any', 'post-carousel,external-carousel', true ),
							),

							array(
								'id'         => 'wpcp_post_cat_font_load',
								'type'       => 'switcher',
								'title'      => __( 'Post Category Font Load', 'wp-carousel-pro' ),
								'subtitle'   => __( 'On/Off google font for the post category.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type', 'any', 'post-carousel', true ),
							),
							array(
								'id'           => 'wpcp_post_cat_typography',
								'type'         => 'typography',
								'title'        => __( 'Post Category Font', 'wp-carousel-pro' ),
								'subtitle'     => __( 'Set post category font properties.', 'wp-carousel-pro' ),
								'default'      => array(
									'color'          => '#22afba',
									'font-family'    => '',
									'font-style'     => '',
									'font-size'      => '14',
									'line-height'    => '18',
									'letter-spacing' => '0',
									'type'           => 'google',
								),
								'preview'      => 'always',
								'text_align'   => false,
								'preview_text' => 'The Category', // Replace preview text with any text you like.
								'dependency'   => array( 'wpcp_carousel_type', 'any', 'post-carousel', true ),
							),
							array(
								'id'         => 'wpcp_post_meta_font_load',
								'type'       => 'switcher',
								'title'      => __( 'Post Meta Font Load', 'wp-carousel-pro' ),
								'subtitle'   => __( 'On/Off google font for the post meta.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array(
									'wpcp_carousel_type',
									'==',
									'post-carousel',
									true,
								),
							),
							array(
								'id'           => 'wpcp_post_meta_typography',
								'type'         => 'typography',
								'title'        => __( 'Post Meta Font', 'wp-carousel-pro' ),
								'subtitle'     => __( 'Set post meta font properties.', 'wp-carousel-pro' ),
								'default'      => array(
									'color'          => '#999',
									'font-family'    => '',
									'font-style'     => '',
									'font-size'      => '14',
									'line-height'    => '18',
									'letter-spacing' => '0',
									'text-align'     => 'center',
									'type'           => 'google',
								),
								'preview_text' => 'Post Meta', // Replace preview text with any text you like.
								'dependency'   => array(
									'wpcp_carousel_type',
									'==',
									'post-carousel',
									true,
								),
							),
							array(
								'id'         => 'wpcp_post_readmore_font_load',
								'class'      => 'wpcp_post_readmore_font_load',
								'type'       => 'switcher',
								'title'      => __( 'Read More Font Load', 'wp-carousel-pro' ),
								'subtitle'   => __( 'On/Off google font for the read more.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type', 'any', 'post-carousel,external-carousel', true ),
							),
							array(
								'id'           => 'wpcp_post_readmore_typography',
								'class'        => 'wpcp_post_readmore_typography',
								'type'         => 'typography',
								'title'        => __( 'Read More Font', 'wp-carousel-pro' ),
								'subtitle'     => __( 'Set read more font properties.', 'wp-carousel-pro' ),
								'default'      => array(
									'font-family'    => '',
									'font-style'     => '',
									'font-size'      => '14',
									'line-height'    => '24',
									'letter-spacing' => '0',
									'text-align'     => 'center',
									'type'           => 'google',
								),
								'preview'      => 'always',
								'color'        => false,
								'preview_text' => 'Read more', // Replace preview text with any text you like.
								'dependency'   => array( 'wpcp_carousel_type', 'any', 'post-carousel,external-carousel', true ),
							),

							// Product Typography.
							array(
								'id'         => 'wpcp_product_name_font_load',
								'type'       => 'switcher',
								'title'      => __( 'Product Name Font Load', 'wp-carousel-pro' ),
								'subtitle'   => __( 'On/Off google font for the product name.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array(
									'wpcp_carousel_type|wpcp_product_name',
									'==|==',
									'product-carousel|true',
									true,
								),
							),
							array(
								'id'           => 'wpcp_product_name_typography',
								'type'         => 'typography',
								'title'        => __( 'Product Name Font', 'wp-carousel-pro' ),
								'subtitle'     => __( 'Set product name font properties.', 'wp-carousel-pro' ),
								'default'      => array(
									'color'          => '#444',
									'hover_color'    => '#555',
									'font-family'    => '',
									'font-style'     => '',
									'font-size'      => '15',
									'line-height'    => '23',
									'letter-spacing' => '0',
									'text-align'     => 'center',
									'type'           => 'google',
								),
								'hover_color'  => true,
								'preview_text' => 'Product Name', // Replace preview text.
								'dependency'   => array(
									'wpcp_carousel_type|wpcp_product_name',
									'==|==',
									'product-carousel|true',
									true,
								),
							),
							array(
								'id'         => 'wpcp_product_desc_font_load',
								'type'       => 'switcher',
								'title'      => __( 'Product Description Font Load', 'wp-carousel-pro' ),
								'subtitle'   => __( 'On/Off google font for the product description.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array(
									'wpcp_carousel_type|wpcp_product_desc',
									'==|==',
									'product-carousel|true',
									true,
								),
							),
							array(
								'id'           => 'wpcp_product_desc_typography',
								'type'         => 'typography',
								'title'        => __( 'Product Description Font', 'wp-carousel-pro' ),
								'subtitle'     => __( 'Set product description font properties.', 'wp-carousel-pro' ),
								'default'      => array(
									'color'          => '#333',
									'font-family'    => '',
									'font-style'     => '',
									'font-size'      => '14',
									'line-height'    => '22',
									'letter-spacing' => '0',
									'text-align'     => 'center',
									'type'           => 'google',
								),
								'preview_text' => 'Lorem ipsum dolor sit amet, connecter adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.', // Replace preview text with any text you like.
								'dependency'   => array(
									'wpcp_carousel_type|wpcp_product_desc',
									'==|==',
									'product-carousel|true',
									true,
								),
							),
							array(
								'id'         => 'wpcp_product_price_font_load',
								'type'       => 'switcher',
								'title'      => __( 'Product Price Font Load', 'wp-carousel-pro' ),
								'subtitle'   => __( 'On/Off google font for the product price.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array(
									'wpcp_carousel_type|wpcp_product_price',
									'==|==',
									'product-carousel|true',
									true,
								),
							),
							array(
								'id'           => 'wpcp_product_price_typography',
								'type'         => 'typography',
								'title'        => __( 'Product Price Font', 'wp-carousel-pro' ),
								'subtitle'     => __( 'Set product price font properties.', 'wp-carousel-pro' ),
								'default'      => array(
									'color'          => '#222',
									'font-family'    => '',
									'font-style'     => '',
									'font-size'      => '14',
									'line-height'    => '26',
									'letter-spacing' => '0',
									'text-align'     => 'center',
									'type'           => 'google',
								),
								'preview_text' => '$49.00', // Replace preview text with any text you like.
								'dependency'   => array(
									'wpcp_carousel_type|wpcp_product_price',
									'==|==',
									'product-carousel|true',
									true,
								),
							),
							array(
								'id'         => 'wpcp_product_readmore_font_load',
								'type'       => 'switcher',
								'title'      => __( 'Read More Font Load', 'wp-carousel-pro' ),
								'subtitle'   => __( 'On/Off google font for the read more.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array(
									'wpcp_carousel_type|wpcp_product_rating',
									'==|==',
									'product-carousel|true',
									true,
								),
							),
							array(
								'id'           => 'wpcp_product_readmore_typography',
								'type'         => 'typography',
								'title'        => __( 'Read More Font', 'wp-carousel-pro' ),
								'subtitle'     => __( 'Set read more font properties.', 'wp-carousel-pro' ),
								'default'      => array(
									'color'          => '#e74c3c',
									'hover_color'    => '#e74c3c',
									'font-family'    => '',
									'font-style'     => '',
									'font-size'      => '14',
									'line-height'    => '24',
									'letter-spacing' => '0',
									'text-align'     => 'center',
									'type'           => 'google',
								),
								'hover_color'  => true,
								'preview_text' => 'Read more', // Replace preview text with any text you like.
								'dependency'   => array(
									'wpcp_carousel_type|wpcp_product_rating',
									'==|==',
									'product-carousel|true',
									true,
								),
							),
							array(
								'id'         => 'wpcp_product_cart_font_load',
								'type'       => 'switcher',
								'title'      => __( 'Product Add to Cart Font Load', 'wp-carousel-pro' ),
								'subtitle'   => __( 'On/Off google font for the product add to cart.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array(
									'wpcp_carousel_type|wpcp_product_cart',
									'==|==',
									'product-carousel|true',
									true,
								),
							),
							array(
								'id'           => 'wpcp_product_cart_typography',
								'type'         => 'typography',
								'title'        => __( 'Product Add To Cart Font', 'wp-carousel-pro' ),
								'subtitle'     => __( 'Set product add to cart font properties.', 'wp-carousel-pro' ),
								'default'      => array(
									'font-family'    => '',
									'font-style'     => '',
									'font-size'      => '14',
									'line-height'    => '21',
									'letter-spacing' => '0',
									'text-align'     => 'center',
									'text-transform' => 'uppercase',
									'type'           => 'google',
									'margin-top'     => '0',
									'margin-bottom'  => '10',
									'unit'           => 'px',
								),
								'color'        => false,
								'margin'       => true,
								'preview_text' => 'Add To Cart', // Replace preview text with any text you like.
								'dependency'   => array(
									'wpcp_carousel_type|wpcp_product_cart',
									'==|==',
									'product-carousel|true',
									true,
								),
							),
						), // End of fields array.
					),
				),
			),
		),
	)
);
