class CustomColor{constructor(r,g,b,o=1){this.set(r,g,b,o)}toString(){return`rgb(${Math.round(this.r)}, ${Math.round(this.g)}, ${Math.round(this.b)}, ${this.o})`}set(r,g,b,o){this.r=this.clamp(r),this.g=this.clamp(g),this.b=this.clamp(b),this.o=o}hueRotate(angle=0){angle=angle/180*Math.PI;const sin=Math.sin(angle),cos=Math.cos(angle);this.multiply([.213+.787*cos-.213*sin,.715-.715*cos-.715*sin,.072-.072*cos+.928*sin,.213-.213*cos+.143*sin,.715+.285*cos+.14*sin,.072-.072*cos-.283*sin,.213-.213*cos-.787*sin,.715-.715*cos+.715*sin,.072+.928*cos+.072*sin])}grayscale(value=1){this.multiply([.2126+.7874*(1-value),.7152-.7152*(1-value),.0722-.0722*(1-value),.2126-.2126*(1-value),.7152+.2848*(1-value),.0722-.0722*(1-value),.2126-.2126*(1-value),.7152-.7152*(1-value),.0722+.9278*(1-value)])}sepia(value=1){this.multiply([.393+.607*(1-value),.769-.769*(1-value),.189-.189*(1-value),.349-.349*(1-value),.686+.314*(1-value),.168-.168*(1-value),.272-.272*(1-value),.534-.534*(1-value),.131+.869*(1-value)])}saturate(value=1){this.multiply([.213+.787*value,.715-.715*value,.072-.072*value,.213-.213*value,.715+.285*value,.072-.072*value,.213-.213*value,.715-.715*value,.072+.928*value])}multiply(matrix){const newR=this.clamp(this.r*matrix[0]+this.g*matrix[1]+this.b*matrix[2]),newG=this.clamp(this.r*matrix[3]+this.g*matrix[4]+this.b*matrix[5]),newB=this.clamp(this.r*matrix[6]+this.g*matrix[7]+this.b*matrix[8]);this.r=newR,this.g=newG,this.b=newB}brightness(value=1){this.linear(value)}contrast(value=1){this.linear(value,-.5*value+.5)}linear(slope=1,intercept=0){this.r=this.clamp(this.r*slope+255*intercept),this.g=this.clamp(this.g*slope+255*intercept),this.b=this.clamp(this.b*slope+255*intercept)}invert(value=1){this.r=this.clamp(255*(value+this.r/255*(1-2*value))),this.g=this.clamp(255*(value+this.g/255*(1-2*value))),this.b=this.clamp(255*(value+this.b/255*(1-2*value)))}hsl(){const r=this.r/255,g=this.g/255,b=this.b/255,max=Math.max(r,g,b),min=Math.min(r,g,b);let h,s,l=(max+min)/2;if(max===min)h=s=0;else{const d=max-min;switch(s=l>.5?d/(2-max-min):d/(max+min),max){case r:h=(g-b)/d+(g<b?6:0);break;case g:h=(b-r)/d+2;break;case b:h=(r-g)/d+4}h/=6}return{h:100*h,s:100*s,l:100*l}}clamp(value){return value>255?value=255:value<0&&(value=0),value}}class Solver{constructor(target,baseColor){this.target=target,this.targetHSL=target.hsl(),this.reusedColor=new CustomColor(0,0,0,1)}solve(){const result=this.solveNarrow(this.solveWide());return{values:result.values,loss:result.loss,filter:this.css(result.values)}}solveWide(){const A=5,c=15,a=[60,180,18e3,600,1.2,1.2];let best={loss:1/0};for(let i=0;best.loss>25&&i<3;i++){const initial=[50,20,3750,50,100,100],result=this.spsa(5,a,c,initial,1e3);result.loss<best.loss&&(best=result)}return best}solveNarrow(wide){const A=wide.loss,c=2,A1=A+1,a=[.25*A1,.25*A1,A1,.25*A1,.2*A1,.2*A1];return this.spsa(A,a,2,wide.values,500)}spsa(A,a,c,values,iters){const alpha=1,gamma=.16666666666666666;let best=null,bestLoss=1/0;const deltas=new Array(6),highArgs=new Array(6),lowArgs=new Array(6);for(let k=0;k<iters;k++){const ck=c/Math.pow(k+1,gamma);for(let i=0;i<6;i++)deltas[i]=Math.random()>.5?1:-1,highArgs[i]=values[i]+ck*deltas[i],lowArgs[i]=values[i]-ck*deltas[i];const lossDiff=this.loss(highArgs)-this.loss(lowArgs);for(let i=0;i<6;i++){const g=lossDiff/(2*ck)*deltas[i],ak=a[i]/Math.pow(A+k+1,1);values[i]=fix(values[i]-ak*g,i)}const loss=this.loss(values);loss<bestLoss&&(best=values.slice(0),bestLoss=loss)}return{values:best,loss:bestLoss};function fix(value,idx){let max=100;return 2===idx?max=7500:4!==idx&&5!==idx||(max=200),3===idx?value>max?value%=max:value<0&&(value=max+value%max):value<0?value=0:value>max&&(value=max),value}}loss(filters){const color=this.reusedColor;color.set(0,0,0),color.invert(filters[0]/100),color.sepia(filters[1]/100),color.saturate(filters[2]/100),color.hueRotate(3.6*filters[3]),color.brightness(filters[4]/100),color.contrast(filters[5]/100);const colorHSL=color.hsl();return Math.abs(color.r-this.target.r)+Math.abs(color.g-this.target.g)+Math.abs(color.b-this.target.b)+Math.abs(colorHSL.h-this.targetHSL.h)+Math.abs(colorHSL.s-this.targetHSL.s)+Math.abs(colorHSL.l-this.targetHSL.l)}css(filters){function fmt(idx,multiplier=1){return Math.round(filters[idx]*multiplier)}return`invert(${fmt(0)}%) sepia(${fmt(1)}%) saturate(${fmt(2)}%) hue-rotate(${fmt(3,3.6)}deg) brightness(${fmt(4)}%) contrast(${fmt(5)}%) opacity(${this.target.o})`}}function hexToRgb(hex){const shorthandRegex=/^#?([a-f\d])([a-f\d])([a-f\d])$/i;hex=hex.replace(shorthandRegex,(m,r,g,b)=>r+r+g+g+b+b);const result=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);return result?[parseInt(result[1],16),parseInt(result[2],16),parseInt(result[3],16)]:null}