<?php
/**
 * Metabox config file.
 *
 * @link       https://shapedplugin.com
 * @since      3.0.0
 *
 * @package    WP_Carousel_Pro
 * @subpackage WP_Carousel_Pro/admin/views
 */

use ShapedPlugin\WPCarouselPro\Admin\views\sp_framework\classes\SP_WPCP_Framework;
if ( ! defined( 'ABSPATH' ) ) {
	die;
} // Cannot access pages directly.
//
// Carousel settings section begin.
//
SP_WPCP_Framework::createSection(
	$wpcp_carousel_shortcode_settings,
	array(
		'title'  => __( 'Carousel Settings', 'wp-carousel-pro' ),
		'icon'   => 'fa fa-sliders',
		'fields' => array(
			array(
				'type'  => 'tabbed',
				'class' => 'wp-carousel-display-tabs wp-carousel-carousel-tabs',
				'tabs'  => array(
					array(
						'title'  => __( 'Basics', 'wp-carousel-pro' ),
						'icon'   => 'wpcp-icon-tab_basic-settings',
						'fields' => array(
							array(
								'id'         => 'wpcp_carousel_auto_play',
								'type'       => 'switcher',
								'title'      => __( 'AutoPlay', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable/Disable carousel auto play.', 'wp-carousel-pro' ),
								'default'    => false,
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'dependency' => array( 'wpcp_carousel_mode', '!=', 'ticker', true ),
							),
							array(
								'id'         => 'carousel_auto_play_speed',
								'type'       => 'slider',
								'title'      => __( 'AutoPlay Delay Time', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set auto play delay time in millisecond.', 'wp-carousel-pro' ),
								'title_help' => __(
									'<div class="sp_wpcp-info-label">AutoPlay Delay Time</div><div class="sp_wpcp-short-content">Set autoplay delay or interval time. The amount of time to delay between automatically cycling a item. e.g. 1000 milliseconds(ms) = 1 second.</div>',
									'wp-carousel-pro'
								),
								'unit'       => __( 'ms', 'wp-carousel-pro' ),
								'step'       => 100,
								'min'        => 100,
								'max'        => 50000,
								'default'    => 3000,
								'dependency' => array(
									'wpcp_carousel_auto_play|wpcp_carousel_mode',
									'==|!=',
									'true|ticker',
									true,
								),
							),
							array(
								'id'         => 'standard_carousel_scroll_speed',
								'type'       => 'slider',
								'title'      => __( 'Carousel Speed', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set autoplay scroll speed in millisecond.', 'wp-carousel-pro' ),
								'title_help' => __( '<div class="sp_wpcp-info-label">Carousel Speed</div><div class="sp_wpcp-short-content">Set carousel scrolling speed. e.g. 1000 milliseconds(ms) = 1 second.</div>', 'wp-carousel-pro' ),
								'unit'       => __( 'ms', 'wp-carousel-pro' ),
								'step'       => 50,
								'min'        => 100,
								'max'        => 20000,
								'default'    => 600,
								'dependency' => array( 'wpcp_carousel_mode', '!=', 'ticker', true ),
							),
							array(
								'id'              => 'ticker_carousel_scroll_speed',
								'type'            => 'spacing',
								'class'           => 'standard_width_of_spacing_field',
								'title'           => __( 'Sliding Speed', 'wp-carousel-pro' ),
								'subtitle'        => __( 'Set sliding or scrolling speed. Default value is 8000 milliseconds.', 'wp-carousel-pro' ),
								'all'             => true,
								'all_text'        => false,
								'all_placeholder' => 'speed',
								'default'         => array(
									'all' => '8000',
								),
								'units'           => array(
									'ms',
								),
								'attributes'      => array(
									'min' => 0,
								),
								'dependency'      => array( 'wpcp_carousel_mode', '==', 'ticker', true ),
							),

							array(
								'id'         => 'carousel_pause_on_hover',
								'type'       => 'switcher',
								'title'      => __( 'Pause on Hover', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable/Disable carousel pause on hover.', 'wp-carousel-pro' ),
								'default'    => true,
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
							),
							array(
								'id'         => 'carousel_infinite',
								'type'       => 'switcher',
								'title'      => __( 'Infinite Loop', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable/Disable infinite loop mode. It won\'t work well in the multi-row.', 'wp-carousel-pro' ),
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_mode', '!=', 'ticker', true ),
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
							),
							array(
								'id'       => 'wpcp_carousel_direction',
								'type'     => 'button_set',
								'title'    => __( 'Carousel Direction', 'wp-carousel-pro' ),
								'subtitle' => __( 'Select carousel direction as you need.', 'wp-carousel-pro' ),
								'options'  => array(
									'rtl' => __( 'Right to Left', 'wp-carousel-pro' ),
									'ltr' => __( 'Left to Right', 'wp-carousel-pro' ),
								),
								'radio'    => true,
								'default'  => 'rtl',
							),
							array(
								'id'         => 'wpcp_adaptive_height',
								'type'       => 'switcher',
								'title'      => __( 'Adaptive Height', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable/Disable adaptive height for the carousel.', 'wp-carousel-pro' ),
								'default'    => false,
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'dependency' => array( 'wpcp_carousel_mode', '!=', 'ticker', true ),
							),
						),
					),
					array(
						'title'  => __( 'Navigation', 'wp-carousel-pro' ),
						'icon'   => 'wpcp-icon-tab_navigation',
						'fields' => array(// Navigation.
							array(
								'id'     => 'wpcp_carousel_navigation',
								'class'  => 'wpcp-navigation-and-pagination-style',
								'type'   => 'fieldset',
								'fields' => array(
									array(
										'id'         => 'wpcp_navigation',
										'type'       => 'switcher',
										'class'      => 'wpcp_navigation',
										'title'      => __( 'Navigation', 'wp-carousel-pro' ),
										'subtitle'   => __( 'Show/Hide carousel navigation.', 'wp-carousel-pro' ),
										'default'    => true,
										'text_on'    => __( 'Show', 'wp-carousel-pro' ),
										'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
										'text_width' => 77,
										'dependency' => array( 'wpcp_carousel_mode', '!=', 'ticker', true ),
									),
									array(
										'id'         => 'wpcp_hide_on_mobile',
										'type'       => 'checkbox',
										'class'      => 'wpcp_hide_on_mobile',
										'title'      => __( 'Hide on Mobile', 'wp-carousel-pro' ),
										'default'    => false,
										'dependency' => array( 'wpcp_carousel_mode|wpcp_navigation', '!=|==', 'ticker|true', true ),
									),
								),
							),
							array(
								'id'         => 'wpcp_carousel_nav_position',
								'type'       => 'select',
								'class'      => 'chosen wpcp-carousel-nav-position',
								'preview'    => true,
								'title'      => __( 'Select Position', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Select a position for the navigation arrows.', 'wp-carousel-pro' ),
								'options'    => array(
									'top_right'       => __( 'Top Right', 'wp-carousel-pro' ),
									'top_center'      => __( 'Top Center', 'wp-carousel-pro' ),
									'top_left'        => __( 'Top Left', 'wp-carousel-pro' ),
									'bottom_left'     => __( 'Bottom Left', 'wp-carousel-pro' ),
									'bottom_center'   => __( 'Bottom Center', 'wp-carousel-pro' ),
									'bottom_right'    => __( 'Bottom Right', 'wp-carousel-pro' ),
									'vertical_center_inner' => __( 'Vertical Inner', 'wp-carousel-pro' ),
									'vertical_outer'  => __( 'Vertical Outer', 'wp-carousel-pro' ),
									'vertical_center' => __( 'Vertical Center', 'wp-carousel-pro' ),
								),
								'default'    => 'vertical_outer',
								'dependency' => array( 'wpcp_navigation|wpcp_carousel_mode', '!=|!=', 'false|ticker', true ),
							),
							array(
								'id'         => 'wpcp_visible_on_hover',
								'type'       => 'checkbox',
								'title'      => __( 'Show On Hover', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Check to show navigation on hover in the carousel or slider area.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array(
									'wpcp_navigation|wpcp_carousel_mode|wpcp_carousel_nav_position',
									'!=|!=|any',
									'false|ticker|vertical_center,vertical_center_inner,vertical_outer',
									true,
								),
							),
							array(
								'id'         => 'navigation_icons',
								'type'       => 'button_set',
								'title'      => __( 'Navigation Arrow Style', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Choose a carousel navigation arrow icon.', 'wp-carousel-pro' ),
								'class'      => 'wpcp_navigation_icons',
								'options'    => array(
									'right_open'         => '<i class="wpcp-icon-right-open"></i>',
									'angle'              => '<i class="wpcp-icon-angle-right"></i>',
									'chevron_open_big'   => '<i class="wpcp-icon-right-open-big"></i>',
									'chevron'            => '<i class="wpcp-icon-right-open-1"></i>',
									'right_open_3'       => '<i class="wpcp-icon-right-open-3"></i>',
									'right_open_outline' => '<i class="wpcp-icon-right-open-outline"></i>',
									'arrow'              => '<i class="wpcp-icon-right"></i>',
									'triangle'           => '<i class="wpcp-icon-arrow-triangle-right"></i>',
								),
								'default'    => 'right_open',
								'radio'      => true,
								'dependency' => array(
									'wpcp_navigation|wpcp_carousel_mode',
									'!=|!=',
									'false|ticker',
									true,
								),
							),
							array(
								'id'         => 'navigation_icons_size',
								'type'       => 'spacing',
								'class'      => 'standard_width_of_spacing_field',
								'title'      => __( 'Icon Size', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set a size for the nav arrow icon.', 'wp-carousel-pro' ),
								'style'      => false,
								'color'      => false,
								'all'        => true,
								'units'      => array( 'px' ),
								'default'    => array(
									'all' => '20',
								),
								'attributes' => array(
									'min' => 0,
								),
								'dependency' => array(
									'wpcp_navigation|wpcp_carousel_mode',
									'!=|!=',
									'false|ticker',
									true,
								),
							),
							array(
								'id'         => 'wpcp_nav_arrow_color',
								'type'       => 'color_group',
								'title'      => __( 'Navigation Arrow ', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set color for the carousel navigation arrow.', 'wp-carousel-pro' ),
								'options'    => array(
									'color1' => __( 'Color', 'wp-carousel-pro' ),
									'color2' => __( 'Hover Color', 'wp-carousel-pro' ),
								),
								'default'    => array(
									'color1' => '#aaa',
									'color2' => '#178087',
								),
								'dependency' => array(
									'wpcp_navigation|wpcp_carousel_mode',
									'!=|!=',
									'false|ticker',
									true,
								),
							),
							// array(
							// 	'id'         => 'wpcp_hide_nav_bg_border',
							// 	'type'       => 'checkbox',
							// 	'title'      => __( 'Hide Border and Background', 'wp-carousel-pro' ),
							// 	'subtitle'   => __( 'Check to hide nav arrow border and background.', 'wp-carousel-pro' ),
							// 	'default'    => false,
							// 	'dependency' => array(
							// 		'wpcp_navigation|wpcp_carousel_mode',
							// 		'!=|!=',
							// 		'false|ticker',
							// 		true,
							// 	),
							// ),
							array(
								'id'         => 'wpcp_nav_border',
								'type'       => 'border',
								'class'      => 'wpcp-nav-border',
								'title'      => __( 'Border', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set border for the navigation.', 'wp-carousel-pro' ),
								'all'        => true,
								'radius'     => true,
								'unit'       => '%',
								'default'    => array(
									'all'         => '0',
									'style'       => 'solid',
									'color'       => '#aaa',
									'hover-color' => '#178087',
									'radius'      => '0',
								),
								'dependency' => array(
									'wpcp_navigation|wpcp_carousel_mode',
									'!=|!=',
									'false|ticker',
									true,
								),
							),
							array(
								'id'         => 'wpcp_nav_bg',
								'type'       => 'color_group',
								'title'      => __( 'Background', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set color for the carousel navigation arrow.', 'wp-carousel-pro' ),
								'options'    => array(
									'color1' => __( 'Color', 'wp-carousel-pro' ),
									'color2' => __( 'Hover Color', 'wp-carousel-pro' ),
								),
								'default'    => array(
									'color1' => 'transparent',
									'color2' => 'transparent',
								),
								'dependency' => array(
									'wpcp_navigation|wpcp_carousel_mode',
									'!=|!=',
									'false|ticker',
									true,
								),
							),
						),
					),
					array(
						'title'  => __( 'Pagination', 'wp-carousel-pro' ),
						'icon'   => 'wpcp-icon-tab_pagination',
						'fields' => array(
							array(
								'id'     => 'wpcp_carousel_pagination',
								'class'  => 'wpcp-navigation-and-pagination-style',
								'type'   => 'fieldset',
								'fields' => array(
									array(
										'id'         => 'wpcp_pagination',
										'type'       => 'switcher',
										'class'      => 'wpcp_pagination',
										'title'      => __( 'Pagination', 'wp-carousel-pro' ),
										'subtitle'   => __( 'Show/Hide carousel pagination.', 'wp-carousel-pro' ),
										'default'    => true,
										'text_on'    => __( 'Show', 'wp-carousel-pro' ),
										'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
										'text_width' => 77,
										'dependency' => array( 'wpcp_carousel_mode|wpcp_layout', '!=|any', 'ticker|carousel,slider', true ),
									),
									array(
										'id'         => 'wpcp_pagination_hide_on_mobile',
										'type'       => 'checkbox',
										'class'      => 'wpcp_hide_on_mobile',
										'title'      => __( 'Hide on Mobile', 'wp-carousel-pro' ),
										'default'    => false,
										'dependency' => array( 'wpcp_carousel_mode|wpcp_layout|wpcp_pagination', '!=|any|==', 'ticker|carousel,slider|true', true ),
									),
								),
							),

							array(
								'id'         => 'wpcp_carousel_pagination_type',
								'type'       => 'image_select',
								'class'      => 'wpcp_carousel_pagination_width',
								'title'      => __( 'Pagination Style', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Select carousel pagination type.', 'wp-carousel-pro' ),
								'options'    => array(
									'dots'      => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/pagination/bullets.svg',
										'text'  => __( 'Bullets', 'wp-carousel-pro' ),
									),
									'dynamic'   => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/pagination/dynamic.svg',
										'text'  => __( 'Dynamic', 'wp-carousel-pro' ),
									),
									'strokes'   => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/pagination/strokes.svg',
										'text'  => __( 'Strokes', 'wp-carousel-pro' ),
									),
									'scrollbar' => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/pagination/scrollbar.svg',
										'text'  => __( 'Scrollbar', 'wp-carousel-pro' ),
									),
									'fraction'  => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/pagination/numbers.svg',
										'text'  => __( 'Fraction', 'wp-carousel-pro' ),
									),
									'numbers'   => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/pagination/custom-numbers.svg',
										'text'  => __( 'Numbers', 'wp-carousel-pro' ),
									),
								),
								'radio'      => true,
								'default'    => 'dots',
								'dependency' => array( 'wpcp_pagination|wpcp_carousel_mode|wpcp_layout', '!=|!=|any', 'false|ticker|carousel,slider', true ),
							),
							array(
								'id'         => 'wpcp_carousel_pagination_position',
								'type'       => 'button_set',
								'title'      => __( 'Position', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Select a position for the pagination.', 'wp-carousel-pro' ),
								'options'    => array(
									'inside'  => __( 'Inside', 'wp-carousel-pro' ),
									'outside' => __( 'Outside', 'wp-carousel-pro' ),
								),
								'radio'      => true,
								'default'    => 'outside',
								'dependency' => array( 'wpcp_pagination|wpcp_carousel_mode|wpcp_layout', '!=|!=|any', 'false|ticker|slider,carousel', true ),
							),
							array(
								'id'          => 'wpcp_pagination_margin',
								'type'        => 'spacing',
								'title'       => __( 'Margin', 'wp-carousel-pro' ),
								'subtitle'    => __( 'Set margin for carousel pagination.', 'wp-carousel-pro' ),
								'output_mode' => 'margin',
								'unit_text'   => 'Unit',
								'class'       => 'wpcp-pagination-margin',
								'min'         => '-200',
								'default'     => array(
									'top'    => '40',
									'right'  => '0',
									'bottom' => '0',
									'left'   => '0',
									'unit'   => 'px',
								),
								'dependency'  => array( 'wpcp_pagination|wpcp_carousel_mode|wpcp_layout|wpcp_carousel_pagination_position', '!=|!=|any|!=', 'false|ticker|carousel,slider|inside', true ),
							),
							array(
								'id'         => 'wpcp_pagination_color',
								'type'       => 'color_group',
								'title'      => __( 'Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set color for the carousel pagination.', 'wp-carousel-pro' ),
								'options'    => array(
									'color1' => __( 'Color', 'wp-carousel-pro' ),
									'color2' => __( 'Active Color', 'wp-carousel-pro' ),
								),
								'default'    => array(
									'color1' => '#cccccc',
									'color2' => '#178087',
								),
								'dependency' => array( 'wpcp_pagination|wpcp_carousel_mode|wpcp_layout|wpcp_carousel_pagination_type', '!=|!=|any|!=', 'false|ticker|carousel,slider|fraction', true ),
							),
							array(
								'id'         => 'slides_to_scroll',
								'type'       => 'column',
								'title'      => __( 'Slide to Scroll', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Number of slide(s) to scroll at a time.', 'wp-carousel-pro' ),
								'title_help' => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/equal-height.svg" alt="Slide to Scroll"></div><div class="sp_wpcp-info-label">' . __( 'Slide to Scroll', 'wp-carousel-pro' ) . '</div>',
								'unit'       => false,
								'default'    => array(
									'lg_desktop' => '1',
									'desktop'    => '1',
									'laptop'     => '1',
									'tablet'     => '1',
									'mobile'     => '1',
								),
								'dependency' => array( 'wpcp_carousel_mode|wpcp_layout', '!=|==', 'ticker|carousel', true ),
							),
						),
					),
					array(
						'title'  => __( 'Miscellaneous', 'wp-carousel-pro' ),
						'icon'   => 'wpcp-icon-tab_mischellaneous',
						'fields' => array(

							array(
								'id'         => 'wpcp_accessibility',
								'type'       => 'switcher',
								'title'      => __( 'Tab and Key Navigation', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable/Disable carousel scroll with tab and keyboard.', 'wp-carousel-pro' ),
								'default'    => true,
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'dependency' => array( 'wpcp_carousel_mode', '!=', 'ticker', true ),
							),
							array(
								'id'         => 'slider_swipe',
								'type'       => 'switcher',
								'title'      => __( 'Touch Swipe', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable/Disable touch swipe mode.', 'wp-carousel-pro' ),
								'default'    => true,
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'dependency' => array( 'wpcp_carousel_mode', '!=', 'ticker', true ),
							),
							array(
								'id'         => 'slider_draggable',
								'type'       => 'switcher',
								'title'      => __( 'Mouse Draggable', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable/Disable mouse draggable mode.', 'wp-carousel-pro' ),
								'default'    => true,
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'dependency' => array(
									'slider_swipe|wpcp_carousel_mode',
									'==|!=',
									'true|ticker',
									true,
								),
							),
							array(
								'id'         => 'free_mode',
								'type'       => 'switcher',
								'title'      => __( 'Free Mode', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable/Disable free mode slider.', 'wp-carousel-pro' ),
								'title_help' => __( '<div class="sp_wpcp-info-label">Free Mode</div><div class="sp_wpcp-short-content">Enable this feature to allow users to freely scroll and position the slides at anywhere instead of specific positions.</div><a class="sp_wpcp-open-live-demo" href="https://wpcarousel.io/free-mode-carousel/" target="_blank">Live Demo</a>', 'wp-carousel-pro' ),
								'default'    => false,
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'dependency' => array(
									'wpcp_carousel_mode',
									'!=',
									'ticker',
									true,
								),
							),
							array(
								'id'         => 'carousel_swipetoslide',
								'type'       => 'switcher',
								'title'      => __( 'Swipe To Slide', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Allow users to drag or swipe directly to a slide irrespective of slides to scroll.', 'wp-carousel-pro' ),
								'default'    => false,
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'dependency' => array( 'wpcp_carousel_mode', '!=', 'ticker', true ),
							),
						),
					),
				),
			),
		),
	)
); // Carousel settings section end.
