<?php
/**
 * Metabox config file.
 *
 * @link       https://shapedplugin.com
 * @since      3.0.0
 *
 * @package    WP_Carousel_Pro
 * @subpackage WP_Carousel_Pro/admin/views
 */

use ShapedPlugin\WPCarouselPro\Admin\views\sp_framework\classes\SP_WPCP_Framework;
if ( ! defined( 'ABSPATH' ) ) {
	die;
} // Cannot access pages directly.
//
// Lightbox settings section begin.
//
SP_WPCP_Framework::createSection(
	$wpcp_carousel_shortcode_settings,
	array(
		'title'  => __( 'Lightbox Settings', 'wp-carousel-pro' ),
		'icon'   => 'fa fa-search',
		'fields' => array(
			array(
				'type'  => 'tabbed',
				'class' => 'wp-lightbox-display-tabs',
				'tabs'  => array(
					array(
						'title'  => __( 'General', 'wp-carousel-pro' ),
						'icon'   => 'wpcp-icon-general-2',
						'fields' => array(
							array(
								'id'         => 'l_box_autoplay',
								'type'       => 'switcher',
								'title'      => __( 'AutoPlay ', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable to automatically start slideshow.', 'wp-carousel-pro' ),
								'default'    => false,
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'              => 'l_box_autoplay_speed',
								'type'            => 'slider',
								'class'           => 'standard_width_of_spacing_field',
								'title'           => __( 'Speed', 'wp-carousel-pro' ),
								'subtitle'        => __( 'The timeout between sliding to the next slide in milliseconds.', 'wp-carousel-pro' ),
								'all'             => true,
								'all_text'        => false,
								'all_placeholder' => 'speed',
								'default'         => '4000',
								'unit'            => 'ms',
								'min'             => 0,
								'max'             => 20000,
								'dependency'      => array( 'wpcp_carousel_type|wpcp_logo_link_show|l_box_autoplay', 'any|==|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box|true', true ),
							),
							array(
								'id'         => 'l_box_loop',
								'type'       => 'switcher',
								'title'      => __( 'Loop', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable/Disable infinite gallery navigation.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'l_box_keyboard_nav',
								'type'       => 'switcher',
								'title'      => __( 'Keyboard Navigation', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable/Disable keyboard navigation for the lightbox image.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'l_box_nav_arrow_color',
								'type'       => 'color_group',
								'title'      => __( 'Lightbox Navigation Arrow', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set navigation color for the lightbox.', 'wp-carousel-pro' ),
								'options'    => array(
									'color1' => __( 'Color', 'wp-carousel-pro' ),
									'color2' => __( 'Hover Color', 'wp-carousel-pro' ),
									'color3' => __( 'Background', 'wp-carousel-pro' ),
									'color4' => __( 'Hover Background', 'wp-carousel-pro' ),
								),
								'default'    => array(
									'color1' => '#ccc',
									'color2' => '#fff',
									'color3' => '#1e1e1e',
									'color4' => '#1e1e1e',
								),
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'wpcp_img_lb_overlay_color',
								'type'       => 'color',
								'title'      => __( 'Overlay Background Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set overlay background color for lightbox.', 'wp-carousel-pro' ),
								'default'    => '#0b0b0b',
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'l_box_outside_close',
								'type'       => 'switcher',
								'title'      => __( 'Overlay/Outside Close', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Close when clicked outside of the image and content or dark overlay.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'type'       => 'subheading',
								'content'    => __( 'Lightbox Icons', 'wp-carousel-pro' ),
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show|wpcp_post_detail_position', 'any|==|!=', 'image-carousel,video-carousel,mix-content,external-carousel|l_box|with_overlay', true ),
							),
							array(
								'id'         => 'l_box_icon_style',
								'class'      => 'l_box_icon_style',
								'type'       => 'button_set',
								'title'      => __( 'Lightbox Icon Style', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Choose an icon on hover image.', 'wp-carousel-pro' ),
								'multiple'   => false,
								'options'    => array(
									'search'      => '<i class="fa fa-search"></i>',
									'plus'        => '<i class="fa fa-plus"></i>',
									'zoom'        => '<i class="fa fa-search-plus"></i>',
									'eye'         => '<i class="fa fa-eye"></i>',
									'info'        => '<i class="fa fa-info"></i>',
									'expand'      => '<i class="fa fa-expand"></i>',
									'arrow_alt'   => '<i class="fa fa-arrows-alt"></i>',
									'plus_square' => '<i class="fa fa-plus-square-o"></i>',
									'none'        => __( 'None', 'wp-carousel-pro' ),
								),
								'default'    => array( 'search' ),
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show|wpcp_post_detail_position', 'any|==|!=', 'image-carousel,video-carousel,mix-content,external-carousel|l_box|with_overlay', true ),
							),
							array(
								'id'         => 'l_box_icon_position',
								'type'       => 'image_select',
								'title'      => __( 'Icon Display Position', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Select an icon display position on image.', 'wp-carousel-pro' ),
								'class'      => 'wpcp_thumbnail_position',
								'options'    => array(
									'middle'       => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/lightbox-icon-middle.svg',
										'text'  => __( 'Middle', 'wp-carousel-pro' ),
									),
									'top_right'    => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/lightbox-icon-top-right.svg',
										'text'  => __( 'Top Right', 'wp-carousel-pro' ),
									),
									'top_left'     => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/lightbox-icon-top-left.svg',
										'text'  => __( 'Top Left', 'wp-carousel-pro' ),
									),
									'bottom_right' => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/lightbox-icon-bottom-right.svg',
										'text'  => __( 'Bottom Right', 'wp-carousel-pro' ),
									),
									'bottom_left'  => array(
										'image' => WPCAROUSEL_URL . 'Admin/img/lightbox-icon-bottom-left.svg',
										'text'  => __( 'Bottom Left', 'wp-carousel-pro' ),
									),
								),
								'default'    => array( 'middle' ),
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show|l_box_icon_style|wpcp_post_detail_position', 'any|==|!=|!=', 'image-carousel,video-carousel,mix-content,external-carousel|l_box|none|with_overlay', true ),
							),
							array(
								'id'         => 'l_box_icon_size',
								'class'      => 'border_radius_around',
								'type'       => 'spinner',
								'title'      => __( 'Icon Size', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set icon size for image.', 'wp-carousel-pro' ),
								'default'    => 16,
								'unit'       => 'px',
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show|l_box_icon_style|wpcp_post_detail_position', 'any|==|!=|!=', 'image-carousel,video-carousel,mix-content,external-carousel|l_box|none|with_overlay', true ),
							),
							array(
								'id'         => 'l_box_icon_color',
								'type'       => 'color_group',
								'title'      => __( 'Icon Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set color for the lightbox icon.', 'wp-carousel-pro' ),
								'options'    => array(
									'color1' => __( 'Color', 'wp-carousel-pro' ),
									'color2' => __( 'Hover Color', 'wp-carousel-pro' ),
									'color3' => __( 'Background', 'wp-carousel-pro' ),
									'color4' => __( 'Hover Background', 'wp-carousel-pro' ),
								),
								'default'    => array(
									'color1' => '#fff',
									'color2' => '#fff',
									'color3' => 'rgba(0, 0, 0, 0.5)',
									'color4' => 'rgba(0, 0, 0, 0.8)',
								),
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show|l_box_icon_style|wpcp_post_detail_position', 'any|==|!=|!=', 'image-carousel,video-carousel,mix-content,external-carousel|l_box|none|with_overlay', true ),
							),
							array(
								'type'       => 'subheading',
								'content'    => __( 'Animation', 'wp-carousel-pro' ),
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'l_box_sliding_effect',
								'type'       => 'select',
								'title'      => __( 'Transition Effect Between Slides', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Select a transition effect between slides for lightbox image.', 'wp-carousel-pro' ),
								'multiple'   => false,
								'options'    => array(
									'fade'        => __( 'Fade', 'wp-carousel-pro' ),
									'slide'       => __( 'Slide', 'wp-carousel-pro' ),
									'circular'    => __( 'Circular', 'wp-carousel-pro' ),
									'tube'        => __( 'Tube', 'wp-carousel-pro' ),
									'zoom-in-out' => __( 'Zoom-in-out', 'wp-carousel-pro' ),
									'rotate'      => __( 'Rotate', 'wp-carousel-pro' ),
									'none'        => __( 'None', 'wp-carousel-pro' ),
								),
								'default'    => array( 'fade' ),
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'l_box_open_close_effect',
								'type'       => 'select',
								'title'      => __( 'Open/Close Animation Type', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Select an animation type for opening/closing lightbox image.', 'wp-carousel-pro' ),
								'multiple'   => false,
								'options'    => array(
									'zoom'        => __( 'Zoom', 'wp-carousel-pro' ),
									'fade'        => __( 'Fade', 'wp-carousel-pro' ),
									'slide'       => __( 'Slide', 'wp-carousel-pro' ),
									'circular'    => __( 'Circular', 'wp-carousel-pro' ),
									'tube'        => __( 'Tube', 'wp-carousel-pro' ),
									'zoom-in-out' => __( 'Zoom-in-out', 'wp-carousel-pro' ),
									'rotate'      => __( 'Rotate', 'wp-carousel-pro' ),
									'none'        => __( 'None', 'wp-carousel-pro' ),
								),
								'default'    => array( 'zoom' ),
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
						),
					),

					// array(
					// 'title'  => __( 'Lightbox Icons', 'wp-carousel-pro' ),
					// 'icon'   => 'wpcp-icon-lightbox-icon',
					// 'fields' => array(
					// ),
					// ),
					array(
						'title'  => __( 'Image & Thumbnails', 'wp-carousel-pro' ),
						'icon'   => 'wpcp-icon-image-and-thumbnail',
						'fields' => array(
							array(
								'id'         => 'l_box_icon_overlay_color',
								'type'       => 'color',
								'title'      => __( 'Image Icon Overlay Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Set icon overlay color for image.', 'wp-carousel-pro' ),
								'title_help' => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/image-icon-overlay-color.svg" alt="Image Icon Overlay Color"></div><div class="sp_wpcp-info-label">' . __( 'Image Icon Overlay Color', 'wp-carousel-pro' ) . '</div>',
								'default'    => 'rgba(0,0,0,0.5)',
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show|l_box_icon_style|wpcp_post_detail_position', 'any|==|!=|!=', 'image-carousel,video-carousel,mix-content,external-carousel|l_box|none|with_overlay', true ),
							),
							array(
								'id'         => 'wpcp_l_box_image_caption',
								'type'       => 'switcher',
								'title'      => __( 'Image Caption', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide image caption for lightbox.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'wpcp_lb_caption_color',
								'type'       => 'color',
								'title'      => __( 'Caption Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Change the color for lightbox image caption.', 'wp-carousel-pro' ),
								'default'    => '#ffffff',
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show|wpcp_l_box_image_caption', 'any|==|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box|true', true ),
							),
							array(
								'id'         => 'l_box_desc',
								'type'       => 'switcher',
								'title'      => __( 'Image Description', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide image description for lightbox.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'l_box_desc_color',
								'type'       => 'color',
								'title'      => __( 'Description Color', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Change the color for lightbox image description.', 'wp-carousel-pro' ),
								'default'    => '#ffffff',
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show|l_box_desc', 'any|==|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box|true', true ),
							),
							array(
								'id'         => 'wpcp_image_counter',
								'type'       => 'switcher',
								'title'      => __( 'Image Counter', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide image counter for lightbox.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'l_box_hover_img_on_mobile',
								'type'       => 'checkbox',
								'title'      => __( 'Disable Image Hover Overlay on the Mobile Devices', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Check to disable image hover overlay on the mobile devices.', 'wp-carousel-pro' ),
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show|l_box_icon_style|wpcp_post_detail_position', 'any|==|!=|!=', 'image-carousel,video-carousel,mix-content,external-carousel|l_box|none|with_overlay', true ),
							),
							array(
								'id'         => 'l_box_thumb_visibility',
								'type'       => 'switcher',
								'title'      => __( 'Bottom Thumbnails Gallery Visibility', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide bottom thumbnails gallery visibility for lightbox.', 'wp-carousel-pro' ),
								'title_help' => '<div class="sp_wpcp-img-tag"><img src="' . WPCAROUSEL_URL . 'Admin/img/help-visuals/lightbox-thumbnail.svg" alt="Lightbox Bottom Thumbnails Gallery"></div><div class="sp_wpcp-info-label">' . __( 'Lightbox Bottom Thumbnails Gallery', 'wp-carousel-pro' ) . '</div>',
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'l_box_img_sharper_on_retina',
								'type'       => 'switcher',
								'title'      => __( 'Sharper Image in Retina Display', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Enable/Disable sharper image in retina display for lightbox image.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 94,
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'l_box_protect_image',
								'type'       => 'switcher',
								'title'      => __( 'Protect Images', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Protect an image downloading from right-click.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Enabled', 'wp-carousel-pro' ),
								'text_off'   => __( 'Disabled', 'wp-carousel-pro' ),
								'text_width' => 95,
								'default'    => false,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
						),
					),
					array(
						'title'  => __( 'Toolbar', 'wp-carousel-pro' ),
						'icon'   => 'wpcp-icon-lightbox-toolbar',
						'fields' => array(
							array(
								'id'         => 'l_box_zoom_button',
								'type'       => 'switcher',
								'title'      => __( 'Zoom Button', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide zoom button for lightbox image.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'l_box_full_screen_button',
								'type'       => 'switcher',
								'title'      => __( 'Full-Screen Button', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide full-screen button for lightbox.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'l_box_slideshow_button',
								'type'       => 'switcher',
								'title'      => __( 'Slideshow Play Button', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide slideshow play button for lightbox.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'l_box_social_button',
								'type'       => 'switcher',
								'title'      => __( 'Social Share Button', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide social share button for lightbox.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'l_box_download_button',
								'type'       => 'switcher',
								'title'      => __( 'Download Button', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide download button for lightbox.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'l_box_close_button',
								'type'       => 'switcher',
								'title'      => __( 'Close Button', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide close bottom for lightbox.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
							array(
								'id'         => 'wpcp_thumbnails_gallery',
								'type'       => 'switcher',
								'title'      => __( 'Lightbox Bottom Thumbnails Gallery Icon', 'wp-carousel-pro' ),
								'subtitle'   => __( 'Show/Hide bottom thumbnails gallery icon for lightbox.', 'wp-carousel-pro' ),
								'text_on'    => __( 'Show', 'wp-carousel-pro' ),
								'text_off'   => __( 'Hide', 'wp-carousel-pro' ),
								'text_width' => 77,
								'default'    => true,
								'dependency' => array( 'wpcp_carousel_type|wpcp_logo_link_show', 'any|==', 'image-carousel,video-carousel,mix-content,external-carousel|l_box', true ),
							),
						),
					),
				),
			),
		), // End of fields array.
	)
); // Style settings section end.
