<?php
/**
 * The Responsive style file for the WP Carousel pro.
 *
 * @package WP Carousel Pro
 */

// Responsive style.
$wpcp_screen_sizes = wpcp_get_option( 'wpcp_responsive_screen_setting' );
$desktop_size      = isset( $wpcp_screen_sizes['desktop'] ) && ! empty( $wpcp_screen_sizes['desktop'] ) ? $wpcp_screen_sizes['desktop'] : '1200';
$laptop_size       = isset( $wpcp_screen_sizes['laptop'] ) && ! empty( $wpcp_screen_sizes['laptop'] ) ? $wpcp_screen_sizes['laptop'] : '980';
$tablet_size       = isset( $wpcp_screen_sizes['tablet'] ) && ! empty( $wpcp_screen_sizes['tablet'] ) ? $wpcp_screen_sizes['tablet'] : '736';
$mobile_size       = isset( $wpcp_screen_sizes['mobile'] ) && ! empty( $wpcp_screen_sizes['mobile'] ) ? $wpcp_screen_sizes['mobile'] : '480';

$dynamic_css .= '
	.wpcpro-wrapper .wpcp-carousel-section.detail-on-right .wpcp-single-item,
	.wpcpro-wrapper .wpcp-carousel-section.detail-on-left .wpcp-single-item {
		flex-direction: column;
	}
';

$dynamic_css .= '@media (min-width: ' . $mobile_size . 'px) {
	.wpcpro-row .wpcpro-col-sm-1 {
		flex: 0 0 100%;
		max-width: 100%;
	}
	.wpcpro-row .wpcpro-col-sm-2 {
		flex: 0 0 50%;
		max-width: 50%;
	}
	.wpcpro-row .wpcpro-col-sm-2-5 {
		flex: 0 0 75%;
		max-width: 75%;
	}
	.wpcpro-row .wpcpro-col-sm-3 {
		flex: 0 0 33.333%;
		max-width: 33.333%;
	}
	.wpcpro-row .wpcpro-col-sm-4 {
		flex: 0 0 25%;
		max-width: 25%;
	}
	.wpcpro-row .wpcpro-col-sm-5 {
		flex: 0 0 20%;
		max-width: 20%;
	}
	.wpcpro-row .wpcpro-col-sm-6 {
		flex: 0 0 16.66666666666667%;
		max-width: 16.66666666666667%;
	}
	.wpcpro-row .wpcpro-col-sm-7 {
		flex: 0 0 14.28571428%;
		max-width: 14.28571428%;
	}
	.wpcpro-row .wpcpro-col-sm-8 {
		flex: 0 0 12.5%;
		max-width: 12.5%;
	}
	.wpcpro-wrapper .wpcp-carousel-section.detail-on-right .wpcp-single-item {
		flex-direction: row;
	}
	.wpcpro-wrapper .wpcp-carousel-section.detail-on-left .wpcp-single-item {
		flex-direction: row-reverse;
	}
}
@media (max-width: ' . $mobile_size . 'px) {
	.wpcpro-row .wpcpro-col-xs-1 {
		flex: 0 0 100%;
		max-width: 100%;
	}
	.wpcpro-row .wpcpro-col-xs-2 {
		flex: 0 0 50%;
		max-width: 50%;
	}
	.wpcpro-row .wpcpro-col-xs-3 {
		flex: 0 0 33.222%;
		max-width: 33.222%;
	}
	.wpcpro-row .wpcpro-col-xs-4 {
		flex: 0 0 25%;
		max-width: 25%;
	}
	.wpcpro-row .wpcpro-col-xs-5 {
		flex: 0 0 20%;
		max-width: 20%;
	}
	.wpcpro-row .wpcpro-col-xs-6 {
		flex: 0 0 16.6667%;
		max-width: 16.6667%;
	}
	.wpcpro-row .wpcpro-col-xs-7 {
		flex: 0 0 14.28571428%;
		max-width: 14.28571428%;
	}
	.wpcpro-row .wpcpro-col-xs-8 {
		flex: 0 0 12.5%;
		max-width: 12.5%;
	}
}
@media (min-width: ' . $tablet_size . 'px) {
	.wpcpro-row .wpcpro-col-md-1 {
		flex: 0 0 100%;
		max-width: 100%;
	}
	.wpcpro-row .wpcpro-col-md-2 {
		flex: 0 0 50%;
		max-width: 50%;
	}
	.wpcpro-row .wpcpro-col-md-2-5 {
		flex: 0 0 75%;
		max-width: 75%;
	}
	.wpcpro-row .wpcpro-col-md-3 {
		flex: 0 0 33.333%;
		max-width: 33.333%;
	}
	.wpcpro-row .wpcpro-col-md-4 {
		flex: 0 0 25%;
		max-width: 25%;
	}
	.wpcpro-row .wpcpro-col-md-5 {
		flex: 0 0 20%;
		max-width: 20%;
	}
	.wpcpro-row .wpcpro-col-md-6 {
		flex: 0 0 16.66666666666667%;
		max-width: 16.66666666666667%;
	}
	.wpcpro-row .wpcpro-col-md-7 {
		flex: 0 0 14.28571428%;
		max-width: 14.28571428%;
	}
	.wpcpro-row .wpcpro-col-md-8 {
		flex: 0 0 12.5%;
		max-width: 12.5%;
	}
}
@media (min-width: ' . $laptop_size . 'px) {
	.wpcpro-row .wpcpro-col-lg-1 {
		flex: 0 0 100%;
		max-width: 100%;
	}
	.wpcpro-row .wpcpro-col-lg-2 {
		flex: 0 0 50%;
		max-width: 50%;
	}
	.wpcpro-row .wpcpro-col-lg-3 {
		flex: 0 0 33.222%;
		max-width: 33.222%;
	}
	.wpcpro-row .wpcpro-col-lg-4 {
		flex: 0 0 25%;
		max-width: 25%;
	}
	.wpcpro-row .wpcpro-col-lg-5 {
		flex: 0 0 20%;
		max-width: 20%;
	}
	.wpcpro-row .wpcpro-col-lg-6 {
		flex: 0 0 16.6667%;
		max-width: 16.6667%;
	}
	.wpcpro-row .wpcpro-col-lg-7 {
		flex: 0 0 14.28571428%;
		max-width: 14.28571428%;
	}
	.wpcpro-row .wpcpro-col-lg-8 {
		flex: 0 0 12.5%;
		max-width: 12.5%;
	}
}
@media (min-width: ' . $desktop_size . 'px) {
	.wpcpro-row .wpcpro-col-xl-1 {
		flex: 0 0 100%;
		max-width: 100%;
	}
	.wpcpro-row .wpcpro-col-xl-2 {
		flex: 0 0 50%;
		max-width: 50%;
	}
	.wpcpro-row .wpcpro-col-xl-3 {
		flex: 0 0 33.22222222%;
		max-width: 33.22222222%;
	}
	.wpcpro-row .wpcpro-col-xl-4 {
		flex: 0 0 25%;
		max-width: 25%;
	}
	.wpcpro-row .wpcpro-col-xl-5 {
		flex: 0 0 20%;
		max-width: 20%;
	}
	.wpcpro-row .wpcpro-col-xl-6 {
		flex: 0 0 16.66667%;
		max-width: 16.66667%;
	}
	.wpcpro-row .wpcpro-col-xl-7 {
		flex: 0 0 14.28571428%;
		max-width: 14.28571428%;
	}
	.wpcpro-row .wpcpro-col-xl-8 {
		flex: 0 0 12.5%;
		max-width: 12.5%;
	}
}';
