!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?module.exports=factory():"function"==typeof define&&define.amd?define(factory):(global="undefined"!=typeof globalThis?globalThis:global||self).WPCPSwiperGL=factory()}(this,(function(){"use strict";function length(a){let x=a[0],y=a[1],z=a[2];return Math.sqrt(x*x+y*y+z*z)}function copy$4(out,a){return out[0]=a[0],out[1]=a[1],out[2]=a[2],out}function set$4(out,x,y,z){return out[0]=x,out[1]=y,out[2]=z,out}function add(out,a,b){return out[0]=a[0]+b[0],out[1]=a[1]+b[1],out[2]=a[2]+b[2],out}function subtract(out,a,b){return out[0]=a[0]-b[0],out[1]=a[1]-b[1],out[2]=a[2]-b[2],out}function multiply$3(out,a,b){return out[0]=a[0]*b[0],out[1]=a[1]*b[1],out[2]=a[2]*b[2],out}function divide(out,a,b){return out[0]=a[0]/b[0],out[1]=a[1]/b[1],out[2]=a[2]/b[2],out}function scale$3(out,a,b){return out[0]=a[0]*b,out[1]=a[1]*b,out[2]=a[2]*b,out}function distance(a,b){let x=b[0]-a[0],y=b[1]-a[1],z=b[2]-a[2];return Math.sqrt(x*x+y*y+z*z)}function squaredDistance(a,b){let x=b[0]-a[0],y=b[1]-a[1],z=b[2]-a[2];return x*x+y*y+z*z}function squaredLength(a){let x=a[0],y=a[1],z=a[2];return x*x+y*y+z*z}function negate(out,a){return out[0]=-a[0],out[1]=-a[1],out[2]=-a[2],out}function inverse(out,a){return out[0]=1/a[0],out[1]=1/a[1],out[2]=1/a[2],out}function normalize$2(out,a){let x=a[0],y=a[1],z=a[2],len=x*x+y*y+z*z;return len>0&&(len=1/Math.sqrt(len)),out[0]=a[0]*len,out[1]=a[1]*len,out[2]=a[2]*len,out}function dot$2(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]}function cross(out,a,b){let ax=a[0],ay=a[1],az=a[2],bx=b[0],by=b[1],bz=b[2];return out[0]=ay*bz-az*by,out[1]=az*bx-ax*bz,out[2]=ax*by-ay*bx,out}function lerp(out,a,b,t){let ax=a[0],ay=a[1],az=a[2];return out[0]=ax+t*(b[0]-ax),out[1]=ay+t*(b[1]-ay),out[2]=az+t*(b[2]-az),out}function transformMat4(out,a,m){let x=a[0],y=a[1],z=a[2],w=m[3]*x+m[7]*y+m[11]*z+m[15];return w=w||1,out[0]=(m[0]*x+m[4]*y+m[8]*z+m[12])/w,out[1]=(m[1]*x+m[5]*y+m[9]*z+m[13])/w,out[2]=(m[2]*x+m[6]*y+m[10]*z+m[14])/w,out}function scaleRotateMat4(out,a,m){let x=a[0],y=a[1],z=a[2],w=m[3]*x+m[7]*y+m[11]*z+m[15];return w=w||1,out[0]=(m[0]*x+m[4]*y+m[8]*z)/w,out[1]=(m[1]*x+m[5]*y+m[9]*z)/w,out[2]=(m[2]*x+m[6]*y+m[10]*z)/w,out}function transformMat3(out,a,m){let x=a[0],y=a[1],z=a[2];return out[0]=x*m[0]+y*m[3]+z*m[6],out[1]=x*m[1]+y*m[4]+z*m[7],out[2]=x*m[2]+y*m[5]+z*m[8],out}function transformQuat(out,a,q){let x=a[0],y=a[1],z=a[2],qx=q[0],qy=q[1],qz=q[2],qw,uvx=qy*z-qz*y,uvy=qz*x-qx*z,uvz=qx*y-qy*x,uuvx=qy*uvz-qz*uvy,uuvy=qz*uvx-qx*uvz,uuvz=qx*uvy-qy*uvx,w2=2*q[3];return uvx*=w2,uvy*=w2,uvz*=w2,uuvx*=2,uuvy*=2,uuvz*=2,out[0]=x+uvx+uuvx,out[1]=y+uvy+uuvy,out[2]=z+uvz+uuvz,out}const angle=function(){const tempA=[0,0,0],tempB=[0,0,0];return function(a,b){copy$4(tempA,a),copy$4(tempB,b),normalize$2(tempA,tempA),normalize$2(tempB,tempB);let cosine=dot$2(tempA,tempB);return cosine>1?0:cosine<-1?Math.PI:Math.acos(cosine)}}();function exactEquals(a,b){return a[0]===b[0]&&a[1]===b[1]&&a[2]===b[2]}class Vec3 extends Array{constructor(x=0,y=x,z=x){return super(x,y,z),this}get x(){return this[0]}get y(){return this[1]}get z(){return this[2]}set x(v){this[0]=v}set y(v){this[1]=v}set z(v){this[2]=v}set(x,y=x,z=x){return x.length?this.copy(x):(set$4(this,x,y,z),this)}copy(v){return copy$4(this,v),this}add(va,vb){return vb?add(this,va,vb):add(this,this,va),this}sub(va,vb){return vb?subtract(this,va,vb):subtract(this,this,va),this}multiply(v){return v.length?multiply$3(this,this,v):scale$3(this,this,v),this}divide(v){return v.length?divide(this,this,v):scale$3(this,this,1/v),this}inverse(v=this){return inverse(this,v),this}len(){return length(this)}distance(v){return v?distance(this,v):length(this)}squaredLen(){return squaredLength(this)}squaredDistance(v){return v?squaredDistance(this,v):squaredLength(this)}negate(v=this){return negate(this,v),this}cross(va,vb){return vb?cross(this,va,vb):cross(this,this,va),this}scale(v){return scale$3(this,this,v),this}normalize(){return normalize$2(this,this),this}dot(v){return dot$2(this,v)}equals(v){return exactEquals(this,v)}applyMatrix3(mat3){return transformMat3(this,this,mat3),this}applyMatrix4(mat4){return transformMat4(this,this,mat4),this}scaleRotateMatrix4(mat4){return scaleRotateMat4(this,this,mat4),this}applyQuaternion(q){return transformQuat(this,this,q),this}angle(v){return angle(this,v)}lerp(v,t){return lerp(this,this,v,t),this}clone(){return new Vec3(this[0],this[1],this[2])}fromArray(a,o=0){return this[0]=a[o],this[1]=a[o+1],this[2]=a[o+2],this}toArray(a=[],o=0){return a[o]=this[0],a[o+1]=this[1],a[o+2]=this[2],a}transformDirection(mat4){const x=this[0],y=this[1],z=this[2];return this[0]=mat4[0]*x+mat4[4]*y+mat4[8]*z,this[1]=mat4[1]*x+mat4[5]*y+mat4[9]*z,this[2]=mat4[2]*x+mat4[6]*y+mat4[10]*z,this.normalize()}}const tempVec3$1=new Vec3;let ID$4=1,ATTR_ID=1,isBoundsWarned=!1;class Geometry{constructor(gl,attributes={}){gl.canvas||console.error("gl not passed as first argument to Geometry"),this.gl=gl,this.attributes=attributes,this.id=ID$4++,this.VAOs={},this.drawRange={start:0,count:0},this.instancedCount=0,this.gl.renderer.bindVertexArray(null),this.gl.renderer.currentGeometry=null,this.glState=this.gl.renderer.state;for(let key in attributes)this.addAttribute(key,attributes[key])}addAttribute(key,attr){if(this.attributes[key]=attr,attr.id=ATTR_ID++,attr.size=attr.size||1,attr.type=attr.type||(attr.data.constructor===Float32Array?this.gl.FLOAT:attr.data.constructor===Uint16Array?this.gl.UNSIGNED_SHORT:this.gl.UNSIGNED_INT),attr.target="index"===key?this.gl.ELEMENT_ARRAY_BUFFER:this.gl.ARRAY_BUFFER,attr.normalized=attr.normalized||!1,attr.stride=attr.stride||0,attr.offset=attr.offset||0,attr.count=attr.count||(attr.stride?attr.data.byteLength/attr.stride:attr.data.length/attr.size),attr.divisor=attr.instanced||0,attr.needsUpdate=!1,attr.usage=attr.usage||this.gl.STATIC_DRAW,attr.buffer||this.updateAttribute(attr),attr.divisor){if(this.isInstanced=!0,this.instancedCount&&this.instancedCount!==attr.count*attr.divisor)return console.warn("geometry has multiple instanced buffers of different length"),this.instancedCount=Math.min(this.instancedCount,attr.count*attr.divisor);this.instancedCount=attr.count*attr.divisor}else"index"===key?this.drawRange.count=attr.count:this.attributes.index||(this.drawRange.count=Math.max(this.drawRange.count,attr.count))}updateAttribute(attr){const isNewBuffer=!attr.buffer;isNewBuffer&&(attr.buffer=this.gl.createBuffer()),this.glState.boundBuffer!==attr.buffer&&(this.gl.bindBuffer(attr.target,attr.buffer),this.glState.boundBuffer=attr.buffer),isNewBuffer?this.gl.bufferData(attr.target,attr.data,attr.usage):this.gl.bufferSubData(attr.target,0,attr.data),attr.needsUpdate=!1}setIndex(value){this.addAttribute("index",value)}setDrawRange(start,count){this.drawRange.start=start,this.drawRange.count=count}setInstancedCount(value){this.instancedCount=value}createVAO(program){this.VAOs[program.attributeOrder]=this.gl.renderer.createVertexArray(),this.gl.renderer.bindVertexArray(this.VAOs[program.attributeOrder]),this.bindAttributes(program)}bindAttributes(program){program.attributeLocations.forEach((location,{name:name,type:type})=>{if(!this.attributes[name])return void console.warn(`active attribute ${name} not being supplied`);const attr=this.attributes[name];this.gl.bindBuffer(attr.target,attr.buffer),this.glState.boundBuffer=attr.buffer;let numLoc=1;35674===type&&(numLoc=2),35675===type&&(numLoc=3),35676===type&&(numLoc=4);const size=attr.size/numLoc,stride=1===numLoc?0:numLoc*numLoc*numLoc,offset=1===numLoc?0:numLoc*numLoc;for(let i=0;i<numLoc;i++)this.gl.vertexAttribPointer(location+i,size,attr.type,attr.normalized,attr.stride+stride,attr.offset+i*offset),this.gl.enableVertexAttribArray(location+i),this.gl.renderer.vertexAttribDivisor(location+i,attr.divisor)}),this.attributes.index&&this.gl.bindBuffer(this.gl.ELEMENT_ARRAY_BUFFER,this.attributes.index.buffer)}draw({program:program,mode:mode=this.gl.TRIANGLES}){this.gl.renderer.currentGeometry!==`${this.id}_${program.attributeOrder}`&&(this.VAOs[program.attributeOrder]||this.createVAO(program),this.gl.renderer.bindVertexArray(this.VAOs[program.attributeOrder]),this.gl.renderer.currentGeometry=`${this.id}_${program.attributeOrder}`),program.attributeLocations.forEach((location,{name:name})=>{const attr=this.attributes[name];attr.needsUpdate&&this.updateAttribute(attr)}),this.isInstanced?this.attributes.index?this.gl.renderer.drawElementsInstanced(mode,this.drawRange.count,this.attributes.index.type,this.attributes.index.offset+2*this.drawRange.start,this.instancedCount):this.gl.renderer.drawArraysInstanced(mode,this.drawRange.start,this.drawRange.count,this.instancedCount):this.attributes.index?this.gl.drawElements(mode,this.drawRange.count,this.attributes.index.type,this.attributes.index.offset+2*this.drawRange.start):this.gl.drawArrays(mode,this.drawRange.start,this.drawRange.count)}getPosition(){const attr=this.attributes.position;return attr.data?attr:isBoundsWarned?void 0:(console.warn("No position buffer data found to compute bounds"),isBoundsWarned=!0)}computeBoundingBox(attr){attr||(attr=this.getPosition());const array=attr.data,stride=attr.stride?attr.stride/array.BYTES_PER_ELEMENT:attr.size;this.bounds||(this.bounds={min:new Vec3,max:new Vec3,center:new Vec3,scale:new Vec3,radius:1/0});const min=this.bounds.min,max=this.bounds.max,center=this.bounds.center,scale=this.bounds.scale;min.set(1/0),max.set(-1/0);for(let i=0,l=array.length;i<l;i+=stride){const x=array[i],y=array[i+1],z=array[i+2];min.x=Math.min(x,min.x),min.y=Math.min(y,min.y),min.z=Math.min(z,min.z),max.x=Math.max(x,max.x),max.y=Math.max(y,max.y),max.z=Math.max(z,max.z)}scale.sub(max,min),center.add(min,max).divide(2)}computeBoundingSphere(attr){attr||(attr=this.getPosition());const array=attr.data,stride=attr.stride?attr.stride/array.BYTES_PER_ELEMENT:attr.size;this.bounds||this.computeBoundingBox(attr);let maxRadiusSq=0;for(let i=0,l=array.length;i<l;i+=stride)tempVec3$1.fromArray(array,i),maxRadiusSq=Math.max(maxRadiusSq,this.bounds.center.squaredDistance(tempVec3$1));this.bounds.radius=Math.sqrt(maxRadiusSq)}remove(){for(let key in this.VAOs)this.gl.renderer.deleteVertexArray(this.VAOs[key]),delete this.VAOs[key];for(let key in this.attributes)this.gl.deleteBuffer(this.attributes[key].buffer),delete this.attributes[key]}}let ID$3=1;const arrayCacheF32={};class Program{constructor(gl,{vertex:vertex,fragment:fragment,uniforms:uniforms={},transparent:transparent=!1,cullFace:cullFace=gl.BACK,frontFace:frontFace=gl.CCW,depthTest:depthTest=!0,depthWrite:depthWrite=!0,depthFunc:depthFunc=gl.LESS}={}){gl.canvas||console.error("gl not passed as fist argument to Program"),this.gl=gl,this.uniforms=uniforms,this.id=ID$3++,vertex||console.warn("vertex shader not supplied"),fragment||console.warn("fragment shader not supplied"),this.transparent=transparent,this.cullFace=cullFace,this.frontFace=frontFace,this.depthTest=depthTest,this.depthWrite=depthWrite,this.depthFunc=depthFunc,this.blendFunc={},this.blendEquation={},this.transparent&&!this.blendFunc.src&&(this.gl.renderer.premultipliedAlpha?this.setBlendFunc(this.gl.ONE,this.gl.ONE_MINUS_SRC_ALPHA):this.setBlendFunc(this.gl.SRC_ALPHA,this.gl.ONE_MINUS_SRC_ALPHA));const vertexShader=gl.createShader(gl.VERTEX_SHADER);gl.shaderSource(vertexShader,vertex),gl.compileShader(vertexShader),""!==gl.getShaderInfoLog(vertexShader)&&console.warn(`${gl.getShaderInfoLog(vertexShader)}\nVertex Shader\n${addLineNumbers(vertex)}`);const fragmentShader=gl.createShader(gl.FRAGMENT_SHADER);if(gl.shaderSource(fragmentShader,fragment),gl.compileShader(fragmentShader),""!==gl.getShaderInfoLog(fragmentShader)&&console.warn(`${gl.getShaderInfoLog(fragmentShader)}\nFragment Shader\n${addLineNumbers(fragment)}`),this.program=gl.createProgram(),gl.attachShader(this.program,vertexShader),gl.attachShader(this.program,fragmentShader),gl.linkProgram(this.program),!gl.getProgramParameter(this.program,gl.LINK_STATUS))return console.warn(gl.getProgramInfoLog(this.program));gl.deleteShader(vertexShader),gl.deleteShader(fragmentShader),this.uniformLocations=new Map;let numUniforms=gl.getProgramParameter(this.program,gl.ACTIVE_UNIFORMS);for(let uIndex=0;uIndex<numUniforms;uIndex++){let uniform=gl.getActiveUniform(this.program,uIndex);this.uniformLocations.set(uniform,gl.getUniformLocation(this.program,uniform.name));const split=uniform.name.match(/(\w+)/g);uniform.uniformName=split[0],3===split.length?(uniform.isStructArray=!0,uniform.structIndex=Number(split[1]),uniform.structProperty=split[2]):2===split.length&&isNaN(Number(split[1]))&&(uniform.isStruct=!0,uniform.structProperty=split[1])}this.attributeLocations=new Map;const locations=[],numAttribs=gl.getProgramParameter(this.program,gl.ACTIVE_ATTRIBUTES);for(let aIndex=0;aIndex<numAttribs;aIndex++){const attribute=gl.getActiveAttrib(this.program,aIndex),location=gl.getAttribLocation(this.program,attribute.name);-1!==location&&(locations[location]=attribute.name,this.attributeLocations.set(attribute,location))}this.attributeOrder=locations.join("")}setBlendFunc(src,dst,srcAlpha,dstAlpha){this.blendFunc.src=src,this.blendFunc.dst=dst,this.blendFunc.srcAlpha=srcAlpha,this.blendFunc.dstAlpha=dstAlpha,src&&(this.transparent=!0)}setBlendEquation(modeRGB,modeAlpha){this.blendEquation.modeRGB=modeRGB,this.blendEquation.modeAlpha=modeAlpha}applyState(){this.depthTest?this.gl.renderer.enable(this.gl.DEPTH_TEST):this.gl.renderer.disable(this.gl.DEPTH_TEST),this.cullFace?this.gl.renderer.enable(this.gl.CULL_FACE):this.gl.renderer.disable(this.gl.CULL_FACE),this.blendFunc.src?this.gl.renderer.enable(this.gl.BLEND):this.gl.renderer.disable(this.gl.BLEND),this.cullFace&&this.gl.renderer.setCullFace(this.cullFace),this.gl.renderer.setFrontFace(this.frontFace),this.gl.renderer.setDepthMask(this.depthWrite),this.gl.renderer.setDepthFunc(this.depthFunc),this.blendFunc.src&&this.gl.renderer.setBlendFunc(this.blendFunc.src,this.blendFunc.dst,this.blendFunc.srcAlpha,this.blendFunc.dstAlpha),this.gl.renderer.setBlendEquation(this.blendEquation.modeRGB,this.blendEquation.modeAlpha)}use({flipFaces:flipFaces=!1}={}){let textureUnit=-1;const programActive=this.gl.renderer.state.currentProgram===this.id;programActive||(this.gl.useProgram(this.program),this.gl.renderer.state.currentProgram=this.id),this.uniformLocations.forEach((location,activeUniform)=>{let name=activeUniform.uniformName,uniform=this.uniforms[name];if(activeUniform.isStruct&&(uniform=uniform[activeUniform.structProperty],name+=`.${activeUniform.structProperty}`),activeUniform.isStructArray&&(uniform=uniform[activeUniform.structIndex][activeUniform.structProperty],name+=`[${activeUniform.structIndex}].${activeUniform.structProperty}`),!uniform)return warn(`Active uniform ${name} has not been supplied`);if(uniform&&void 0===uniform.value)return warn(`${name} uniform is missing a value parameter`);if(uniform.value.texture)return textureUnit+=1,uniform.value.update(textureUnit),setUniform(this.gl,activeUniform.type,location,textureUnit);if(uniform.value.length&&uniform.value[0].texture){const textureUnits=[];return uniform.value.forEach(value=>{textureUnit+=1,value.update(textureUnit),textureUnits.push(textureUnit)}),setUniform(this.gl,activeUniform.type,location,textureUnits)}setUniform(this.gl,activeUniform.type,location,uniform.value)}),this.applyState(),flipFaces&&this.gl.renderer.setFrontFace(this.frontFace===this.gl.CCW?this.gl.CW:this.gl.CCW)}remove(){this.gl.deleteProgram(this.program)}}function setUniform(gl,type,location,value){value=value.length?flatten(value):value;const setValue=gl.renderer.state.uniformLocations.get(location);if(value.length)if(void 0===setValue||setValue.length!==value.length)gl.renderer.state.uniformLocations.set(location,value.slice(0));else{if(arraysEqual(setValue,value))return;setValue.set?setValue.set(value):setArray(setValue,value),gl.renderer.state.uniformLocations.set(location,setValue)}else{if(setValue===value)return;gl.renderer.state.uniformLocations.set(location,value)}switch(type){case 5126:return value.length?gl.uniform1fv(location,value):gl.uniform1f(location,value);case 35664:return gl.uniform2fv(location,value);case 35665:return gl.uniform3fv(location,value);case 35666:return gl.uniform4fv(location,value);case 35670:case 5124:case 35678:case 35680:return value.length?gl.uniform1iv(location,value):gl.uniform1i(location,value);case 35671:case 35667:return gl.uniform2iv(location,value);case 35672:case 35668:return gl.uniform3iv(location,value);case 35673:case 35669:return gl.uniform4iv(location,value);case 35674:return gl.uniformMatrix2fv(location,!1,value);case 35675:return gl.uniformMatrix3fv(location,!1,value);case 35676:return gl.uniformMatrix4fv(location,!1,value)}}function addLineNumbers(string){let lines=string.split("\n");for(let i=0;i<lines.length;i++)lines[i]=i+1+": "+lines[i];return lines.join("\n")}function flatten(a){const arrayLen=a.length,valueLen=a[0].length;if(void 0===valueLen)return a;const length=arrayLen*valueLen;let value=arrayCacheF32[length];value||(arrayCacheF32[length]=value=new Float32Array(length));for(let i=0;i<arrayLen;i++)value.set(a[i],i*valueLen);return value}function arraysEqual(a,b){if(a.length!==b.length)return!1;for(let i=0,l=a.length;i<l;i++)if(a[i]!==b[i])return!1;return!0}function setArray(a,b){for(let i=0,l=a.length;i<l;i++)a[i]=b[i]}let warnCount=0;function warn(message){warnCount>100||(console.warn(message),warnCount++,warnCount>100&&console.warn("More than 100 program warnings - stopping logs."))}const tempVec3=new Vec3;let ID$2=1;class Renderer{constructor({canvas:canvas=document.createElement("canvas"),width:width=300,height:height=150,dpr:dpr=1,alpha:alpha=!1,depth:depth=!0,stencil:stencil=!1,antialias:antialias=!1,premultipliedAlpha:premultipliedAlpha=!1,preserveDrawingBuffer:preserveDrawingBuffer=!1,powerPreference:powerPreference="default",autoClear:autoClear=!0,webgl:webgl=2}={}){const attributes={alpha:alpha,depth:depth,stencil:stencil,antialias:antialias,premultipliedAlpha:premultipliedAlpha,preserveDrawingBuffer:preserveDrawingBuffer,powerPreference:powerPreference};this.dpr=dpr,this.alpha=alpha,this.color=!0,this.depth=depth,this.stencil=stencil,this.premultipliedAlpha=premultipliedAlpha,this.autoClear=autoClear,this.id=ID$2++,2===webgl&&(this.gl=canvas.getContext("webgl2",attributes)),this.isWebgl2=!!this.gl,this.gl||(this.gl=canvas.getContext("webgl",attributes)),this.gl||console.error("unable to create webgl context"),this.gl.renderer=this,this.setSize(width,height),this.state={},this.state.blendFunc={src:this.gl.ONE,dst:this.gl.ZERO},this.state.blendEquation={modeRGB:this.gl.FUNC_ADD},this.state.cullFace=null,this.state.frontFace=this.gl.CCW,this.state.depthMask=!0,this.state.depthFunc=this.gl.LESS,this.state.premultiplyAlpha=!1,this.state.flipY=!1,this.state.unpackAlignment=4,this.state.framebuffer=null,this.state.viewport={x:0,y:0,width:null,height:null},this.state.textureUnits=[],this.state.activeTextureUnit=0,this.state.boundBuffer=null,this.state.uniformLocations=new Map,this.state.currentProgram=null,this.extensions={},this.isWebgl2?(this.getExtension("EXT_color_buffer_float"),this.getExtension("OES_texture_float_linear")):(this.getExtension("OES_texture_float"),this.getExtension("OES_texture_float_linear"),this.getExtension("OES_texture_half_float"),this.getExtension("OES_texture_half_float_linear"),this.getExtension("OES_element_index_uint"),this.getExtension("OES_standard_derivatives"),this.getExtension("EXT_sRGB"),this.getExtension("WEBGL_depth_texture"),this.getExtension("WEBGL_draw_buffers")),this.getExtension("WEBGL_compressed_texture_astc"),this.getExtension("EXT_texture_compression_bptc"),this.getExtension("WEBGL_compressed_texture_s3tc"),this.getExtension("WEBGL_compressed_texture_etc1"),this.getExtension("WEBGL_compressed_texture_pvrtc"),this.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc"),this.vertexAttribDivisor=this.getExtension("ANGLE_instanced_arrays","vertexAttribDivisor","vertexAttribDivisorANGLE"),this.drawArraysInstanced=this.getExtension("ANGLE_instanced_arrays","drawArraysInstanced","drawArraysInstancedANGLE"),this.drawElementsInstanced=this.getExtension("ANGLE_instanced_arrays","drawElementsInstanced","drawElementsInstancedANGLE"),this.createVertexArray=this.getExtension("OES_vertex_array_object","createVertexArray","createVertexArrayOES"),this.bindVertexArray=this.getExtension("OES_vertex_array_object","bindVertexArray","bindVertexArrayOES"),this.deleteVertexArray=this.getExtension("OES_vertex_array_object","deleteVertexArray","deleteVertexArrayOES"),this.drawBuffers=this.getExtension("WEBGL_draw_buffers","drawBuffers","drawBuffersWEBGL"),this.parameters={},this.parameters.maxTextureUnits=this.gl.getParameter(this.gl.MAX_COMBINED_TEXTURE_IMAGE_UNITS),this.parameters.maxAnisotropy=this.getExtension("EXT_texture_filter_anisotropic")?this.gl.getParameter(this.getExtension("EXT_texture_filter_anisotropic").MAX_TEXTURE_MAX_ANISOTROPY_EXT):0}setSize(width,height){this.width=width,this.height=height,this.gl.canvas.width=width*this.dpr,this.gl.canvas.height=height*this.dpr,Object.assign(this.gl.canvas.style,{width:width+"px",height:height+"px"})}setViewport(width,height,x=0,y=0){this.state.viewport.width===width&&this.state.viewport.height===height||(this.state.viewport.width=width,this.state.viewport.height=height,this.state.viewport.x=x,this.state.viewport.y=y,this.gl.viewport(x,y,width,height))}setScissor(width,height,x=0,y=0){this.gl.scissor(x,y,width,height)}enable(id){!0!==this.state[id]&&(this.gl.enable(id),this.state[id]=!0)}disable(id){!1!==this.state[id]&&(this.gl.disable(id),this.state[id]=!1)}setBlendFunc(src,dst,srcAlpha,dstAlpha){this.state.blendFunc.src===src&&this.state.blendFunc.dst===dst&&this.state.blendFunc.srcAlpha===srcAlpha&&this.state.blendFunc.dstAlpha===dstAlpha||(this.state.blendFunc.src=src,this.state.blendFunc.dst=dst,this.state.blendFunc.srcAlpha=srcAlpha,this.state.blendFunc.dstAlpha=dstAlpha,void 0!==srcAlpha?this.gl.blendFuncSeparate(src,dst,srcAlpha,dstAlpha):this.gl.blendFunc(src,dst))}setBlendEquation(modeRGB,modeAlpha){modeRGB=modeRGB||this.gl.FUNC_ADD,this.state.blendEquation.modeRGB===modeRGB&&this.state.blendEquation.modeAlpha===modeAlpha||(this.state.blendEquation.modeRGB=modeRGB,this.state.blendEquation.modeAlpha=modeAlpha,void 0!==modeAlpha?this.gl.blendEquationSeparate(modeRGB,modeAlpha):this.gl.blendEquation(modeRGB))}setCullFace(value){this.state.cullFace!==value&&(this.state.cullFace=value,this.gl.cullFace(value))}setFrontFace(value){this.state.frontFace!==value&&(this.state.frontFace=value,this.gl.frontFace(value))}setDepthMask(value){this.state.depthMask!==value&&(this.state.depthMask=value,this.gl.depthMask(value))}setDepthFunc(value){this.state.depthFunc!==value&&(this.state.depthFunc=value,this.gl.depthFunc(value))}activeTexture(value){this.state.activeTextureUnit!==value&&(this.state.activeTextureUnit=value,this.gl.activeTexture(this.gl.TEXTURE0+value))}bindFramebuffer({target:target=this.gl.FRAMEBUFFER,buffer:buffer=null}={}){this.state.framebuffer!==buffer&&(this.state.framebuffer=buffer,this.gl.bindFramebuffer(target,buffer))}getExtension(extension,webgl2Func,extFunc){return webgl2Func&&this.gl[webgl2Func]?this.gl[webgl2Func].bind(this.gl):(this.extensions[extension]||(this.extensions[extension]=this.gl.getExtension(extension)),webgl2Func?this.extensions[extension]?this.extensions[extension][extFunc].bind(this.extensions[extension]):null:this.extensions[extension])}sortOpaque(a,b){return a.renderOrder!==b.renderOrder?a.renderOrder-b.renderOrder:a.program.id!==b.program.id?a.program.id-b.program.id:a.zDepth!==b.zDepth?a.zDepth-b.zDepth:b.id-a.id}sortTransparent(a,b){return a.renderOrder!==b.renderOrder?a.renderOrder-b.renderOrder:a.zDepth!==b.zDepth?b.zDepth-a.zDepth:b.id-a.id}sortUI(a,b){return a.renderOrder!==b.renderOrder?a.renderOrder-b.renderOrder:a.program.id!==b.program.id?a.program.id-b.program.id:b.id-a.id}getRenderList({scene:scene,camera:camera,frustumCull:frustumCull,sort:sort}){let renderList=[];if(camera&&frustumCull&&camera.updateFrustum(),scene.traverse(node=>{if(!node.visible)return!0;node.draw&&(frustumCull&&node.frustumCulled&&camera&&!camera.frustumIntersectsMesh(node)||renderList.push(node))}),sort){const opaque=[],transparent=[],ui=[];renderList.forEach(node=>{node.program.transparent?node.program.depthTest?transparent.push(node):ui.push(node):opaque.push(node),node.zDepth=0,0===node.renderOrder&&node.program.depthTest&&camera&&(node.worldMatrix.getTranslation(tempVec3),tempVec3.applyMatrix4(camera.projectionViewMatrix),node.zDepth=tempVec3.z)}),opaque.sort(this.sortOpaque),transparent.sort(this.sortTransparent),ui.sort(this.sortUI),renderList=opaque.concat(transparent,ui)}return renderList}render({scene:scene,camera:camera,target:target=null,update:update=!0,sort:sort=!0,frustumCull:frustumCull=!0,clear:clear}){null===target?(this.bindFramebuffer(),this.setViewport(this.width*this.dpr,this.height*this.dpr)):(this.bindFramebuffer(target),this.setViewport(target.width,target.height)),(clear||this.autoClear&&!1!==clear)&&(!this.depth||target&&!target.depth||(this.enable(this.gl.DEPTH_TEST),this.setDepthMask(!0)),this.gl.clear((this.color?this.gl.COLOR_BUFFER_BIT:0)|(this.depth?this.gl.DEPTH_BUFFER_BIT:0)|(this.stencil?this.gl.STENCIL_BUFFER_BIT:0))),update&&scene.updateMatrixWorld(),camera&&camera.updateMatrixWorld();const renderList=this.getRenderList({scene:scene,camera:camera,frustumCull:frustumCull,sort:sort});renderList.forEach(node=>{node.draw({camera:camera})})}}function copy$3(out,a){return out[0]=a[0],out[1]=a[1],out[2]=a[2],out[3]=a[3],out}function set$3(out,x,y,z,w){return out[0]=x,out[1]=y,out[2]=z,out[3]=w,out}function scale$2(out,a,b){return out[0]=a[0]*b,out[1]=a[1]*b,out[2]=a[2]*b,out[3]=a[3]*b,out}function normalize$1(out,a){let x=a[0],y=a[1],z=a[2],w=a[3],len=x*x+y*y+z*z+w*w;return len>0&&(len=1/Math.sqrt(len)),out[0]=x*len,out[1]=y*len,out[2]=z*len,out[3]=w*len,out}function dot$1(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]+a[3]*b[3]}function identity$2(out){return out[0]=0,out[1]=0,out[2]=0,out[3]=1,out}function setAxisAngle(out,axis,rad){rad*=.5;let s=Math.sin(rad);return out[0]=s*axis[0],out[1]=s*axis[1],out[2]=s*axis[2],out[3]=Math.cos(rad),out}function multiply$2(out,a,b){let ax=a[0],ay=a[1],az=a[2],aw=a[3],bx=b[0],by=b[1],bz=b[2],bw=b[3];return out[0]=ax*bw+aw*bx+ay*bz-az*by,out[1]=ay*bw+aw*by+az*bx-ax*bz,out[2]=az*bw+aw*bz+ax*by-ay*bx,out[3]=aw*bw-ax*bx-ay*by-az*bz,out}function rotateX(out,a,rad){rad*=.5;let ax=a[0],ay=a[1],az=a[2],aw=a[3],bx=Math.sin(rad),bw=Math.cos(rad);return out[0]=ax*bw+aw*bx,out[1]=ay*bw+az*bx,out[2]=az*bw-ay*bx,out[3]=aw*bw-ax*bx,out}function rotateY(out,a,rad){rad*=.5;let ax=a[0],ay=a[1],az=a[2],aw=a[3],by=Math.sin(rad),bw=Math.cos(rad);return out[0]=ax*bw-az*by,out[1]=ay*bw+aw*by,out[2]=az*bw+ax*by,out[3]=aw*bw-ay*by,out}function rotateZ(out,a,rad){rad*=.5;let ax=a[0],ay=a[1],az=a[2],aw=a[3],bz=Math.sin(rad),bw=Math.cos(rad);return out[0]=ax*bw+ay*bz,out[1]=ay*bw-ax*bz,out[2]=az*bw+aw*bz,out[3]=aw*bw-az*bz,out}function slerp(out,a,b,t){let ax=a[0],ay=a[1],az=a[2],aw=a[3],bx=b[0],by=b[1],bz=b[2],bw=b[3],omega,cosom,sinom,scale0,scale1;return cosom=ax*bx+ay*by+az*bz+aw*bw,cosom<0&&(cosom=-cosom,bx=-bx,by=-by,bz=-bz,bw=-bw),1-cosom>1e-6?(omega=Math.acos(cosom),sinom=Math.sin(omega),scale0=Math.sin((1-t)*omega)/sinom,scale1=Math.sin(t*omega)/sinom):(scale0=1-t,scale1=t),out[0]=scale0*ax+scale1*bx,out[1]=scale0*ay+scale1*by,out[2]=scale0*az+scale1*bz,out[3]=scale0*aw+scale1*bw,out}function invert$2(out,a){let a0=a[0],a1=a[1],a2=a[2],a3=a[3],dot=a0*a0+a1*a1+a2*a2+a3*a3,invDot=dot?1/dot:0;return out[0]=-a0*invDot,out[1]=-a1*invDot,out[2]=-a2*invDot,out[3]=a3*invDot,out}function conjugate(out,a){return out[0]=-a[0],out[1]=-a[1],out[2]=-a[2],out[3]=a[3],out}function fromMat3(out,m){let fTrace=m[0]+m[4]+m[8],fRoot;if(fTrace>0)fRoot=Math.sqrt(fTrace+1),out[3]=.5*fRoot,fRoot=.5/fRoot,out[0]=(m[5]-m[7])*fRoot,out[1]=(m[6]-m[2])*fRoot,out[2]=(m[1]-m[3])*fRoot;else{let i=0;m[4]>m[0]&&(i=1),m[8]>m[3*i+i]&&(i=2);let j=(i+1)%3,k=(i+2)%3;fRoot=Math.sqrt(m[3*i+i]-m[3*j+j]-m[3*k+k]+1),out[i]=.5*fRoot,fRoot=.5/fRoot,out[3]=(m[3*j+k]-m[3*k+j])*fRoot,out[j]=(m[3*j+i]+m[3*i+j])*fRoot,out[k]=(m[3*k+i]+m[3*i+k])*fRoot}return out}function fromEuler(out,euler,order="YXZ"){let sx=Math.sin(.5*euler[0]),cx=Math.cos(.5*euler[0]),sy=Math.sin(.5*euler[1]),cy=Math.cos(.5*euler[1]),sz=Math.sin(.5*euler[2]),cz=Math.cos(.5*euler[2]);return"XYZ"===order?(out[0]=sx*cy*cz+cx*sy*sz,out[1]=cx*sy*cz-sx*cy*sz,out[2]=cx*cy*sz+sx*sy*cz,out[3]=cx*cy*cz-sx*sy*sz):"YXZ"===order?(out[0]=sx*cy*cz+cx*sy*sz,out[1]=cx*sy*cz-sx*cy*sz,out[2]=cx*cy*sz-sx*sy*cz,out[3]=cx*cy*cz+sx*sy*sz):"ZXY"===order?(out[0]=sx*cy*cz-cx*sy*sz,out[1]=cx*sy*cz+sx*cy*sz,out[2]=cx*cy*sz+sx*sy*cz,out[3]=cx*cy*cz-sx*sy*sz):"ZYX"===order?(out[0]=sx*cy*cz-cx*sy*sz,out[1]=cx*sy*cz+sx*cy*sz,out[2]=cx*cy*sz-sx*sy*cz,out[3]=cx*cy*cz+sx*sy*sz):"YZX"===order?(out[0]=sx*cy*cz+cx*sy*sz,out[1]=cx*sy*cz+sx*cy*sz,out[2]=cx*cy*sz-sx*sy*cz,out[3]=cx*cy*cz-sx*sy*sz):"XZY"===order&&(out[0]=sx*cy*cz-cx*sy*sz,out[1]=cx*sy*cz-sx*cy*sz,out[2]=cx*cy*sz+sx*sy*cz,out[3]=cx*cy*cz+sx*sy*sz),out}const copy$2=copy$3,set$2=set$3,dot=dot$1,normalize=normalize$1;class Quat extends Array{constructor(x=0,y=0,z=0,w=1){return super(x,y,z,w),this.onChange=()=>{},this}get x(){return this[0]}get y(){return this[1]}get z(){return this[2]}get w(){return this[3]}set x(v){this[0]=v,this.onChange()}set y(v){this[1]=v,this.onChange()}set z(v){this[2]=v,this.onChange()}set w(v){this[3]=v,this.onChange()}identity(){return identity$2(this),this.onChange(),this}set(x,y,z,w){return x.length?this.copy(x):(set$2(this,x,y,z,w),this.onChange(),this)}rotateX(a){return rotateX(this,this,a),this.onChange(),this}rotateY(a){return rotateY(this,this,a),this.onChange(),this}rotateZ(a){return rotateZ(this,this,a),this.onChange(),this}inverse(q=this){return invert$2(this,q),this.onChange(),this}conjugate(q=this){return conjugate(this,q),this.onChange(),this}copy(q){return copy$2(this,q),this.onChange(),this}normalize(q=this){return normalize(this,q),this.onChange(),this}multiply(qA,qB){return qB?multiply$2(this,qA,qB):multiply$2(this,this,qA),this.onChange(),this}dot(v){return dot(this,v)}fromMatrix3(matrix3){return fromMat3(this,matrix3),this.onChange(),this}fromEuler(euler){return fromEuler(this,euler,euler.order),this}fromAxisAngle(axis,a){return setAxisAngle(this,axis,a),this}slerp(q,t){return slerp(this,this,q,t),this}fromArray(a,o=0){return this[0]=a[o],this[1]=a[o+1],this[2]=a[o+2],this[3]=a[o+3],this}toArray(a=[],o=0){return a[o]=this[0],a[o+1]=this[1],a[o+2]=this[2],a[o+3]=this[3],a}}const EPSILON=1e-6;function copy$1(out,a){return out[0]=a[0],out[1]=a[1],out[2]=a[2],out[3]=a[3],out[4]=a[4],out[5]=a[5],out[6]=a[6],out[7]=a[7],out[8]=a[8],out[9]=a[9],out[10]=a[10],out[11]=a[11],out[12]=a[12],out[13]=a[13],out[14]=a[14],out[15]=a[15],out}function set$1(out,m00,m01,m02,m03,m10,m11,m12,m13,m20,m21,m22,m23,m30,m31,m32,m33){return out[0]=m00,out[1]=m01,out[2]=m02,out[3]=m03,out[4]=m10,out[5]=m11,out[6]=m12,out[7]=m13,out[8]=m20,out[9]=m21,out[10]=m22,out[11]=m23,out[12]=m30,out[13]=m31,out[14]=m32,out[15]=m33,out}function identity$1(out){return out[0]=1,out[1]=0,out[2]=0,out[3]=0,out[4]=0,out[5]=1,out[6]=0,out[7]=0,out[8]=0,out[9]=0,out[10]=1,out[11]=0,out[12]=0,out[13]=0,out[14]=0,out[15]=1,out}function invert$1(out,a){let a00=a[0],a01=a[1],a02=a[2],a03=a[3],a10=a[4],a11=a[5],a12=a[6],a13=a[7],a20=a[8],a21=a[9],a22=a[10],a23=a[11],a30=a[12],a31=a[13],a32=a[14],a33=a[15],b00=a00*a11-a01*a10,b01=a00*a12-a02*a10,b02=a00*a13-a03*a10,b03=a01*a12-a02*a11,b04=a01*a13-a03*a11,b05=a02*a13-a03*a12,b06=a20*a31-a21*a30,b07=a20*a32-a22*a30,b08=a20*a33-a23*a30,b09=a21*a32-a22*a31,b10=a21*a33-a23*a31,b11=a22*a33-a23*a32,det=b00*b11-b01*b10+b02*b09+b03*b08-b04*b07+b05*b06;return det?(det=1/det,out[0]=(a11*b11-a12*b10+a13*b09)*det,out[1]=(a02*b10-a01*b11-a03*b09)*det,out[2]=(a31*b05-a32*b04+a33*b03)*det,out[3]=(a22*b04-a21*b05-a23*b03)*det,out[4]=(a12*b08-a10*b11-a13*b07)*det,out[5]=(a00*b11-a02*b08+a03*b07)*det,out[6]=(a32*b02-a30*b05-a33*b01)*det,out[7]=(a20*b05-a22*b02+a23*b01)*det,out[8]=(a10*b10-a11*b08+a13*b06)*det,out[9]=(a01*b08-a00*b10-a03*b06)*det,out[10]=(a30*b04-a31*b02+a33*b00)*det,out[11]=(a21*b02-a20*b04-a23*b00)*det,out[12]=(a11*b07-a10*b09-a12*b06)*det,out[13]=(a00*b09-a01*b07+a02*b06)*det,out[14]=(a31*b01-a30*b03-a32*b00)*det,out[15]=(a20*b03-a21*b01+a22*b00)*det,out):null}function determinant(a){let a00=a[0],a01=a[1],a02=a[2],a03=a[3],a10=a[4],a11=a[5],a12=a[6],a13=a[7],a20=a[8],a21=a[9],a22=a[10],a23=a[11],a30=a[12],a31=a[13],a32=a[14],a33=a[15],b00,b01,b02,b03,b04,b05,b06,b07,b08,b09,b10,b11;return(a00*a11-a01*a10)*(a22*a33-a23*a32)-(a00*a12-a02*a10)*(a21*a33-a23*a31)+(a00*a13-a03*a10)*(a21*a32-a22*a31)+(a01*a12-a02*a11)*(a20*a33-a23*a30)-(a01*a13-a03*a11)*(a20*a32-a22*a30)+(a02*a13-a03*a12)*(a20*a31-a21*a30)}function multiply$1(out,a,b){let a00=a[0],a01=a[1],a02=a[2],a03=a[3],a10=a[4],a11=a[5],a12=a[6],a13=a[7],a20=a[8],a21=a[9],a22=a[10],a23=a[11],a30=a[12],a31=a[13],a32=a[14],a33=a[15],b0=b[0],b1=b[1],b2=b[2],b3=b[3];return out[0]=b0*a00+b1*a10+b2*a20+b3*a30,out[1]=b0*a01+b1*a11+b2*a21+b3*a31,out[2]=b0*a02+b1*a12+b2*a22+b3*a32,out[3]=b0*a03+b1*a13+b2*a23+b3*a33,b0=b[4],b1=b[5],b2=b[6],b3=b[7],out[4]=b0*a00+b1*a10+b2*a20+b3*a30,out[5]=b0*a01+b1*a11+b2*a21+b3*a31,out[6]=b0*a02+b1*a12+b2*a22+b3*a32,out[7]=b0*a03+b1*a13+b2*a23+b3*a33,b0=b[8],b1=b[9],b2=b[10],b3=b[11],out[8]=b0*a00+b1*a10+b2*a20+b3*a30,out[9]=b0*a01+b1*a11+b2*a21+b3*a31,out[10]=b0*a02+b1*a12+b2*a22+b3*a32,out[11]=b0*a03+b1*a13+b2*a23+b3*a33,b0=b[12],b1=b[13],b2=b[14],b3=b[15],out[12]=b0*a00+b1*a10+b2*a20+b3*a30,out[13]=b0*a01+b1*a11+b2*a21+b3*a31,out[14]=b0*a02+b1*a12+b2*a22+b3*a32,out[15]=b0*a03+b1*a13+b2*a23+b3*a33,out}function translate$1(out,a,v){let x=v[0],y=v[1],z=v[2],a00,a01,a02,a03,a10,a11,a12,a13,a20,a21,a22,a23;return a===out?(out[12]=a[0]*x+a[4]*y+a[8]*z+a[12],out[13]=a[1]*x+a[5]*y+a[9]*z+a[13],out[14]=a[2]*x+a[6]*y+a[10]*z+a[14],out[15]=a[3]*x+a[7]*y+a[11]*z+a[15]):(a00=a[0],a01=a[1],a02=a[2],a03=a[3],a10=a[4],a11=a[5],a12=a[6],a13=a[7],a20=a[8],a21=a[9],a22=a[10],a23=a[11],out[0]=a00,out[1]=a01,out[2]=a02,out[3]=a03,out[4]=a10,out[5]=a11,out[6]=a12,out[7]=a13,out[8]=a20,out[9]=a21,out[10]=a22,out[11]=a23,out[12]=a00*x+a10*y+a20*z+a[12],out[13]=a01*x+a11*y+a21*z+a[13],out[14]=a02*x+a12*y+a22*z+a[14],out[15]=a03*x+a13*y+a23*z+a[15]),out}function scale$1(out,a,v){let x=v[0],y=v[1],z=v[2];return out[0]=a[0]*x,out[1]=a[1]*x,out[2]=a[2]*x,out[3]=a[3]*x,out[4]=a[4]*y,out[5]=a[5]*y,out[6]=a[6]*y,out[7]=a[7]*y,out[8]=a[8]*z,out[9]=a[9]*z,out[10]=a[10]*z,out[11]=a[11]*z,out[12]=a[12],out[13]=a[13],out[14]=a[14],out[15]=a[15],out}function rotate$1(out,a,rad,axis){let x=axis[0],y=axis[1],z=axis[2],len=Math.hypot(x,y,z),s,c,t,a00,a01,a02,a03,a10,a11,a12,a13,a20,a21,a22,a23,b00,b01,b02,b10,b11,b12,b20,b21,b22;return Math.abs(len)<1e-6?null:(len=1/len,x*=len,y*=len,z*=len,s=Math.sin(rad),c=Math.cos(rad),t=1-c,a00=a[0],a01=a[1],a02=a[2],a03=a[3],a10=a[4],a11=a[5],a12=a[6],a13=a[7],a20=a[8],a21=a[9],a22=a[10],a23=a[11],b00=x*x*t+c,b01=y*x*t+z*s,b02=z*x*t-y*s,b10=x*y*t-z*s,b11=y*y*t+c,b12=z*y*t+x*s,b20=x*z*t+y*s,b21=y*z*t-x*s,b22=z*z*t+c,out[0]=a00*b00+a10*b01+a20*b02,out[1]=a01*b00+a11*b01+a21*b02,out[2]=a02*b00+a12*b01+a22*b02,out[3]=a03*b00+a13*b01+a23*b02,out[4]=a00*b10+a10*b11+a20*b12,out[5]=a01*b10+a11*b11+a21*b12,out[6]=a02*b10+a12*b11+a22*b12,out[7]=a03*b10+a13*b11+a23*b12,out[8]=a00*b20+a10*b21+a20*b22,out[9]=a01*b20+a11*b21+a21*b22,out[10]=a02*b20+a12*b21+a22*b22,out[11]=a03*b20+a13*b21+a23*b22,a!==out&&(out[12]=a[12],out[13]=a[13],out[14]=a[14],out[15]=a[15]),out)}function getTranslation(out,mat){return out[0]=mat[12],out[1]=mat[13],out[2]=mat[14],out}function getScaling(out,mat){let m11=mat[0],m12=mat[1],m13=mat[2],m21=mat[4],m22=mat[5],m23=mat[6],m31=mat[8],m32=mat[9],m33=mat[10];return out[0]=Math.hypot(m11,m12,m13),out[1]=Math.hypot(m21,m22,m23),out[2]=Math.hypot(m31,m32,m33),out}function getMaxScaleOnAxis(mat){let m11=mat[0],m12=mat[1],m13=mat[2],m21=mat[4],m22=mat[5],m23=mat[6],m31=mat[8],m32=mat[9],m33=mat[10];const x=m11*m11+m12*m12+m13*m13,y=m21*m21+m22*m22+m23*m23,z=m31*m31+m32*m32+m33*m33;return Math.sqrt(Math.max(x,y,z))}const getRotation=function(){const temp=[0,0,0];return function(out,mat){let scaling=temp;getScaling(scaling,mat);let is1=1/scaling[0],is2=1/scaling[1],is3=1/scaling[2],sm11=mat[0]*is1,sm12=mat[1]*is2,sm13=mat[2]*is3,sm21=mat[4]*is1,sm22=mat[5]*is2,sm23=mat[6]*is3,sm31=mat[8]*is1,sm32=mat[9]*is2,sm33=mat[10]*is3,trace=sm11+sm22+sm33,S=0;return trace>0?(S=2*Math.sqrt(trace+1),out[3]=.25*S,out[0]=(sm23-sm32)/S,out[1]=(sm31-sm13)/S,out[2]=(sm12-sm21)/S):sm11>sm22&&sm11>sm33?(S=2*Math.sqrt(1+sm11-sm22-sm33),out[3]=(sm23-sm32)/S,out[0]=.25*S,out[1]=(sm12+sm21)/S,out[2]=(sm31+sm13)/S):sm22>sm33?(S=2*Math.sqrt(1+sm22-sm11-sm33),out[3]=(sm31-sm13)/S,out[0]=(sm12+sm21)/S,out[1]=.25*S,out[2]=(sm23+sm32)/S):(S=2*Math.sqrt(1+sm33-sm11-sm22),out[3]=(sm12-sm21)/S,out[0]=(sm31+sm13)/S,out[1]=(sm23+sm32)/S,out[2]=.25*S),out}}();function fromRotationTranslationScale(out,q,v,s){let x=q[0],y=q[1],z=q[2],w=q[3],x2=x+x,y2=y+y,z2=z+z,xx=x*x2,xy=x*y2,xz=x*z2,yy=y*y2,yz=y*z2,zz=z*z2,wx=w*x2,wy=w*y2,wz=w*z2,sx=s[0],sy=s[1],sz=s[2];return out[0]=(1-(yy+zz))*sx,out[1]=(xy+wz)*sx,out[2]=(xz-wy)*sx,out[3]=0,out[4]=(xy-wz)*sy,out[5]=(1-(xx+zz))*sy,out[6]=(yz+wx)*sy,out[7]=0,out[8]=(xz+wy)*sz,out[9]=(yz-wx)*sz,out[10]=(1-(xx+yy))*sz,out[11]=0,out[12]=v[0],out[13]=v[1],out[14]=v[2],out[15]=1,out}function fromQuat$1(out,q){let x=q[0],y=q[1],z=q[2],w=q[3],x2=x+x,y2=y+y,z2=z+z,xx=x*x2,yx=y*x2,yy=y*y2,zx=z*x2,zy=z*y2,zz=z*z2,wx=w*x2,wy=w*y2,wz=w*z2;return out[0]=1-yy-zz,out[1]=yx+wz,out[2]=zx-wy,out[3]=0,out[4]=yx-wz,out[5]=1-xx-zz,out[6]=zy+wx,out[7]=0,out[8]=zx+wy,out[9]=zy-wx,out[10]=1-xx-yy,out[11]=0,out[12]=0,out[13]=0,out[14]=0,out[15]=1,out}function perspective(out,fovy,aspect,near,far){let f=1/Math.tan(fovy/2),nf=1/(near-far);return out[0]=f/aspect,out[1]=0,out[2]=0,out[3]=0,out[4]=0,out[5]=f,out[6]=0,out[7]=0,out[8]=0,out[9]=0,out[10]=(far+near)*nf,out[11]=-1,out[12]=0,out[13]=0,out[14]=2*far*near*nf,out[15]=0,out}function ortho(out,left,right,bottom,top,near,far){let lr=1/(left-right),bt=1/(bottom-top),nf=1/(near-far);return out[0]=-2*lr,out[1]=0,out[2]=0,out[3]=0,out[4]=0,out[5]=-2*bt,out[6]=0,out[7]=0,out[8]=0,out[9]=0,out[10]=2*nf,out[11]=0,out[12]=(left+right)*lr,out[13]=(top+bottom)*bt,out[14]=(far+near)*nf,out[15]=1,out}function targetTo(out,eye,target,up){let eyex=eye[0],eyey=eye[1],eyez=eye[2],upx=up[0],upy=up[1],upz=up[2],z0=eyex-target[0],z1=eyey-target[1],z2=eyez-target[2],len=z0*z0+z1*z1+z2*z2;0===len?z2=1:(len=1/Math.sqrt(len),z0*=len,z1*=len,z2*=len);let x0=upy*z2-upz*z1,x1=upz*z0-upx*z2,x2=upx*z1-upy*z0;return len=x0*x0+x1*x1+x2*x2,0===len&&(upz?upx+=1e-6:upy?upz+=1e-6:upy+=1e-6,x0=upy*z2-upz*z1,x1=upz*z0-upx*z2,x2=upx*z1-upy*z0,len=x0*x0+x1*x1+x2*x2),len=1/Math.sqrt(len),x0*=len,x1*=len,x2*=len,out[0]=x0,out[1]=x1,out[2]=x2,out[3]=0,out[4]=z1*x2-z2*x1,out[5]=z2*x0-z0*x2,out[6]=z0*x1-z1*x0,out[7]=0,out[8]=z0,out[9]=z1,out[10]=z2,out[11]=0,out[12]=eyex,out[13]=eyey,out[14]=eyez,out[15]=1,out}class Mat4 extends Array{constructor(m00=1,m01=0,m02=0,m03=0,m10=0,m11=1,m12=0,m13=0,m20=0,m21=0,m22=1,m23=0,m30=0,m31=0,m32=0,m33=1){return super(m00,m01,m02,m03,m10,m11,m12,m13,m20,m21,m22,m23,m30,m31,m32,m33),this}get x(){return this[12]}get y(){return this[13]}get z(){return this[14]}get w(){return this[15]}set x(v){this[12]=v}set y(v){this[13]=v}set z(v){this[14]=v}set w(v){this[15]=v}set(m00,m01,m02,m03,m10,m11,m12,m13,m20,m21,m22,m23,m30,m31,m32,m33){return m00.length?this.copy(m00):(set$1(this,m00,m01,m02,m03,m10,m11,m12,m13,m20,m21,m22,m23,m30,m31,m32,m33),this)}translate(v,m=this){return translate$1(this,m,v),this}rotate(v,axis,m=this){return rotate$1(this,m,v,axis),this}scale(v,m=this){return scale$1(this,m,"number"==typeof v?[v,v,v]:v),this}multiply(ma,mb){return mb?multiply$1(this,ma,mb):multiply$1(this,this,ma),this}identity(){return identity$1(this),this}copy(m){return copy$1(this,m),this}fromPerspective({fov:fov,aspect:aspect,near:near,far:far}={}){return perspective(this,fov,aspect,near,far),this}fromOrthogonal({left:left,right:right,bottom:bottom,top:top,near:near,far:far}){return ortho(this,left,right,bottom,top,near,far),this}fromQuaternion(q){return fromQuat$1(this,q),this}setPosition(v){return this.x=v[0],this.y=v[1],this.z=v[2],this}inverse(m=this){return invert$1(this,m),this}compose(q,pos,scale){return fromRotationTranslationScale(this,q,pos,scale),this}getRotation(q){return getRotation(q,this),this}getTranslation(pos){return getTranslation(pos,this),this}getScaling(scale){return getScaling(scale,this),this}getMaxScaleOnAxis(){return getMaxScaleOnAxis(this)}lookAt(eye,target,up){return targetTo(this,eye,target,up),this}determinant(){return determinant(this)}fromArray(a,o=0){return this[0]=a[o],this[1]=a[o+1],this[2]=a[o+2],this[3]=a[o+3],this[4]=a[o+4],this[5]=a[o+5],this[6]=a[o+6],this[7]=a[o+7],this[8]=a[o+8],this[9]=a[o+9],this[10]=a[o+10],this[11]=a[o+11],this[12]=a[o+12],this[13]=a[o+13],this[14]=a[o+14],this[15]=a[o+15],this}toArray(a=[],o=0){return a[o]=this[0],a[o+1]=this[1],a[o+2]=this[2],a[o+3]=this[3],a[o+4]=this[4],a[o+5]=this[5],a[o+6]=this[6],a[o+7]=this[7],a[o+8]=this[8],a[o+9]=this[9],a[o+10]=this[10],a[o+11]=this[11],a[o+12]=this[12],a[o+13]=this[13],a[o+14]=this[14],a[o+15]=this[15],a}}function fromRotationMatrix(out,m,order="YXZ"){return"XYZ"===order?(out[1]=Math.asin(Math.min(Math.max(m[8],-1),1)),Math.abs(m[8])<.99999?(out[0]=Math.atan2(-m[9],m[10]),out[2]=Math.atan2(-m[4],m[0])):(out[0]=Math.atan2(m[6],m[5]),out[2]=0)):"YXZ"===order?(out[0]=Math.asin(-Math.min(Math.max(m[9],-1),1)),Math.abs(m[9])<.99999?(out[1]=Math.atan2(m[8],m[10]),out[2]=Math.atan2(m[1],m[5])):(out[1]=Math.atan2(-m[2],m[0]),out[2]=0)):"ZXY"===order?(out[0]=Math.asin(Math.min(Math.max(m[6],-1),1)),Math.abs(m[6])<.99999?(out[1]=Math.atan2(-m[2],m[10]),out[2]=Math.atan2(-m[4],m[5])):(out[1]=0,out[2]=Math.atan2(m[1],m[0]))):"ZYX"===order?(out[1]=Math.asin(-Math.min(Math.max(m[2],-1),1)),Math.abs(m[2])<.99999?(out[0]=Math.atan2(m[6],m[10]),out[2]=Math.atan2(m[1],m[0])):(out[0]=0,out[2]=Math.atan2(-m[4],m[5]))):"YZX"===order?(out[2]=Math.asin(Math.min(Math.max(m[1],-1),1)),Math.abs(m[1])<.99999?(out[0]=Math.atan2(-m[9],m[5]),out[1]=Math.atan2(-m[2],m[0])):(out[0]=0,out[1]=Math.atan2(m[8],m[10]))):"XZY"===order&&(out[2]=Math.asin(-Math.min(Math.max(m[4],-1),1)),Math.abs(m[4])<.99999?(out[0]=Math.atan2(m[6],m[5]),out[1]=Math.atan2(m[8],m[0])):(out[0]=Math.atan2(-m[9],m[10]),out[1]=0)),out}const tmpMat4=new Mat4;class Euler extends Array{constructor(x=0,y=x,z=x,order="YXZ"){return super(x,y,z),this.order=order,this.onChange=()=>{},this}get x(){return this[0]}get y(){return this[1]}get z(){return this[2]}set x(v){this[0]=v,this.onChange()}set y(v){this[1]=v,this.onChange()}set z(v){this[2]=v,this.onChange()}set(x,y=x,z=x){return x.length?this.copy(x):(this[0]=x,this[1]=y,this[2]=z,this.onChange(),this)}copy(v){return this[0]=v[0],this[1]=v[1],this[2]=v[2],this.onChange(),this}reorder(order){return this.order=order,this.onChange(),this}fromRotationMatrix(m,order=this.order){return fromRotationMatrix(this,m,order),this}fromQuaternion(q,order=this.order){return tmpMat4.fromQuaternion(q),this.fromRotationMatrix(tmpMat4,order)}toArray(a=[],o=0){return a[o]=this[0],a[o+1]=this[1],a[o+2]=this[2],a}}class Transform{constructor(){this.parent=null,this.children=[],this.visible=!0,this.matrix=new Mat4,this.worldMatrix=new Mat4,this.matrixAutoUpdate=!0,this.position=new Vec3,this.quaternion=new Quat,this.scale=new Vec3(1),this.rotation=new Euler,this.up=new Vec3(0,1,0),this.rotation.onChange=()=>this.quaternion.fromEuler(this.rotation),this.quaternion.onChange=()=>this.rotation.fromQuaternion(this.quaternion)}setParent(parent,notifyParent=!0){this.parent&&parent!==this.parent&&this.parent.removeChild(this,!1),this.parent=parent,notifyParent&&parent&&parent.addChild(this,!1)}addChild(child,notifyChild=!0){~this.children.indexOf(child)||this.children.push(child),notifyChild&&child.setParent(this,!1)}removeChild(child,notifyChild=!0){~this.children.indexOf(child)&&this.children.splice(this.children.indexOf(child),1),notifyChild&&child.setParent(null,!1)}updateMatrixWorld(force){this.matrixAutoUpdate&&this.updateMatrix(),(this.worldMatrixNeedsUpdate||force)&&(null===this.parent?this.worldMatrix.copy(this.matrix):this.worldMatrix.multiply(this.parent.worldMatrix,this.matrix),this.worldMatrixNeedsUpdate=!1,force=!0);for(let i=0,l=this.children.length;i<l;i++)this.children[i].updateMatrixWorld(force)}updateMatrix(){this.matrix.compose(this.quaternion,this.position,this.scale),this.worldMatrixNeedsUpdate=!0}traverse(callback){if(!callback(this))for(let i=0,l=this.children.length;i<l;i++)this.children[i].traverse(callback)}decompose(){this.matrix.getTranslation(this.position),this.matrix.getRotation(this.quaternion),this.matrix.getScaling(this.scale),this.rotation.fromQuaternion(this.quaternion)}lookAt(target,invert=!1){invert?this.matrix.lookAt(this.position,target,this.up):this.matrix.lookAt(target,this.position,this.up),this.matrix.getRotation(this.quaternion),this.rotation.fromQuaternion(this.quaternion)}}const tempMat4=new Mat4,tempVec3a=new Vec3,tempVec3b=new Vec3;class Camera extends Transform{constructor(gl,{near:near=.1,far:far=100,fov:fov=45,aspect:aspect=1,left:left,right:right,bottom:bottom,top:top,zoom:zoom=1}={}){super(),Object.assign(this,{near:near,far:far,fov:fov,aspect:aspect,left:left,right:right,bottom:bottom,top:top,zoom:zoom}),this.projectionMatrix=new Mat4,this.viewMatrix=new Mat4,this.projectionViewMatrix=new Mat4,this.worldPosition=new Vec3,this.type=left||right?"orthographic":"perspective","orthographic"===this.type?this.orthographic():this.perspective()}perspective({near:near=this.near,far:far=this.far,fov:fov=this.fov,aspect:aspect=this.aspect}={}){return Object.assign(this,{near:near,far:far,fov:fov,aspect:aspect}),this.projectionMatrix.fromPerspective({fov:fov*(Math.PI/180),aspect:aspect,near:near,far:far}),this.type="perspective",this}orthographic({near:near=this.near,far:far=this.far,left:left=this.left,right:right=this.right,bottom:bottom=this.bottom,top:top=this.top,zoom:zoom=this.zoom}={}){return Object.assign(this,{near:near,far:far,left:left,right:right,bottom:bottom,top:top,zoom:zoom}),left/=zoom,right/=zoom,bottom/=zoom,top/=zoom,this.projectionMatrix.fromOrthogonal({left:left,right:right,bottom:bottom,top:top,near:near,far:far}),this.type="orthographic",this}updateMatrixWorld(){return super.updateMatrixWorld(),this.viewMatrix.inverse(this.worldMatrix),this.worldMatrix.getTranslation(this.worldPosition),this.projectionViewMatrix.multiply(this.projectionMatrix,this.viewMatrix),this}lookAt(target){return super.lookAt(target,!0),this}project(v){return v.applyMatrix4(this.viewMatrix),v.applyMatrix4(this.projectionMatrix),this}unproject(v){return v.applyMatrix4(tempMat4.inverse(this.projectionMatrix)),v.applyMatrix4(this.worldMatrix),this}updateFrustum(){this.frustum||(this.frustum=[new Vec3,new Vec3,new Vec3,new Vec3,new Vec3,new Vec3]);const m=this.projectionViewMatrix;this.frustum[0].set(m[3]-m[0],m[7]-m[4],m[11]-m[8]).constant=m[15]-m[12],this.frustum[1].set(m[3]+m[0],m[7]+m[4],m[11]+m[8]).constant=m[15]+m[12],this.frustum[2].set(m[3]+m[1],m[7]+m[5],m[11]+m[9]).constant=m[15]+m[13],this.frustum[3].set(m[3]-m[1],m[7]-m[5],m[11]-m[9]).constant=m[15]-m[13],this.frustum[4].set(m[3]-m[2],m[7]-m[6],m[11]-m[10]).constant=m[15]-m[14],this.frustum[5].set(m[3]+m[2],m[7]+m[6],m[11]+m[10]).constant=m[15]+m[14];for(let i=0;i<6;i++){const invLen=1/this.frustum[i].distance();this.frustum[i].multiply(invLen),this.frustum[i].constant*=invLen}}frustumIntersectsMesh(node){if(!node.geometry.attributes.position)return!0;if(node.geometry.bounds&&node.geometry.bounds.radius!==1/0||node.geometry.computeBoundingSphere(),!node.geometry.bounds)return!0;const center=tempVec3a;center.copy(node.geometry.bounds.center),center.applyMatrix4(node.worldMatrix);const radius=node.geometry.bounds.radius*node.worldMatrix.getMaxScaleOnAxis();return this.frustumIntersectsSphere(center,radius)}frustumIntersectsSphere(center,radius){const normal=tempVec3b;for(let i=0;i<6;i++){const plane=this.frustum[i],distance=normal.copy(plane).dot(center)+plane.constant;if(distance<-radius)return!1}return!0}}function fromMat4(out,a){return out[0]=a[0],out[1]=a[1],out[2]=a[2],out[3]=a[4],out[4]=a[5],out[5]=a[6],out[6]=a[8],out[7]=a[9],out[8]=a[10],out}function fromQuat(out,q){let x=q[0],y=q[1],z=q[2],w=q[3],x2=x+x,y2=y+y,z2=z+z,xx=x*x2,yx=y*x2,yy=y*y2,zx=z*x2,zy=z*y2,zz=z*z2,wx=w*x2,wy=w*y2,wz=w*z2;return out[0]=1-yy-zz,out[3]=yx-wz,out[6]=zx+wy,out[1]=yx+wz,out[4]=1-xx-zz,out[7]=zy-wx,out[2]=zx-wy,out[5]=zy+wx,out[8]=1-xx-yy,out}function copy(out,a){return out[0]=a[0],out[1]=a[1],out[2]=a[2],out[3]=a[3],out[4]=a[4],out[5]=a[5],out[6]=a[6],out[7]=a[7],out[8]=a[8],out}function set(out,m00,m01,m02,m10,m11,m12,m20,m21,m22){return out[0]=m00,out[1]=m01,out[2]=m02,out[3]=m10,out[4]=m11,out[5]=m12,out[6]=m20,out[7]=m21,out[8]=m22,out}function identity(out){return out[0]=1,out[1]=0,out[2]=0,out[3]=0,out[4]=1,out[5]=0,out[6]=0,out[7]=0,out[8]=1,out}function invert(out,a){let a00=a[0],a01=a[1],a02=a[2],a10=a[3],a11=a[4],a12=a[5],a20=a[6],a21=a[7],a22=a[8],b01=a22*a11-a12*a21,b11=-a22*a10+a12*a20,b21=a21*a10-a11*a20,det=a00*b01+a01*b11+a02*b21;return det?(det=1/det,out[0]=b01*det,out[1]=(-a22*a01+a02*a21)*det,out[2]=(a12*a01-a02*a11)*det,out[3]=b11*det,out[4]=(a22*a00-a02*a20)*det,out[5]=(-a12*a00+a02*a10)*det,out[6]=b21*det,out[7]=(-a21*a00+a01*a20)*det,out[8]=(a11*a00-a01*a10)*det,out):null}function multiply(out,a,b){let a00=a[0],a01=a[1],a02=a[2],a10=a[3],a11=a[4],a12=a[5],a20=a[6],a21=a[7],a22=a[8],b00=b[0],b01=b[1],b02=b[2],b10=b[3],b11=b[4],b12=b[5],b20=b[6],b21=b[7],b22=b[8];return out[0]=b00*a00+b01*a10+b02*a20,out[1]=b00*a01+b01*a11+b02*a21,out[2]=b00*a02+b01*a12+b02*a22,out[3]=b10*a00+b11*a10+b12*a20,out[4]=b10*a01+b11*a11+b12*a21,out[5]=b10*a02+b11*a12+b12*a22,out[6]=b20*a00+b21*a10+b22*a20,out[7]=b20*a01+b21*a11+b22*a21,out[8]=b20*a02+b21*a12+b22*a22,out}function translate(out,a,v){let a00=a[0],a01=a[1],a02=a[2],a10=a[3],a11=a[4],a12=a[5],a20=a[6],a21=a[7],a22=a[8],x=v[0],y=v[1];return out[0]=a00,out[1]=a01,out[2]=a02,out[3]=a10,out[4]=a11,out[5]=a12,out[6]=x*a00+y*a10+a20,out[7]=x*a01+y*a11+a21,out[8]=x*a02+y*a12+a22,out}function rotate(out,a,rad){let a00=a[0],a01=a[1],a02=a[2],a10=a[3],a11=a[4],a12=a[5],a20=a[6],a21=a[7],a22=a[8],s=Math.sin(rad),c=Math.cos(rad);return out[0]=c*a00+s*a10,out[1]=c*a01+s*a11,out[2]=c*a02+s*a12,out[3]=c*a10-s*a00,out[4]=c*a11-s*a01,out[5]=c*a12-s*a02,out[6]=a20,out[7]=a21,out[8]=a22,out}function scale(out,a,v){let x=v[0],y=v[1];return out[0]=x*a[0],out[1]=x*a[1],out[2]=x*a[2],out[3]=y*a[3],out[4]=y*a[4],out[5]=y*a[5],out[6]=a[6],out[7]=a[7],out[8]=a[8],out}function normalFromMat4(out,a){let a00=a[0],a01=a[1],a02=a[2],a03=a[3],a10=a[4],a11=a[5],a12=a[6],a13=a[7],a20=a[8],a21=a[9],a22=a[10],a23=a[11],a30=a[12],a31=a[13],a32=a[14],a33=a[15],b00=a00*a11-a01*a10,b01=a00*a12-a02*a10,b02=a00*a13-a03*a10,b03=a01*a12-a02*a11,b04=a01*a13-a03*a11,b05=a02*a13-a03*a12,b06=a20*a31-a21*a30,b07=a20*a32-a22*a30,b08=a20*a33-a23*a30,b09=a21*a32-a22*a31,b10=a21*a33-a23*a31,b11=a22*a33-a23*a32,det=b00*b11-b01*b10+b02*b09+b03*b08-b04*b07+b05*b06;return det?(det=1/det,out[0]=(a11*b11-a12*b10+a13*b09)*det,out[1]=(a12*b08-a10*b11-a13*b07)*det,out[2]=(a10*b10-a11*b08+a13*b06)*det,out[3]=(a02*b10-a01*b11-a03*b09)*det,out[4]=(a00*b11-a02*b08+a03*b07)*det,out[5]=(a01*b08-a00*b10-a03*b06)*det,out[6]=(a31*b05-a32*b04+a33*b03)*det,out[7]=(a32*b02-a30*b05-a33*b01)*det,out[8]=(a30*b04-a31*b02+a33*b00)*det,out):null}class Mat3 extends Array{constructor(m00=1,m01=0,m02=0,m10=0,m11=1,m12=0,m20=0,m21=0,m22=1){return super(m00,m01,m02,m10,m11,m12,m20,m21,m22),this}set(m00,m01,m02,m10,m11,m12,m20,m21,m22){return m00.length?this.copy(m00):(set(this,m00,m01,m02,m10,m11,m12,m20,m21,m22),this)}translate(v,m=this){return translate(this,m,v),this}rotate(v,m=this){return rotate(this,m,v),this}scale(v,m=this){return scale(this,m,v),this}multiply(ma,mb){return mb?multiply(this,ma,mb):multiply(this,this,ma),this}identity(){return identity(this),this}copy(m){return copy(this,m),this}fromMatrix4(m){return fromMat4(this,m),this}fromQuaternion(q){return fromQuat(this,q),this}fromBasis(vec3a,vec3b,vec3c){return this.set(vec3a[0],vec3a[1],vec3a[2],vec3b[0],vec3b[1],vec3b[2],vec3c[0],vec3c[1],vec3c[2]),this}inverse(m=this){return invert(this,m),this}getNormalMatrix(m){return normalFromMat4(this,m),this}}let ID$1=0;class Mesh extends Transform{constructor(gl,{geometry:geometry,program:program,mode:mode=gl.TRIANGLES,frustumCulled:frustumCulled=!0,renderOrder:renderOrder=0}={}){super(),gl.canvas||console.error("gl not passed as first argument to Mesh"),this.gl=gl,this.id=ID$1++,this.geometry=geometry,this.program=program,this.mode=mode,this.frustumCulled=frustumCulled,this.renderOrder=renderOrder,this.modelViewMatrix=new Mat4,this.normalMatrix=new Mat3,this.beforeRenderCallbacks=[],this.afterRenderCallbacks=[]}onBeforeRender(f){return this.beforeRenderCallbacks.push(f),this}onAfterRender(f){return this.afterRenderCallbacks.push(f),this}draw({camera:camera}={}){this.beforeRenderCallbacks.forEach(f=>f&&f({mesh:this,camera:camera})),camera&&(this.program.uniforms.modelMatrix||Object.assign(this.program.uniforms,{modelMatrix:{value:null},viewMatrix:{value:null},modelViewMatrix:{value:null},normalMatrix:{value:null},projectionMatrix:{value:null},cameraPosition:{value:null}}),this.program.uniforms.projectionMatrix.value=camera.projectionMatrix,this.program.uniforms.cameraPosition.value=camera.worldPosition,this.program.uniforms.viewMatrix.value=camera.viewMatrix,this.modelViewMatrix.multiply(camera.viewMatrix,this.worldMatrix),this.normalMatrix.getNormalMatrix(this.modelViewMatrix),this.program.uniforms.modelMatrix.value=this.worldMatrix,this.program.uniforms.modelViewMatrix.value=this.modelViewMatrix,this.program.uniforms.normalMatrix.value=this.normalMatrix);let flipFaces=this.program.cullFace&&this.worldMatrix.determinant()<0;this.program.use({flipFaces:flipFaces}),this.geometry.draw({mode:this.mode,program:this.program}),this.afterRenderCallbacks.forEach(f=>f&&f({mesh:this,camera:camera}))}}const emptyPixel=new Uint8Array(4);function isPowerOf2(value){return 0==(value&value-1)}let ID=1;class Texture{constructor(gl,{image:image,target:target=gl.TEXTURE_2D,type:type=gl.UNSIGNED_BYTE,format:format=gl.RGBA,internalFormat:internalFormat=format,wrapS:wrapS=gl.CLAMP_TO_EDGE,wrapT:wrapT=gl.CLAMP_TO_EDGE,generateMipmaps:generateMipmaps=!0,minFilter:minFilter=(generateMipmaps?gl.NEAREST_MIPMAP_LINEAR:gl.LINEAR),magFilter:magFilter=gl.LINEAR,premultiplyAlpha:premultiplyAlpha=!1,unpackAlignment:unpackAlignment=4,flipY:flipY=target==gl.TEXTURE_2D,anisotropy:anisotropy=0,level:level=0,width:width,height:height=width}={}){this.gl=gl,this.id=ID++,this.image=image,this.target=target,this.type=type,this.format=format,this.internalFormat=internalFormat,this.minFilter=minFilter,this.magFilter=magFilter,this.wrapS=wrapS,this.wrapT=wrapT,this.generateMipmaps=generateMipmaps,this.premultiplyAlpha=premultiplyAlpha,this.unpackAlignment=unpackAlignment,this.flipY=flipY,this.anisotropy=Math.min(anisotropy,this.gl.renderer.parameters.maxAnisotropy),this.level=level,this.width=width,this.height=height,this.texture=this.gl.createTexture(),this.store={image:null},this.glState=this.gl.renderer.state,this.state={},this.state.minFilter=this.gl.NEAREST_MIPMAP_LINEAR,this.state.magFilter=this.gl.LINEAR,this.state.wrapS=this.gl.REPEAT,this.state.wrapT=this.gl.REPEAT,this.state.anisotropy=0}bind(){this.glState.textureUnits[this.glState.activeTextureUnit]!==this.id&&(this.gl.bindTexture(this.target,this.texture),this.glState.textureUnits[this.glState.activeTextureUnit]=this.id)}update(textureUnit=0){const needsUpdate=!(this.image===this.store.image&&!this.needsUpdate);if((needsUpdate||this.glState.textureUnits[textureUnit]!==this.id)&&(this.gl.renderer.activeTexture(textureUnit),this.bind()),needsUpdate){if(this.needsUpdate=!1,this.flipY!==this.glState.flipY&&(this.gl.pixelStorei(this.gl.UNPACK_FLIP_Y_WEBGL,this.flipY),this.glState.flipY=this.flipY),this.premultiplyAlpha!==this.glState.premultiplyAlpha&&(this.gl.pixelStorei(this.gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL,this.premultiplyAlpha),this.glState.premultiplyAlpha=this.premultiplyAlpha),this.unpackAlignment!==this.glState.unpackAlignment&&(this.gl.pixelStorei(this.gl.UNPACK_ALIGNMENT,this.unpackAlignment),this.glState.unpackAlignment=this.unpackAlignment),this.minFilter!==this.state.minFilter&&(this.gl.texParameteri(this.target,this.gl.TEXTURE_MIN_FILTER,this.minFilter),this.state.minFilter=this.minFilter),this.magFilter!==this.state.magFilter&&(this.gl.texParameteri(this.target,this.gl.TEXTURE_MAG_FILTER,this.magFilter),this.state.magFilter=this.magFilter),this.wrapS!==this.state.wrapS&&(this.gl.texParameteri(this.target,this.gl.TEXTURE_WRAP_S,this.wrapS),this.state.wrapS=this.wrapS),this.wrapT!==this.state.wrapT&&(this.gl.texParameteri(this.target,this.gl.TEXTURE_WRAP_T,this.wrapT),this.state.wrapT=this.wrapT),this.anisotropy&&this.anisotropy!==this.state.anisotropy&&(this.gl.texParameterf(this.target,this.gl.renderer.getExtension("EXT_texture_filter_anisotropic").TEXTURE_MAX_ANISOTROPY_EXT,this.anisotropy),this.state.anisotropy=this.anisotropy),this.image){if(this.image.width&&(this.width=this.image.width,this.height=this.image.height),this.target===this.gl.TEXTURE_CUBE_MAP)for(let i=0;i<6;i++)this.gl.texImage2D(this.gl.TEXTURE_CUBE_MAP_POSITIVE_X+i,this.level,this.internalFormat,this.format,this.type,this.image[i]);else if(ArrayBuffer.isView(this.image))this.gl.texImage2D(this.target,this.level,this.internalFormat,this.width,this.height,0,this.format,this.type,this.image);else if(this.image.isCompressedTexture)for(let level=0;level<this.image.length;level++)this.gl.compressedTexImage2D(this.target,level,this.internalFormat,this.image[level].width,this.image[level].height,0,this.image[level].data);else this.gl.texImage2D(this.target,this.level,this.internalFormat,this.format,this.type,this.image);this.generateMipmaps&&(this.gl.renderer.isWebgl2||isPowerOf2(this.image.width)&&isPowerOf2(this.image.height)?this.gl.generateMipmap(this.target):(this.generateMipmaps=!1,this.wrapS=this.wrapT=this.gl.CLAMP_TO_EDGE,this.minFilter=this.gl.LINEAR)),this.onUpdate&&this.onUpdate()}else if(this.target===this.gl.TEXTURE_CUBE_MAP)for(let i=0;i<6;i++)this.gl.texImage2D(this.gl.TEXTURE_CUBE_MAP_POSITIVE_X+i,0,this.gl.RGBA,1,1,0,this.gl.RGBA,this.gl.UNSIGNED_BYTE,emptyPixel);else this.width?this.gl.texImage2D(this.target,this.level,this.internalFormat,this.width,this.height,0,this.format,this.type,null):this.gl.texImage2D(this.target,0,this.gl.RGBA,1,1,0,this.gl.RGBA,this.gl.UNSIGNED_BYTE,emptyPixel);this.store.image=this.image}}}class Vec4 extends Array{constructor(x=0,y=x,z=x,w=x){return super(x,y,z,w),this}get x(){return this[0]}get y(){return this[1]}get z(){return this[2]}get w(){return this[3]}set x(v){this[0]=v}set y(v){this[1]=v}set z(v){this[2]=v}set w(v){this[3]=v}set(x,y,z,w){return x.length?this.copy(x):(set$3(this,x,y,z,w),this)}copy(v){return copy$3(this,v),this}normalize(){return normalize$1(this,this),this}multiply(v){return scale$2(this,this,v),this}dot(v){return dot$1(this,v)}fromArray(a,o=0){return this[0]=a[o],this[1]=a[o+1],this[2]=a[o+2],this[3]=a[o+3],this}toArray(a=[],o=0){return a[o]=this[0],a[o+1]=this[1],a[o+2]=this[2],a[o+3]=this[3],a}}class Plane extends Geometry{constructor(gl,{width:width=1,height:height=1,widthSegments:widthSegments=1,heightSegments:heightSegments=1,attributes:attributes={}}={}){const wSegs=widthSegments,hSegs=heightSegments,num=(wSegs+1)*(hSegs+1),numIndices=wSegs*hSegs*6,position=new Float32Array(3*num),normal=new Float32Array(3*num),uv=new Float32Array(2*num),index=numIndices>65536?new Uint32Array(numIndices):new Uint16Array(numIndices);Plane.buildPlane(position,normal,uv,index,width,height,0,wSegs,hSegs),Object.assign(attributes,{position:{size:3,data:position},normal:{size:3,data:normal},uv:{size:2,data:uv},index:{data:index}}),super(gl,attributes)}static buildPlane(position,normal,uv,index,width,height,depth,wSegs,hSegs,u=0,v=1,w=2,uDir=1,vDir=-1,i=0,ii=0){const io=i,segW=width/wSegs,segH=height/hSegs;for(let iy=0;iy<=hSegs;iy++){let y=iy*segH-height/2;for(let ix=0;ix<=wSegs;ix++,i++){let x=ix*segW-width/2;if(position[3*i+u]=x*uDir,position[3*i+v]=y*vDir,position[3*i+w]=depth/2,normal[3*i+u]=0,normal[3*i+v]=0,normal[3*i+w]=depth>=0?1:-1,uv[2*i]=ix/wSegs,uv[2*i+1]=1-iy/hSegs,iy===hSegs||ix===wSegs)continue;let a=io+ix+iy*(wSegs+1),b=io+ix+(iy+1)*(wSegs+1),c=io+ix+(iy+1)*(wSegs+1)+1,d=io+ix+iy*(wSegs+1)+1;index[6*ii]=a,index[6*ii+1]=b,index[6*ii+2]=d,index[6*ii+3]=b,index[6*ii+4]=c,index[6*ii+5]=d,ii++}}}}const displacement="data:image/jpeg;base64,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",F2=.5*(Math.sqrt(3)-1),G2=(3-Math.sqrt(3))/6,fastFloor=x=>0|Math.floor(x),grad2=new Float64Array([1,1,-1,1,1,-1,-1,-1,1,0,-1,0,1,0,-1,0,0,1,0,-1,0,1,0,-1]);function createNoise2D(random=Math.random){const perm=buildPermutationTable(random),permGrad2x=new Float64Array(perm).map(v=>grad2[v%12*2]),permGrad2y=new Float64Array(perm).map(v=>grad2[v%12*2+1]);return function noise2D(x,y){let n0=0,n1=0,n2=0;const s=(x+y)*F2,i=fastFloor(x+s),j=fastFloor(y+s),t=(i+j)*G2,X0=i-t,Y0=j-t,x0=x-X0,y0=y-Y0;let i1,j1;x0>y0?(i1=1,j1=0):(i1=0,j1=1);const x1=x0-i1+G2,y1=y0-j1+G2,x2=x0-1+2*G2,y2=y0-1+2*G2,ii=255&i,jj=255&j;let t0=.5-x0*x0-y0*y0;if(t0>=0){const gi0=ii+perm[jj],g0x=permGrad2x[gi0],g0y=permGrad2y[gi0];t0*=t0,n0=t0*t0*(g0x*x0+g0y*y0)}let t1=.5-x1*x1-y1*y1;if(t1>=0){const gi1=ii+i1+perm[jj+j1],g1x=permGrad2x[gi1],g1y=permGrad2y[gi1];t1*=t1,n1=t1*t1*(g1x*x1+g1y*y1)}let t2=.5-x2*x2-y2*y2;if(t2>=0){const gi2=ii+1+perm[jj+1],g2x=permGrad2x[gi2],g2y=permGrad2y[gi2];t2*=t2,n2=t2*t2*(g2x*x2+g2y*y2)}return 70*(n0+n1+n2)}}function buildPermutationTable(random){const tableSize=512,p=new Uint8Array(512);for(let i=0;i<256;i++)p[i]=i;for(let i=0;i<255;i++){const r=i+~~(random()*(256-i)),aux=p[i];p[i]=p[r],p[r]=aux}for(let i=256;i<512;i++)p[i]=p[i-256];return p}function randFloatSpread(range){return range*(.5-Math.random())}function randFloat(low,high){return low+Math.random()*(high-low)}const noise2D=createNoise2D(Math.random);function clamp(a){return Math.max(0,Math.min(1,a))}function getGeometry(gl,detail,offsetTop){offsetTop=offsetTop||0;const number=detail,width=2,height=2,gran=2/number,granH=gran*Math.sqrt(3)/2,rows=2/granH,offsets=[],positions=[],centroids=[],control0=[],control1=[],randoms=[],uvs=[];let currentShift=0;const bary=[];let currentHeight=0;const scale=2;for(let j=0;j<rows;j+=1){currentHeight=j*granH,currentShift=j%2==1?-gran/2:0;for(let i=0;i<=number;i+=1){const sign=Math.sign(i*gran+currentShift-1);positions.push(i*gran+currentShift-1,currentHeight-1,0),uvs.push((i*gran+currentShift)/2,currentHeight/2),positions.push(i*gran+gran/2+currentShift-1,granH+currentHeight-1,0),uvs.push((i*gran+gran/2+currentShift)/2,(granH+currentHeight)/2),positions.push(i*gran-gran/2+currentShift-1,granH+currentHeight-1,0),uvs.push((i*gran-gran/2+currentShift)/2,(granH+currentHeight)/2);let simp=noise2D(i/rows,j/rows)+Math.random();const o=clamp(currentHeight/2+2*simp/detail);let r=Math.random();offsets.push(o,clamp(o+.1*offsetTop),clamp(o+.1*offsetTop)),randoms.push(r,r,r);const c=[i*gran+currentShift-1,currentHeight-1,0];centroids.push(...c,...c,...c);const ctrl0=[2*sign*randFloat(-.3,.3),-2*randFloat(-.3,.3)*1.5,-randFloatSpread(.5)],ctrl1=[2*sign*randFloat(.3,.6),-2*randFloat(.3,.6)*1.5,-randFloatSpread(.5)];control0.push(...ctrl0,...ctrl0,...ctrl0),control1.push(...ctrl1,...ctrl1,...ctrl1),bary.push(0,0,1,0,1,0,1,0,0),positions.push(i*gran+currentShift-1,currentHeight-1,0),uvs.push((i*gran+currentShift)/2,currentHeight/2),positions.push(i*gran+gran+currentShift-1,currentHeight-1,0),uvs.push((i*gran+gran+currentShift)/2,currentHeight/2),positions.push(i*gran+gran/2+currentShift-1,granH+currentHeight-1,0),uvs.push((i*gran+gran/2+currentShift)/2,(granH+currentHeight)/2),simp=noise2D((i+1)/rows,j/rows)+Math.random();const o1=clamp(currentHeight/2+2*simp/detail);r=Math.random(),offsets.push(o1,o1,clamp(o1+.1*offsetTop)),randoms.push(r,r,r);const c1=[i*gran+currentShift-1,currentHeight-1,0];control0.push(...ctrl0,...ctrl0,...ctrl0),control1.push(...ctrl1,...ctrl1,...ctrl1),centroids.push(...c1,...c1,...c1),bary.push(0,0,1,0,1,0,1,0,0)}}const geometry=new Geometry(gl);return geometry.addAttribute("position",{size:3,data:new Float32Array(positions)}),geometry.addAttribute("bary",{size:3,data:new Float32Array(bary)}),geometry.addAttribute("uv",{size:2,data:new Float32Array(uvs)}),geometry.addAttribute("offset",{size:1,data:new Float32Array(offsets)}),geometry.addAttribute("centroid1",{size:3,data:new Float32Array(centroids)}),geometry.addAttribute("control0",{size:3,data:new Float32Array(control0)}),geometry.addAttribute("control1",{size:3,data:new Float32Array(control1)}),geometry.addAttribute("random",{size:1,data:new Float32Array(randoms)}),geometry}const PI="float PI = 3.141592653589793238;",fragmentCommon="\nprecision highp float;\n\nuniform float time;\nuniform float progress;\nuniform sampler2D texture1;\nuniform sampler2D texture2;\nuniform vec4 resolution;\nvarying vec2 vUv;\n",vertexCommon="\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\nattribute float offset;\nattribute vec3 bary;\n\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform float progress;\nuniform vec4 resolution;\n\nvarying vec2 vUv;\nvarying float vProgress;\nvarying float vProgress1;\nvarying vec3 vBary;\n",vertexRotate="\nmat4 rotationMatrix(vec3 axis, float angle) {\n  axis = normalize(axis);\n  float s = sin(angle);\n  float c = cos(angle);\n  float oc = 1.0 - c;\n\n  return mat4(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,  0.0,\n              oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,  0.0,\n              oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c,           0.0,\n              0.0,                                0.0,                                0.0,                                1.0);\n}\nvec3 rotate(vec3 v, vec3 axis, float angle) {\n  mat4 m = rotationMatrix(axis, angle);\n  return (m * vec4(v, 1.0)).xyz;\n}\n",morphX={uniforms:{intensity:{value:1,type:"f",min:0,max:3}},fragment:`\n  ${fragmentCommon}\n  uniform float intensity;\n  uniform sampler2D displacement;\n  mat2 getRotM(float angle) {\n    float s = sin(angle);\n    float c = cos(angle);\n    return mat2(c, -s, s, c);\n  }\n  const float PI = 3.1415;\n  const float angle1 = PI *0.25;\n  const float angle2 = -PI *0.75;\n  void main()\t{\n    vec2 newUV = (vUv - vec2(0.5))*resolution.zw + vec2(0.5);\n    vec4 disp = texture2D(displacement, newUV);\n    vec2 dispVec = vec2(disp.r, disp.g);\n    vec2 distortedPosition1 = newUV + getRotM(angle1) * dispVec * intensity * progress;\n    vec4 t1 = texture2D(texture1, distortedPosition1);\n    vec2 distortedPosition2 = newUV + getRotM(angle2) * dispVec * intensity * (1.0 - progress);\n    vec4 t2 = texture2D(texture2, distortedPosition2);\n    gl_FragColor = mix(t1, t2, progress);\n  }\n`},morphY={uniforms:{intensity:{value:.3,type:"f",min:0,max:2}},fragment:`\n  ${fragmentCommon}\n  uniform float intensity;\n  uniform sampler2D displacement;\n  void main()\t{\n    vec2 newUV = (vUv - vec2(0.5))*resolution.zw + vec2(0.5);\n    vec4 d1 = texture2D(texture1, newUV);\n    vec4 d2 = texture2D(texture2, newUV);\n    float displace1 = (d1.r + d1.g + d1.b)*0.33;\n    float displace2 = (d2.r + d2.g + d2.b)*0.33;\n\n    vec4 t1 = texture2D(texture1, vec2(newUV.x, newUV.y + progress * (displace2 * intensity)));\n    vec4 t2 = texture2D(texture2, vec2(newUV.x, newUV.y + (1.0 - progress) * (displace1 * intensity)));\n    gl_FragColor = mix(t1, t2, progress);\n  }\n`},pageCurl={uniforms:{},fragment:`\n    ${fragmentCommon}\n    const float MIN_AMOUNT = -0.16;\n    const float MAX_AMOUNT = 1.5;\n\n    const float PI = 3.141592653589793;\n\n    const float scale = 512.0;\n    const float sharpness = 3.0;\n\n    const float cylinderRadius = 1.0 / PI / 2.0;\n\n    vec4 getFromColor(vec2 p) {\n      return texture2D(texture1, p);\n    }\n\n    vec4 getToColor(vec2 p) {\n      return texture2D(texture2, p);\n    }\n\n    vec3 hitPoint(float hitAngle, float yc, vec3 point, mat3 rrotation) {\n      float hitPoint = hitAngle / (2.0 * PI);\n      point.y = hitPoint;\n      return rrotation * point;\n    }\n\n    vec4 antiAlias(vec4 color1, vec4 color2, float distanc) {\n      distanc *= scale;\n      if(distanc < 0.0)\n        return color2;\n      if(distanc > 2.0)\n        return color1;\n      float dd = pow(1.0 - distanc / 2.0, sharpness);\n      return ((color2 - color1) * dd) + color1;\n    }\n\n    float distanceToEdge(vec3 point) {\n      float dx = abs(point.x > 0.5 ? 1.0 - point.x : point.x);\n      float dy = abs(point.y > 0.5 ? 1.0 - point.y : point.y);\n      if(point.x < 0.0)\n        dx = -point.x;\n      if(point.x > 1.0)\n        dx = point.x - 1.0;\n      if(point.y < 0.0)\n        dy = -point.y;\n      if(point.y > 1.0)\n        dy = point.y - 1.0;\n      if((point.x < 0.0 || point.x > 1.0) && (point.y < 0.0 || point.y > 1.0))\n        return sqrt(dx * dx + dy * dy);\n      return min(dx, dy);\n    }\n\n    vec4 seeThrough(float yc, vec2 p, mat3 rotation, mat3 rrotation, float cylinderAngle) {\n      float hitAngle = PI - (acos(yc / cylinderRadius) - cylinderAngle);\n      vec3 point = hitPoint(hitAngle, yc, rotation * vec3(p, 1.0), rrotation);\n      if(yc <= 0.0 && (point.x < 0.0 || point.y < 0.0 || point.x > 1.0 || point.y > 1.0)) {\n        return getToColor(p);\n      }\n\n      if(yc > 0.0)\n        return getFromColor(p);\n\n      vec4 color = getFromColor(point.xy);\n      vec4 tcolor = vec4(0.0);\n\n      return antiAlias(color, tcolor, distanceToEdge(point));\n    }\n\n    vec4 seeThroughWithShadow(float yc, vec2 p, vec3 point, mat3 rotation, mat3 rrotation, float cylinderAngle, float amount) {\n      float shadow = distanceToEdge(point) * 30.0;\n      shadow = (1.0 - shadow) / 3.0;\n\n      if(shadow < 0.0)\n        shadow = 0.0;\n      else\n        shadow *= amount;\n\n      vec4 shadowColor = seeThrough(yc, p, rotation, rrotation, cylinderAngle);\n      shadowColor.r -= shadow;\n      shadowColor.g -= shadow;\n      shadowColor.b -= shadow;\n\n      return shadowColor;\n    }\n\n    vec4 backside(float yc, vec3 point) {\n      vec4 color = getFromColor(point.xy);\n      float gray = (color.r + color.b + color.g) / 15.0;\n      gray += (8.0 / 10.0) * (pow(1.0 - abs(yc / cylinderRadius), 2.0 / 10.0) / 2.0 + (5.0 / 10.0));\n      color.rgb = vec3(gray);\n      return color;\n    }\n\n    vec4 behindSurface(vec2 p, float yc, vec3 point, mat3 rrotation, float cylinderAngle, float amount) {\n      float shado = (1.0 - ((-cylinderRadius - yc) / amount * 7.0)) / 6.0;\n      shado *= 1.0 - abs(point.x - 0.5);\n\n      yc = (-cylinderRadius - cylinderRadius - yc);\n\n      float hitAngle = (acos(yc / cylinderRadius) + cylinderAngle) - PI;\n      point = hitPoint(hitAngle, yc, point, rrotation);\n\n      if(yc < 0.0 && point.x >= 0.0 && point.y >= 0.0 && point.x <= 1.0 && point.y <= 1.0 && (hitAngle < PI || amount > 0.5)) {\n        shado = 1.0 - (sqrt(pow(point.x - 0.5, 2.0) + pow(point.y - 0.5, 2.0)) / (71.0 / 100.0));\n        shado *= pow(-yc / cylinderRadius, 3.0);\n        shado *= 0.5;\n      } else {\n        shado = 0.0;\n      }\n      return vec4(getToColor(p).rgb - shado, 1.0);\n    }\n\n    void main() {\n      vec2 newUV = (vUv - vec2(0.5)) * resolution.zw + vec2(0.5);\n\n      float amount = progress * (MAX_AMOUNT - MIN_AMOUNT) + MIN_AMOUNT;\n      float cylinderCenter = amount;\n          // 360 degrees * amount\n      float cylinderAngle = 2.0 * PI * amount;\n\n      const float angle = 100.0 * PI / 180.0;\n      float c = cos(-angle);\n      float s = sin(-angle);\n\n      mat3 rotation = mat3(c, s, 0, -s, c, 0, -0.801, 0.8900, 1);\n      c = cos(angle);\n      s = sin(angle);\n\n      mat3 rrotation = mat3(c, s, 0, -s, c, 0, 0.98500, 0.985, 1);\n\n      vec3 point = rotation * vec3(newUV, 1.0);\n\n      float yc = point.y - cylinderCenter;\n\n      if(yc < -cylinderRadius) {\n                        // Behind surface\n        gl_FragColor = behindSurface(newUV, yc, point, rrotation, cylinderAngle, amount);\n        return;\n      }\n\n      if(yc > cylinderRadius) {\n                        // Flat surface\n        gl_FragColor = getFromColor(newUV);\n        return;\n      }\n\n      float hitAngle = (acos(yc / cylinderRadius) + cylinderAngle) - PI;\n\n      float hitAngleMod = mod(hitAngle, 2.0 * PI);\n      if((hitAngleMod > PI && amount < 0.5) || (hitAngleMod > PI / 2.0 && amount < 0.0)) {\n        gl_FragColor = seeThrough(yc, newUV, rotation, rrotation, cylinderAngle);\n        return;\n      }\n\n      point = hitPoint(hitAngle, yc, point, rrotation);\n\n      if(point.x < 0.0 || point.y < 0.0 || point.x > 1.0 || point.y > 1.0) {\n        gl_FragColor = seeThroughWithShadow(yc, newUV, point, rotation, rrotation, cylinderAngle, amount);\n        return;\n      }\n\n      vec4 color = backside(yc, point);\n\n      vec4 otherColor;\n      if(yc < 0.0) {\n        float shado = 1.0 - (sqrt(pow(point.x - 0.5, 2.0) + pow(point.y - 0.5, 2.0)) / 0.71);\n        shado *= pow(-yc / cylinderRadius, 3.0);\n        shado *= 0.5;\n        otherColor = vec4(0.0, 0.0, 0.0, shado);\n      } else {\n        otherColor = getFromColor(newUV);\n      }\n\n      color = antiAlias(color, otherColor, cylinderRadius - abs(yc));\n\n      vec4 cl = seeThroughWithShadow(yc, newUV, point, rotation, rrotation, cylinderAngle, amount);\n      float dist = distanceToEdge(point);\n\n      gl_FragColor = antiAlias(color, cl, dist);\n    }\n  `},peelX={uniforms:{},fragment:`\n    ${fragmentCommon}\n    void main()\t{\n      vec2 newUV = (vUv - vec2(0.5))*resolution.zw + vec2(0.5);\n      vec2 p = newUV;\n      float x = progress;\n      x = smoothstep(.0,1.0,(x*2.0+p.x-1.0));\n      vec4 f = mix(\n        texture2D(texture1, (p-.5)*(1.-x)+.5),\n        texture2D(texture2, (p-.5)*x+.5),\n        x);\n      gl_FragColor = f;\n    }\n  `},peelY={uniforms:{},fragment:`\n    ${fragmentCommon}\n    void main()\t{\n      vec2 newUV = (vUv - vec2(0.5))*resolution.zw + vec2(0.5);\n      vec2 p = newUV;\n      float x = progress;\n      x = smoothstep(.0,1.0,(x*2.0+p.y-1.0));\n      vec4 f = mix(\n        texture2D(texture1, (p-.5)*(1.-x)+.5),\n        texture2D(texture2, (p-.5)*x+.5),\n        x);\n      gl_FragColor = f;\n    }\n  `},pixelize={uniforms:{},fragment:`\n    ${fragmentCommon}\n    ivec2 squaresMin = ivec2(50);\n    int steps = 20;\n\n    void main()\t{\n      vec2 newUV = (vUv - vec2(0.5))*resolution.zw + vec2(0.5);\n\n      float d = min(progress, 1.0 - progress);\n      float dist = steps>0 ? ceil(d * float(steps)) / float(steps) : d;\n      vec2 squareSize = 2.0 * dist / vec2(squaresMin);\n\n      vec2 p = dist>0.0 ? (floor(newUV / squareSize) + 0.5) * squareSize : newUV;\n\n      vec2 uv1 = newUV;\n      vec2 uv2 = newUV;\n\n      vec4 t1 = texture2D(texture1,p);\n      vec4 t2 = texture2D(texture2,p);\n\n      gl_FragColor = mix(t1, t2, progress);\n    }\n  `},polygonsFall={uniforms:{},detail:12,offsetTop:0,vertex:`\n    ${vertexCommon}\n    attribute vec3 centroid1;\n\n    ${vertexRotate}\n\n    void main() {\n      ${PI}\n      vUv = uv;\n      vBary = bary;\n\n      vec3 newpos = position;\n\n      float o = 1. - offset;\n      float pr = (progress - 0.5) * (0. + resolution.y / resolution.x) + 0.5;\n      pr = progress;\n      float prog = clamp((pr - o * 0.9) / 0.1, 0., 1.);\n      vProgress = prog;\n      vProgress1 = clamp((pr - clamp(o - 0.1, 0., 1.) * 0.9) / 0.1, 0., 1.);\n      newpos = rotate((newpos - centroid1), vec3(1., 0., 0.), -prog * PI) + centroid1 + vec3(0., -1., 0.) * prog * 0.;\n      gl_Position = projectionMatrix * modelViewMatrix * vec4(newpos, 1.0);\n    }\n  `,fragment:`\n    ${fragmentCommon}\n    varying float vProgress;\n    varying float vProgress1;\n    ${PI}\n    varying vec3 vBary;\n\n    void main()\t{\n      float width = 2.5 * vProgress1;\n      vec3 d;\n      #ifdef GL_OES_standard_derivatives\n        d = fwidth(vBary);\n      #endif\n      vec3 s = smoothstep(d * (width + 0.5), d * (width - 0.5), vBary);\n      float alpha = max(max(s.x, s.y), s.z);\n      vec3 color = vec3(alpha);\n      vec2 newUV = (vUv - vec2(0.5)) * resolution.zw + vec2(0.5);\n      vec4 t = texture2D(texture1, newUV);\n      float opa = smoothstep(1., 0.5, vProgress);\n      opa = 1. - vProgress;\n      gl_FragColor = vec4(vUv, 0.0, opa);\n      gl_FragColor = vec4(t.rgb + .5 * color * vProgress1, opa);\n    }\n  `},polygonsMorph={uniforms:{},detail:20,offsetTop:.4,vertex:`\n    ${vertexCommon}\n    ${vertexRotate}\n\n    void main() {\n      ${PI}\n      vUv = uv;\n      vBary = bary;\n\n      vec3 newpos = position;\n\n      float o = 1. - offset;\n      float prog = clamp((progress - o * 0.6) / 0.4, 0., 1.);\n      vProgress = prog;\n      vProgress1 = clamp((progress - clamp(o - 0.1, -0., 1.) * 0.9) / 0.1, 0., 1.);\n      gl_Position = projectionMatrix * modelViewMatrix * vec4(newpos, 1.0);\n    }\n  `,fragment:`\n    ${fragmentCommon}\n    varying float vProgress;\n    varying float vProgress1;\n    ${PI}\n    varying vec3 vBary;\n    void main()\t{\n      float width = 2.5 * vProgress1;\n      vec3 d;\n      #ifdef GL_OES_standard_derivatives\n        d = fwidth(vBary);\n      #endif\n      vec3 s = smoothstep(d * (width + 0.5), d * (width - 0.5), vBary);\n      float alpha = max(max(s.x, s.y), s.z);\n      vec3 color = vec3(alpha);\n\n      vec2 newUV = (vUv - vec2(0.5)) * resolution.zw + vec2(0.5);\n      vec4 t = texture2D(texture1, newUV);\n      float opa = smoothstep(1., 0.5, vProgress);\n      opa = 1. - vProgress;\n      gl_FragColor = vec4(t.rgb + 1. * color * vProgress1, opa);\n    }\n  `},polygonsWind={uniforms:{},detail:40,offsetTop:1,vertex:`\n    ${vertexCommon}\n    attribute vec3 control0;\n    attribute vec3 control1;\n\n    ${vertexRotate}\n\n    float easeOut(float t){\n      return  t * t * t;\n    }\n\n    vec3 bezier4(vec3 a, vec3 b, vec3 c, vec3 d, float t) {\n      return mix(mix(mix(a, b, t), mix(b, c, t), t), mix(mix(b, c, t), mix(c, d, t), t), t);\n    }\n\n    void main() {\n      ${PI}\n      vUv = uv;\n      vBary = bary;\n\n      vec3 newpos = position;\n\n      float o = 1. - offset;\n      float prog = clamp((progress - o * 0.6) / 0.4, 0., 1.);\n      vProgress = prog;\n      vProgress1 = clamp((progress - clamp(o - 0.2, -0., 1.) * 0.6) / 0.4, 0., 1.);\n      newpos = bezier4(newpos, control0, control1, newpos, easeOut(prog));\n      gl_Position = projectionMatrix * modelViewMatrix * vec4(newpos, 1.0);\n    }\n  `,fragment:`\n    ${fragmentCommon}\n    varying float vProgress;\n    varying float vProgress1;\n    ${PI}\n    varying vec3 vBary;\n    void main()\t{\n      float width = 2.5 * vProgress1;\n      vec3 d;\n      #ifdef GL_OES_standard_derivatives\n        d = fwidth(vBary);\n      #endif\n      vec3 s = smoothstep(d * (width + 0.5), d * (width - 0.5), vBary);\n      float alpha = max(max(s.x, s.y), s.z);\n      vec3 color = vec3(alpha);\n\n      vec2 newUV = (vUv - vec2(0.5)) * resolution.zw + vec2(0.5);\n      vec4 t = texture2D(texture1, newUV);\n      float opa = smoothstep(1., 0.5, vProgress);\n      opa = 1. - vProgress;\n      gl_FragColor = vec4(vUv, 0.0, opa);\n      opa = smoothstep(0.5, 1., opa);\n      gl_FragColor = vec4(t.rgb + 1. * color * vProgress1, opa);\n    }\n  `},ripple={uniforms:{radius:{value:.9,type:"f",min:.1,max:2},width:{value:.35,type:"f",min:0,max:1}},fragment:`\n    ${fragmentCommon}\n    uniform float width;\n    uniform float radius;\n    uniform sampler2D displacement;\n    float parabola( float x, float k ) {\n      return pow( 4. * x * ( 1. - x ), k );\n    }\n    void main()\t{\n      vec2 newUV = (vUv - vec2(0.5))*resolution.zw + vec2(0.5);\n      vec2 p = newUV;\n      vec2 start = vec2(0.5,0.5);\n      vec2 aspect = resolution.wz;\n      vec2 uv = newUV;\n      float dt = parabola(progress, 1.);\n      vec4 noise = texture2D(displacement, fract(vUv+time*0.04));\n      float prog = progress*0.66 + noise.g * 0.04;\n      float circ = 1. - smoothstep(-width, 0.0, radius * distance(start*aspect, uv*aspect) - prog*(1.+width));\n      float intpl = pow(abs(circ), 1.);\n      vec4 t1 = texture2D( texture1, (uv - 0.5) * (1.0 - intpl) + 0.5 ) ;\n      vec4 t2 = texture2D( texture2, (uv - 0.5) * intpl + 0.5 );\n      gl_FragColor = mix( t1, t2, intpl );\n    }\n  `},shutters={uniforms:{intensity:{value:50,type:"f",min:1,max:100}},fragment:`\n    ${fragmentCommon}\n    uniform float intensity;\n    mat2 rotate(float a) {\n      float s = sin(a);\n      float c = cos(a);\n      return mat2(c, -s, s, c);\n    }\n    const float PI = 3.1415;\n    const float angle1 = PI *0.25;\n    const float angle2 = PI *0.25;\n\n    void main()\t{\n      vec2 newUV = (vUv - vec2(0.5))*resolution.zw + vec2(0.5);\n\n      vec2 uvDivided = fract(newUV*vec2(intensity,1.));\n\n      vec2 uvDisplaced1 = newUV + rotate(angle1)*uvDivided*progress*0.1;\n      vec2 uvDisplaced2 = newUV + rotate(angle2)*uvDivided*(1. - progress)*0.1;\n\n      vec4 t1 = texture2D(texture1,uvDisplaced1);\n      vec4 t2 = texture2D(texture2,uvDisplaced2);\n\n      gl_FragColor = mix(t1, t2, progress);\n    }\n\n  `},slices={uniforms:{size:{value:.25,type:"f",min:.1,max:1}},fragment:`\n    ${fragmentCommon}\n    uniform float size; // = 0.2\n    float count = 20.; // = 10.0\n    float smoothness = .5; // = 0.5\n    void main()\t{\n      vec2 newUV = (vUv - vec2(0.5))*resolution.zw + vec2(0.5);\n\n      float pr = smoothstep(-smoothness, 0.0, newUV.x - progress * (1.0 + smoothness));\n      float s = step(pr, fract(count * newUV.x));\n\n      vec2 uv1 = newUV;\n      vec2 uv2 = newUV;\n\n      vec4 t1 = texture2D(texture1,uv1);\n      vec4 t2 = texture2D(texture2,uv2);\n      gl_FragColor = mix(t1, t2, s);\n\n    }\n  `},squares={uniforms:{},fragment:`\n    ${fragmentCommon}\n    ivec2 squares = ivec2(10,10);\n    vec2 direction = vec2(1.0, -0.5);\n    float smoothness = 1.6;\n\n    const vec2 center = vec2(0.5, 0.5);\n    void main() {\n      vec2 newUV = (vUv - vec2(0.5))*resolution.zw + vec2(0.5);\n\n      vec2 v = normalize(direction);\n      v /= abs(v.x)+abs(v.y);\n      float d = v.x * center.x + v.y * center.y;\n      float offset = smoothness;\n      float pr = smoothstep(-offset, 0.0, v.x * newUV.x + v.y * newUV.y - (d-0.5+progress*(1.+offset)));\n      vec2 squarep = fract(newUV*vec2(squares));\n      vec2 squaremin = vec2(pr/2.0);\n      vec2 squaremax = vec2(1.0 - pr/2.0);\n      float a = (1.0 - step(progress, 0.0)) * step(squaremin.x, squarep.x) * step(squaremin.y, squarep.y) * step(squarep.x, squaremax.x) * step(squarep.y, squaremax.y);\n\n      vec2 uv1 = newUV;\n      vec2 uv2 = newUV;\n\n      vec4 t1 = texture2D(texture1,newUV);\n      vec4 t2 = texture2D(texture2,newUV);\n\n      gl_FragColor = mix(t1, t2, a);\n    }\n  `},stretch={uniforms:{intensity:{value:50,type:"f",min:1,max:100}},fragment:`\n    ${fragmentCommon}\n    uniform float intensity;\n    mat2 rotate(float a) {\n      float s = sin(a);\n      float c = cos(a);\n      return mat2(c, -s, s, c);\n    }\n    const float PI = 3.1415;\n    const float angle1 = PI *0.25;\n    const float angle2 = -PI *0.75;\n    const float noiseSeed = 2.;\n    float random() {\n      return fract(sin(noiseSeed + dot(gl_FragCoord.xy / resolution.xy / 10.0, vec2(12.9898, 4.1414))) * 43758.5453);\n    }\n    float hash(float n) { return fract(sin(n) * 1e4); }\n    float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }\n    float hnoise(vec2 x) {\n      vec2 i = floor(x);\n      vec2 f = fract(x);\n      float a = hash(i);\n      float b = hash(i + vec2(1.0, 0.0));\n      float c = hash(i + vec2(0.0, 1.0));\n      float d = hash(i + vec2(1.0, 1.0));\n      vec2 u = f * f * (3.0 - 2.0 * f);\n      return mix(a, b, u.x) + (c - a) * u.y * (1.0 - u.x) + (d - b) * u.x * u.y;\n    }\n    void main()\t{\n      vec2 newUV = (vUv - vec2(0.5))*resolution.zw + vec2(0.5);\n\n      float hn = hnoise(newUV.xy * resolution.xy / 100.0);\n      vec2 d = vec2(0.,normalize(vec2(0.5,0.5) - newUV.xy).y);\n      vec2 uv1 = newUV + d * progress / 5.0 * (1.0 + hn / 2.0);\n      vec2 uv2 = newUV - d * (1.0 - progress) / 5.0 * (1.0 + hn / 2.0);\n      vec4 t1 = texture2D(texture1,uv1);\n      vec4 t2 = texture2D(texture2,uv2);\n      gl_FragColor = mix(t1, t2, progress);\n    }\n  `},waveX={uniforms:{},fragment:`\n  ${fragmentCommon}\n  uniform sampler2D displacement;\n  vec2 mirrored(vec2 v) {\n    vec2 m = mod(v,2.);\n    return mix(m,2.0 - m, step(1.0 ,m));\n  }\n  void main()\t{\n    vec2 newUV = (vUv - vec2(0.5))*resolution.zw + vec2(0.5);\n    vec4 noise = texture2D(displacement, mirrored(newUV+time*0.04));\n    float prog = (1.0 - progress)*0.8 -0.05 + noise.g * 0.06;\n    float intpl = pow(abs(smoothstep(0., 1., (prog*2. - vUv.x + 0.5))), 10.);\n\n    vec4 t1 = texture2D( texture2, (newUV - 0.5) * (1.0 - intpl) + 0.5 ) ;\n    vec4 t2 = texture2D( texture1, (newUV - 0.5) * intpl + 0.5 );\n    gl_FragColor = mix( t1, t2, intpl );\n  }\n  `},wind={uniforms:{},fragment:`\n    ${fragmentCommon}\n    float size = 0.2;\n\n    float rand (vec2 co) {\n      return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);\n    }\n\n    void main()\t{\n      vec2 newUV = (vUv - vec2(0.5))*resolution.zw + vec2(0.5);\n\n      float r = rand(vec2(0, newUV.y));\n      float m = smoothstep(0.0, -size, newUV.x*(1.0-size) + size*r - ((progress) * (1.0 + size)));\n\n      vec2 uv1 = newUV;\n      vec2 uv2 = newUV;\n\n      vec4 t1 = texture2D(texture1,uv1);\n      vec4 t2 = texture2D(texture2,uv2);\n      gl_FragColor = mix(t1, t2, m);\n\n    }\n  `},dots={uniforms:{},fragment:`\n    ${fragmentCommon}\n    const float SQRT_2 = 1.414213562373;\n    const vec2 center = vec2(0, 0);// = vec2(0, 0);\n    const float dots = 20.0;// = 20.0;\n\n    vec4 getFromColor(vec2 p) {\n      return texture2D(texture1, p);\n    }\n\n    vec4 getToColor(vec2 p) {\n      return texture2D(texture2, p);\n    }\n\n    void main()\t{\n      vec2 newUV = (vUv - vec2(0.5))*resolution.zw + vec2(0.5);\n\n      bool nextImage = distance(fract(newUV * dots), vec2(0.5, 0.5)) < ( progress / distance(newUV, center));\n      gl_FragColor = nextImage ? getToColor(newUV) : getFromColor(newUV);\n    }\n\n  `},flyeye={uniforms:{},fragment:`\n    ${fragmentCommon}\n    const float size = 0.04; // = 0.04\n    const float zoom = 100.0; // = 50.0\n    const float colorSeparation = 0.3; // = 0.3\n\n    vec4 getFromColor(vec2 p) {\n      return texture2D(texture1, p);\n    }\n\n    vec4 getToColor(vec2 p) {\n      return texture2D(texture2, p);\n    }\n\n    void main()\t{\n      vec2 newUV = (vUv - vec2(0.5))*resolution.zw + vec2(0.5);\n\n      float inv = 1. - progress;\n      vec2 disp = size*vec2(cos(zoom*newUV.x), sin(zoom*newUV.y));\n      vec4 texTo = getToColor(newUV + inv*disp);\n      vec4 texFrom = vec4(\n        getFromColor(newUV + progress*disp*(1.0 - colorSeparation)).r,\n        getFromColor(newUV + progress*disp).g,\n        getFromColor(newUV + progress*disp*(1.0 + colorSeparation)).b,\n        1.0);\n      gl_FragColor = texTo*progress + texFrom*inv;\n    }\n\n  `},shaders={dots:dots,flyeye:flyeye,"morph-x":morphX,"morph-y":morphY,"page-curl":pageCurl,"peel-x":peelX,"peel-y":peelY,"polygons-fall":polygonsFall,"polygons-morph":polygonsMorph,"polygons-wind":polygonsWind,pixelize:pixelize,ripple:ripple,shutters:shutters,slices:slices,squares:squares,stretch:stretch,"wave-x":waveX,wind:wind},defaultVertex="\nattribute vec2 uv;\nattribute vec3 position;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nvarying vec2 vUv;\n\nvoid main() {\n  vUv = uv;\n  gl_Position = projectionMatrix * modelViewMatrix * vec4(position, 1.0);\n}\n",getRandomShader=(arr,opts)=>{const{shaderPerSlide:shaderPerSlide,swiper:swiper}=opts,index=swiper.params.loop?swiper.realIndex:swiper.activeIndex;let allShaders=shaders;if(Array.isArray(arr)&&arr.length){if(shaderPerSlide)return void 0===arr[index]?shaders[arr[0]]:shaders[arr[index]];allShaders={},Object.keys(shaders).forEach(key=>{arr.includes(key)&&(allShaders[key]=shaders[key])})}const keyIndex=Math.floor(Math.random()*Object.keys(allShaders).length);return allShaders[Object.keys(allShaders)[keyIndex]]};class GL{constructor(opts){const shader="random"===opts.shader||Array.isArray(opts.shader)?getRandomShader(opts.shader,opts):shaders[opts.shader];this.shader=shader,this.displacement=opts.displacementMap||displacement,this.scene=new Transform,this.swiper=opts.swiper,this.vertex=shader.vertex||defaultVertex,this.fragment=shader.fragment,this.uniforms=shader.uniforms||{},this.renderer=new Renderer({dpr:2,webgl:2,alpha:!0}),this.gl=this.renderer.gl,this.width=window.innerWidth,this.height=window.innerHeight,this.renderer.setSize(this.width,this.height),this.gl.clearColor(1,1,1,0),this.gl.clear(this.gl.COLOR_BUFFER_BIT),this.opts=opts,this.container=this.swiper.el,this.displacementTexture=null,this.width=this.swiper.width,this.height=this.swiper.height,this.swiper.isElement&&(this.gl.canvas.setAttribute("slot","container-start"),this.swiper.hostEl.classList.add("swiper-gl")),this.container.prepend(this.gl.canvas),this.camera=new Camera(this.gl,{fov:45}),this.camera.perspective({aspect:this.gl.canvas.width/this.gl.canvas.height}),this.camera.position.set(0,0,2),this.time=0,this.current=0,this.init(()=>{this.addObjects(),this.resize(),this.render()})}animateUniform(uniform,targetValue,cb){const startPosition=uniform.value;let startTime=null,time;window.cancelAnimationFrame(this.animateUniformFrame);const dir=targetValue>uniform.value?"next":"prev",isOutOfBound=(current,target)=>"next"===dir&&current>=target||"prev"===dir&&current<=target,animate=()=>{if(this.destroyed)return;time=(new Date).getTime(),null===startTime&&(startTime=time);const progress=Math.max(Math.min((time-startTime)/this.swiper.params.speed,1),0),easeProgress=.5-Math.cos(progress*Math.PI)/2;let currentPosition=startPosition+easeProgress*(targetValue-startPosition);if(isOutOfBound(currentPosition,targetValue)&&(currentPosition=targetValue),uniform.value=currentPosition,isOutOfBound(currentPosition,targetValue))return cancelAnimationFrame(this.animateUniformFrame),void(cb&&cb());this.animateUniformFrame=requestAnimationFrame(animate)};animate()}loadTextures(){const promises=[],that=this;this.images=[],this.textures=[];const container=this.swiper&&this.swiper.isElement?this.swiper.hostEl:this.container;return container.querySelectorAll(".swiper-gl-image").forEach(img=>{this.images.push(img.src)}),this.images.forEach((url,i)=>{const promise=new Promise(resolve=>{const img=new Image;img.crossOrigin="anonymous";const texture=new Texture(this.gl);img.onload=()=>{texture.image=img,that.textures[i]=texture,resolve()},img.src=url});promises.push(promise)}),promises.push(new Promise(resolve=>{const img=new Image;img.crossOrigin="anonymous";const texture=new Texture(this.gl);img.onload=()=>{texture.image=img,that.displacementTexture=texture,resolve()},img.src=displacement})),Promise.all(promises)}init(cb){this.loadTextures().then(()=>{this.initialized=!0,this.onInit&&this.onInit(),cb()})}resize(){if(!this.initialized||this.destroyed)return;const{width:width,height:height}=this.swiper;this.width=width,this.height=height,this.renderer.setSize(width,height);const dist=this.camera.position.z;if(this.camera.perspective({aspect:width/height,fov:180/Math.PI*2*Math.atan(1/(2*dist))}),!this.textures[0].image)return;const imageAspect=this.textures[0].image.height/this.textures[0].image.width;let a1,a2;height/width>imageAspect?(a1=width/height*imageAspect,a2=1):(a1=1,a2=height/width/imageAspect),this.material.uniforms.resolution.value.x=width,this.material.uniforms.resolution.value.y=height,this.material.uniforms.resolution.value.z=a1,this.material.uniforms.resolution.value.w=a2,this.shader.vertex&&this.vertexMaterial&&(this.vertexMaterial.uniforms.resolution.value.x=width,this.vertexMaterial.uniforms.resolution.value.y=height,this.vertexMaterial.uniforms.resolution.value.z=a1,this.vertexMaterial.uniforms.resolution.value.w=a2),this.shader.vertex?(this.nextMesh.scale.set(this.camera.aspect/2,.5,.5),this.currentMesh.scale.set(this.camera.aspect/2,.5,.5)):(this.plane.scale.x=this.camera.aspect,this.plane.scale.y=1)}createMaterial(){return new Program(this.gl,{extensions:{derivatives:"#extension GL_OES_standard_derivatives : enable"},uniforms:{time:{type:"f",value:0},progress:{type:"f",value:0},intensity:{type:"f",value:0},width:{type:"f",value:0},radius:{type:"f",value:0},size:{type:"f",value:0},texture1:{type:"f",value:this.textures[0]},texture2:{type:"f",value:this.textures[1]},displacement:{type:"f",value:this.displacementTexture},resolution:{type:"v4",value:new Vec4}},vertex:this.shader.vertex||defaultVertex,fragment:this.shader.fragment,...this.shader.vertex?{transparent:!0,depthWrite:!1}:{}})}addObjects(){if(this.scene.children.forEach(child=>{this.scene.removeChild(child)}),this.scene.children.forEach(child=>{this.scene.removeChild(child)}),this.material=this.createMaterial(),this.shader.vertex){const geometry=getGeometry(this.gl,this.shader.detail,this.shader.offsetTop),texture=this.textures[1];this.vertexMaterial=this.createMaterial(),this.vertexMaterial.uniforms.texture1.value=texture,this.currentMesh=new Mesh(this.gl,{geometry:geometry,program:this.material}),this.nextMesh=new Mesh(this.gl,{geometry:geometry,program:this.vertexMaterial}),this.nextMesh.position.z=-1e-4,this.currentMesh.setParent(this.scene),this.nextMesh.setParent(this.scene)}else{const geometry=new Plane(this.gl,{width:1,height:1,widthSegments:2,heightSegments:2});this.plane=new Mesh(this.gl,{geometry:geometry,program:this.material}),this.plane.setParent(this.scene)}}replaceShader(newShaderName){let fromTexture,newTexture;this.shader.vertex?(fromTexture=this.material.uniforms.texture1.value,newTexture=this.vertexMaterial.uniforms.texture1.value):(fromTexture=this.material.uniforms.texture1.value,newTexture=this.material.uniforms.texture2.value);const shader="random"===newShaderName||Array.isArray(newShaderName)?getRandomShader(newShaderName,this.opts):shaders[newShaderName],{fragment:fragment,uniforms:uniforms,vertex:vertex}=shader;this.shader=shader,this.vertex=vertex||defaultVertex,this.fragment=fragment||"",this.uniforms=uniforms||{},this.addObjects(),this.shader.vertex?(this.material.uniforms.texture1.value=newTexture,this.vertexMaterial.uniforms.texture1.value=newTexture):(this.material.uniforms.texture1.value=fromTexture,this.material.uniforms.texture2.value=newTexture,this.material.uniforms.progress.value=1),this.resize(),this.swiper.params.gl.shader=newShaderName}replaceRandomShader(){const shader=getRandomShader(this.opts.shader,this.opts),{fragment:fragment,uniforms:uniforms,vertex:vertex}=shader;this.shader=shader,this.fragment=fragment||"",this.uniforms=uniforms||{},this.vertex=vertex||defaultVertex,this.addObjects(),this.resize()}setProgress(fromIndex,toIndex,progress,needsTransitionDuration,needShaderReplace){if(this.destroyed||this.swiper.glDestroyed)return;if(!this.initialized)return void(this.onInit=()=>{requestAnimationFrame(()=>{this.setProgress(fromIndex,toIndex,progress,needsTransitionDuration)})});this.swiper.params.loop&&this.swiper.slides[fromIndex]&&this.swiper.slides[toIndex]&&(fromIndex=parseInt(this.swiper.slides[fromIndex].getAttribute("data-swiper-slide-index"),10),toIndex=parseInt(this.swiper.slides[toIndex].getAttribute("data-swiper-slide-index"),10));const newTexture=this.textures[toIndex],fromTexture=this.textures[fromIndex];if(this.material.uniforms.texture1.value=fromTexture,this.shader.vertex?this.vertexMaterial.uniforms.texture1.value=newTexture:this.material.uniforms.texture2.value=newTexture,needShaderReplace){if(this.preventShaderReplace)return void(this.material.uniforms.progress.value=Math.abs(progress));this.preventShaderReplace=!0,requestAnimationFrame(()=>{this.preventShaderReplace=!1}),"random"===this.swiper.params.gl.shader||Array.isArray(this.swiper.params.gl.shader)?(this.replaceRandomShader(),this.material.uniforms.texture1.value=fromTexture,this.material.uniforms.texture2.value=newTexture,this.material.uniforms.progress.value=Math.abs(progress)):this.material.uniforms.progress.value=Math.abs(progress)}else needsTransitionDuration?(0===progress&&0===this.material.uniforms.progress.value&&(this.material.uniforms.progress.value=1),1===progress&&1===this.material.uniforms.progress.value&&(this.material.uniforms.progress.value=0),this.animateUniform(this.material.uniforms.progress,progress,()=>{("random"===this.swiper.params.gl.shader||Array.isArray(this.swiper.params.gl.shader))&&(this.replaceRandomShader(),this.material.uniforms.texture1.value=fromTexture,this.material.uniforms.texture2.value=newTexture,this.material.uniforms.progress.value=progress),1===progress&&(this.material.uniforms.texture1.value=newTexture),this.material.uniforms.progress.value=0})):this.material.uniforms.progress.value=Math.abs(progress)}render(){this.swiper.destroyed||this.destroyed||(this.time+=.05,this.material.uniforms.time.value=this.time,Object.keys(this.uniforms).forEach(item=>{this.material.uniforms[item].value=this.uniforms[item].value}),requestAnimationFrame(this.render.bind(this)),this.renderer.render({scene:this.scene,camera:this.camera}))}destroy(){this.initialized=!1,this.destroyed=!0,this.gl&&this.gl.canvas&&this.container.removeChild(this.gl.canvas)}}function WPCPSwiperGL({swiper:swiper,on:on,extendParams:extendParams}){swiper.gl=null;let noWebGLSupport=!1;function supportsWebGL(){try{const canvas=document.createElement("canvas");return!!window.WebGLRenderingContext&&(canvas.getContext("webgl")||canvas.getContext("experimental-webgl"))}catch(e){return!1}}extendParams({gl:{shader:"random",shaderPerSlide:!1,displacementMap:void 0}});const glInit=()=>{swiper.gl=new GL({swiper:swiper,shader:swiper.params.gl.shader,shaderPerSlide:swiper.params.gl.shaderPerSlide})};let needsTransitionDuration,previousProgress;on("beforeInit",()=>{if("gl"!==swiper.params.effect)return;if(!supportsWebGL())return void(noWebGLSupport=!0);swiper.classNames.push(`${swiper.params.containerModifierClass}gl`);const overwriteParams={watchSlidesProgress:!0};Object.assign(swiper.params,overwriteParams),Object.assign(swiper.originalParams,overwriteParams)}),on("init",()=>{"gl"!==swiper.params.effect||noWebGLSupport||swiper.glDestroyed||swiper.gl||glInit()}),on("resize",()=>{"gl"!==swiper.params.effect||noWebGLSupport||swiper.glDestroyed||swiper.gl.resize()}),on("setTranslate",()=>{if("gl"!==swiper.params.effect||noWebGLSupport||swiper.glDestroyed)return;let from,to,transitionProgress;swiper.gl||glInit();let needShaderReplace=!1,targetIndex;if(swiper.slides.forEach((slideEl,slideIndex)=>{const progress=slideEl.progress;swiper.params.cssMode&&0===Math.round(100*progress)&&(needShaderReplace=!0),(progress>0&&progress<1||0===progress&&swiper.progress<previousProgress)&&(from=slideIndex,to=slideIndex+1,transitionProgress=progress,targetIndex=from),(progress<0&&progress>-1||0===progress&&swiper.progress>previousProgress)&&(from=slideIndex-1,to=slideIndex,transitionProgress=1+progress,targetIndex=to)}),previousProgress=swiper.progress||0,void 0===from&&void 0===to)return;needShaderReplace=needShaderReplace&&Math.round(transitionProgress)===transitionProgress;const newFrom=Math.min(targetIndex,swiper.activeIndex),newTo=Math.max(targetIndex,swiper.activeIndex);swiper.params.loop||newTo===newFrom||(from=newFrom,to=newTo),swiper.gl.setProgress(from,to,transitionProgress,needsTransitionDuration,needShaderReplace)}),on("setTransition",(_s,duration)=>{"gl"!==swiper.params.effect||noWebGLSupport||swiper.glDestroyed||(needsTransitionDuration=duration>0&&!swiper.params.cssMode)}),on("slidesGridLengthChange",()=>{"gl"!==swiper.params.effect||noWebGLSupport||!swiper.initialized||swiper.glDestroyed||swiper.gl&&swiper.gl.loadTextures&&swiper.gl.loadTextures()}),on("beforeDestroy",()=>{"gl"!==swiper.params.effect||noWebGLSupport||swiper.gl&&(swiper.glDestroyed=!0,swiper.gl.destroy(),swiper.gl=null)})}return"undefined"!=typeof window&&window.WPCPSwiperElementRegisterParams&&window.WPCPSwiperElementRegisterParams(["gl"]),WPCPSwiperGL}));