<?php
defined( 'ABSPATH' ) || die( 'Cheatin&#8217; uh?' );

/**
 * Excludes WP Rocket from WP updates
 *
 * @since 1.0
 *
 * @param array  $request An array of HTTP request arguments.
 * @param string $url The request URL.
 * @return array Updated array of HTTP request arguments.
 */
function rocket_updates_exclude( $request, $url ) {
	if ( ! is_string( $url ) ) {
		return $request;
	}

	if ( 0 !== strpos( $url, 'http://api.wordpress.org/plugins/update-check' ) || ! isset( $request['body']['plugins'] ) ) {
		return $request; // Not a plugin update request. Stop immediately.
	}

	$plugins = maybe_unserialize( $request['body']['plugins'] );

	if ( isset( $plugins->plugins[ plugin_basename( WP_ROCKET_FILE ) ], $plugins->active[ array_search( plugin_basename( WP_ROCKET_FILE ), $plugins->active, true ) ] ) ) {
		unset( $plugins->plugins[ plugin_basename( WP_ROCKET_FILE ) ] );
		unset( $plugins->active[ array_search( plugin_basename( WP_ROCKET_FILE ), $plugins->active, true ) ] );
	}

	$request['body']['plugins'] = maybe_serialize( $plugins );
	return $request;
}
add_filter( 'http_request_args', 'rocket_updates_exclude', 5, 2 );

/**
 * Hack the returned object
 *
 * @since 1.0
 *
 * @param false|object|array $bool The result object or array. Default false.
 * @param string             $action The type of information being requested from the Plugin Install API.
 * @param object             $args Plugin API arguments.
 * @return false|object|array Empty object if slug is WP Rocket, default value otherwise
 */
function rocket_force_info( $bool, $action, $args ) {
	if ( 'plugin_information' === $action && 'wp-rocket' === $args->slug ) {
		return new stdClass();
	}
	return $bool;
}
add_filter( 'plugins_api', 'rocket_force_info', 10, 3 );
