<?php
defined( 'ABSPATH' ) || die( 'Cheatin&#8217; uh?' );

/**
 * When WP deletes the update_plugins site transient or updates the plugins, we delete our own transients to avoid another 12 hours waiting
 *
 * @since 2.6.8
 *
 * @param string $transient Transient name.
 * @param object $value Transient object.
 */
function rocket_reset_check_update_timer( $transient = 'update_plugins', $value = null ) {
	// $value used by setted.
	if ( 'update_plugins' === $transient ) {
		if ( is_null( $value ) || is_object( $value ) && ! isset( $value->response ) ) {
			delete_site_transient( 'update_wprocket' );
		}
	}
}
add_action( 'wp_update_plugins', 'rocket_reset_check_update_timer', 9 ); // WP Cron.
add_action( 'deleted_site_transient', 'rocket_reset_check_update_timer' );
add_action( 'setted_site_transient', 'rocket_reset_check_update_timer' );
