<?php
/**
 * Dashboard section template.
 *
 * @since 3.0
 *
 * @param array {
 *     Section arguments.
 *
 *     @type string $id    Page section identifier.
 *     @type string $title Page section title.
 *     @type array  $faq   {
 *         Items to populate the FAQ section.
 *
 *         @type string $id    Documentation item ID.
 *         @type string $url   Documentation item URL.
 *         @type string $title Documentation item title.
 *     }
 *     @type object $customer_data WP Rocket customer data.
 * }
 */

defined( 'ABSPATH' ) || die( 'Cheatin&#8217; uh?' );
?>
<div id="<?php echo esc_attr( $data['id'] ); ?>" class="wpr-Page">
	<div class="wpr-sectionHeader">
		<h2 class="wpr-title1 wpr-icon-home"><?php echo esc_html( $data['title'] ); ?></h2>
	</div>

	<?php
	$rocket_boxes = get_user_meta( get_current_user_id(), 'rocket_boxes', true );
    ?>

	<div class="wpr-Page-row">
		<div class="wpr-Page-col wpr-Page-col">
			<div class="wpr-optionHeader">
				<h3 class="wpr-title2"><?php esc_html_e( 'Quick Actions', 'rocket' ); ?></h3>
			</div>

			<div class="wpr-fieldsContainer">
				<fieldset class="wpr-fieldsContainer-fieldset">
					<div class="wpr-field">
						<h4 class="wpr-title3"><?php esc_html_e( 'Remove all cached files', 'rocket' ); ?></h4>
						<?php
						$this->render_action_button(
							'link',
							'purge_cache',
							[
								'label'      => __( 'Clear cache', 'rocket' ),
								'parameters' => [
									'type' => 'all',
								],
								'attributes' => [
									'class' => 'wpr-button wpr-button--icon wpr-button--small wpr-icon-trash',
								],
							]
						);
						?>
					</div>

					<?php if ( get_rocket_option( 'manual_preload' ) ) : ?>
					<div class="wpr-field">
						<h4 class="wpr-title3"><?php esc_html_e( 'Start cache preloading', 'rocket' ); ?></h4>
						<?php
						$this->render_action_button(
							'link',
							'preload',
							[
								'label'      => __( 'Preload cache', 'rocket' ),
								'attributes' => [
									'class' => 'wpr-button wpr-button--icon wpr-button--small wpr-icon-refresh',
								],
							]
						);
						?>
					</div>
					<?php endif; ?>

					<?php if ( function_exists( 'opcache_reset' ) ) : ?>
					<div class="wpr-field">
						<h4 class="wpr-title3"><?php esc_html_e( 'Purge OPCache content', 'rocket' ); ?></h4>
						<?php
						$this->render_action_button(
							'link',
							'rocket_purge_opcache',
							[
								'label'      => __( 'Purge OPCache', 'rocket' ),
								'attributes' => [
									'class' => 'wpr-button wpr-button--icon wpr-button--small wpr-icon-trash',
								],
							]
						);
						?>
					</div>
					<?php endif; ?>
					<?php if ( get_rocket_option( 'async_css' ) && apply_filters( 'do_rocket_critical_css_generation', true ) ) : ?>
					<div class="wpr-field">
						<h4 class="wpr-title3"><?php esc_html_e( 'Regenerate Critical CSS', 'rocket' ); ?></h4>
						<?php
						$this->render_action_button(
							'link',
							'rocket_generate_critical_css',
							[
								'label'      => __( 'Regenerate Critical CSS', 'rocket' ),
								'attributes' => [
									'class' => 'wpr-button wpr-button--icon wpr-button--small wpr-icon-refresh',
								],
							]
						);
						?>
					</div>
					<?php endif; ?>
				</fieldset>
			</div>
		</div>
	</div>
	<div class="wpr-Page-row">
		<div class="wpr-Page-col">
			<div class="wpr-optionHeader">
				<h3 class="wpr-title2"><?php esc_html_e( 'Frequently Asked Questions', 'rocket' ); ?></h3>
			</div>
			<fieldset class="wpr-fieldsContainer-fieldset">
				<div class="wpr-field">
					<ul class="wpr-field-list">
					<?php foreach ( $data['faq'] as $rocket_faq_item ) : ?>
						<li class="wpr-icon-information"><a href="<?php echo esc_url( $rocket_faq_item['url'] ); ?>" data-beacon-article="<?php echo esc_attr( $rocket_faq_item['id'] ); ?>" target="_blank"><?php echo esc_html( $rocket_faq_item['title'] ); ?></a></li>
					<?php endforeach; ?>
					</ul>
				</div>
				<div class="wpr-field">
					<div class="wpr-flex wpr-flex--egal">
						<div>
							<h3 class="wpr-title2"><?php esc_html_e( 'Still cannot find a solution?', 'rocket' ); ?></h3>
							<p class="wpr-field-description"><?php esc_html_e( 'Submit a ticket and get help from our friendly and knowledgeable Rocketeers.', 'rocket' ); ?></p>
						</div>
						<div>
							<?php
							$this->render_action_button(
								'link',
								'ask_support',
								[
									'label'      => __( 'Ask support', 'rocket' ),
									'attributes' => [
										'class'  => 'wpr-button wpr-button--icon wpr-button--small wpr-button--blue wpr-icon-help wpr-js-askSupport',
										'target' => '_blank',
									],
								]
							);
							?>
						</div>
					</div>
				</div>
			</fieldset>
		</div>

		<div class="wpr-Page-col wpr-Page-col--fixed">
			<?php $this->render_part( 'documentation' ); ?>
		</div>
	</div>
</div>
