<?php
/**
 * Frontend class
 *
 * @package YITH\AddedToCartPopup\Frontend
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

if ( ! class_exists( 'YITH_WACP_Frontend' ) ) {
	/**
	 * Frontend class.
	 * The class manage all the frontend behaviors.
	 *
	 * @class   YITH_WACP_Frontend
	 * @since   1.0.0
	 * @author  YITH <plugins@yithemes.com>
	 * @package YITH\AddedToCartPopup\Frontend
	 */
	class YITH_WACP_Frontend {

		use YITH_WACP_Trait_Singleton;

		/**
		 * Constructor
		 *
		 * @access public
		 * @since  1.0.0
		 */
		public function __construct() {
			add_action( 'wp_footer', array( $this, 'load_template' ) );
		}


		/**
		 * Load popup template
		 *
		 * @return void
		 * @since  1.0.0
		 */
		public function load_template() {

			/**
			 * APPLY_FILTERS: yith_wacp_popup_template_args
			 *
			 * Handles popup template args.
			 *
			 * @param array $args The popup template arguments.
			 */
			$args = apply_filters( 'yith_wacp_popup_template_args', array( 'animation' => 'fade-in' ) );

			/**
			 * APPLY_FILTERS: yith_wacp_load_popup_template
			 *
			 * Handles popup template args.
			 *
			 * @param boolean $value The popup should be displayed?
			 */
			if ( apply_filters( 'yith_wacp_load_popup_template', true ) ) {
				wc_get_template( 'yith-wacp-popup.php', $args, '', YITH_WACP_TEMPLATE_PATH . '/' );
			}

		}

	}
}
