<?php
/**
 * Customization tab array
 *
 * @package YITH\AddedToCartPopup\PluginOptions
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

$customization = array(
	'customization' => array(
		'customization-tab-options' => array(
			'type'     => 'multi_tab',
			'sub-tabs' => array(
				'customization-popup-design'      => array(
					'title' => esc_html__( 'Popup Design', 'yith-woocommerce-added-to-cart-popup' ),
                    'description' => esc_html__( 'Customize the added cart popup design', 'yith-woocommerce-added-to-cart-popup' ),
				),
				'customization-added-notice'      => array(
					'title' => esc_html__( 'Added Notice', 'yith-woocommerce-added-to-cart-popup' ),
                    'description' => esc_html__( 'Customize the notice to show when a product in added in cart', 'yith-woocommerce-added-to-cart-popup' ),
				),
				'customization-products-table'    => array(
					'title' => esc_html__( 'Products Table', 'yith-woocommerce-added-to-cart-popup' ),
                    'description' => esc_html__( 'Customize the products table shown in the cart popup', 'yith-woocommerce-added-to-cart-popup' ),
				),
				'customization-cart-total'        => array(
					'title' => esc_html__( 'Cart Total', 'yith-woocommerce-added-to-cart-popup' ),
                    'description' => esc_html__( 'Customize the cart total section', 'yith-woocommerce-added-to-cart-popup' ),
				),
				'customization-buttons'           => array(
					'title' => esc_html__( 'Buttons', 'yith-woocommerce-added-to-cart-popup' ),
                    'description' => esc_html__( 'Style options for buttons shown in the cart popup', 'yith-woocommerce-added-to-cart-popup' ),
				),
				'customization-upsell-cross-sell' => array(
					'title' => esc_html__( 'Upsell & Cross-sell', 'yith-woocommerce-added-to-cart-popup' ),
                    'description' => esc_html__( 'Customize the upsell/cross-sell section shown in the cart popup', 'yith-woocommerce-added-to-cart-popup' ),
				),
			),
		),
	),
);

/**
 * APPLY_FILTERS: yith_wacp_customization_tab_options
 *
 * Customize tab options.
 *
 * @param array $customization Options array.
 */
return apply_filters( 'yith_wacp_customization_tab_options', $customization );
