<?php
/**
 * Popup product template
 *
 * @package YITH\AddedToCartPopup\Templates
 * @var $last_cart_item_key string The last item cart key added.
 * @var $product            WC_Product The product added
 * @var $thumb              boolean Check if thumbnail should be displayed.
 * @var $product_info       boolean Check if product info should be displayed.
 * @var $quantity           array The quantity added.
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

// Get cart.
$cart = WC()->cart->get_cart();
// Get current cart item.
$cart_item = WC()->cart->get_cart_item( $last_cart_item_key );
if ( ! $cart_item ) {
	foreach ( WC()->cart->get_cart_contents() as $key => $item ) {
		$p_id = $product instanceof WC_Product ? $product->get_id() : false;
		if ( $item['product_id'] === $p_id || $item['variation_id'] === $p_id ) {
			$cart_item = $item;
			break;
		}
	}
}

$kses_defaults = wp_kses_allowed_html( 'post' );
$svg_args      = array(
	'svg'   => array(
		'class'           => true,
		'aria-hidden'     => true,
		'aria-labelledby' => true,
		'role'            => true,
		'xmlns'           => true,
		'width'           => true,
		'height'          => true,
		'viewbox'         => true, // <= Must be lower case!
	),
	'g'     => array( 'fill' => true ),
	'title' => array( 'title' => true ),
	'path'  => array(
		'd'    => true,
		'fill' => true,
	),
);
$allowed_tags  = array_merge( $kses_defaults, $svg_args );

?>
<div class="yith-wacp-added-product">
	<?php if ( $thumb && $product instanceof WC_Product ) : ?>
		<div class="product-thumb">
			<?php
			$thumbnail = $product->get_image( 'yith_wacp_image_size' );
			echo wp_kses( ! $product->is_visible() ? $thumbnail : sprintf( '<a href="%s" target="_blank">%s</a>', esc_url( $product->get_permalink() ), $thumbnail ), $allowed_tags );
			?>
		</div>
	<?php endif; ?>

	<?php if ( $product_info ) : ?>
		<div class="info-box">
			<div class="product-info">
				<h3 class="product-title">
					<a href="<?php echo esc_url( $product->get_permalink() ); ?>">
						<?php echo wp_kses_post( $product->get_name() ); ?>
					</a>
				</h3>
				<span class="product-price">
					<?php
					$price_html = '';
					if ( $product->is_type( 'yith_bundle' ) && class_exists( 'YITH_WCPB_Frontend_Premium' ) && $last_cart_item_key ) {
						$price      = yith_wcpb_frontend()->calculate_bundled_items_price_by_cart( $cart_item );
						$price_html = wc_price( $price );
					} elseif ( $product->is_type( 'gift-card' ) && $cart_item && isset( $cart_item['ywgc_amount'] ) ) {
						$price      = apply_filters( 'yith_ywgc_set_cart_item_price', $cart_item['ywgc_amount'], $cart_item );
						$price_html = wc_price( apply_filters( 'yith_ywgc_get_gift_card_price', $price ) );
					} elseif ( $product->is_type( 'grouped' ) ) {
						foreach ( $quantity as $key => $qty ) {
							if ( ! $qty ) {
								continue;
							}
							$product            = wc_get_product( $key );
							$tot_qty            = intval( $qty ) > 1 ? sprintf( '%s &times; ', $qty ) : '';
							$product_cart_price = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $product ), $cart_item, $last_cart_item_key );
							$price_html         = '<b>' . $product->get_name() . '</b> ' . $tot_qty . $product_cart_price . '<br>';
						}
					} else {
						// Set quantity.
						$quantity           = $quantity > 1 ? sprintf( '%s &times; ', $quantity ) : '';
						$product_cart_price = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $product ), $cart_item, $last_cart_item_key );
						$price_html         = $quantity . $product_cart_price;
					}

					echo wp_kses_post( $price_html );
					?>
				</span>
				<div class="product-variation">
					<?php
					if ( $product->is_type( 'variation' ) && get_option( 'yith-wacp-show-product-variation', yith_wacp_get_default( 'show-product-variation' ) ) === 'yes' ) :
						$variation_id = is_callable( array( $product, 'get_id' ) ) ? $product->get_id() : $product->variation_id;
						?>
						<div class="product-variation">
							<?php
							if ( isset( $cart_item['variation_id'] ) && $cart_item['variation_id'] === $variation_id ) {
								echo wp_kses_post( yith_wacp_get_formatted_cart_item_data( $cart_item ) );
							}
							?>
						</div>
					<?php endif; ?>
				</div>

				<?php
				/**
				 * DO_ACTION: yith_wacp_after_product_info
				 *
				 * Perform actions after showing the added product info.
				 *
				 * @param WC_Product $product   The added product.
				 * @param array      $cart_item The added product cart item.
				 */
				do_action( 'yith_wacp_after_product_info', $product, $cart_item );
				?>
			</div>
			<?php
			/**
			 * DO_ACTION: yith_wacp_add_cart_info
			 *
			 * Show added to cart info.
			 *
			 * @param WC_Product $product The added product.
			 */
			do_action( 'yith_wacp_add_cart_info', $product );
			?>
		</div>
	<?php endif; ?>
</div>
