<?php
/**
 * Exclusion table view
 *
 * @package YITH\AddedToCartPopup\Views\Panel\CustomTabs
 * @var boolean                         $is_blank Check if the table is empty
 * @var YITH_WACP_Exclusions_List_Table $table    The exclusion table content.
 * @var array                           $get      The GET vars.
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

$fields = array(
	array(
		'id'      => 'yith-wacp-exclusion-type',
		'name'    => 'yith-wacp-exclusion-type',
		'type'    => 'select',
		'class'   => 'wc-enhanced-select',
		'options' => array(
			'add_products'   => esc_html__( 'Products', 'yith-woocommerce-added-to-cart-popup' ),
			'add_categories' => esc_html__( 'Categories', 'yith-woocommerce-added-to-cart-popup' ),
		),
		'title'   => esc_html__( 'Exclusion type', 'yith-woocommerce-added-to-cart-popup' ),
		'value'   => '',
		'desc'    => esc_html__( 'Choose whether to add specific products or categories to the exclusion list.', 'yith-woocommerce-added-to-cart-popup' ),
	),
	array(
		'id'       => 'add_products',
		'name'     => 'add_products',
		'type'     => 'ajax-products',
		'multiple' => true,
		'data'     => array(
			'placeholder' => esc_html__( 'Search for products...', 'yith-woocommerce-added-to-cart-popup' ),
		),
		'title'    => esc_html__( 'Select products', 'yith-woocommerce-added-to-cart-popup' ),
		'desc'     => esc_html__( 'Select which products to add to the exclusion list.', 'yith-woocommerce-added-to-cart-popup' ),
	),
	array(
		'id'       => 'add_categories',
		'name'     => 'add_categories',
		'type'     => 'ajax-terms',
		'multiple' => true,
		'data'     => array(
			'placeholder' => esc_html__( 'Search for categories...', 'yith-woocommerce-added-to-cart-popup' ),
			'taxonomy'    => 'product_cat',
		),
		'title'    => esc_html__( 'Select categories', 'yith-woocommerce-added-to-cart-popup' ),
		'desc'     => esc_html__( 'Select which product categories to add to the exclusion list.', 'yith-woocommerce-added-to-cart-popup' ),
	),
)

?>
<div class="yith-wacp-admin-wrap-content">
	<div class="wrap yith-wacp-exclusion-list-tab">
        <?php if ( ! $is_blank ) : ?>
            <a class="yith-wacp-add-exclusions button-primary" href="#" style="margin-left:10px">+ <?php esc_html_e( 'Add exclusion', 'yith-woocommerce-added-to-cart-popup' ); ?></a>
        <?php endif; ?>
		<?php if ( $is_blank ) : ?>
			<div class="yith-wacp-admin-no-posts">
				<div class="yith-wacp-admin-no-posts-container">
					<div class="yith-wacp-admin-no-posts-logo">
						<img width="80" src="<?php echo esc_url( YITH_WACP_ASSETS_URL . '/images/exclusion-list.svg' ); ?>">
					</div>
					<div class="yith-wacp-admin-no-posts-text">
						<span>
							<strong>
								<?php echo esc_html_x( "You haven't excluded any products or categories yet.", 'Text showed when the list of exclusions is empty.', 'yith-woocommerce-added-to-cart-popup' ); ?>
							</strong>
						</span>
						<p>
							<?php echo esc_html_x( 'Click on the "Add exclusion" button to exclude a product or a category!', 'Text showed when the list of exclusions is empty.', 'yith-woocommerce-added-to-cart-popup' ); ?>
						</p>
					</div>
					<a href="#" class="yith-add-button yith-wacp-add-exclusions"><?php esc_html_e( 'Add exclusion', 'yith-woocommerce-added-to-cart-popup' ); ?></a>
				</div>
			</div>

		<?php else : ?>
			<form method="get">
				<input type="hidden" name="page" value="<?php echo esc_attr( $get['page'] ); ?>">
				<input type="hidden" name="tab" value="exclusions">
				<?php $table->display(); ?>
			</form>
		<?php endif; ?>
	</div>
</div>
<div class="yith-exclusion-list__delete_row" title="<?php esc_html_e( 'Remove item', 'yith-woocommerce-added-to-cart-popup' ); ?>">
	<p>
		<?php esc_html_e( 'This item will be removed from the list.', 'yith-woocommerce-added-to-cart-popup' ); ?>
		<br />
		<?php esc_html_e( 'Do you wish to continue?', 'yith-woocommerce-added-to-cart-popup' ); ?>
	</p>
</div>
<div class="yith-exclusion-list__popup_wrapper">
	<form method="post" class="yith-exclusion-list__form_row">
		<input type="hidden" name="_nonce" value="<?php echo sanitize_key( wp_create_nonce( 'yith_wacp_add_exclusions' ) ); ?>" />
		<table class="form-table">
			<tbody>
			<?php foreach ( $fields as $field ) : ?>
				<tr valign="top" class="yith-plugin-fw-panel-wc-row <?php echo esc_attr( $field['type'] ); ?> <?php echo esc_attr( $field['name'] ); ?>">
					<th scope="row" class="titledesc">
						<label for="<?php echo esc_attr( $field['name'] ); ?>"><?php echo esc_attr( $field['title'] ); ?></label>
					</th>
					<td class="forminp forminp-<?php echo esc_attr( $field['type'] ); ?>">
						<?php yith_plugin_fw_get_field( $field, true ); ?>
						<?php if ( isset( $field['desc'] ) && '' !== $field['desc'] ) : ?>
							<span class="description"><?php echo esc_attr( $field['desc'] ); ?></span>
						<?php endif; ?>
					</td>
				</tr>
			<?php endforeach; ?>
			</tbody>
		</table>
	</form>
</div>
