<?php
/**
 * Draggable position custom field template
 *
 * @package YITH\AddedToCartPopup\Views\Panel\Types
 * @var $field array The field options.
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

list ( $field_id, $class, $name, $default, $value ) = yith_plugin_fw_extract( $field, 'id', 'class', 'name', 'default', 'value' );

if ( empty( $value ) ) {
	$value = $default;
}

?>
<div id="<?php echo esc_attr( $field_id ); ?>_draggable_container">
	<div id="<?php echo esc_attr( $field_id ); ?>_draggable"></div>
</div>
<input name="<?php echo esc_attr( $field_id ); ?>[top]" id="<?php echo esc_attr( $field_id ); ?>_top" type="hidden" value="<?php echo esc_attr( $value['top'] ); ?>" />
<input name="<?php echo esc_attr( $field_id ); ?>[left]" id="<?php echo esc_attr( $field_id ); ?>_left" type="hidden" value="<?php echo esc_attr( $value['left'] ); ?>" />
