<?php
/**
 * Main class
 *
 * @package YITH\AddedToCartPopup
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

if ( ! class_exists( 'YITH_WACP' ) ) {

	/**
	 * Implements features of YITH WooCommerce Added to Cart Popup plugin
	 *
	 * @class   YITH_WACP
	 * @since   1.0.0
	 * @author  YITH <plugins@yithemes.com>
	 * @package YITH\AddedToCartPopup
	 */
	class YITH_WACP {

		use YITH_WACP_Trait_Singleton;

		/**
		 * Constructor
		 *
		 * @return void
		 * @since  1.0.0
		 * @auhtor Francesco Licandro
		 */
		public function __construct() {
			$this->require_files();

			if ( $this->is_admin() ) {
				YITH_WACP_Admin::get_instance();
			} elseif ( $this->load_frontend() ) {
				YITH_WACP_Frontend::get_instance();
			}

			add_action( 'before_woocommerce_init', array( $this, 'declare_wc_features_support' ) );

			// Register image size.
			add_action( 'init', array( $this, 'register_size' ) );

		}

		/**
		 * Load required files
		 *
		 * @return void
		 * @since  2.0.0
		 */
		public function require_files() {
			require_once YITH_WACP_INC . 'functions.yith-wacp.php';
		}

		/**
		 * Check if is admin
		 *
		 * @return boolean
		 * @since  1.1.0
		 */
		public function is_admin() {
			$context_check = isset( $_REQUEST['context'] ) && 'frontend' === $_REQUEST['context']; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
			$is_admin      = is_admin() && ! ( defined( 'DOING_AJAX' ) && DOING_AJAX && ( $context_check || $this->is_porto_add_to_cart() ) );

			/**
			 * APPLY_FILTERS: yith_wacp_check_is_admin
			 *
			 * Check if we are in an admin screen
			 *
			 * @param boolean $is_admin Is an admin screen?
			 */
			return apply_filters( 'yith_wacp_check_is_admin', $is_admin );
		}

		/**
		 * Check if load or not frontend class
		 *
		 * @return boolean
		 * @since  1.2.0
		 */
		public function load_frontend() {
			$is_one_click = isset( $_REQUEST['_yith_wocc_one_click'] ) && 'is_one_click' === $_REQUEST['_yith_wocc_one_click']; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
			$load         = ( ! wp_is_mobile() || get_option( 'yith-wacp-enable-mobile', 'yes' ) !== 'no' ) && ( ! $is_one_click || $this->is_porto_add_to_cart() );

			/**
			 * APPLY_FILTERS: yith_wacp_check_load_frontend
			 *
			 * Check if we are in a frontend screen
			 *
			 * @param boolean $load Is a frontend screen?
			 */
			return apply_filters( 'yith_wacp_check_load_frontend', $load );
		}

		/**
		 * Check if add to cart is performed by Porto theme
		 *
		 * @return boolean
		 * @since  1.0.0
		 */
		public function is_porto_add_to_cart() {
			return isset( $_POST['action'] ) && 'porto_add_to_cart' === sanitize_text_field( wp_unslash( $_POST['action'] ) ); //phpcs:ignore WordPress.Security.NonceVerification.Missing
		}

		/**
		 * Register size
		 *
		 * @access public
		 * @since  1.0.0
		 */
		public function register_size() {
			// Set image size.
			$size   = get_option( 'yith-wacp-image-size' );
			$width  = isset( $size['width'] ) ? $size['width'] : 170;
			$height = isset( $size['height'] ) ? $size['height'] : 170;
			$crop   = isset( $size['crop'] ) ? $size['crop'] : false;

			add_image_size( 'yith_wacp_image_size', $width, $height, $crop );
		}

		/**
		 * Declare support for WooCommerce features.
		 */
		public function declare_wc_features_support() {
			if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
				\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', YITH_WACP_INIT, true );
			}
		}
	}
}
