<?php
/**
 * General Function
 *
 * @author YITH <plugins@yithemes.com>
 * @package YITH\AddedToCartPopup\
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

if ( ! function_exists( 'yith_wacp_is_ywcm_enabled' ) ) {
	/**
	 * Check if YITH WooCommerce Cart Messages Premium is enabled
	 *
	 * @return bool
	 * @since  2.0.0
	 */
	function yith_wacp_is_ywcm_enabled() {
		return defined( 'YITH_YWCM_PREMIUM' ) && YITH_YWCM_PREMIUM;
	}
}

if ( ! function_exists( 'yith_wacp_is_ywraq_enabled' ) ) {
	/**
	 * Check if YITH WooCommerce Request a Quote is enabled
	 *
	 * @return bool
	 * @since  2.0.0
	 */
	function yith_wacp_is_ywraq_enabled() {
		return defined( 'YITH_YWRAQ_INIT' ) && YITH_YWRAQ_INIT;
	}
}

if ( ! function_exists( 'yith_wacp_is_ywfbt_enabled' ) ) {
	/**
	 * Check if YITH WooCommerce Frequently Bought Together is enabled
	 *
	 * @return bool
	 * @since  2.0.0
	 */
	function yith_wacp_is_ywfbt_enabled() {
		return defined( 'YITH_WFBT_PREMIUM' ) && YITH_WFBT_PREMIUM;
	}
}

if ( ! function_exists( 'yith_wacp_is_ywcmcs_enabled' ) ) {
	/**
	 * Check if YITH Multi Currency Switcher for WooCommerce is enabled
	 *
	 * @return bool
	 * @since  2.0.0
	 */
	function yith_wacp_is_ywcmcs_enabled() {
		return defined( 'YITH_WCMCS_INIT' ) && YITH_WCMCS_INIT;
	}
}

if ( ! function_exists( 'yith_wacp_get_style_options' ) ) {
	/**
	 * Get style options from Plugin Options
	 *
	 * @return string
	 * @since  1.0.0
	 */
	function yith_wacp_get_style_options() {
		$size                      = get_option( 'yith-wacp-box-size', yith_wacp_get_default( 'box-size' ) );
		$border_radius             = get_option( 'yith-wacp-popup-border-radius', yith_wacp_get_default( 'popup-border-radius' ) );
		$border_radius             = implode( 'px ', $border_radius['dimensions'] ) . 'px';
		$close_icon_color          = get_option( 'yith-wacp-close-color', yith_wacp_get_default( 'close-color' ) );
		$overlay_color             = get_option( 'yith-wacp-overlay-color', yith_wacp_get_default( 'overlay-color' ) );
		$popup_background          = get_option( 'yith-wacp-popup-background', yith_wacp_get_default( 'popup-background' ) );
		$popup_notice_alignment    = get_option( 'yith-wacp-popup-message-alignment', yith_wacp_get_default( 'popup-message-alignment' ) );
		$notice_border_radius      = get_option( 'yith-wacp-notice-border-radius', yith_wacp_get_default( 'notice-border-radius' ) );
		$notice_border_radius      = implode( 'px ', $notice_border_radius['dimensions'] ) . 'px';
		$notice_style              = get_option( 'yith-wacp-notice-colors', yith_wacp_get_default( 'notice-colors' ) );
		$notice_icon_color         = get_option( 'yith-wacp-notice-icon-color', yith_wacp_get_default( 'notice-icon-color' ) );
		$notice_icon               = get_option( 'yith-wacp-message-icon', yith_wacp_get_default( 'message-icon' ) );
		$product_name_color        = get_option( 'yith-wacp-product-name-color', yith_wacp_get_default( 'product-name-color' ) );
		$table_separator_color     = get_option( 'yith-wacp-table-border-color', yith_wacp_get_default( 'table-border-color' ) );
		$product_price_color       = get_option( 'yith-wacp-product-price-color', yith_wacp_get_default( 'product-price-color' ) );
		$tax_shipping_label_color  = get_option( 'yith-wacp-shipping-taxes-label-color', yith_wacp_get_default( 'shipping-taxes-label-color' ) );
		$cart_total_style          = get_option( 'yith-wacp-cart-total-label-color', yith_wacp_get_default( 'cart-total-label-color' ) );
		$go_cart_button_colors     = get_option( 'yith-wacp-view-cart-button-colors', yith_wacp_get_default( 'view-cart-button-colors' ) );
		$go_checkout_button_colors = get_option( 'yith-wacp-checkout-button-colors', yith_wacp_get_default( 'checkout-button-colors' ) );
		$continue_button_colors    = get_option( 'yith-wacp-continue-shopping-button-colors', yith_wacp_get_default( 'continue-shopping-button-colors' ) );
		$buttons_border_radius     = get_option( 'yith-wacp-button-border-radius', yith_wacp_get_default( 'button-border-radius' ) );
		$buttons_border_radius     = implode( 'px ', $buttons_border_radius['dimensions'] ) . 'px';
		$related_title_color       = get_option( 'yith-wacp-related-title-color', yith_wacp_get_default( 'related-title-color' ) );
		$mini_cart_colors          = get_option( 'yith-wacp-mini-cart-colors', yith_wacp_get_default( 'mini-cart-colors' ) );
		$mini_cart_icon_color      = get_option( 'yith-wacp-mini-cart-icon-color', yith_wacp_get_default( 'mini-cart-icon-color' ) );
		$mini_cart_border_radius   = get_option( 'yith-wacp-mini-cart-border-radius', yith_wacp_get_default( 'mini-cart-border-radius' ) );
		$mini_cart_border_radius   = implode( 'px ', $mini_cart_border_radius['dimensions'] ) . 'px';

		$inline_css = "
			:root {
				--yith-wacp-box-width-size: {$size['width']}px;
				--yith-wacp-box-height-size: {$size['height']}px;
				--yith-wacp-popup-border-radius: $border_radius;
				--yith-wacp-close-color-normal: {$close_icon_color['normal']};
				--yith-wacp-close-color-hover: {$close_icon_color['hover']};
				--yith-wacp-overlay-color: $overlay_color;
				--yith-wacp-popup-background: $popup_background;
				--yith-wacp-popup-message-alignment: $popup_notice_alignment;
				--yith-wacp-notice-border-radius: $notice_border_radius;
				--yith-wacp-notice-colors-text: {$notice_style['text']};
				--yith-wacp-notice-colors-background: {$notice_style['background']};
				--yith-wacp-notice-icon-color: $notice_icon_color;
				--yith-wacp-product-name-color-normal: {$product_name_color['normal']};
				--yith-wacp-product-name-color-hover: {$product_name_color['hover']};
				--yith-wacp-table-border-color: $table_separator_color;
				--yith-wacp-product-price-color: $product_price_color;
				--yith-wacp-shipping-taxes-label-color-label: {$tax_shipping_label_color['label']};
				--yith-wacp-shipping-taxes-label-color-amount: {$tax_shipping_label_color['amount']};
				--yith-wacp-cart-total-label-color-label: {$cart_total_style['label']};
				--yith-wacp-cart-total-label-color-amount: {$cart_total_style['amount']};
				--yith-wacp-button-background-go-cart: {$go_cart_button_colors['background_normal']};
				--yith-wacp-button-text-color-go-cart: {$go_cart_button_colors['text_normal']};
				--yith-wacp-button-border-color-go-cart: {$go_cart_button_colors['border_normal']};
				--yith-wacp-button-hover-background-go-cart: {$go_cart_button_colors['background_hover']};
				--yith-wacp-button-hover-text-color-go-cart: {$go_cart_button_colors['text_hover']};
				--yith-wacp-button-hover-border-color-go-cart: {$go_cart_button_colors['border_hover']};
				--yith-wacp-button-background-go-checkout: {$go_checkout_button_colors['background_normal']};
				--yith-wacp-button-text-color-go-checkout: {$go_checkout_button_colors['text_normal']};
				--yith-wacp-button-border-color-go-checkout: {$go_checkout_button_colors['border_normal']};
				--yith-wacp-button-hover-background-go-checkout: {$go_checkout_button_colors['background_hover']};
				--yith-wacp-button-hover-text-color-go-checkout: {$go_checkout_button_colors['text_hover']};
				--yith-wacp-button-hover-border-color-go-checkout: {$go_checkout_button_colors['border_hover']};
				--yith-wacp-button-background-continue-shopping: {$continue_button_colors['background_normal']};
				--yith-wacp-button-text-color-continue-shopping: {$continue_button_colors['text_normal']};
				--yith-wacp-button-border-color-continue-shopping: {$continue_button_colors['border_normal']};
				--yith-wacp-button-hover-background-continue-shopping: {$continue_button_colors['background_hover']};
				--yith-wacp-button-hover-text-color-continue-shopping: {$continue_button_colors['text_hover']};
				--yith-wacp-button-hover-border-color-continue-shopping: {$continue_button_colors['border_hover']};
				--yith-wacp-actions-buttons-radius: $buttons_border_radius;
				--yith-wacp-color-title-related: $related_title_color;
				--yith-wacp-mini-cart-bg: {$mini_cart_colors['background']};
				--yith-wacp-mini-cart-shadow: {$mini_cart_colors['shadow']};
				--yith-wacp-mini-cart-counter: {$mini_cart_colors['counter']};
				--yith-wacp-mini-cart-icon-color: $mini_cart_icon_color;
				--yith-wacp-mini-cart-borders: $mini_cart_border_radius;
				}
				
			#yith-wacp-popup .yith-wacp-content .yith-wacp-message.custom-icon:before {
				background-image: url($notice_icon);
				}
				
				";

		return $inline_css;
	}
}

if ( ! function_exists( 'yith_wacp_get_default' ) ) {

	/**
	 * Get default values
	 *
	 * @param string $option    The option name.
	 * @param string $suboption The sub-option name.
	 *
	 * @return array|mixed
	 * @since  2.0.0
	 */
	function yith_wacp_get_default( $option, $suboption = false ) {

		$defaults = array(
			'exclusion'                       => 'all-products',
			'enable-on-archive'               => 'yes',
			'enable-on-single'                => 'yes',
			'enable-on-mobile'                => 'yes',
			'layout-popup'                    => 'product',
			'enable-raq'                      => 'no',
			'enable-wfbt'                     => 'no',
			'box-size'                        => array(
				'width'  => '700',
				'height' => '700',
			),
			'box-animation'                   => 'fade-in',
			'overlay-color'                   => '#000000',
			'popup-background'                => '#ffffff',
			'popup-border-radius'             => array(
				'dimensions' => array(
					'top'    => 0,
					'right'  => 0,
					'bottom' => 0,
					'left'   => 0,
				),
				'unit'       => 'px',
				'linked'     => 'no',
			),
			'enable-close-popup-icon'         => 'yes',
			'close-color'                     => array(
				'normal' => '#c0c0c0',
				'hover'  => '#c0c0c0',
			),
			'popup-message'                   => esc_html__( 'Product successfully added to your cart!', 'yith-woocommerce-added-to-cart-popup' ),
			'popup-message-alignment'         => 'left',
			'popup-message-style'             => 'h3',
			'notice-colors'                   => array(
				'text'       => '#000000',
				'background' => '#EFF7D4',
			),
			'notice-icon'                     => 'default-icon',
			'message-icon'                    => YITH_WACP_ASSETS_URL . '/images/check.svg',
			'notice-icon-color'               => '#ADBC15',
			'notice-border-radius'            => array(
				'dimensions' => array(
					'top'    => 0,
					'right'  => 0,
					'bottom' => 0,
					'left'   => 0,
				),
				'unit'       => 'px',
				'linked'     => 'no',
			),
			'show-info'                       => 'yes',
			'product-name-color'              => array(
				'normal' => '#000000',
				'hover'  => '#008371',
			),
			'product-price-color'             => '#000000',
			'show-product-variation'          => 'yes',
			'show-thumbnail'                  => 'yes',
			'image-size'                      => array(
				'width'  => '170',
				'height' => '170',
				'crop'   => 'yes',
			),
			'table-border-color'              => '#e5e5e5',
			'show-cart-shipping'              => 'yes',
			'show-cart-tax'                   => 'yes',
			'shipping-taxes-label-color'      => array(
				'label'  => '#000000',
				'amount' => '#000000',
			),
			'show-cart-totals'                => 'yes',
			'cart-total-label-color'          => array(
				'label'  => '#000000',
				'amount' => '#000000',
			),
			'show-go-cart'                    => 'yes',
			'text-go-cart'                    => esc_html__( 'View Cart', 'yith-woocommerce-added-to-cart-popup' ),
			'view-cart-button-colors'         => array(
				'text_normal'       => '#FFFFFF',
				'background_normal' => '#008671',
				'border_normal'     => '#008671',
				'text_hover'        => '#008671',
				'background_hover'  => 'rgba(0,0,0,0)',
				'border_hover'      => '#008671',
			),
			'show-go-checkout'                => 'yes',
			'text-go-checkout'                => esc_html__( 'Checkout', 'yith-woocommerce-added-to-cart-popup' ),
			'checkout-button-colors'          => array(
				'text_normal'       => '#FFFFFF',
				'background_normal' => '#008671',
				'border_normal'     => '#008671',
				'text_hover'        => '#008671',
				'background_hover'  => 'rgba(0,0,0,0)',
				'border_hover'      => '#008671',
			),
			'show-continue-shopping'          => 'yes',
			'text-continue-shopping'          => esc_html__( 'Continue Shopping', 'yith-woocommerce-added-to-cart-popup' ),
			'continue-shopping-button-colors' => array(
				'text_normal'       => '#FFFFFF',
				'background_normal' => '#008671',
				'border_normal'     => '#008671',
				'text_hover'        => '#008671',
				'background_hover'  => 'rgba(0,0,0,0)',
				'border_hover'      => '#008671',
			),
			'button-border-radius'            => array(
				'dimensions' => array(
					'top'    => 10,
					'right'  => 10,
					'bottom' => 10,
					'left'   => 10,
				),
				'unit'       => 'px',
				'linked'     => 'yes',
			),
			'show-related'                    => 'yes',
			'related-title'                   => esc_html__( 'You might also like', 'yith-woocommerce-added-to-cart-popup' ),
			'related-title-color'             => '#000000',
			'suggested-products-type'         => 'related',
			'related-products'                => array(),
			'related-number'                  => 20,
			'related-columns'                 => 4,
			'main-product-overlay-colors'     => array(
				'text'       => '#FFFFFF',
				'background' => '#335D57',
			),
			'suggested-add-to-cart'           => 'yes',
			'mini-cart-enable'                => 'yes',
			'mini-cart-enable-mobile'         => 'yes',
			'mini-cart-hide-empty'            => 'no',
			'mini-cart-show-counter'          => 'yes',
			'mini-cart-icon-type'             => 'default',
			'mini-cart-icon'                  => YITH_WACP_ASSETS_URL . '/images/mini-cart.svg',
			'mini-cart-icon-color'            => '#000000',
			'mini-cart-colors'                => array(
				'background' => '#ffffff',
				'shadow'     => '#cccccc',
				'counter'    => '#008671',
			),
			'mini-cart-border-radius'         => array(
				'dimensions' => array(
					'top'    => 5,
					'right'  => 5,
					'bottom' => 5,
					'left'   => 5,
				),
				'unit'       => 'px',
				'linked'     => 'yes',
			),
			'mini-cart-position'              => array(
				'top'  => '20',
				'left' => '97',
			),
		);

		if ( isset( $defaults[ $option ] ) ) {
			if ( $suboption && isset( $defaults[ $option ][ $suboption ] ) ) {
				return $defaults[ $option ][ $suboption ];
			} else {
				return $defaults[ $option ];
			}
		} else {
			return '';
		}

	}
}

if ( ! function_exists( 'yith_wacp_get_cart_info' ) ) {
	/**
	 * Get cart info for popup
	 *
	 * @return array
	 * @since  1.1.0
	 */
	function yith_wacp_get_cart_info() {

		// First of all define cart constant for cart calculation.
		if ( ! defined( 'WOOCOMMERCE_CART' ) ) {
			define( 'WOOCOMMERCE_CART', true );
		}

		$cart_info = array();

		// Calculate totals.
		WC()->cart->calculate_totals();

		// Build info array.
		if ( WC()->cart->calculate_shipping() && WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) {
			$cart_info['shipping'] = WC()->cart->get_cart_shipping_total();
		}

		if ( wc_tax_enabled() ) {
			$cart_info['tax'] = WC()->cart->get_cart_tax();
		}

		$cart_info['discount'] = WC()->cart->get_discount_total() + WC()->cart->get_discount_tax() > 0 ? wc_price( WC()->cart->get_discount_total() + WC()->cart->get_discount_tax() ) : null;
		$cart_info['total']    = WC()->cart->get_total();

		/**
		 * APPLY_FILTERS: yith_wacp_popup_cart_info
		 *
		 * Manages cart info in the popup
		 *
		 * @param array $cart_info The current cart info.
		 */
		return apply_filters( 'yith_wacp_popup_cart_info', $cart_info );
	}
}

if ( ! function_exists( 'yith_wacp_get_cart_remove_url' ) ) {
	/**
	 * Get cart item remove url
	 *
	 * @param string $item_key The item key.
	 *
	 * @return string
	 * @since  1.3.0
	 */
	function yith_wacp_get_cart_remove_url( $item_key ) {
		return function_exists( 'wc_get_cart_remove_url' ) ? wc_get_cart_remove_url( $item_key ) : WC()->cart->get_remove_url( $item_key );
	}
}

if ( ! function_exists( 'yith_wacp_get_formatted_cart_item_data' ) ) {
	/**
	 * Get formatted cart item data
	 *
	 * @param array $item Cart item object.
	 *
	 * @return string
	 * @since  1.3.0
	 */
	function yith_wacp_get_formatted_cart_item_data( $item ) {
		return function_exists( 'wc_get_formatted_cart_item_data' ) ? wc_get_formatted_cart_item_data( $item ) : WC()->cart->get_item_data( $item );
	}
}
