<?php
/**
 * Handle integration with YITH WooCommerce Request A Quote
 *
 * @package YITH\AddedToCartPopup\Integrations
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

if ( ! class_exists( 'YITH_WACP_YWRAQ_Integration' ) ) {

	/**
	 * Integration class.
	 * The class manage all the integration behaviors with YITH WooCommerce Request A Quote.
	 *
	 * @class   YITH_WACP_YWRAQ_Integration
	 * @since   1.1.0
	 * @author  YITH <plugins@yithemes.com>
	 * @package YITH\AddedToCartPopup\Integrations
	 */
	class YITH_WACP_YWRAQ_Integration {

		use YITH_WACP_Trait_Singleton;

		/**
		 * Update raq action
		 *
		 * @since 1.3.0
		 * @var string
		 */
		public $action_update_raq = 'yith_wacp_update_raq';

		/**
		 * Constructor
		 *
		 * @access public
		 * @since  1.1.0
		 */
		public function __construct() {
			add_action( 'wc_ajax_' . $this->action_update_raq, array( $this, 'update_raq_ajax' ) );
			add_action( 'wp_ajax_nopriv' . $this->action_update_raq, array( $this, 'update_raq_ajax' ) );

			// Add message for request a quote action.
			add_filter( 'yith_ywraq_ajax_add_item_json', array( $this, 'get_popup_raq_content' ), 10, 1 );
			// Add action to localized.
			add_filter( 'yith_wacp_frontend_script_localized_args', array( $this, 'add_localized_args' ), 10, 1 );
			// Handle form scripts and style.
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_form_scripts' ), 99 );
		}

		/**
		 * Handle scripts ans style for selected form
		 *
		 * @return void
		 * @since  1.4.5
		 */
		public function enqueue_form_scripts() {
			$form = get_option( 'ywraq_inquiry_form_type', 'default' );
			if ( 'gravity-forms' === $form && class_exists( 'GFForms' ) ) {
				$form_id = get_option( 'ywraq_inquiry_gravity_forms_id', 0 );
				$form_id && GFForms::enqueue_form_scripts( $form_id, true );
			}
		}

		/**
		 * Add args to frontend localized array
		 *
		 * @param array $args The frontend localized array.
		 *
		 * @return array
		 * @since  1.3.0
		 */
		public function add_localized_args( $args ) {
			$args['actionUpdateRaq'] = $this->action_update_raq;

			return $args;
		}


		/**
		 * Update Request a Quote form on popup
		 *
		 * @access public
		 * @since  1.3.0
		 */
		public function update_raq_ajax() {

			if ( ! isset( $_REQUEST['update_raq_wpnonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_REQUEST['update_raq_wpnonce'] ) ), 'update-request-quote-quantity' ) || ! isset( $_REQUEST['action'] ) || $_REQUEST['action'] !== $this->action_update_raq || ! isset( $_REQUEST['raq'] ) ) {
				die();
			}

			$json = $this->get_popup_raq_content();
			// Refresh popup!
			wp_send_json( $json );
		}

		/**
		 * Get content html for added to cart popup on request a quote action
		 *
		 * @access public
		 *
		 * @param array $json        Default json response.
		 * @param array $product_raq An array of raq args.
		 *
		 * @return array
		 * @since  1.3.0
		 */
		public function get_popup_raq_content( $json = array(), $product_raq = array() ) {

			/**
			 * APPLY_FILTERS: yith_wacp_get_popup_raq_content
			 *
			 * Manages RAQ popup additional arguments.
			 *
			 * @param array $value The custom args array.
			 */
			$args = apply_filters( 'yith_wacp_get_popup_raq_content', array() );

			ob_start();

			/**
			 * DO_ACTION: yith_wacp_before_popup_raq_content
			 *
			 * Perform actions before showing RAQ form.
			 *
			 * @param array $product_raq An array of RAQ args..
			 */
			do_action( 'yith_wacp_before_popup_raq_content', $product_raq );

			wc_get_template( 'yith-wacp-popup-raq.php', $args, '', YITH_WACP_TEMPLATE_PATH . '/' );

			/**
			 * DO_ACTION: yith_wacp_after_popup_raq_content
			 *
			 * Perform actions after showing RAQ form.
			 *
			 * @param array $product_raq An array of RAQ args..
			 */
			do_action( 'yith_wacp_after_popup_raq_content', $product_raq );

			$json['yith_wacp_raq'] = ob_get_clean();

			return $json;
		}
	}
}
