<?php
/**
 * Added notice sub-tab array
 *
 * @package YITH\AddedToCartPopup\PluginOptions\Customization
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

return array(
	'customization-added-notice' => array(

        array(
            'title' => esc_html__( 'Style options', 'yith-woocommerce-added-to-cart-popup' ),
            'type'  => 'title',
            'desc'  => '',
            'id'    => 'yith_wacp_added_notice_options_style',
        ),
		array(
			'title'     => esc_html__( 'Text to show', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the text to show when a product is added to the cart.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'text',
			'default'   => yith_wacp_get_default( 'popup-message' ),
			'id'        => 'yith-wacp-popup-message',
		),
		array(
			'id'        => 'yith-wacp-popup-message-alignment',
			'title'     => esc_html__( 'Text alignment', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Choose the text alignment.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'select',
			'default'   => yith_wacp_get_default( 'popup-message-alignment' ),
			'class'     => 'wc-enhanced-select',
			'options'   => array(
				'center' => esc_html__( 'Center', 'yith-woocommerce-added-to-cart-popup' ),
				'left'   => esc_html__( 'Left', 'yith-woocommerce-added-to-cart-popup' ),
			),
		),
		array(
			'id'        => 'yith-wacp-popup-message-style',
			'title'     => esc_html__( 'Text style', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the text style.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'select',
			'class'     => 'wc-enhanced-select',
			'options'   => array(
				'h1'   => 'H1',
				'h2'   => 'H2',
				'h3'   => 'H3',
				'h4'   => 'H4',
				'h5'   => 'H5',
				'h6'   => 'H6',
				'span' => 'Paragraphs',
			),
			'default'   => yith_wacp_get_default( 'popup-message-style' ),
		),
        array(
            'title'     => esc_html__( 'Border radius', 'yith-woocommerce-added-to-cart-popup' ),
            'desc'      => esc_html__( 'Set the notice border radius.', 'yith-woocommerce-added-to-cart-popup' ),
            'id'        => 'yith-wacp-notice-border-radius',
            'type'      => 'yith-field',
            'yith-type' => 'dimensions',
            'units'     => array( 'px' => 'px' ),
            'default'   => yith_wacp_get_default( 'notice-border-radius' ),
        ),
        array(
            'id'   => 'yith_wacp_added_notice_options_style_end',
            'type' => 'sectionend',
        ),

        array(
            'title' => esc_html__('Notice options', 'yith-woocommerce-added-to-cart-popup' ),
            'type'  => 'title',
            'desc'  => '',
            'id'    => 'yith_wacp_added_notice_options_notice',
        ),
		array(
			'title'        => esc_html__( 'Notice colors', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'         => esc_html__( 'Set the notice text and background colors.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'         => 'yith-field',
			'yith-type'    => 'multi-colorpicker',
			'id'           => 'yith-wacp-notice-colors',
			'colorpickers' => array(
				array(
					'name'    => esc_html__( 'Text', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'text',
					'default' => yith_wacp_get_default( 'notice-colors', 'text' ),
				),
				array(
					'name'    => esc_html__( 'Background', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'background',
					'default' => yith_wacp_get_default( 'notice-colors', 'background' ),
				),
			),
		),
		array(
			'id'        => 'yith-wacp-notice-icon',
			'title'     => esc_html__( 'Notice icon', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Choose if you want to show the default icon, upload a custom one, or not show an icon at all.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'select',
			'class'     => 'wc-enhanced-select',
			'default'   => yith_wacp_get_default( 'notice-icon' ),
			'options'   => array(
				'not-show-icon' => esc_html__( "Don't show an icon", 'yith-woocommerce-added-to-cart-popup' ),
				'default-icon'  => esc_html__( 'Use the default icon', 'yith-woocommerce-added-to-cart-popup' ),
				'custom-icon'   => esc_html__( 'Upload a custom icon', 'yith-woocommerce-added-to-cart-popup' ),
			),
		),
		array(
			'title'     => esc_html__( 'Upload icon', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Upload a popup icon (suggested size: 25x25 px).', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'media',
			'default'   => yith_wacp_get_default( 'message-icon' ),
			'id'        => 'yith-wacp-message-icon',
			'deps'      => array(
				'id'    => 'yith-wacp-notice-icon',
				'value' => 'custom-icon',
				'type'  => 'hide',
			),
		),
		array(
			'title'     => esc_html__( 'Icon color', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the icon color.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'colorpicker',
			'default'   => yith_wacp_get_default( 'notice-icon-color' ),
			'id'        => 'yith-wacp-notice-icon-color',
			'deps'      => array(
				'id'    => 'yith-wacp-notice-icon',
				'value' => 'default-icon',
				'type'  => 'hide',
			),
		),
		array(
			'type' => 'sectionend',
			'id'   => 'yith_wacp_added_notice_options_notice_end',
		),
	),
);
