<?php
/**
 * Product table sub-tab array
 *
 * @package YITH\AddedToCartPopup\PluginOptions\Customization
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

return array(
	'customization-products-table' => array(

        array(
            'title' => esc_html__( 'Products table', 'yith-woocommerce-added-to-cart-popup' ),
            'type'  => 'title',
            'desc'  => '',
            'id'    => 'yith_wacp_products_table_options_products',
        ),
		array(
			'title'     => esc_html__( 'Show product name and price', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show product name and price in the popup.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'show-info' ),
			'id'        => 'yith-wacp-show-info',
		),
		array(
			'title'     => esc_html__( 'Show variations info', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show variations info in variable products (size, color, etc.).', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'show-product-variation' ),
			'id'        => 'yith-wacp-show-product-variation',
			'deps'      => array(
				'id'    => 'yith-wacp-show-info',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		array(
			'title'     => esc_html__( 'Show product image', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show the product image.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'show-thumbnail' ),
			'id'        => 'yith-wacp-show-thumbnail',
		),
		array(
			'type'      => 'yith-field',
			'yith-type' => 'inline-fields',
			/* translators: %s stand for a link to download a free WordPress plugin to regenerate image sizes. */
			'desc'      => sprintf( esc_html__( 'Set the product image size. After changing these settings, you may need to %s.', 'yith-woocommerce-added-to-cart-popup' ), '<a href="https://wordpress.org/extend/plugins/regenerate-thumbnails/">' . esc_html__( 'regenerate your thumbnails', 'yith-woocommerce-added-to-cart-popup' ) . '</a>' ),
			'title'     => esc_html__( 'Image size (px)', 'yith-woocommerce-added-to-cart-popup' ),
			'id'        => 'yith-wacp-image-size',
			'fields'    => array(
				'width'  => array(
					'inline-label' => '',
					'default'      => yith_wacp_get_default( 'image-size', 'width' ),
					'type'         => 'number',
				),
				'height' => array(
					'inline-label' => '&times;',
					'default'      => yith_wacp_get_default( 'image-size', 'height' ),
					'type'         => 'number',
				),
				'crop'   => array(
					'type'    => 'checkbox',
					'label'   => esc_html__( 'Hard crop?', 'yith-woocommerce-added-to-cart-popup' ),
					'default' => yith_wacp_get_default( 'image-size', 'crop' ),
				),
			),
			'deps'      => array(
				'id'    => 'yith-wacp-show-thumbnail',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
        array(
            'id'   => 'yith_wacp_products_table_options_products_end',
            'type' => 'sectionend',
        ),

        array(
            'title' => esc_html__('Colors','yith-woocommerce-added-to-cart-popup' ),
            'type'  => 'title',
            'desc'  => '',
            'id'    => 'yith_wacp_products_table_options_colors',
        ),
        array(
            'title'        => esc_html__( 'Products color', 'yith-woocommerce-added-to-cart-popup' ),
            'type'         => 'yith-field',
            'yith-type'    => 'multi-colorpicker',
            'desc'         => esc_html__( 'Set the products text color.', 'yith-woocommerce-added-to-cart-popup' ),
            'id'           => 'yith-wacp-product-name-color',
            'colorpickers' => array(
                array(
                    'name'    => esc_html__( 'Name', 'yith-woocommerce-added-to-cart-popup' ),
                    'id'      => 'normal',
                    'default' => yith_wacp_get_default( 'product-name-color', 'normal' ),
                ),
                array(
                    'name'    => esc_html__( 'Name hover', 'yith-woocommerce-added-to-cart-popup' ),
                    'id'      => 'hover',
                    'default' => yith_wacp_get_default( 'product-name-color', 'hover' ),
                ),
            ),
            'deps'         => array(
                'id'    => 'yith-wacp-show-info',
                'value' => 'yes',
                'type'  => 'hide',
            ),
        ),
        array(
            'name'      => esc_html__( 'Product price', 'yith-woocommerce-added-to-cart-popup' ),
            'desc'      => esc_html__( 'Set the product price text color.', 'yith-woocommerce-added-to-cart-popup' ),
            'type'      => 'yith-field',
            'yith-type' => 'colorpicker',
            'default'   => yith_wacp_get_default( 'product-price-color' ),
            'id'        => 'yith-wacp-product-price-color',
            'deps'      => array(
                'id'    => 'yith-wacp-show-info',
                'value' => 'yes',
                'type'  => 'hide',
            ),
        ),
		array(
			'title'     => esc_html__( 'Border color', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the separator border color.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'colorpicker',
			'default'   => yith_wacp_get_default( 'table-border-color' ),
			'id'        => 'yith-wacp-table-border-color',
		),
        array(
            'id'   => 'yith_wacp_products_table_options_colors_end',
            'type' => 'sectionend',
        ),
	),
);
