<?php
/**
 * Upsell cross-sell sub-tab array
 *
 * @package YITH\AddedToCartPopup\PluginOptions\Customization
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

return array(
	'customization-upsell-cross-sell' => array(

        array(
            'title' => esc_html__('Suggested products', 'yith-woocommerce-added-to-cart-popup' ),
            'type'  => 'title',
            'desc'  => '',
            'id'    => 'yith_wacp_suggested_products_options',
        ),
		array(
			'title'     => esc_html__( 'Show suggested products', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show a list of suggested products in the popup.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'show-related' ),
			'id'        => 'yith-wacp-show-related',
		),
		array(
			'title'     => esc_html__( 'Section title', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set a title to show above the suggested products.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'text',
			'default'   => yith_wacp_get_default( 'related-title' ),
			'id'        => 'yith-wacp-related-title',
            'deps'      => array(
                'id'    => 'yith-wacp-show-related',
                'value' => 'yes',
                'type'  => 'hide',
            ),
		),
		array(
			'title'     => esc_html__( 'Title color', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the color of the title.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'colorpicker',
			'default'   => yith_wacp_get_default( 'related-title-color' ),
			'id'        => 'yith-wacp-related-title-color',
            'deps'      => array(
                'id'    => 'yith-wacp-show-related',
                'value' => 'yes',
                'type'  => 'hide',
            ),
		),
		array(
			'id'        => 'yith-wacp-suggested-products-type',
			'title'     => esc_html__( 'Products to suggest', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Choose what type of products to suggest.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'select',
			'class'     => 'wc-enhanced-select',
			'options'   => array(
				'specific_products' => esc_html__( 'Choose specific products', 'yith-woocommerce-added-to-cart-popup' ),
				'related'           => esc_html__( 'Related products', 'yith-woocommerce-added-to-cart-popup' ),
				'crossell'          => esc_html__( 'Cross-sell products', 'yith-woocommerce-added-to-cart-popup' ),
				'upsell'            => esc_html__( 'Upsell products', 'yith-woocommerce-added-to-cart-popup' ),
			),
			'default'   => yith_wacp_get_default( 'suggested-products-type' ),
            'deps'      => array(
                'id'    => 'yith-wacp-show-related',
                'value' => 'yes',
                'type'  => 'hide',
            ),
		),
		array(
			'title'     => esc_html__( 'Choose products', 'yith-woocommerce-added-to-cart-popup' ),
			'id'        => 'yith-wacp-related-products',
			'type'      => 'yith-field',
			'yith-type' => 'ajax-products',
			'multiple'  => true,
			'data'      => array(
				'action'      => 'woocommerce_json_search_products_and_variations',
				'security'    => wp_create_nonce( 'search-products' ),
				'placeholder' => esc_html__( 'Search for a product...', 'yith-woocommerce-added-to-cart-popup' ),
			),
			'default'   => yith_wacp_get_default( 'related-products' ),
			'desc'      => esc_html__( 'Choose which products to suggest in the popup.', 'yith-woocommerce-added-to-cart-popup' ),
			'deps'      => array(
				'id'    => 'yith-wacp-suggested-products-type',
				'value' => 'specific_products',
				'type'  => 'hide',
			),
		),
		array(
			'title'     => esc_html__( 'Number of suggested products', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Choose how many suggested products to show.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'number',
			'default'   => yith_wacp_get_default( 'related-number' ),
			'min'       => 1,
			'id'        => 'yith-wacp-related-number',
            'deps'      => array(
                'id'    => 'yith-wacp-show-related',
                'value' => 'yes',
                'type'  => 'hide',
            ),
		),
		array(
			'title'     => esc_html__( 'Columns of suggested products', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Choose how many columns to show for suggested products.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'slider',
			'option'    => array(
				'min' => 1,
				'max' => 6,
			),
			'default'   => yith_wacp_get_default( 'related-columns' ),
			'step'      => 1,
			'id'        => 'yith-wacp-related-columns',
            'deps'      => array(
                'id'    => 'yith-wacp-show-related',
                'value' => 'yes',
                'type'  => 'hide',
            ),
		),
		array(
			'id'        => 'yith-wacp-suggested-add-to-cart',
			'title'     => esc_html__( 'Show "Add to cart" button', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show the "Add to cart" button for each suggested product.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'suggested-add-to-cart' ),
            'deps'      => array(
                'id'    => 'yith-wacp-show-related',
                'value' => 'yes',
                'type'  => 'hide',
            ),
		),
		array(
			'type' => 'sectionend',
			'id'   => 'yith_wacp_suggested_products_options_end',
		),
	),
);
