<?php
/**
 * Mini cart template
 *
 * @package YITH\AddedToCartPopup\Templates
 * @var $show_counter   boolean Show the item counter.
 * @var $items          integer The number of items in the cart.
 * @var $icon           string  The custom icon path.
 * @var $icon_type      string  The mini cart icon type.
 * @var $hide_empty     string  The mini cart icon type.
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.
?>

<div id="yith-wacp-mini-cart" class="<?php echo esc_attr( $hide_empty ); ?> <?php echo empty( $items ) ? 'empty' : ''; ?>">
	<?php if ( $show_counter ) : ?>
		<div class="yith-wacp-mini-cart-count"><?php echo esc_html( $items ); ?></div>
	<?php endif; ?>
	<div class="yith-wacp-mini-cart-icon <?php echo esc_attr( $icon_type ); ?>">
		<?php if ( ! empty( $icon ) && 'default-icon' !== $icon_type ) : ?>
			<img src="<?php echo esc_url( $icon ); ?>" width="35px" height="35px">
		<?php endif; ?>
	</div>
</div>
