<?php
/**
 * Popup actions template
 *
 * @package YITH\AddedToCartPopup\Templates
 * @var $cart                  boolean Button "Go to cart" enabled?
 * @var $checkout              boolean Button "Go to checkout" enabled?
 * @var $continue              boolean Button "Continue shopping" enabled?
 * @var $cart_url              string "Go to cart" button url.
 * @var $checkout_url          string "Go to checkout" button url.
 * @var $continue_shopping_url string "Continue shopping" button url.
 * @var $layout                string The button layout.
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.
?>

<div class="yith-wacp-popup-actions <?php echo esc_attr( $layout ); ?>">
	<?php
	/**
	 * DO_ACTION: yith_wacp_before_action_buttons
	 *
	 * Perform actions before showing action buttons.
	 */
	do_action( 'yith_wacp_before_action_buttons' );
	?>

	<?php
	if ( $cart ) :
		/**
		 * APPLY_FILTERS: yith_wacp_go_cart_class
		 *
		 * Handles "Go to cart" button CSS classes.
		 *
		 * @param string $text The CSS classes.
		 */
		?>
		<a class="<?php echo esc_attr( apply_filters( 'yith_wacp_go_cart_class', 'button go-cart' ) ); ?>" href="<?php echo esc_url( $cart_url ); ?>">
			<?php echo wp_kses_post( get_option( 'yith-wacp-text-go-cart', yith_wacp_get_default( 'text-go-cart' ) ) ); ?>
		</a>
	<?php endif; ?>

	<?php
	if ( $checkout ) :
		/**
		 * APPLY_FILTERS: yith_wacp_go_checkout_class
		 *
		 * Handles "Go to checkout" button CSS classes.
		 *
		 * @param string $text The CSS classes.
		 */
		?>
		<a class="<?php echo esc_attr( apply_filters( 'yith_wacp_go_checkout_class', 'button go-checkout' ) ); ?>" href="<?php echo esc_url( $checkout_url ); ?>">
			<?php echo wp_kses_post( get_option( 'yith-wacp-text-go-checkout', yith_wacp_get_default( 'text-go-checkout' ) ) ); ?>
		</a>
	<?php endif; ?>

	<?php
	if ( $continue ) :
		/**
		 * APPLY_FILTERS: yith_wacp_continue_shopping_class
		 *
		 * Handles "Contine shopping" button CSS classes.
		 *
		 * @param string $text The CSS classes.
		 */
		?>
		<a class="<?php echo esc_attr( apply_filters( 'yith_wacp_continue_shopping_class', 'button continue-shopping' ) ); ?>" href="<?php echo esc_url( $continue_shopping_url ); ?>">
			<?php echo wp_kses_post( get_option( 'yith-wacp-text-continue-shopping', yith_wacp_get_default( 'text-continue-shopping' ) ) ); ?>
		</a>
	<?php endif; ?>

	<?php
	/**
	 * DO_ACTION: yith_wacp_after_action_buttons
	 *
	 * Perform actions after showing action buttons.
	 */
	do_action( 'yith_wacp_after_action_buttons' );
	?>
</div>
