<?php
/**
 * Popup related products template
 *
 * @package YITH\AddedToCartPopup\Templates
 * @var $products           array The current product Loop.
 * @var $title              string The block title.
 * @var $columns            integer The column number.
 * @var $show_add_to_cart   boolean Check if "add to cart" should be displayed.
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

?>
<div class="yith-wacp-related woocommmerce">
	<h4><?php echo esc_html( $title ); ?></h4>
	<ul class="yith-wacp-related-products products layout-columns-<?php echo esc_attr( $columns ); ?>">
		<?php while ( $products->have_posts() ) : ?>
			<?php $products->the_post(); ?>
			<li <?php post_class( array( 'yith-wacp-related-product' ) ); ?>>
				<?php
				/**
				 * DO_ACTION: yith_wacp_before_related_item
				 *
				 * Perform actions before showing the related product.
				 */
				do_action( 'yith_wacp_before_related_item' );
				// Opening product link.
				woocommerce_template_loop_product_link_open();
				// Show "sale" badge (if necessary).
				woocommerce_show_product_loop_sale_flash();
				// Display Product thumbnail.
				woocommerce_template_loop_product_thumbnail();
				// Show product title.
				woocommerce_template_loop_product_title();
				// Show product price.
				woocommerce_template_loop_price();
				// Show "add to cart" button, if enabled.
				$show_add_to_cart && woocommerce_template_loop_add_to_cart();
				// Closing. product link.
				woocommerce_template_loop_product_link_close();
				/**
				 * DO_ACTION: yith_wacp_after_related_item
				 *
				 * Perform actions after showing the related product.
				 */
				do_action( 'yith_wacp_after_related_item' );
				?>
			</li>
		<?php endwhile; ?>
	</ul>
</div>
