/**
 * Frontend Scripts
 *
 * @package YITH\AddedToCartPopup\Assets\JS
 */

jQuery(
	function ( $ ) {
		"use strict";

		if ( typeof yith_wacp == 'undefined' ) {
			return;
		}

		var PS_instance,
			popup                     = $( '#yith-wacp-popup' ),
			overlay                   = popup.find( '.yith-wacp-overlay' ),
			close                     = popup.find( '.yith-wacp-close' ),
			mini_cart_content         = undefined,
			close_popup               = function () {
				// Remove class to html.
				$( 'html' ).removeClass( 'yith_wacp_open' );

				// Remove class open.
				popup.removeClass( 'open mini_cart' );
				// After 2 sec remove content.
				setTimeout(
					function () {
						PS_instance.destroy();
					},
					1000
				);

				$( document ).trigger( 'yith_wacp_popup_after_closing' );
			},
			center_popup              = function () {
				// Center popup function.
				var wrapper  = popup.find( '.yith-wacp-wrapper' ),
					is_empty = popup.find( '.empty-cart' ).length,
					window_w = $( window ).width(),
					window_h = $( window ).height(),
					popup_h  = 380;

				if ( is_empty === 0 ) {
					var content_h = 70; // Initial value determined by top and bottom padding.

					// Get the height of internal items in order to make popup height flexible.
					$( '.yith-wacp-content > div[class^="yith-wacp"], .yith-wacp-content > h3[class^="yith-wacp"], .yith-wacp-content > table[class^="yith-wacp"]' ).each(
						function () {
							content_h += $( this ).outerHeight( true );
						}
					);

					popup_h = content_h < yith_wacp.popup_size.height ? content_h : yith_wacp.popup_size.height;
				}

				var width  = ( ( window_w - 60 ) > yith_wacp.popup_size.width ) ? yith_wacp.popup_size.width : ( window_w - 60 ),
					height = ( ( window_h - 120 ) > popup_h ) ? popup_h : ( window_h - 120 );

				wrapper.css(
					{
						'left'  : ( ( window_w / 2 ) - ( width / 2 ) ),
						'top'   : ( ( window_h / 2 ) - ( height / 2 ) ),
						'width' : width + 'px',
						'height': height + 'px'
					}
				);
			},
			position_mini_cart        = function () {
				var minicart = $( '#yith-wacp-mini-cart' ),
					window_w = $( window ).width(),
					window_h = $( window ).height(),
					top      = ( ( window_h * ( yith_wacp.mini_cart_position.top / 100 ) ) - minicart.innerHeight() ),
					left     = ( ( window_w * ( yith_wacp.mini_cart_position.left / 100 ) ) - minicart.innerWidth() );

				minicart.css(
					{
						'left': left,
						'top' : top
					}
				).show();
			},
			handle_popup_open         = function ( data ) {
				// Function that handle the popup opening.

				// Add content.
				var popup_content = popup.find( '.yith-wacp-content' );
				if ( typeof data != 'undefined' ) {
					popup_content.html( data ); // Update content.
				}

				// Remove notice in mini cart popup.
				if ( popup.hasClass( 'mini_cart' ) ) {
					popup.find( '.yith-wacp-message' ).remove()
				}

				// Check if popup is still open, if yes, update it.
				if ( popup.hasClass( 'open' ) ) {
					// Update scroll.
					if ( typeof PerfectScrollbar != 'undefined' ) {
						PS_instance.update();
					}
					// Then scroll to Top.
					popup_content.scrollTop( 0 );
					$( document ).trigger( 'yith_wacp_popup_changed', [popup] );
				} else {
					$( document ).trigger( 'yith_wacp_popup_before_opening', [popup] );
					// Position popup.
					center_popup();
					// Scroll.
					if ( typeof PerfectScrollbar != 'undefined' ) {
						PS_instance = new PerfectScrollbar(
							'.yith-wacp-content',
							{
								suppressScrollX: true
							}
						);
					}

					// Add class to html for prevent page scroll on mobile device.
					$( 'html' ).addClass( 'yith_wacp_open' );

					popup.addClass( 'open' );

					$( document ).trigger( 'yith_wacp_popup_after_opening', [popup] );
				}

				if ( yith_wacp.touchstart_on_popup_actions_buttons ) {
					$( document ).on(
						'touchstart',
						'.yith-wacp-popup-actions a',
						function () {
							var $t = $( this );

							if ( $t.hasClass( 'continue-shopping' ) ) {
								close_popup();
							} else {
								window.location.href = $t.attr( 'href' );
							}
						}
					);
				}

				if ( yith_wacp.touchstart_on_suggested_products ) {
					$( document ).on(
						'touchstart',
						'.yith-wacp-related-product > a',
						function () {
							var $t = $( this );

							window.location.href = $t.attr( 'href' );
						}
					);
				}

				return false;
			},
			handle_mini_cart_open     = function () {
				// Function that handle float cart open.
				if ( typeof mini_cart_content != 'undefined' ) {
					popup.addClass( 'mini_cart' );
					handle_popup_open( mini_cart_content );
				}
			},
			update_cart_count         = function ( num ) {
				var mini_cart       = $( '#yith-wacp-mini-cart' ),
					mini_cart_count = $( '.yith-wacp-mini-cart-count' );

				num > 0 ? mini_cart.removeClass( 'empty' ) : mini_cart.addClass( 'empty' );
				if ( mini_cart_count.length ) {
					mini_cart_count.html( num );
				}
				$( document ).trigger( 'yith_wacp_cart_counter_updated' );
			},
			getUrlParameter           = function ( sURL, sParam ) {
				// Function to get param from url.
				var sURLVariables    = sURL.split( '&' ),
					sParameterName,
					variables_length = sURLVariables.length,
					i;

				for ( i = 0; i < variables_length; i++ ) {
					sParameterName = sURLVariables[i].split( '=' );

					if ( sParameterName[0] === sParam ) {
						return sParameterName[1] === undefined ? true : sParameterName[1];
					}
				}
			},
			waiting_ajax              = function ( elem ) {
				if ( typeof $.fn.block != 'undefined' ) {
					elem.block(
						{
							message   : null,
							overlayCSS: {
								background: '#fff url(' + yith_wacp.loader + ') no-repeat center',
								opacity   : 0.5,
								cursor    : 'none'
							}
						}
					);
				}
			},
			handle_add_to_cart_single = function ( data, form, button ) {
				$( document ).trigger( 'yith_wacp_adding_cart_single' );

				button
					.addClass( 'loading' )
					.removeClass( 'added' );

				$.ajax(
					{
						url        : window.location,
						data       : data,
						contentType: false,
						processData: false,
						dataType   : 'json',
						type       : 'POST',
						success    : function ( response ) {
							// Add error notice if any.
							if ( typeof response.error != 'undefined' ) {
								// Add mess and scroll to Top.
								form.parents( 'div.product' ).before( response.error );
								$( 'body, html' ).animate(
									{
										scrollTop: 0
									},
									500
								);
								// Gravity form error handler.
								form.find( '.gfield input, .gfield textarea, .gfield select ' ).each(
									function () {
										if ( ! $( this ).val() ) {
											$( this ).closest( '.gfield' ).addClass( 'gfield_error' );
										}
									}
								);
							} else if ( typeof response.html != 'undefined' ) {

								handle_popup_open( response.html );
								mini_cart_content = response.cart_html;
								// Refresh fragments.
								$( document.body ).trigger( 'wc_fragment_refresh' ).trigger( 'wacp_single_added_to_cart' );
								update_cart_count( response.items );

							} else {
								// Trigger event added to cart.
								$( document.body ).trigger( 'added_to_cart', [response.fragments, response.cart_hash, button] );
							}
						},
						complete   : function () {
							// Remove disabled from submit button.
							button
								.prop( 'disabled', false )
								.removeClass( 'loading' )
								.addClass( 'added' );
						}
					}
				);
			};

		// ADD TO CART LOOP AND SINGLE PRODUCT.
		$( 'body' ).on(
			'added_to_cart cleverswatch_after_add_to_cart',
			function ( ev, fragmentsJSON ) {
				if ( typeof fragmentsJSON === 'undefined' ) {
					fragmentsJSON = JSON.parse( JSON.stringify( sessionStorage.getItem( wc_cart_fragments_params.fragment_name ) ) );
				}
				if ( typeof fragmentsJSON.yith_wacp_message != 'undefined' ) {
					if ( yith_wacp.allow_automatic_popup ) {
						handle_popup_open( popup.hasClass( 'mini_cart' ) ? fragmentsJSON.yith_wacp_message_cart : fragmentsJSON.yith_wacp_message );
					}
					mini_cart_content = fragmentsJSON.yith_wacp_message_cart;
					update_cart_count( fragmentsJSON.yith_wacp_cart_items );
				}
			}
		);
		// REQUEST A QUOTE.
		$( document ).on(
			'yith_wwraq_added_successfully',
			function ( ev, response ) {
				if ( typeof response.yith_wacp_raq != 'undefined' ) {
					handle_popup_open( response.yith_wacp_raq );
				}
			}
		);

		// ACTIONS
		// Remove from cart ajax.
		popup.on(
			'click',
			'.yith-wacp-remove-cart, .item-remove a.remove',
			function ( ev ) {
				ev.preventDefault();

				var remove_button = $( this ),
					item_key      = remove_button.data( 'item_key' ) ? remove_button.data( 'item_key' ) : getUrlParameter( remove_button.attr( 'href' ), 'remove_item' );

				var data = {
					action  : yith_wacp.actionRemove,
					item_key: item_key,
					context : 'frontend'
				};

				waiting_ajax( remove_button.parents( 'table' ) );

				$.ajax(
					{
						url     : yith_wacp.ajaxurl.toString().replace( '%%endpoint%%', yith_wacp.actionRemove ),
						data    : data,
						dataType: 'json',
						success : function ( res ) {

							if ( res.html !== '' ) {
								popup.find( '.yith-wacp-content' ).html( res.html );

								$( document ).trigger( 'yith_wacp_popup_changed', [popup] );
								$( document.body ).trigger( 'wc_fragment_refresh' );
							} else {
								$( document.body ).trigger( 'wc_fragment_refresh' );
								mini_cart_content = undefined;
								close_popup();
							}
							update_cart_count( res.items );
							mini_cart_content = res.html; // as in this case html is always the cart.
						}
					}
				);
			}
		);

		$( document ).on(
			'keydown',
			function ( e ) {
				if ( e.keyCode === 27 ) {
					close_popup();
				}
			}
		);

		// Update from cart ajax.
		popup.on(
			'change',
			'table.yith-wacp-cart-list input.qty',
			function ( ev ) {
				ev.preventDefault();

				var quantity = $( this );
				var data     = {
					action  : yith_wacp.actionUpdate,
					item_key: quantity.attr( 'name' ).replace( /\[|\]|qty/gi, '' ),
					qty     : quantity.val(),
					context : 'frontend'
				};

				waiting_ajax( quantity.parents( 'table' ) );

				$.ajax(
					{
						url     : yith_wacp.ajaxurl.toString().replace( '%%endpoint%%', yith_wacp.actionUpdate ),
						data    : data,
						dataType: 'json',
						success : function ( res ) {
							if ( res.html !== '' ) {
								popup.find( '.yith-wacp-content' ).html( res.html );
								$( document ).trigger( 'yith_wacp_popup_changed', [popup] );
								$( document.body ).trigger( 'wc_fragment_refresh' );
							}
							update_cart_count( res.items );
							mini_cart_content = res.html; // As in this case html is always the cart.
						}
					}
				);
			}
		);

		// Continue shopping.
		popup.on(
			'click',
			'a.continue-shopping',
			function ( e ) {
				if ( $( this ).attr( 'href' ) !== '#' ) {
					return;
				}
				e.preventDefault();
				close_popup();
			}
		);

		// Update raq quote list.
		popup.on(
			'submit',
			'#yith-ywraq-form',
			function ( ev ) {
				ev.preventDefault();

				var t    = $( this ),
					form = t.serializeArray();

				// Add action.
				form.push(
					{
						name : "action",
						value: yith_wacp.actionUpdateRaq
					},
					{
						name : "context",
						value: "frontend"
					}
				);

				$.ajax(
					{
						url     : yith_wacp.ajaxurl.toString().replace( '%%endpoint%%', yith_wacp.actionUpdateRaq ),
						data    : $.param( form ),
						dataType: 'json',
						type    : 'POST',
						success : function ( res ) {
							handle_popup_open( res.yith_wacp_raq );
						}
					}
				);
			}
		);

		// GENERAL ACTION.
		overlay.on( 'click', close_popup );
		close.on(
			'click',
			function ( ev ) {
				ev.preventDefault();
				close_popup();
			}
		);

		$( window ).on( 'resize yith_wacp_popup_changed', center_popup );

		// ADD TO CART AJAX IN SINGLE PRODUCT PAGE.
		$( document ).on(
			'submit',
			yith_wacp.form_selectors,
			function ( ev ) {

				var form         = $( this ),
					button       = form.find( 'button[type="submit"]' ),
					exclude      = form.find( 'input[name="yith-wacp-is-excluded"]' ),
					is_one_click = form.find( 'input[name="_yith_wocc_one_click"]' ).val() === 'is_one_click',
					productId    = form.find( '[name="add-to-cart"]' ).val();

				if ( typeof wc_cart_fragments_params === 'undefined' || ! yith_wacp.enable_single || $( this ).parents( '.product-type-external' ).length === 1 || button.hasClass( 'wcsatt-add-to-subscription-button' ) ) {
					return;
				}

				// Check if excluded.
				if ( exclude.length || is_one_click ) {
					return;
				}

				ev.preventDefault();

				// Process Form.
				var dataForm = new FormData();
				$.each(
					form.find( "input[type='file']" ),
					function ( i, tag ) {
						$.each(
							$( tag )[0].files,
							function ( i, file ) {
								dataForm.append( tag.name, file );
							}
						);
					}
				);

				$.each(
					form.serializeArray(),
					function ( i, val ) {
						dataForm.append( val.name, val.value );
					}
				);

				dataForm.append( 'context', 'frontend' );
				dataForm.append( 'action', yith_wacp.actionAdd );
				dataForm.append( 'ywacp_is_single', 'yes' );
				dataForm.append( 'yith_wcmcs_currency', yith_wacp.current_currency );

				// Make sure add-to-cart and product_id are set (useful for simple products).
				( ! dataForm.getAll( 'add-to-cart' ).length && productId ) && dataForm.append( 'add-to-cart', productId );
				( ! dataForm.getAll( 'product_id' ).length && productId ) && dataForm.append( 'product_id', productId );

				handle_add_to_cart_single( dataForm, form, button );
			}
		);

		$( document ).on(
			'yith_wacp_popup_after_opening yith_wacp_popup_changed',
			function () {
				if ( typeof $.yith_wccl != 'undefined' && typeof $.fn.wc_variation_form != 'undefined' ) {
					// Not initialized.
					$( document ).find( '.variations_form:not(.initialized)' ).each(
						function () {
							$( this ).wc_variation_form();
						}
					);
					$.yith_wccl();
				}

				// Compatibility with lazyload.
				if ( typeof thb_lazyload != 'undefined' ) {
					thb_lazyload.update();
				}
			}
		);

		$( document.body ).on(
			'wc_cart_button_updated',
			function ( ev, button ) {
				if ( button.closest( 'form.cart' ).length ) {
					button.parent().find( '.added_to_cart' ).remove();
				}
			}
		);

		// ADD TO CART FREQUENTLY BOUGHT.

		$( document ).on(
			'submit',
			'.yith-wfbt-form',
			function ( ev ) {

				if ( typeof yith_wacp.actionAddFBT == 'undefined' ) {
					return;
				}

				ev.preventDefault();

				var form     = $( this ),
					button   = form.find( 'button[type="submit"]' ),
					data     = new FormData(),
					dataForm = form.serializeArray();

				// Process Form.
				$.each(
					dataForm,
					function ( i, val ) {
						data.append( val.name, val.value );
					}
				);
				data.append( 'context', 'frontend' );
				data.append( 'actionAjax', yith_wacp.actionAddFBT );
				data.append( 'action', 'yith_bought_together' );
				data.append( '_wpnonce', yith_wacp.nonceFBT );

				handle_add_to_cart_single( data, form, button );
			}
		);

		// HANDLE MINI CART.
		if ( typeof yith_wacp.actionUpdateMiniCart != 'undefined' && $( '#yith-wacp-mini-cart' ).length ) {
			var update_mini_cart = function () {
				waiting_ajax( $( '#yith-wacp-mini-cart' ) );
				$.ajax(
					{
						url     : yith_wacp.ajaxurl.toString().replace( '%%endpoint%%', yith_wacp.actionUpdateMiniCart ),
						data    : {
							action : yith_wacp.actionUpdateMiniCart,
							context: 'frontend'
						},
						dataType: 'json',
						cache   : false,
						success : function ( res ) {
							mini_cart_content = res.html;
							update_cart_count( res.items );
							$( document ).on( 'click', yith_wacp.open_popup_selectors, handle_mini_cart_open );
						},
						complete: function () {
							if ( typeof $.fn.block != 'undefined' ) {
								$( '#yith-wacp-mini-cart' ).unblock();
							}
						}
					}
				);
			};

			$( window ).on( 'resize', position_mini_cart );
			position_mini_cart();
			update_mini_cart();

			$( document ).on( 'ajaxfdoe_added wc_fragment_refresh', update_mini_cart );

		}
	}
);
