<?php
/**
 * Admin Premium class
 *
 * @package YITH\AddedToCartPopup\Admin
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

if ( ! class_exists( 'YITH_WACP_Admin_Premium' ) ) {

	/**
	 * Admin class.
	 * The class manage all the admin behaviors.
	 *
	 * @class   YITH_WACP_Admin_Premium
	 * @since   1.0.0
	 * @author  YITH <plugins@yithemes.com>
	 * @package YITH\AddedToCartPopup\Admin
	 */
	class YITH_WACP_Admin_Premium extends YITH_WACP_Admin_Extended {

		use YITH_WACP_Trait_Singleton;

		/**
		 * Constructor
		 *
		 * @access public
		 * @since  1.0.0
		 */
		public function __construct() {

			parent::__construct();

			// Add custom draggable position type.
			add_filter( 'woocommerce_admin_settings_sanitize_option_yith-wacp-mini-cart-position', array( $this, 'sanitize_option_draggable' ), 10 );
			add_filter( 'woocommerce_admin_settings_sanitize_option_yith-wacp-related-products', array( $this, 'sanitize_option_products' ), 10 );
			add_filter( 'woocommerce_admin_settings_sanitize_option_yith-wacp-image-size', array( $this, 'sanitize_option_size' ), 10 );
			add_filter( 'yith_wacp_admin_tabs', array( $this, 'add_tabs' ), 1 );

			// Add exclusions tables.
			add_action( 'yith_wacp_exclusions_table', array( $this, 'exclusions_table' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts_premium' ) );
			add_filter( 'yith_plugin_fw_inline_fields_allowed_types', array( $this, 'add_inline_field_panel' ), 10, 2 );
			add_filter( 'yith_plugin_fw_get_field_template_path', array( $this, 'get_yith_panel_custom_template' ), 10, 2 );

		}

		/**
		 * Add premium tabs in settings panel
		 *
		 * @param array $tabs An array of plugin admin settings tabs.
		 *
		 * @return array
		 * @since  1.0.0
		 */
		public function add_tabs( $tabs ) {
			$tabs['customization'] = esc_html__( 'Customization', 'yith-woocommerce-added-to-cart-popup' );
			$tabs['mini-cart']     = esc_html__( 'Mini Cart', 'yith-woocommerce-added-to-cart-popup' );
			$tabs['exclusions']    = esc_html__( 'Exclusion List', 'yith-woocommerce-added-to-cart-popup' );

			return $tabs;
		}

		/**
		 * Add products exclusion table
		 *
		 * @access public
		 * @since  1.0.0
		 */
		public function exclusions_table() {

			$get           = $_GET; // phpcs:ignore WordPress.Security.NonceVerification.Recommended
			$template_file = YITH_WACP_VIEWS_PATH . '/panel/custom-tabs/yith-wacp-exclusions-table.php';

			if ( isset( $get['page'] ) && $get['page'] === $this->panel_page && isset( $get['tab'] ) && 'exclusions' === $get['tab'] && file_exists( $template_file ) ) {

				include_once YITH_WACP_INC . '/admin/admin-tables/class-yith-wacp-exclusions-list-table.php';
				$table = new YITH_WACP_Exclusions_List_Table();
				$table->handle_bulk_action();

				$exclusions_prod = array_filter( explode( ',', get_option( 'yith-wacp-exclusions-prod-list' ) ) );
				$exclusions_cat  = array_filter( explode( ',', get_option( 'yith-wacp-exclusions-cat-list' ) ) );
				$list            = array_merge( $exclusions_prod, $exclusions_cat );
				$is_blank        = count( $list ) === 0;
				$table->prepare_items();

				include_once $template_file;
			}
		}

		/**
		 * Enqueue premium styles and scripts
		 *
		 * @access public
		 * @since  1.0.0
		 */
		public function enqueue_scripts_premium() {

			wp_register_style( 'yith-wacp-admin', yit_load_css_file( YITH_WACP_ASSETS_URL . '/css/wacp-admin.css' ), array( 'wp-jquery-ui-dialog' ), YITH_WACP_VERSION );
			wp_register_script( 'yith-wacp-admin', yit_load_js_file( YITH_WACP_ASSETS_URL . '/js/wacp-admin-panel.js' ), array( 'jquery', 'jquery-blockui', 'jquery-ui-dialog' ), YITH_WACP_VERSION, true );

			$get = $_GET; // phpcs:ignore WordPress.Security.NonceVerification.Recommended

			if ( isset( $get['page'] ) && $get['page'] === $this->panel_page ) {
				wp_enqueue_style( 'yith-wacp-admin' );
				wp_enqueue_script( 'yith-wacp-admin' );
				wp_localize_script(
					'yith-wacp-admin',
					'yith_wacp_exclusion_list',
					array(
						'ajaxurl'         => admin_url( 'admin-ajax.php' ),
						'delete_nonce'    => wp_create_nonce( 'yith_wacp_delete_exclusions' ),
						'popup_add_title' => esc_html__( 'Add exclusion', 'yith-woocommerce-added-to-cart-popup' ),
						'save'            => esc_html__( 'Add exclusion to the list', 'yith-woocommerce-added-to-cart-popup' ),
						'confirmChoice'   => esc_html_x( 'Continue', 'Label button of a dialog popup', 'yith-woocommerce-added-to-cart-popup' ),
						'cancel'          => esc_html_x( 'Cancel', 'Label button of a dialog popup', 'yith-woocommerce-added-to-cart-popup' ),
					)
				);
			}

		}

		/**
		 * Add custom panel fields.
		 *
		 * @param string $template Template ID.
		 * @param array  $field    Field options.
		 *
		 * @return string
		 * @since  2.0.0
		 */
		public function get_yith_panel_custom_template( $template, $field ) {
			$custom_option_types = array(
				'yith-wacp-draggable-position',
			);

			$field_type = $field['type'];

			if ( isset( $field['type'] ) && in_array( $field['type'], $custom_option_types, true ) ) {
				$template = YITH_WACP_VIEWS_PATH . "/panel/types/$field_type.php";
			}

			return $template;
		}

		/**
		 * Add checkbox to inline field allowed types
		 *
		 * @param array  $types The allowed field types.
		 * @param string $name  The field name.
		 *
		 * @return array
		 * @since  2.0.0
		 */
		public function add_inline_field_panel( $types, $name ) {
			if ( 'yith-wacp-image-size' === $name ) {
				$types[] = 'checkbox';
			}

			return $types;
		}

		/**
		 * Sanitize option for select products
		 *
		 * @param mixed $value The option value.
		 *
		 * @return mixed
		 * @since  1.1.0
		 */
		public function sanitize_option_products( $value ) {
			return is_null( $value ) ? array() : $value;
		}

		/**
		 * Sanitize option image sizeoption
		 *
		 * @param mixed $value The option value.
		 *
		 * @return mixed
		 * @since  1.1.0
		 */
		public function sanitize_option_size( $value ) {

			if ( ! isset( $value['crop'] ) ) {
				$value['crop'] = 'no';
			}

			return is_null( $value ) ? array() : $value;
		}

		/**
		 * Sanitize option for draggable position
		 *
		 * @param mixed $value The option value.
		 *
		 * @return mixed
		 * @since  1.4.0
		 */
		public function sanitize_option_draggable( $value ) {

			foreach ( $value as $key => $pos ) {
				$value[ $key ] = intval( $pos );
				$value[ $key ] = $pos > 100 ? 100 : ( $pos < 0 ? 0 : $value[ $key ] );
			}

			return $value;
		}
	}
}
