<?php
/**
 * Main premium class
 *
 * @package YITH\AddedToCartPopup
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

if ( ! class_exists( 'YITH_WACP_Premium' ) ) {

	/**
	 * Implements features of YITH WooCommerce Added to Cart Popup plugin
	 *
	 * @class   YITH_WACP_Premium
	 * @since   1.0.0
	 * @author  YITH <plugins@yithemes.com>
	 * @package YITH\AddedToCartPopup
	 */
	class YITH_WACP_Premium extends YITH_WACP_Extended {

		use YITH_WACP_Trait_Singleton;

		/**
		 * Constructor
		 *
		 * @return void
		 * @since  1.0.0
		 */
		public function __construct() {
			parent::__construct();

			// Register plugin to licence/update system.
			add_action( 'wp_loaded', array( $this, 'register_plugin_for_activation' ), 99 );
			add_action( 'admin_init', array( $this, 'register_plugin_for_updates' ) );

			$this->load_integrations();

			add_action( 'init', array( $this, 'update_old_options' ), 1 );

			if ( $this->is_admin() ) {
				YITH_WACP_Admin_Exclusions_Handler::get_instance();
			}

		}

		/**
		 * Load required files
		 *
		 * @return void
		 * @since  2.0.0
		 */
		public function require_files() {
			parent::require_files();
			require_once YITH_WACP_INC . 'functions.yith-wacp-premium.php';
		}

		/**
		 * Load class integrations if needed
		 *
		 * @return void
		 * @since  1.3.0
		 */
		public function load_integrations() {

			// YITH WooCommerce Cart Messages Premium integration class.
			if ( yith_wacp_is_ywcm_enabled() ) {
				YITH_WACP_YWCM_Integration::get_instance();
			}

			// YITH WooCommerce Request A Quote integration class.
			if ( yith_wacp_is_ywraq_enabled() && ! $this->is_admin() && get_option( 'yith-wacp-enable-raq', 'no' ) === 'yes' ) {
				YITH_WACP_YWRAQ_Integration::get_instance();
			}

		}

		/**
		 * Update old option for new panel in version 2.0
		 *
		 * @return void
		 * @since  1.5.0
		 */
		public function update_old_options() {

			$last_options_updated = get_option( 'yith-wacp-option-version', '1.0.0' );

			if ( version_compare( $last_options_updated, '2.0.0', '<' ) ) {
				$notice_text_color       = get_option( 'yith-wacp-message-text-color' );
				$notice_color_background = get_option( 'yith-wacp-message-background-color' );

				if ( $notice_color_background ) {
					update_option(
						'yith-wacp-notice-colors',
						array(
							'text'       => $notice_text_color,
							'background' => $notice_color_background,
						)
					);

					delete_option( 'yith-wacp-message-text-color' );
					delete_option( 'yith-wacp-message-background-color' );
				}

				$total_and_shipping_label  = get_option( 'yith-wacp-cart-info-label-color' );
				$total_and_shipping_amount = get_option( 'yith-wacp-cart-info-amount-color' );

				if ( $total_and_shipping_label && $total_and_shipping_amount ) {
					update_option(
						'yith-wacp-shipping-taxes-label-color',
						array(
							'label'  => $total_and_shipping_label,
							'amount' => $total_and_shipping_amount,
						)
					);
					update_option(
						'yith-wacp-cart-total-label-color',
						array(
							'label'  => $total_and_shipping_label,
							'amount' => $total_and_shipping_amount,
						)
					);

					delete_option( 'yith-wacp-cart-info-label-color' );
					delete_option( 'yith-wacp-cart-info-amount-color' );
				}
				$button_background_color = get_option( 'yith-wacp-button-background' );
				$button_text_color       = get_option( 'yith-wacp-button-text' );
				if ( ! is_array( $button_background_color ) && ! is_array( $button_text_color ) ) {
					$button_background_color_hover = get_option( 'yith-wacp-button-background-hover' );
					$button_text_color_hover       = get_option( 'yith-wacp-button-text-hover' );
				}
				if ( $button_background_color && $button_text_color ) {
					$new_options = array( 'yith-wacp-view-cart-button-colors', 'yith-wacp-checkout-button-colors', 'yith-wacp-continue-shopping-button-colors' );
					foreach ( $new_options as $key => $value ) {
						update_option(
							$value,
							array(
								'background_normal' => is_array( $button_background_color ) ? $button_background_color['normal'] : $button_background_color,
								'background_hover'  => is_array( $button_background_color ) ? $button_background_color['hover'] : $button_background_color_hover,
								'text_normal'       => is_array( $button_text_color ) ? $button_text_color['normal'] : $button_text_color,
								'text_hover'        => is_array( $button_text_color ) ? $button_text_color['hover'] : $button_text_color_hover,
								'border_normal'     => is_array( $button_background_color ) ? $button_background_color['normal'] : $button_background_color,
								'border_hover'      => is_array( $button_background_color ) ? $button_background_color['hover'] : $button_background_color_hover,
							)
						);
					}

					delete_option( 'yith-wacp-button-background' );
					delete_option( 'yith-wacp-button-text' );
					if ( ! empty( $button_background_color_hover ) && ! empty( $button_text_color_hover ) ) {
						delete_option( 'yith-wacp-button-background-hover' );
						delete_option( 'yith-wacp-button-text-hover' );
					}
				}

				$overlay_opacity = get_option( 'yith-wacp-overlay-opacity' );
				$overlay_color   = get_option( 'yith-wacp-overlay-color' );
				if ( $overlay_opacity && $overlay_color ) {
					if ( '#000000' === $overlay_color ) {
						$overlay_color = 'rgb(0,0,0)';
					}

					$color    = str_replace( array( 'rgba', 'rgb', '(', ')', ' ' ), '', $overlay_color );
					$rgba_arr = explode( ',', $color );
					if ( array_key_exists( 3, $rgba_arr ) ) {
						$rgba_arr[3] = $overlay_opacity;
					} else {
						array_push( $rgba_arr, $overlay_opacity );
					}
					$rgba = 'rgba(' . $rgba_arr[0] . ',' . $rgba_arr[1] . ',' . $rgba_arr[2] . ',' . $rgba_arr[3] . ')';

					update_option( 'yith-wacp-overlay-color', $rgba );
					delete_option( 'yith-wacp-overlay-opacity' );
				}

				update_option( 'yith-wacp-option-version', YITH_WACP_VERSION );
			}

		}

		/**
		 * Register plugins for activation tab
		 *
		 * @return void
		 * @since  2.0.0
		 */
		public function register_plugin_for_activation() {
			if ( ! class_exists( 'YIT_Plugin_Licence' ) ) {
				require_once YITH_WACP_DIR . 'plugin-fw/lib/yit-licence.php';
			}

			YIT_Plugin_Licence()->register( YITH_WACP_INIT, YITH_WACP_SECRET_KEY, YITH_WACP_SLUG );
		}

		/**
		 * Register plugins for update tab
		 *
		 * @return void
		 * @since  2.0.0
		 */
		public function register_plugin_for_updates() {
			if ( ! class_exists( 'YIT_Upgrade' ) ) {
				require_once YITH_WACP_DIR . 'plugin-fw/lib/yit-upgrade.php';
			}

			YIT_Upgrade()->register( YITH_WACP_SLUG, YITH_WACP_INIT );
		}
	}
}
