<?php
/**
 * Handle integration with YITH WooCommerce Cart Messages Premium
 *
 * @package YITH\AddedToCartPopup\Integrations
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

if ( ! class_exists( 'YITH_WACP_YWCM_Integration' ) ) {

	/**
	 * Integration class.
	 * The class manage all the integration behaviors with YITH WooCommerce Cart Messages Premium.
	 *
	 * @class   YITH_WACP_YWCM_Integration
	 * @since   1.1.0
	 * @author  YITH <plugins@yithemes.com>
	 * @package YITH\AddedToCartPopup\Integrations
	 */
	class YITH_WACP_YWCM_Integration {

		use YITH_WACP_Trait_Singleton;

		/**
		 * Constructor
		 *
		 * @access public
		 * @since  1.1.0
		 */
		public function __construct() {
			add_filter( 'ywcm_message_metabox', array( $this, 'add_option_meta' ), 99, 1 );
			add_action( 'yith_wacp_before_popup_content', array( $this, 'cart_messages' ), 15, 1 );
		}

		/**
		 * Add option on Cart Messages array meta box
		 *
		 * @param array $options And array of meta box options for cart message.
		 *
		 * @return array
		 * @since  1.1.0
		 */
		public function add_option_meta( $options ) {

			$options['ywcm_message_show_on_added_cart_popup'] = array(
				'label' => esc_html__( 'Show on "Added to Cart" popup', 'yith-woocommerce-added-to-cart-popup' ),
				'desc'  => esc_html__( 'Show this message also on YITH WooCommerce Added to Cart Popup.', 'yith-woocommerce-added-to-cart-popup' ),
				'type'  => 'checkbox',
				'std'   => 'no',
			);

			return $options;
		}

		/**
		 * Add message on added to cart popup
		 *
		 * @since  1.1.0
		 */
		public function cart_messages() {

			// phpcs:disable WordPress.NamingConventions.ValidVariableName.VariableNotSnakeCase
			global $YWCM_Instance;

			$messages      = YWCM_Cart_Message()->get_messages();
			$messages_html = '';

			if ( empty( $messages ) ) {
				return;
			}

			// Prevent check page types by removing filter.
			remove_filter( 'yith_ywcm_is_valid_message', array( $YWCM_Instance, 'is_valid_page' ), 10 );

			foreach ( $messages as $message ) {
				/**
				 * APPLY_FILTERS: yith_ywcm_is_valid_message
				 *
				 * Check if it's a valid cart message.
				 *
				 * @param boolean $value      Is the message valid?
				 * @param integer $message_id The message ID.
				 */
				if ( apply_filters( 'yith_ywcm_is_valid_message', $YWCM_Instance->is_valid( $message->ID ), $message->ID ) ) {
					if ( ! get_post_meta( $message->ID, '_ywcm_message_show_on_added_cart_popup', true ) ) {
						continue;
					}

					$message_type = get_post_meta( $message->ID, '_ywcm_message_type', true );
					$layout       = ( get_post_meta( $message->ID, '_ywcm_message_layout', true ) !== '' ) ? get_post_meta( $message->ID, '_ywcm_message_layout', true ) : 'layout';
					$args         = ( method_exists( $YWCM_Instance, 'get_' . $message_type . '_args' ) ) ? $YWCM_Instance->{'get_' . $message_type . '_args'}( $message ) : false;

					if ( $args ) {
						$args['ywcm_id'] = $message->ID;

						$messages_html .= yit_plugin_get_template( YITH_YWCM_DIR, '/layouts/' . $layout . '.php', $args, true );
					}
				}
			}

			echo wp_kses_post( $messages_html );
			// phpcs:enable WordPress.NamingConventions.ValidVariableName.VariableNotSnakeCase
		}
	}
}
