<?php
/**
 * Buttons design sub-tab array
 *
 * @package YITH\AddedToCartPopup\PluginOptions\Customization
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

return array(
	'customization-buttons' => array(
		array(
			'type' => 'sectionstart',
			'id'   => 'yith_wacp_buttons_settings_options_start',
		),
		array(
			'title' => '',
			'type'  => 'title',
			'desc'  => '',
			'id'    => 'yith_wacp_buttons_options_title',
		),
		array(
			'title'     => esc_html__( 'Show "View Cart" button', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show the "View Cart" button in the popup.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'show-go-cart' ),
			'id'        => 'yith-wacp-show-go-cart',
		),
		array(
			'title'     => esc_html__( '"View Cart" label', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the label for the "View Cart" button.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'text',
			'default'   => yith_wacp_get_default( 'text-go-cart' ),
			'id'        => 'yith-wacp-text-go-cart',
			'deps'      => array(
				'id'    => 'yith-wacp-show-go-cart',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		array(
			'title'        => esc_html__( '"View Cart" colors', 'yith-woocommerce-added-to-cart-popup' ),
			'id'           => 'yith-wacp-view-cart-button-colors',
			'type'         => 'yith-field',
			'yith-type'    => 'multi-colorpicker',
			'desc'         => esc_html__( 'Set the "View Cart" button colors.', 'yith-woocommerce-added-to-cart-popup' ),
			'colorpickers' => array(
				array(
					'name'    => esc_html__( 'Text', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'text_normal',
					'default' => yith_wacp_get_default( 'view-cart-button-colors', 'text_normal' ),
				),
				array(
					'name'    => esc_html__( 'Background', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'background_normal',
					'default' => yith_wacp_get_default( 'view-cart-button-colors', 'background_normal' ),
				),
				array(
					'name'    => esc_html__( 'Border', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'border_normal',
					'default' => yith_wacp_get_default( 'view-cart-button-colors', 'border_normal' ),
				),
				array(
					'name'    => esc_html__( 'Text Hover', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'text_hover',
					'default' => yith_wacp_get_default( 'view-cart-button-colors', 'text_hover' ),
				),
				array(
					'name'    => esc_html__( 'Background Hover', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'background_hover',
					'default' => yith_wacp_get_default( 'view-cart-button-colors', 'background_hover' ),
				),
				array(
					'name'    => esc_html__( 'Border Hover', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'border_hover',
					'default' => yith_wacp_get_default( 'view-cart-button-colors', 'border_hover' ),
				),
			),
			'deps'         => array(
				'id'    => 'yith-wacp-show-go-cart',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		array(
			'title'     => esc_html__( 'Show "Checkout" button', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show the "Checkout" button.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'show-go-checkout' ),
			'id'        => 'yith-wacp-show-go-checkout',
		),
		array(
			'title'     => esc_html__( '"Checkout" label', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the label for the "Checkout" button.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'text',
			'default'   => yith_wacp_get_default( 'text-go-checkout' ),
			'id'        => 'yith-wacp-text-go-checkout',
			'deps'      => array(
				'id'    => 'yith-wacp-show-go-checkout',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		array(
			'title'        => esc_html__( '"Checkout" colors', 'yith-woocommerce-added-to-cart-popup' ),
			'id'           => 'yith-wacp-checkout-button-colors',
			'type'         => 'yith-field',
			'yith-type'    => 'multi-colorpicker',
			'desc'         => esc_html__( 'Set the "Checkout" button colors.', 'yith-woocommerce-added-to-cart-popup' ),
			'colorpickers' => array(
				array(
					'name'    => esc_html__( 'Text', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'text_normal',
					'default' => yith_wacp_get_default( 'checkout-button-colors', 'text_normal' ),
				),
				array(
					'name'    => esc_html__( 'Background', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'background_normal',
					'default' => yith_wacp_get_default( 'checkout-button-colors', 'background_normal' ),
				),
				array(
					'name'    => esc_html__( 'Border', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'border_normal',
					'default' => yith_wacp_get_default( 'checkout-button-colors', 'border_normal' ),
				),
				array(
					'name'    => esc_html__( 'Text Hover', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'text_hover',
					'default' => yith_wacp_get_default( 'checkout-button-colors', 'text_hover' ),
				),
				array(
					'name'    => esc_html__( 'Background Hover', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'background_hover',
					'default' => yith_wacp_get_default( 'checkout-button-colors', 'background_hover' ),
				),
				array(
					'name'    => esc_html__( 'Border Hover', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'border_hover',
					'default' => yith_wacp_get_default( 'checkout-button-colors', 'border_hover' ),
				),
			),
			'deps'         => array(
				'id'    => 'yith-wacp-show-go-checkout',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		array(
			'title'     => esc_html__( 'Show "Continue Shopping" button', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show the "Continue Shopping" button in the popup.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'show-continue-shopping' ),
			'id'        => 'yith-wacp-show-continue-shopping',
		),
		array(
			'title'     => esc_html__( '"Continue Shopping" label', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the label for the "Continue Shopping" button.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'text',
			'default'   => yith_wacp_get_default( 'text-continue-shopping' ),
			'id'        => 'yith-wacp-text-continue-shopping',
			'deps'      => array(
				'id'    => 'yith-wacp-show-continue-shopping',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		array(
			'title'        => esc_html__( '"Continue Shopping" colors', 'yith-woocommerce-added-to-cart-popup' ),
			'id'           => 'yith-wacp-continue-shopping-button-colors',
			'type'         => 'yith-field',
			'yith-type'    => 'multi-colorpicker',
			'desc'         => esc_html__( 'Set the "Continue Shopping" button colors.', 'yith-woocommerce-added-to-cart-popup' ),
			'colorpickers' => array(
				array(
					'name'    => esc_html__( 'Text', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'text_normal',
					'default' => yith_wacp_get_default( 'continue-shopping-button-colors', 'text_normal' ),
				),
				array(
					'name'    => esc_html__( 'Background', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'background_normal',
					'default' => yith_wacp_get_default( 'continue-shopping-button-colors', 'background_normal' ),
				),
				array(
					'name'    => esc_html__( 'Border', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'border_normal',
					'default' => yith_wacp_get_default( 'continue-shopping-button-colors', 'border_normal' ),
				),
				array(
					'name'    => esc_html__( 'Text Hover', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'text_hover',
					'default' => yith_wacp_get_default( 'continue-shopping-button-colors', 'text_hover' ),
				),
				array(
					'name'    => esc_html__( 'Background Hover', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'background_hover',
					'default' => yith_wacp_get_default( 'continue-shopping-button-colors', 'background_hover' ),
				),
				array(
					'name'    => esc_html__( 'Border Hover', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'border_hover',
					'default' => yith_wacp_get_default( 'continue-shopping-button-colors', 'border_hover' ),
				),
			),
			'deps'         => array(
				'id'    => 'yith-wacp-show-continue-shopping',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		array(
			'title'     => esc_html__( 'Border radius', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the buttons border radius.', 'yith-woocommerce-added-to-cart-popup' ),
			'id'        => 'yith-wacp-button-border-radius',
			'type'      => 'yith-field',
			'yith-type' => 'dimensions',
			'units'     => array( 'px' => 'px' ),
			'default'   => yith_wacp_get_default( 'button-border-radius' ),
		),
		array(
			'type' => 'sectionend',
			'id'   => 'yith_wacp_buttons_settings_options_end',
		),
	),
);
