<?php
/**
 * Cart total sub-tab array
 *
 * @package YITH\AddedToCartPopup\PluginOptions\Customization
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

return array(
	'customization-cart-total' => array(
		array(
			'type' => 'sectionstart',
			'id'   => 'yith_wacp_cart_total_options_start',
		),
		array(
			'title' => '',
			'type'  => 'title',
			'desc'  => '',
			'id'    => 'yith_wacp_cart_total_options_title',
		),
		array(
			'title'     => esc_html__( 'Show shipping cost', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show the shipping cost in the popup.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'show-cart-shipping' ),
			'id'        => 'yith-wacp-show-cart-shipping',
		),
		array(
			'title'     => esc_html__( 'Show taxes', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show the taxes in the popup.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'show-cart-tax' ),
			'id'        => 'yith-wacp-show-cart-tax',
		),
		array(
			'title'        => esc_html__( 'Shipping & taxes colors', 'yith-woocommerce-added-to-cart-popup' ),
			'type'         => 'yith-field',
			'yith-type'    => 'multi-colorpicker',
			'desc'         => esc_html__( 'Set the colors for the shipping and taxes info.', 'yith-woocommerce-added-to-cart-popup' ),
			'id'           => 'yith-wacp-shipping-taxes-label-color',
			'colorpickers' => array(
				array(
					'name'    => esc_html__( 'Label', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'label',
					'default' => yith_wacp_get_default( 'shipping-taxes-label-color', 'label' ),
				),
				array(
					'name'    => esc_html__( 'Amount', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'amount',
					'default' => yith_wacp_get_default( 'shipping-taxes-label-color', 'amount' ),
				),
			),
		),
		array(
			'title'     => esc_html__( 'Show cart total', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show the cart total in the popup.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'show-cart-totals' ),
			'id'        => 'yith-wacp-show-cart-totals',
		),
		array(
			'title'        => esc_html__( 'Cart total colors', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'         => esc_html__( 'Set the colors for the cart total.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'         => 'yith-field',
			'yith-type'    => 'multi-colorpicker',
			'colorpickers' => array(
				array(
					'name'    => esc_html__( 'Label', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'label',
					'default' => yith_wacp_get_default( 'cart-total-label-color', 'label' ),
				),
				array(
					'name'    => esc_html__( 'Amount', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'amount',
					'default' => yith_wacp_get_default( 'cart-total-label-color', 'amount' ),
				),
			),
			'id'           => 'yith-wacp-cart-total-label-color',
			'deps'         => array(
				'id'    => 'yith-wacp-show-cart-totals',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		array(
			'type' => 'sectionend',
			'id'   => 'yith_wacp_cart_total_options_end',
		),
	),
);
