<?php
/**
 * Popup design sub-tab array
 *
 * @package YITH\AddedToCartPopup\PluginOptions\Customization
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

return array(
	'customization-popup-design' => array(
		array(
			'type' => 'sectionstart',
			'id'   => 'yith_wacp_popup_design_settings_options_start',
		),
		array(
			'title' => '',
			'type'  => 'title',
			'desc'  => '',
			'id'    => 'yith_wacp_popup_design_settings_options_title',
		),
		array(
			'type'      => 'yith-field',
			'yith-type' => 'inline-fields',
			'title'     => esc_html__( 'Popup size (px)', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the popup width and height in pixels.', 'yith-woocommerce-added-to-cart-popup' ),
			'id'        => 'yith-wacp-box-size',
			'fields'    => array(
				'width'  => array(
					'default' => yith_wacp_get_default( 'box-size', 'width' ),
					'type'    => 'number',
				),
				'height' => array(
					'inline-label' => '&times;',
					'default'      => yith_wacp_get_default( 'box-size', 'height' ),
					'type'         => 'number',
				),
			),
			'deps'      => array(
				'id'    => 'yith-wacp-show-thumbnail',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		array(
			'title'     => esc_html__( 'Popup animation', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Choose the popup animation effect.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'select',
			'class'     => 'wc-enhanced-select',
			'options'   => array(
				'fade-in'         => esc_html__( 'Fade in', 'yith-woocommerce-added-to-cart-popup' ),
				'slide-in-right'  => esc_html__( 'Slide in (right)', 'yith-woocommerce-added-to-cart-popup' ),
				'slide-in-left'   => esc_html__( 'Slide in (left)', 'yith-woocommerce-added-to-cart-popup' ),
				'slide-in-bottom' => esc_html__( 'Slide in (bottom)', 'yith-woocommerce-added-to-cart-popup' ),
				'slide-in-top'    => esc_html__( 'Slide in (top)', 'yith-woocommerce-added-to-cart-popup' ),
				'tred-flip-h'     => esc_html__( '3D flip (horizontal)', 'yith-woocommerce-added-to-cart-popup' ),
				'tred-flip-v'     => esc_html__( '3D flip (vertical)', 'yith-woocommerce-added-to-cart-popup' ),
				'scale-up'        => esc_html__( 'Scale up', 'yith-woocommerce-added-to-cart-popup' ),
			),
			'default'   => yith_wacp_get_default( 'box-animation' ),
			'id'        => 'yith-wacp-box-animation',
		),
		array(
			'title'     => esc_html__( 'Overlay color', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the overlay color and opacity.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'colorpicker',
			'default'   => yith_wacp_get_default( 'overlay-color' ),
			'id'        => 'yith-wacp-overlay-color',
		),
		array(
			'title'     => esc_html__( 'Popup background', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the popup background color.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'colorpicker',
			'default'   => yith_wacp_get_default( 'popup-background' ),
			'id'        => 'yith-wacp-popup-background',
		),
		array(
			'title'     => esc_html__( 'Border radius', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the popup border radius.', 'yith-woocommerce-added-to-cart-popup' ),
			'id'        => 'yith-wacp-popup-border-radius',
			'type'      => 'yith-field',
			'yith-type' => 'dimensions',
			'units'     => array( 'px' => 'px' ),
			'default'   => yith_wacp_get_default( 'popup-border-radius' ),
		),
		array(
			'title'     => esc_html__( 'Show close icon', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show the close icon.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'enable-close-popup-icon' ),
			'id'        => 'yith-wacp-enable-close-popup-icon',
		),
		array(
			'title'        => esc_html__( 'Icon color', 'yith-woocommerce-added-to-cart-popup' ),
			'type'         => 'yith-field',
			'yith-type'    => 'multi-colorpicker',
			'desc'         => esc_html__( 'Set the close icon color.', 'yith-woocommerce-added-to-cart-popup' ),
			'id'           => 'yith-wacp-close-color',
			'colorpickers' => array(
				array(
					'name'    => esc_html__( 'Default color', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'normal',
					'default' => yith_wacp_get_default( 'close-color', 'normal' ),
				),
				array(
					'name'    => esc_html__( 'Hover color', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'hover',
					'default' => yith_wacp_get_default( 'close-color', 'hover' ),
				),
			),
			'deps'         => array(
				'id'    => 'yith-wacp-enable-close-popup-icon',
				'value' => 'yes',
				'type'  => 'hide',
			),
		),
		array(
			'type' => 'sectionend',
			'id'   => 'yith_wacp_popup_design_settings_options_end',
		),
	),
);
