<?php
/**
 * Mini cart tab array
 *
 * @package YITH\AddedToCartPopup\PluginOptions
 */

defined( 'YITH_WACP' ) || exit; // Exit if accessed directly.

$style = array(
	'mini-cart' => array(
		array(
			'title' => esc_html__( 'Mini Cart Options', 'yith-woocommerce-added-to-cart-popup' ),
			'type'  => 'title',
			'desc'  => '',
			'id'    => 'yith-wacp-mini-cart-options',
		),
		array(
			'title'         => esc_html__( 'Show Mini Cart on desktop', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'          => esc_html__( 'Enable to show the Mini Cart on the desktop browser.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'          => 'yith-field',
			'yith-type'     => 'onoff',
			'default'       => yith_wacp_get_default( 'mini-cart-enable' ),
			'id'            => 'yith-wacp-mini-cart-enable',
			'checkboxgroup' => 'start',
		),
		array(
			'title'         => esc_html__( 'Show Mini Cart on mobile devices', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'          => esc_html__( 'Enable to show the Mini Cart on mobile devices.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'          => 'yith-field',
			'yith-type'     => 'onoff',
			'default'       => yith_wacp_get_default( 'mini-cart-enable-mobile' ),
			'id'            => 'yith-wacp-mini-cart-enable-mobile',
			'checkboxgroup' => 'end',
		),
		array(
			'title'     => esc_html__( 'Hide if empty', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to hide the Mini Cart when the cart is empty.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'mini-cart-hide-empty' ),
			'id'        => 'yith-wacp-mini-cart-hide-empty',
		),
		array(
			'title'     => esc_html__( 'Show counter', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Enable to show a counter with the number of items in cart.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => yith_wacp_get_default( 'mini-cart-show-counter' ),
			'id'        => 'yith-wacp-mini-cart-show-counter',
		),
		array(
			'id'        => 'yith-wacp-mini-cart-icon-type',
			'title'     => esc_html__( 'Mini Cart icon', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Choose if you want to show the default icon, upload a custom one, or not show an icon at all.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'select',
			'class'     => 'wc-enhanced-select',
			'default'   => yith_wacp_get_default( 'mini-cart-icon-type' ),
			'options'   => array(
				'default' => esc_html__( 'Use the default icon', 'yith-woocommerce-added-to-cart-popup' ),
				'custom'  => esc_html__( 'Upload a custom icon', 'yith-woocommerce-added-to-cart-popup' ),
			),
		),
		array(
			'title'     => esc_html__( 'Upload a custom icon', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Upload a Mini Cart icon (suggested size: 32x32 px).', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'upload',
			'default'   => yith_wacp_get_default( 'mini-cart-icon' ),
			'id'        => 'yith-wacp-mini-cart-icon',
			'deps'      => array(
				'id'    => 'yith-wacp-mini-cart-icon-type',
				'value' => 'custom',
				'type'  => 'hide',
			),
		),
		array(
			'title'     => esc_html__( 'Icon color', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the icon color.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'colorpicker',
			'default'   => yith_wacp_get_default( 'mini-cart-icon-color' ),
			'id'        => 'yith-wacp-mini-cart-icon-color',
			'deps'      => array(
				'id'    => 'yith-wacp-mini-cart-icon-type',
				'value' => 'default',
				'type'  => 'hide',
			),
		),
		array(
			'title'        => esc_html__( 'Mini Cart colors', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'         => esc_html__( 'Set the Mini Cart colors.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'         => 'yith-field',
			'yith-type'    => 'multi-colorpicker',
			'id'           => 'yith-wacp-mini-cart-colors',
			'colorpickers' => array(
				array(
					'name'    => esc_html__( 'Background', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'background',
					'default' => yith_wacp_get_default( 'mini-cart-colors', 'background' ),
				),
				array(
					'name'    => esc_html__( 'Shadow', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'shadow',
					'default' => yith_wacp_get_default( 'mini-cart-colors', 'shadow' ),
				),
				array(
					'name'    => esc_html__( 'Item counter', 'yith-woocommerce-added-to-cart-popup' ),
					'id'      => 'counter',
					'default' => yith_wacp_get_default( 'mini-cart-colors', 'counter' ),
				),
			),
		),
		array(
			'title'     => esc_html__( 'Border radius', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Set the Mini Cart border radius.', 'yith-woocommerce-added-to-cart-popup' ),
			'id'        => 'yith-wacp-mini-cart-border-radius',
			'type'      => 'yith-field',
			'yith-type' => 'dimensions',
			'units'     => array( 'px' => 'px' ),
			'default'   => yith_wacp_get_default( 'mini-cart-border-radius' ),
		),
		array(
			'title'     => esc_html__( 'Mini Cart position', 'yith-woocommerce-added-to-cart-popup' ),
			'desc'      => esc_html__( 'Drag the Mini Cart to the desired position.', 'yith-woocommerce-added-to-cart-popup' ),
			'type'      => 'yith-field',
			'yith-type' => 'yith-wacp-draggable-position',
			'id'        => 'yith-wacp-mini-cart-position',
			'default'   => yith_wacp_get_default( 'mini-cart-position' ),
		),
		array(
			'type' => 'sectionend',
			'id'   => 'yith-wacp-mini-cart-options',
		),
	),
);

/**
 * APPLY_FILTERS: yith_wacp_panel_style_options
 *
 * Customize tab options.
 *
 * @param array $style Options array.
 */
return apply_filters( 'yith_wacp_panel_style_options', $style );
